/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.io.InputStream;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder$Result;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder$Result$KotlinClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins.BuiltInsResourceLoader;

public final class ReflectKotlinClassFinder
implements KotlinClassFinder {
    private final ClassLoader classLoader;
    private final BuiltInsResourceLoader builtInsResourceLoader;

    public ReflectKotlinClassFinder(ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"");
        this.classLoader = classLoader;
        this.builtInsResourceLoader = new BuiltInsResourceLoader();
    }

    private final KotlinClassFinder$Result findKotlinClass(String object) {
        KotlinClassFinder$Result$KotlinClass kotlinClassFinder$Result$KotlinClass;
        Class<?> clazz = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, (String)object);
        if (clazz != null && (clazz = ReflectKotlinClass.Factory.create((Class<?>)(object = clazz))) != null) {
            object = (KotlinJvmBinaryClass)((Object)clazz);
            kotlinClassFinder$Result$KotlinClass = new KotlinClassFinder$Result$KotlinClass((KotlinJvmBinaryClass)object, null, 2, null);
        } else {
            kotlinClassFinder$Result$KotlinClass = null;
        }
        return kotlinClassFinder$Result$KotlinClass;
    }

    @Override
    public final KotlinClassFinder$Result findKotlinClassOrContent(ClassId classId, JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        return this.findKotlinClass(ReflectKotlinClassFinderKt.access$toRuntimeFqName(classId));
    }

    @Override
    public final KotlinClassFinder$Result findKotlinClassOrContent(JavaClass javaClass, JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        Object object = javaClass.getFqName();
        if (object == null || (object = ((FqName)object).asString()) == null) {
            return null;
        }
        return this.findKotlinClass((String)object);
    }

    @Override
    public final InputStream findBuiltInsData(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        if (!fqName2.startsWith(StandardNames.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        return this.builtInsResourceLoader.loadResource(BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(fqName2));
    }
}

