/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;

final class SignatureSerializer {
    public static final SignatureSerializer INSTANCE = new SignatureSerializer();

    private SignatureSerializer() {
    }

    public final String methodDesc(Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
        for (Class<?> clazz : classArray) {
            Intrinsics.checkNotNull(clazz);
            stringBuilder.append(ReflectClassUtilKt.getDesc(clazz));
        }
        stringBuilder.append(")");
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        stringBuilder.append(ReflectClassUtilKt.getDesc(clazz));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String constructorDesc(Constructor<?> classArray) {
        Intrinsics.checkNotNullParameter(classArray, (String)"");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        Class<?>[] classArray2 = classArray.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray2, (String)"");
        for (Class<?> clazz : classArray2) {
            Intrinsics.checkNotNull(clazz);
            stringBuilder.append(ReflectClassUtilKt.getDesc(clazz));
        }
        stringBuilder.append(")V");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String fieldDesc(Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"");
        Class<?> clazz = field.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return ReflectClassUtilKt.getDesc(clazz);
    }
}

