/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver$Companion;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver$createKotlinPackagePartScope$2;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader$Kind;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Class;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Package;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.IncompatibleVersionErrorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlin.reflect.jvm.internal.impl.utils.DeserializationHelpersKt;

public final class DeserializedDescriptorResolver {
    public static final DeserializedDescriptorResolver$Companion Companion = new DeserializedDescriptorResolver$Companion(null);
    public DeserializationComponents components;
    private static final Set<KotlinClassHeader$Kind> KOTLIN_CLASS = SetsKt.setOf((Object)((Object)KotlinClassHeader$Kind.CLASS));
    private static final Set<KotlinClassHeader$Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART;
    private static final JvmMetadataVersion KOTLIN_1_1_EAP_METADATA_VERSION;
    private static final JvmMetadataVersion KOTLIN_1_3_M1_METADATA_VERSION;
    private static final JvmMetadataVersion KOTLIN_1_3_RC_METADATA_VERSION;

    public final DeserializationComponents getComponents() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents != null) {
            return deserializationComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    public final void setComponents(DeserializationComponents deserializationComponents) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponents, (String)"");
        this.components = deserializationComponents;
    }

    private final JvmMetadataVersion getOwnMetadataVersion() {
        return DeserializationHelpersKt.jvmMetadataVersionOrDefault(this.getComponents().getConfiguration());
    }

    public final void setComponents(DeserializationComponentsForJava deserializationComponentsForJava) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponentsForJava, (String)"");
        this.setComponents(deserializationComponentsForJava.getComponents());
    }

    private final boolean getSkipMetadataVersionCheck() {
        return this.getComponents().getConfiguration().getSkipMetadataVersionCheck();
    }

    public final ClassDescriptor resolveClass(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        ClassData classData = this.readClassData$descriptors_jvm(kotlinJvmBinaryClass);
        if (classData == null) {
            return null;
        }
        ClassData classData2 = classData;
        return this.getComponents().getClassDeserializer().deserializeClass(kotlinJvmBinaryClass.getClassId(), classData2);
    }

    public final ClassData readClassData$descriptors_jvm(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        Pair<JvmNameResolver, ProtoBuf$Class> pair = this.readData(kotlinJvmBinaryClass, KOTLIN_CLASS);
        if (pair == null) {
            return null;
        }
        Object object = pair;
        String[] stringArray = kotlinJvmBinaryClass.getClassHeader().getStrings();
        if (stringArray == null) {
            return null;
        }
        Object object2 = stringArray;
        Object object3 = this;
        try {
            try {
                object = JvmProtoBufUtil.readClassDataFrom((String[])object, object2);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalStateException("Could not read data from " + kotlinJvmBinaryClass.getLocation(), invalidProtocolBufferException);
            }
        }
        catch (Throwable throwable) {
            if (((DeserializedDescriptorResolver)object3).getSkipMetadataVersionCheck() || kotlinJvmBinaryClass.getClassHeader().getMetadataVersion().isCompatible(((DeserializedDescriptorResolver)object3).getOwnMetadataVersion())) {
                throw throwable;
            }
            object = null;
        }
        Pair<JvmNameResolver, ProtoBuf$Class> pair2 = object;
        if (pair2 == null) {
            return null;
        }
        object = pair2;
        object2 = (JvmNameResolver)pair2.component1();
        object3 = (ProtoBuf$Class)object.component2();
        object = new KotlinJvmBinarySourceElement(kotlinJvmBinaryClass, this.getIncompatibility(kotlinJvmBinaryClass), this.isPreReleaseInvisible(kotlinJvmBinaryClass), this.getAbiStability(kotlinJvmBinaryClass));
        return new ClassData((NameResolver)object2, (ProtoBuf$Class)object3, kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), (SourceElement)object);
    }

    public final MemberScope createKotlinPackagePartScope(PackageFragmentDescriptor packageFragmentDescriptor, KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)packageFragmentDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        Pair<JvmNameResolver, ProtoBuf$Package> pair = this.readData(kotlinJvmBinaryClass, KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART);
        if (pair == null) {
            return null;
        }
        Object object = pair;
        String[] stringArray = kotlinJvmBinaryClass.getClassHeader().getStrings();
        if (stringArray == null) {
            return null;
        }
        Object object2 = stringArray;
        Object object3 = this;
        try {
            try {
                object = JvmProtoBufUtil.readPackageDataFrom((String[])object, object2);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalStateException("Could not read data from " + kotlinJvmBinaryClass.getLocation(), invalidProtocolBufferException);
            }
        }
        catch (Throwable throwable) {
            if (((DeserializedDescriptorResolver)object3).getSkipMetadataVersionCheck() || kotlinJvmBinaryClass.getClassHeader().getMetadataVersion().isCompatible(((DeserializedDescriptorResolver)object3).getOwnMetadataVersion())) {
                throw throwable;
            }
            object = null;
        }
        Pair<JvmNameResolver, ProtoBuf$Package> pair2 = object;
        if (pair2 == null) {
            return null;
        }
        object = pair2;
        object2 = (JvmNameResolver)pair2.component1();
        object3 = (ProtoBuf$Package)object.component2();
        object = new JvmPackagePartSource(kotlinJvmBinaryClass, (ProtoBuf$Package)object3, (NameResolver)object2, this.getIncompatibility(kotlinJvmBinaryClass), this.isPreReleaseInvisible(kotlinJvmBinaryClass), this.getAbiStability(kotlinJvmBinaryClass));
        return new DeserializedPackageMemberScope(packageFragmentDescriptor, (ProtoBuf$Package)object3, (NameResolver)object2, kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), (DeserializedContainerSource)object, this.getComponents(), "scope for " + object + " in " + packageFragmentDescriptor, (Function0<? extends Collection<Name>>)((Function0)DeserializedDescriptorResolver$createKotlinPackagePartScope$2.INSTANCE));
    }

    private final IncompatibleVersionErrorData<JvmMetadataVersion> getIncompatibility(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        if (this.getSkipMetadataVersionCheck() || kotlinJvmBinaryClass.getClassHeader().getMetadataVersion().isCompatible(this.getOwnMetadataVersion())) {
            return null;
        }
        return new IncompatibleVersionErrorData<JvmMetadataVersion>(kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), JvmMetadataVersion.INSTANCE, this.getOwnMetadataVersion(), this.getOwnMetadataVersion().lastSupportedVersionWithThisLanguageVersion(kotlinJvmBinaryClass.getClassHeader().getMetadataVersion().isStrictSemantics()), kotlinJvmBinaryClass.getLocation(), kotlinJvmBinaryClass.getClassId());
    }

    private final boolean isPreReleaseInvisible(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        return this.getComponents().getConfiguration().getReportErrorsOnPreReleaseDependencies() && (kotlinJvmBinaryClass.getClassHeader().isPreRelease() || Intrinsics.areEqual((Object)kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), (Object)KOTLIN_1_1_EAP_METADATA_VERSION)) || this.isCompiledWith13M1(kotlinJvmBinaryClass);
    }

    private final boolean isCompiledWith13M1(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        return !this.getComponents().getConfiguration().getSkipPrereleaseCheck() && kotlinJvmBinaryClass.getClassHeader().isPreRelease() && Intrinsics.areEqual((Object)kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), (Object)KOTLIN_1_3_M1_METADATA_VERSION);
    }

    private final DeserializedContainerAbiStability getAbiStability(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        if (!this.getComponents().getConfiguration().getAllowUnstableDependencies()) {
            if (kotlinJvmBinaryClass.getClassHeader().isUnstableFirBinary()) {
                return DeserializedContainerAbiStability.FIR_UNSTABLE;
            }
            if (kotlinJvmBinaryClass.getClassHeader().isUnstableJvmIrBinary()) {
                return DeserializedContainerAbiStability.IR_UNSTABLE;
            }
        }
        return DeserializedContainerAbiStability.STABLE;
    }

    private final String[] readData(KotlinJvmBinaryClass object, Set<? extends KotlinClassHeader$Kind> set) {
        String[] stringArray = ((KotlinClassHeader)(object = object.getClassHeader())).getData();
        if (stringArray == null) {
            stringArray = ((KotlinClassHeader)object).getIncompatibleData();
        }
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            if (set.contains((Object)((KotlinClassHeader)object).getKind())) {
                return stringArray2;
            }
            return null;
        }
        return null;
    }

    public static final /* synthetic */ JvmMetadataVersion access$getKOTLIN_1_3_RC_METADATA_VERSION$cp() {
        return KOTLIN_1_3_RC_METADATA_VERSION;
    }

    static {
        KotlinClassHeader$Kind[] kotlinClassHeader$KindArray = new KotlinClassHeader$Kind[2];
        Object[] objectArray = kotlinClassHeader$KindArray;
        kotlinClassHeader$KindArray[0] = KotlinClassHeader$Kind.FILE_FACADE;
        objectArray[1] = KotlinClassHeader$Kind.MULTIFILE_CLASS_PART;
        KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = SetsKt.setOf((Object[])objectArray);
        int[] nArray = new int[3];
        objectArray = nArray;
        nArray[0] = 1;
        objectArray[1] = (KotlinClassHeader$Kind)true;
        objectArray[2] = (KotlinClassHeader$Kind)2;
        KOTLIN_1_1_EAP_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
        int[] nArray2 = new int[3];
        objectArray = nArray2;
        nArray2[0] = 1;
        objectArray[1] = (KotlinClassHeader$Kind)true;
        objectArray[2] = (KotlinClassHeader$Kind)11;
        KOTLIN_1_3_M1_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
        int[] nArray3 = new int[3];
        objectArray = nArray3;
        nArray3[0] = 1;
        objectArray[1] = (KotlinClassHeader$Kind)true;
        objectArray[2] = (KotlinClassHeader$Kind)13;
        KOTLIN_1_3_RC_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
    }
}

