/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor$Kind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FieldDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses$MockClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$ValueParametersHandler;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$RenderDeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$appendTypeProjections$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$functionTypeAnnotationsRenderer$2;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$renderConstructor$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$renderSuperTypes$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$renderTypeConstructor$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.PropertyAccessorRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value$LocalClass;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value$NormalClass;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.WrappedType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;

public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    private final DescriptorRendererOptionsImpl options;
    private final Lazy functionTypeAnnotationsRenderer$delegate;

    public DescriptorRendererImpl(DescriptorRendererOptionsImpl descriptorRendererOptionsImpl) {
        Intrinsics.checkNotNullParameter((Object)descriptorRendererOptionsImpl, (String)"");
        this.options = descriptorRendererOptionsImpl;
        boolean bl = this.options.isLocked();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.functionTypeAnnotationsRenderer$delegate = LazyKt.lazy((Function0)new DescriptorRendererImpl$functionTypeAnnotationsRenderer$2(this));
    }

    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public final boolean getActualPropertiesInPrimaryConstructor() {
        return this.options.getActualPropertiesInPrimaryConstructor();
    }

    public final boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    @Override
    public final AnnotationArgumentsRenderingPolicy getAnnotationArgumentsRenderingPolicy() {
        return this.options.getAnnotationArgumentsRenderingPolicy();
    }

    @Override
    public final void setAnnotationArgumentsRenderingPolicy(AnnotationArgumentsRenderingPolicy annotationArgumentsRenderingPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)annotationArgumentsRenderingPolicy), (String)"");
        this.options.setAnnotationArgumentsRenderingPolicy(annotationArgumentsRenderingPolicy);
    }

    public final Function1<AnnotationDescriptor, Boolean> getAnnotationFilter() {
        return this.options.getAnnotationFilter();
    }

    public final boolean getBoldOnlyForNamesInHtml() {
        return this.options.getBoldOnlyForNamesInHtml();
    }

    public final boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    public final ClassifierNamePolicy getClassifierNamePolicy() {
        return this.options.getClassifierNamePolicy();
    }

    @Override
    public final void setClassifierNamePolicy(ClassifierNamePolicy classifierNamePolicy) {
        Intrinsics.checkNotNullParameter((Object)classifierNamePolicy, (String)"");
        this.options.setClassifierNamePolicy(classifierNamePolicy);
    }

    @Override
    public final boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public final void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    public final Function1<ValueParameterDescriptor, String> getDefaultParameterValueRenderer() {
        return this.options.getDefaultParameterValueRenderer();
    }

    public final boolean getEachAnnotationOnNewLine() {
        return this.options.getEachAnnotationOnNewLine();
    }

    @Override
    public final boolean getEnhancedTypes() {
        return this.options.getEnhancedTypes();
    }

    public final Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    public final Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public final void setExcludedTypeAnnotationClasses(Set<FqName> set) {
        Intrinsics.checkNotNullParameter(set, (String)"");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    public final boolean getIncludeAdditionalModifiers() {
        return this.options.getIncludeAdditionalModifiers();
    }

    public final boolean getIncludeAnnotationArguments() {
        return this.options.getIncludeAnnotationArguments();
    }

    public final boolean getIncludeEmptyAnnotationArguments() {
        return this.options.getIncludeEmptyAnnotationArguments();
    }

    public final boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    public final boolean getInformativeErrorType() {
        return this.options.getInformativeErrorType();
    }

    public final Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public final void setModifiers(Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkNotNullParameter(set, (String)"");
        this.options.setModifiers(set);
    }

    public final boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    public final OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    public final ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public final void setParameterNameRenderingPolicy(ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameterNameRenderingPolicy), (String)"");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy);
    }

    public final boolean getParameterNamesInFunctionalTypes() {
        return this.options.getParameterNamesInFunctionalTypes();
    }

    public final boolean getPresentableUnresolvedTypes() {
        return this.options.getPresentableUnresolvedTypes();
    }

    public final PropertyAccessorRenderingPolicy getPropertyAccessorRenderingPolicy() {
        return this.options.getPropertyAccessorRenderingPolicy();
    }

    public final boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public final void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    public final boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public final void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    public final boolean getRenderConstructorDelegation() {
        return this.options.getRenderConstructorDelegation();
    }

    public final boolean getRenderConstructorKeyword() {
        return this.options.getRenderConstructorKeyword();
    }

    public final boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    public final boolean getRenderDefaultModality() {
        return this.options.getRenderDefaultModality();
    }

    public final boolean getRenderDefaultVisibility() {
        return this.options.getRenderDefaultVisibility();
    }

    public final boolean getRenderPrimaryConstructorParametersAsProperties() {
        return this.options.getRenderPrimaryConstructorParametersAsProperties();
    }

    public final boolean getRenderTypeExpansions() {
        return this.options.getRenderTypeExpansions();
    }

    public final boolean getRenderUnabbreviatedType() {
        return this.options.getRenderUnabbreviatedType();
    }

    public final boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    public final boolean getStartFromDeclarationKeyword() {
        return this.options.getStartFromDeclarationKeyword();
    }

    public final boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public final void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    public final RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public final void setTextFormat(RenderingFormat renderingFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderingFormat), (String)"");
        this.options.setTextFormat(renderingFormat);
    }

    public final Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    public final boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    public final boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    public final DescriptorRenderer$ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    public final boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public final void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    public final boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public final void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    public final boolean getWithSourceFileForTopLevel() {
        return this.options.getWithSourceFileForTopLevel();
    }

    public final boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    public final boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public final void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    public final boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public final void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    private final DescriptorRendererImpl getFunctionTypeAnnotationsRenderer() {
        Lazy lazy = this.functionTypeAnnotationsRenderer$delegate;
        return (DescriptorRendererImpl)lazy.getValue();
    }

    private final String renderKeyword(String string) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return string;
            }
            case 2: {
                if (this.getBoldOnlyForNamesInHtml()) {
                    return string;
                }
                return "<b>" + string + "</b>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String renderError(String string) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return string;
            }
            case 2: {
                return "<font color=red><b>" + string + "</b></font>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String escape(String string) {
        return this.getTextFormat().escape(string);
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return this.escape("->");
            }
            case 2: {
                return "&rarr;";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final String renderMessage(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return string;
            }
            case 2: {
                return "<i>" + string + "</i>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public final String renderName(Name object, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = this.escape(RenderingUtilsKt.render((Name)object));
        if (this.getBoldOnlyForNamesInHtml() && this.getTextFormat() == RenderingFormat.HTML && bl) {
            return "<b>" + (String)object + "</b>";
        }
        return object;
    }

    private final void renderName(DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder, boolean bl) {
        Name name = declarationDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        stringBuilder.append(this.renderName(name, bl));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                stringBuilder.append("companion object");
            }
            this.renderSpaceIfNeeded(stringBuilder);
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
            if (declarationDescriptor2 != null) {
                stringBuilder.append("of ");
                Name name = declarationDescriptor2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                stringBuilder.append(this.renderName(name, false));
            }
        }
        if (this.getVerbose() || !Intrinsics.areEqual((Object)declarationDescriptor.getName(), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(stringBuilder);
            }
            Name name = declarationDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            stringBuilder.append(this.renderName(name, true));
        }
    }

    @Override
    public final String renderFqName(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        List<Name> list = fqNameUnsafe.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        return this.renderFqName(list);
    }

    private final String renderFqName(List<Name> list) {
        return this.escape(RenderingUtilsKt.renderFqName(list));
    }

    public final String renderClassifierName(ClassifierDescriptor classifierDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
        if (ErrorUtils.isError(classifierDescriptor)) {
            return classifierDescriptor.getTypeConstructor().toString();
        }
        return this.getClassifierNamePolicy().renderClassifier(classifierDescriptor, this);
    }

    @Override
    public final String renderType(KotlinType kotlinType) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        this.renderNormalizedType(stringBuilder2, (KotlinType)this.getTypeNormalizer().invoke((Object)kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private final void renderNormalizedType(StringBuilder stringBuilder, KotlinType kotlinType) {
        UnwrappedType unwrappedType = kotlinType.unwrap();
        unwrappedType = unwrappedType instanceof AbbreviatedType ? (AbbreviatedType)unwrappedType : null;
        if (unwrappedType != null) {
            if (this.getRenderTypeExpansions()) {
                this.renderNormalizedTypeAsIs(stringBuilder, ((AbbreviatedType)unwrappedType).getExpandedType());
                return;
            }
            this.renderNormalizedTypeAsIs(stringBuilder, ((AbbreviatedType)unwrappedType).getAbbreviation());
            if (this.getRenderUnabbreviatedType()) {
                this.renderAbbreviatedTypeExpansion(stringBuilder, (AbbreviatedType)unwrappedType);
            }
            return;
        }
        this.renderNormalizedTypeAsIs(stringBuilder, kotlinType);
    }

    private final void renderAbbreviatedTypeExpansion(StringBuilder stringBuilder, AbbreviatedType abbreviatedType) {
        if (this.getTextFormat() == RenderingFormat.HTML) {
            stringBuilder.append("<font color=\"808080\"><i>");
        }
        stringBuilder.append(" /* = ");
        this.renderNormalizedTypeAsIs(stringBuilder, abbreviatedType.getExpandedType());
        stringBuilder.append(" */");
        if (this.getTextFormat() == RenderingFormat.HTML) {
            stringBuilder.append("</i></font>");
        }
    }

    private final void renderNormalizedTypeAsIs(StringBuilder stringBuilder, KotlinType kotlinType) {
        if (kotlinType instanceof WrappedType && this.getDebugMode() && !((WrappedType)kotlinType).isComputed()) {
            stringBuilder.append("<Not computed yet>");
            return;
        }
        if ((kotlinType = kotlinType.unwrap()) instanceof FlexibleType) {
            stringBuilder.append(((FlexibleType)kotlinType).render(this, this));
            return;
        }
        if (kotlinType instanceof SimpleType) {
            this.renderSimpleType(stringBuilder, (SimpleType)kotlinType);
        }
    }

    private final void renderSimpleType(StringBuilder stringBuilder, SimpleType simpleType2) {
        if (Intrinsics.areEqual((Object)simpleType2, (Object)TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(simpleType2)) {
            stringBuilder.append("???");
            return;
        }
        if (ErrorUtils.isUninferredTypeVariable(simpleType2)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = simpleType2.getConstructor();
                Intrinsics.checkNotNull((Object)typeConstructor2);
                stringBuilder.append(this.renderError(((ErrorTypeConstructor)typeConstructor2).getParam(0)));
                return;
            }
            stringBuilder.append("???");
            return;
        }
        if (KotlinTypeKt.isError(simpleType2)) {
            this.renderDefaultType(stringBuilder, simpleType2);
            return;
        }
        if (this.shouldRenderAsPrettyFunctionType(simpleType2)) {
            this.renderFunctionType(stringBuilder, simpleType2);
            return;
        }
        this.renderDefaultType(stringBuilder, simpleType2);
    }

    private final boolean shouldRenderAsPrettyFunctionType(KotlinType iterator2) {
        if (FunctionTypesKt.isBuiltinFunctionalType((KotlinType)((Object)iterator2))) {
            boolean bl;
            if (!((iterator2 = (Iterable)((KotlinType)((Object)iterator2)).getArguments()) instanceof Collection) || !((Collection)((Object)iterator2)).isEmpty()) {
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    Object object = iterator2.next();
                    if (!(object = (TypeProjection)object).isStarProjection()) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final String renderFlexibleType(String string, String string2, KotlinBuiltIns object) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(string, string2)) {
            if (StringsKt.startsWith$default((String)string2, (String)"(", (boolean)false, (int)2, null)) {
                return "(" + string + ")!";
            }
            return string + '!';
        }
        ClassifierNamePolicy classifierNamePolicy = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor = ((KotlinBuiltIns)object).getCollection();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
        String string3 = StringsKt.substringBefore$default((String)classifierNamePolicy.renderClassifier(classDescriptor, this), (String)"Collection", null, (int)2, null);
        String string4 = "Mutable";
        string4 = RenderingUtilsKt.replacePrefixesInTypeRepresentations(string, string3 + string4, string2, string3, string3 + '(' + string4 + ')');
        if (string4 != null) {
            return string4;
        }
        if ((string3 = RenderingUtilsKt.replacePrefixesInTypeRepresentations(string, string3 + "MutableMap.MutableEntry", string2, string3 + "Map.Entry", string3 + "(Mutable)Map.(Mutable)Entry")) != null) {
            return string3;
        }
        ClassifierNamePolicy classifierNamePolicy2 = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor2 = ((KotlinBuiltIns)object).getArray();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"");
        object = StringsKt.substringBefore$default((String)classifierNamePolicy2.renderClassifier(classDescriptor2, this), (String)"Array", null, (int)2, null);
        object = RenderingUtilsKt.replacePrefixesInTypeRepresentations(string, (String)object + this.escape("Array<"), string2, (String)object + this.escape("Array<out "), (String)object + this.escape("Array<(out) "));
        if (object != null) {
            return object;
        }
        return "(" + string + ".." + string2 + ')';
    }

    public final String renderTypeArguments(List<? extends TypeProjection> list) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append(this.lt());
        this.appendTypeProjections(stringBuilder2, list);
        stringBuilder2.append(this.gt());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private final void renderDefaultType(StringBuilder stringBuilder, KotlinType kotlinType) {
        SimpleType simpleType2;
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, kotlinType, null, 2, null);
        DefinitelyNotNullType definitelyNotNullType = kotlinType instanceof DefinitelyNotNullType ? (DefinitelyNotNullType)kotlinType : null;
        SimpleType simpleType3 = simpleType2 = definitelyNotNullType != null ? definitelyNotNullType.getOriginal() : null;
        if (KotlinTypeKt.isError(kotlinType)) {
            if (TypeUtilsKt.isUnresolvedType(kotlinType) && this.getPresentableUnresolvedTypes()) {
                stringBuilder.append(this.renderError(ErrorUtils.INSTANCE.unresolvedTypeAsItIs(kotlinType)));
            } else {
                if (kotlinType instanceof ErrorType && !this.getInformativeErrorType()) {
                    stringBuilder.append(((ErrorType)kotlinType).getDebugMessage());
                } else {
                    stringBuilder.append(kotlinType.getConstructor().toString());
                }
                stringBuilder.append(this.renderTypeArguments(kotlinType.getArguments()));
            }
        } else if (kotlinType instanceof StubTypeForBuilderInference) {
            stringBuilder.append(((StubTypeForBuilderInference)kotlinType).getOriginalTypeVariable().toString());
        } else if (simpleType2 instanceof StubTypeForBuilderInference) {
            stringBuilder.append(((StubTypeForBuilderInference)simpleType2).getOriginalTypeVariable().toString());
        } else {
            DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, stringBuilder, kotlinType, null, 2, null);
        }
        if (kotlinType.isMarkedNullable()) {
            stringBuilder.append("?");
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(kotlinType)) {
            stringBuilder.append(" & Any");
        }
    }

    private final void renderTypeConstructorAndArguments(StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2) {
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(kotlinType);
        if (possiblyInnerType == null) {
            stringBuilder.append(this.renderTypeConstructor(typeConstructor2));
            stringBuilder.append(this.renderTypeArguments(kotlinType.getArguments()));
            return;
        }
        this.renderPossiblyInnerType(stringBuilder, possiblyInnerType);
    }

    static /* synthetic */ void renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = kotlinType.getConstructor();
        }
        descriptorRendererImpl.renderTypeConstructorAndArguments(stringBuilder, kotlinType, typeConstructor2);
    }

    private final void renderPossiblyInnerType(StringBuilder stringBuilder, PossiblyInnerType possiblyInnerType) {
        block3: {
            Object object;
            block2: {
                object = possiblyInnerType.getOuterType();
                if (object == null) break block2;
                PossiblyInnerType possiblyInnerType2 = object;
                this.renderPossiblyInnerType(stringBuilder, possiblyInnerType2);
                stringBuilder.append('.');
                Name name = possiblyInnerType.getClassifierDescriptor().getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                object = stringBuilder.append(this.renderName(name, false));
                if (object != null) break block3;
            }
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassifierDescriptor().getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
            object = stringBuilder.append(this.renderTypeConstructor(typeConstructor2));
        }
        stringBuilder.append(this.renderTypeArguments(possiblyInnerType.getArguments()));
    }

    public final String renderTypeConstructor(TypeConstructor typeConstructor2) {
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        if ((classifierDescriptor instanceof TypeParameterDescriptor ? true : classifierDescriptor instanceof ClassDescriptor) ? true : classifierDescriptor instanceof TypeAliasDescriptor) {
            return this.renderClassifierName(classifierDescriptor);
        }
        if (classifierDescriptor == null) {
            if (typeConstructor2 instanceof IntersectionTypeConstructor) {
                return ((IntersectionTypeConstructor)typeConstructor2).makeDebugNameForIntersectionType((Function1<? super KotlinType, ? extends Object>)((Function1)DescriptorRendererImpl$renderTypeConstructor$1.INSTANCE));
            }
            return typeConstructor2.toString();
        }
        throw new IllegalStateException(("Unexpected classifier: " + classifierDescriptor.getClass()).toString());
    }

    @Override
    public final String renderTypeProjection(TypeProjection typeProjection) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        this.appendTypeProjections(stringBuilder2, CollectionsKt.listOf((Object)typeProjection));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private final void appendTypeProjections(StringBuilder stringBuilder, List<? extends TypeProjection> list) {
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder, (CharSequence)", ", null, null, (int)0, null, (Function1)new DescriptorRendererImpl$appendTypeProjections$1(this), (int)60, null);
    }

    private final void renderFunctionType(StringBuilder stringBuilder, KotlinType kotlinType) {
        int n = stringBuilder.length();
        Object object = this.getFunctionTypeAnnotationsRenderer();
        DescriptorRendererImpl.renderAnnotations$default((DescriptorRendererImpl)object, stringBuilder, kotlinType, null, 2, null);
        int n2 = stringBuilder.length() != n ? 1 : 0;
        object = FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType);
        Object object2 = FunctionTypesKt.getContextReceiverTypesFromFunctionType(kotlinType);
        if (!((Collection)object2).isEmpty()) {
            stringBuilder.append("context(");
            List<KotlinType> list = object2.subList(0, CollectionsKt.getLastIndex(object2));
            for (KotlinType kotlinType2 : list) {
                this.renderNormalizedType(stringBuilder, kotlinType2);
                stringBuilder.append(", ");
            }
            this.renderNormalizedType(stringBuilder, (KotlinType)CollectionsKt.last(object2));
            stringBuilder.append(") ");
        }
        boolean bl = FunctionTypesKt.isSuspendFunctionType(kotlinType);
        boolean bl2 = kotlinType.isMarkedNullable();
        boolean bl3 = bl2 || n2 != 0 && object != null;
        if (bl3) {
            if (bl) {
                stringBuilder.insert(n, '(');
            } else {
                if (n2 != 0) {
                    n = CharsKt.isWhitespace((char)StringsKt.last((CharSequence)stringBuilder)) ? 1 : 0;
                    if (_Assertions.ENABLED && n == 0) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    StringBuilder stringBuilder2 = stringBuilder;
                    if (stringBuilder2.charAt(StringsKt.getLastIndex((CharSequence)stringBuilder2) - 1) != ')') {
                        StringBuilder stringBuilder3 = stringBuilder;
                        stringBuilder3.insert(StringsKt.getLastIndex((CharSequence)stringBuilder3), "()");
                    }
                }
                stringBuilder.append("(");
            }
        }
        this.renderModifier(stringBuilder, bl, "suspend");
        if (object != null) {
            n = this.shouldRenderAsPrettyFunctionType((KotlinType)object) && !((KotlinType)object).isMarkedNullable() || this.hasModifiersOrAnnotations((KotlinType)object) || object instanceof DefinitelyNotNullType ? 1 : 0;
            if (n != 0) {
                stringBuilder.append("(");
            }
            this.renderNormalizedType(stringBuilder, (KotlinType)object);
            if (n != 0) {
                stringBuilder.append(")");
            }
            stringBuilder.append(".");
        }
        stringBuilder.append("(");
        if (FunctionTypesKt.isBuiltinExtensionFunctionalType(kotlinType) && kotlinType.getArguments().size() <= 1) {
            stringBuilder.append("???");
        } else {
            Object object3 = FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType);
            object3 = object3.iterator();
            n2 = 0;
            while (object3.hasNext()) {
                Object object4;
                int n3 = n2++;
                object2 = (TypeProjection)object3.next();
                if (n3 > 0) {
                    stringBuilder.append(", ");
                }
                if (this.getParameterNamesInFunctionalTypes()) {
                    KotlinType kotlinType3 = object2.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
                    object4 = FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType3);
                } else {
                    object4 = object = null;
                }
                if (object4 != null) {
                    stringBuilder.append(this.renderName((Name)object, false));
                    stringBuilder.append(": ");
                }
                stringBuilder.append(this.renderTypeProjection((TypeProjection)object2));
            }
        }
        stringBuilder.append(") ").append(this.arrow()).append(" ");
        this.renderNormalizedType(stringBuilder, FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType));
        if (bl3) {
            stringBuilder.append(")");
        }
        if (bl2) {
            stringBuilder.append("?");
        }
    }

    private final boolean hasModifiersOrAnnotations(KotlinType kotlinType) {
        return FunctionTypesKt.isSuspendFunctionType(kotlinType) || !kotlinType.getAnnotations().isEmpty();
    }

    private final void appendDefinedIn(StringBuilder stringBuilder, DeclarationDescriptor object) {
        if (object instanceof PackageFragmentDescriptor || object instanceof PackageViewDescriptor) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = object.getContainingDeclaration();
        if (declarationDescriptor != null && !(declarationDescriptor instanceof ModuleDescriptor)) {
            stringBuilder.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(declarationDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
            FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
            stringBuilder.append(fqNameUnsafe2.isRoot() ? "root package" : this.renderFqName(fqNameUnsafe2));
            if (this.getWithSourceFileForTopLevel() && declarationDescriptor instanceof PackageFragmentDescriptor && object instanceof DeclarationDescriptorWithSource) {
                String string = ((DeclarationDescriptorWithSource)object).getSource().getContainingFile().getName();
                if (string != null) {
                    object = string;
                    stringBuilder.append(" ").append(this.renderMessage("in file")).append(" ").append((String)object);
                    return;
                }
            }
        }
    }

    private final void renderAnnotations(StringBuilder stringBuilder, Annotated object, AnnotationUseSiteTarget annotationUseSiteTarget) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        Set<FqName> set = object instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        Function1<AnnotationDescriptor, Boolean> function1 = this.getAnnotationFilter();
        for (AnnotationDescriptor annotationDescriptor : object.getAnnotations()) {
            if (CollectionsKt.contains((Iterable)set, (Object)annotationDescriptor.getFqName()) || this.isParameterName(annotationDescriptor) || function1 != null && !((Boolean)function1.invoke((Object)annotationDescriptor)).booleanValue()) continue;
            stringBuilder.append(this.renderAnnotation(annotationDescriptor, annotationUseSiteTarget));
            if (this.getEachAnnotationOnNewLine()) {
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"");
                continue;
            }
            stringBuilder.append(" ");
        }
    }

    static /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, Annotated annotated, AnnotationUseSiteTarget annotationUseSiteTarget, int n, Object object) {
        if ((n & 2) != 0) {
            annotationUseSiteTarget = null;
        }
        descriptorRendererImpl.renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
    }

    private final boolean isParameterName(AnnotationDescriptor annotationDescriptor) {
        return Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)StandardNames$FqNames.parameterName);
    }

    @Override
    public final String renderAnnotation(AnnotationDescriptor object, AnnotationUseSiteTarget object2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append('@');
        if (object2 != null) {
            stringBuilder2.append(((AnnotationUseSiteTarget)((Object)object2)).getRenderName() + ':');
        }
        object2 = object.getType();
        stringBuilder2.append(this.renderType((KotlinType)object2));
        if (this.getIncludeAnnotationArguments()) {
            object = this.renderAndSortAnnotationArguments((AnnotationDescriptor)object);
            if (this.getIncludeEmptyAnnotationArguments() || !((Collection)object).isEmpty()) {
                CollectionsKt.joinTo$default((Iterable)((Iterable)object), (Appendable)stringBuilder2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)112, null);
            }
        }
        if (this.getVerbose() && (KotlinTypeKt.isError((KotlinType)object2) || ((KotlinType)object2).getConstructor().getDeclarationDescriptor() instanceof NotFoundClasses$MockClassDescriptor)) {
            stringBuilder2.append(" /* annotation class not found */");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor object) {
        Object object2;
        Object object3;
        List list;
        List list2;
        Object object4;
        Iterable iterable;
        Object object52;
        Object object6;
        Object object7 = object.getAllValueArguments();
        object = this.getRenderDefaultAnnotationArguments() ? DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)object) : null;
        if (object != null && (object6 = object.getUnsubstitutedPrimaryConstructor()) != null && (object52 = object6.getValueParameters()) != null) {
            object6 = (Iterable)object52;
            iterable = object6;
            object6 = new ArrayList();
            for (Object object52 : iterable) {
                object = (ValueParameterDescriptor)object52;
                if (!object.declaresDefaultValue()) continue;
                object6.add(object52);
            }
            object6 = (List)object6;
            iterable = object6;
            object6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object6, (int)10));
            for (Object object52 : iterable) {
                object = (ValueParameterDescriptor)object52;
                object4 = object6;
                object4.add(object.getName());
            }
            list2 = (List)object6;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        object = list;
        object6 = object52 = (List<ValueParameterDescriptor>)list;
        object52 = new ArrayList();
        object6 = object6.iterator();
        while (object6.hasNext()) {
            object3 = object6.next();
            object2 = (Name)object3;
            Intrinsics.checkNotNull((Object)object2);
            if (!(!object7.containsKey(object2))) continue;
            object52.add(object3);
        }
        object6 = object52 = (Iterable)object52;
        object52 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object52, (int)10));
        object6 = object6.iterator();
        while (object6.hasNext()) {
            object3 = object6.next();
            object2 = (Name)object3;
            object4 = object52;
            object4.add(((Name)object2).asString() + " = ...");
        }
        object6 = (List)object52;
        object52 = object7 = (Iterable)object7.entrySet();
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object7, (int)10));
        object3 = object52.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            object52 = (Map.Entry)object2;
            object4 = iterable;
            object7 = (Name)object52.getKey();
            object52 = (ConstantValue)object52.getValue();
            object4.add(((Name)object7).asString() + " = " + (!object.contains(object7) ? this.renderConstant((ConstantValue<?>)object52) : "..."));
        }
        object52 = (List)iterable;
        return CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)((Collection)object6), object52));
    }

    private final String renderConstant(ConstantValue<?> iterator2) {
        Object object = this.options.getPropertyConstantRenderer();
        if (object != null) {
            return (String)object.invoke(iterator2);
        }
        object = iterator2;
        if (object instanceof ArrayValue) {
            iterator2 = (Iterable)((ArrayValue)((Object)iterator2)).getValue();
            Collection collection = new ArrayList();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                object = t;
                object = t;
                object = (ConstantValue)t;
                String string = this.renderConstant((ConstantValue<?>)object);
                if (string == null) continue;
                object = string;
                collection.add(object);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null);
        }
        if (object instanceof AnnotationValue) {
            return StringsKt.removePrefix((String)DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)((Object)iterator2)).getValue(), null, 2, null), (CharSequence)"@");
        }
        if (object instanceof KClassValue) {
            if ((iterator2 = (KClassValue$Value)((KClassValue)((Object)iterator2)).getValue()) instanceof KClassValue$Value$LocalClass) {
                return ((KClassValue$Value$LocalClass)((Object)iterator2)).getType() + "::class";
            }
            if (iterator2 instanceof KClassValue$Value$NormalClass) {
                String string = ((KClassValue$Value$NormalClass)((Object)iterator2)).getClassId().asSingleFqName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                object = string;
                int n = ((KClassValue$Value$NormalClass)((Object)iterator2)).getArrayDimensions();
                for (int i = 0; i < n; ++i) {
                    object = "kotlin.Array<" + object + '>';
                }
                return object + "::class";
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((ConstantValue)((Object)iterator2)).toString();
    }

    private final boolean renderVisibility(DescriptorVisibility descriptorVisibility, StringBuilder stringBuilder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY)) {
            return false;
        }
        if (this.getNormalizedVisibilities()) {
            descriptorVisibility = descriptorVisibility.normalize();
        }
        if (!this.getRenderDefaultVisibility() && Intrinsics.areEqual((Object)descriptorVisibility, (Object)DescriptorVisibilities.DEFAULT_VISIBILITY)) {
            return false;
        }
        stringBuilder.append(this.renderKeyword(descriptorVisibility.getInternalDisplayName())).append(" ");
        return true;
    }

    private final void renderModality(Modality modality, StringBuilder stringBuilder, Modality modality2) {
        if (!this.getRenderDefaultModality() && modality == modality2) {
            return;
        }
        this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(modality.name()));
    }

    private final Modality implicitModalityWithoutExtensions(MemberDescriptor memberDescriptor) {
        if (memberDescriptor instanceof ClassDescriptor) {
            if (((ClassDescriptor)memberDescriptor).getKind() == ClassKind.INTERFACE) {
                return Modality.ABSTRACT;
            }
            return Modality.FINAL;
        }
        DeclarationDescriptor declarationDescriptor = memberDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return Modality.FINAL;
        }
        declarationDescriptor = classDescriptor;
        if (!(memberDescriptor instanceof CallableMemberDescriptor)) {
            return Modality.FINAL;
        }
        Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)memberDescriptor).getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        if (!collection.isEmpty() && declarationDescriptor.getModality() != Modality.FINAL) {
            return Modality.OPEN;
        }
        if (declarationDescriptor.getKind() == ClassKind.INTERFACE && !Intrinsics.areEqual((Object)((CallableMemberDescriptor)memberDescriptor).getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            if (((CallableMemberDescriptor)memberDescriptor).getModality() == Modality.ABSTRACT) {
                return Modality.ABSTRACT;
            }
            return Modality.OPEN;
        }
        return Modality.FINAL;
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callableMemberDescriptor) || callableMemberDescriptor.getModality() != Modality.FINAL) {
            if (this.getOverrideRenderingPolicy() == OverrideRenderingPolicy.RENDER_OVERRIDE && callableMemberDescriptor.getModality() == Modality.OPEN && this.overridesSomething(callableMemberDescriptor)) {
                return;
            }
            Modality modality = callableMemberDescriptor.getModality();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"");
            this.renderModality(modality, stringBuilder, this.implicitModalityWithoutExtensions(callableMemberDescriptor));
        }
    }

    private final void renderOverride(CallableMemberDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMemberDescriptor) && this.getOverrideRenderingPolicy() != OverrideRenderingPolicy.RENDER_OPEN) {
            this.renderModifier(stringBuilder, true, "override");
            if (this.getVerbose()) {
                stringBuilder.append("/*").append(callableMemberDescriptor.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private final void renderMemberKind(CallableMemberDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND)) {
            return;
        }
        if (this.getVerbose() && callableMemberDescriptor.getKind() != CallableMemberDescriptor$Kind.DECLARATION) {
            stringBuilder.append("/*").append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(callableMemberDescriptor.getKind().name())).append("*/ ");
        }
    }

    private final void renderModifier(StringBuilder stringBuilder, boolean bl, String string) {
        if (bl) {
            stringBuilder.append(this.renderKeyword(string));
            stringBuilder.append(" ");
        }
    }

    private final void renderMemberModifiers(MemberDescriptor memberDescriptor, StringBuilder stringBuilder) {
        this.renderModifier(stringBuilder, memberDescriptor.isExternal(), "external");
        this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.EXPECT) && memberDescriptor.isExpect(), "expect");
        this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.ACTUAL) && memberDescriptor.isActual(), "actual");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void renderAdditionalModifiers(FunctionDescriptor var1_1, StringBuilder var2_2) {
        if (!var1_1.isOperator()) ** GOTO lbl-1000
        v0 = var1_1.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(v0, (String)"");
        var4_3 = v0;
        if (!((Collection)var4_3).isEmpty()) {
            var3_5 = var4_3.iterator();
            while (var3_5.hasNext()) {
                var4_3 = var3_5.next();
                var5_7 /* !! */  = (FunctionDescriptor)var4_3;
                if (!var5_7 /* !! */ .isOperator()) continue;
                v1 = false;
                break;
            }
        } else {
            v1 = true;
        }
        if (v1 || this.getAlwaysRenderModifiers()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = var3_6 = false;
        }
        if (!var1_1.isInfix()) ** GOTO lbl-1000
        v3 = var1_1.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(v3, (String)"");
        var4_3 = v3;
        if (!((Collection)var4_3).isEmpty()) {
            var4_3 = var4_3.iterator();
            while (var4_3.hasNext()) {
                var5_7 /* !! */  = var4_3.next();
                if (!(var5_7 /* !! */  = (FunctionDescriptor)var5_7 /* !! */ ).isInfix()) continue;
                v4 = false;
                break;
            }
        } else {
            v4 = true;
        }
        if (v4 || this.getAlwaysRenderModifiers()) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        var4_4 = v5;
        this.renderModifier(var2_2, var1_1.isTailrec(), "tailrec");
        this.renderSuspendModifier(var1_1, var2_2);
        this.renderModifier(var2_2, var1_1.isInline(), "inline");
        this.renderModifier(var2_2, var4_4, "infix");
        this.renderModifier(var2_2, var3_6, "operator");
    }

    private final void renderSuspendModifier(FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
        this.renderModifier(stringBuilder, functionDescriptor.isSuspend(), "suspend");
    }

    @Override
    public final String render(DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        declarationDescriptor.accept(new DescriptorRendererImpl$RenderDeclarationDescriptorVisitor(this), stringBuilder2);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn(stringBuilder2, declarationDescriptor);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private final void renderTypeParameter(TypeParameterDescriptor object, StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(this.lt());
        }
        if (this.getVerbose()) {
            stringBuilder.append("/*").append(object.getIndex()).append("*/ ");
        }
        this.renderModifier(stringBuilder, object.isReified(), "reified");
        String string = object.getVariance().getLabel();
        this.renderModifier(stringBuilder, ((CharSequence)string).length() > 0, string);
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, (Annotated)object, null, 2, null);
        this.renderName((DeclarationDescriptor)object, stringBuilder, bl);
        int n = object.getUpperBounds().size();
        if (n > 1 && !bl || n == 1) {
            KotlinType kotlinType = object.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(kotlinType)) {
                StringBuilder stringBuilder2 = stringBuilder.append(" : ");
                Intrinsics.checkNotNull((Object)kotlinType);
                stringBuilder2.append(this.renderType(kotlinType));
            }
        } else if (bl) {
            n = 1;
            for (KotlinType kotlinType : object.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(kotlinType)) continue;
                if (n != 0) {
                    stringBuilder.append(" : ");
                } else {
                    stringBuilder.append(" & ");
                }
                Intrinsics.checkNotNull((Object)kotlinType);
                stringBuilder.append(this.renderType(kotlinType));
                n = 0;
            }
        }
        if (bl) {
            stringBuilder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> list, StringBuilder stringBuilder, boolean bl) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!((Collection)list).isEmpty()) {
            stringBuilder.append(this.lt());
            this.renderTypeParameterList(stringBuilder, list);
            stringBuilder.append(this.gt());
            if (bl) {
                stringBuilder.append(" ");
            }
        }
    }

    private final void renderTypeParameterList(StringBuilder stringBuilder, List<? extends TypeParameterDescriptor> object) {
        object = object.iterator();
        while (object.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)object.next();
            this.renderTypeParameter(typeParameterDescriptor, stringBuilder, false);
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
    }

    private final void renderFunction(FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, functionDescriptor, null, 2, null);
                List<ReceiverParameterDescriptor> list = functionDescriptor.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                this.renderContextReceivers(list, stringBuilder);
                DescriptorVisibility descriptorVisibility = functionDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
                this.renderVisibility(descriptorVisibility, stringBuilder);
                this.renderModalityForCallable(functionDescriptor, stringBuilder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderMemberModifiers(functionDescriptor, stringBuilder);
                }
                this.renderOverride(functionDescriptor, stringBuilder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderAdditionalModifiers(functionDescriptor, stringBuilder);
                } else {
                    this.renderSuspendModifier(functionDescriptor, stringBuilder);
                }
                this.renderMemberKind(functionDescriptor, stringBuilder);
                if (this.getVerbose()) {
                    if (functionDescriptor.isHiddenToOvercomeSignatureClash()) {
                        stringBuilder.append("/*isHiddenToOvercomeSignatureClash*/ ");
                    }
                    if (functionDescriptor.isHiddenForResolutionEverywhereBesideSupercalls()) {
                        stringBuilder.append("/*isHiddenForResolutionEverywhereBesideSupercalls*/ ");
                    }
                }
            }
            stringBuilder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = functionDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            this.renderTypeParameters(list, stringBuilder, true);
            this.renderReceiver(functionDescriptor, stringBuilder);
        }
        this.renderName(functionDescriptor, stringBuilder, true);
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list, functionDescriptor.hasSynthesizedParameterNames(), stringBuilder);
        this.renderReceiverAfterName(functionDescriptor, stringBuilder);
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && kotlinType != null && KotlinBuiltIns.isUnit(kotlinType))) {
            KotlinType kotlinType2 = kotlinType;
            stringBuilder.append(": ").append(kotlinType2 == null ? "[NULL]" : this.renderType(kotlinType2));
        }
        List<TypeParameterDescriptor> list2 = functionDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"");
        this.renderWhereSuffix(list2, stringBuilder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder stringBuilder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        if ((callableDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null) {
            StringBuilder stringBuilder2 = stringBuilder.append(" on ");
            KotlinType kotlinType = callableDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            stringBuilder2.append(this.renderType(kotlinType));
        }
    }

    private final String renderForReceiver(KotlinType kotlinType) {
        String string = this.renderType(kotlinType);
        if (this.shouldRenderAsPrettyFunctionType(kotlinType) && !TypeUtils.isNullableType(kotlinType) || kotlinType instanceof DefinitelyNotNullType) {
            string = "(" + string + ')';
        }
        return string;
    }

    private final void renderContextReceivers(List<? extends ReceiverParameterDescriptor> list, StringBuilder stringBuilder) {
        if (!(!((Collection)list).isEmpty())) {
            return;
        }
        stringBuilder.append("context(");
        Iterator<? extends ReceiverParameterDescriptor> iterator2 = list.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2 = n++;
            Object object = iterator2.next();
            this.renderAnnotations(stringBuilder, (Annotated)object, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = object.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            object = this.renderForReceiver(kotlinType);
            stringBuilder.append((String)object);
            if (n2 == CollectionsKt.getLastIndex(list)) {
                stringBuilder.append(") ");
                continue;
            }
            stringBuilder.append(", ");
        }
    }

    private final void renderReceiver(CallableDescriptor object, StringBuilder stringBuilder) {
        if ((object = object.getExtensionReceiverParameter()) != null) {
            this.renderAnnotations(stringBuilder, (Annotated)object, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = object.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            object = this.renderForReceiver(kotlinType);
            stringBuilder.append((String)object).append(".");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void renderConstructor(ConstructorDescriptor var1_1, StringBuilder var2_2) {
        DescriptorRendererImpl.renderAnnotations$default(this, var2_2, var1_1, null, 2, null);
        if (!this.options.getRenderDefaultVisibility() && var1_1.getConstructedClass().getModality() == Modality.SEALED) ** GOTO lbl-1000
        v0 = var1_1.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"");
        if (this.renderVisibility(v0, var2_2)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        var3_3 = v1;
        this.renderMemberKind(var1_1, var2_2);
        var3_3 = this.getRenderConstructorKeyword() != false || var1_1.isPrimary() == false || var3_3 != false;
        if (var3_3) {
            var2_2.append(this.renderKeyword("constructor"));
        }
        v2 = var1_1.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"");
        var4_5 = v2;
        if (this.getSecondaryConstructorsAsPrimary()) {
            if (var3_3) {
                var2_2.append(" ");
            }
            this.renderName((DeclarationDescriptor)var4_5, var2_2, true);
            v3 = var1_1.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(v3, (String)"");
            this.renderTypeParameters(v3, var2_2, false);
        }
        v4 = var1_1.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(v4, (String)"");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)v4, var1_1.hasSynthesizedParameterNames(), var2_2);
        if (this.getRenderConstructorDelegation() && !var1_1.isPrimary() && var4_5 instanceof ClassDescriptor && (var3_4 = ((ClassDescriptor)var4_5).getUnsubstitutedPrimaryConstructor()) != null) {
            v5 = var3_4.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(v5, (String)"");
            var3_4 = v5;
            var4_5 = new ArrayList<E>();
            var3_4 = var3_4.iterator();
            while (var3_4.hasNext()) {
                var5_6 = var3_4.next();
                var6_7 = (ValueParameterDescriptor)var5_6;
                if (!(var6_7.declaresDefaultValue() == false && var6_7.getVarargElementType() == null)) continue;
                var4_5.add(var5_6);
            }
            var3_4 = (List)var4_5;
            if (((Collection)var3_4).isEmpty() == false) {
                var2_2.append(" : ").append(this.renderKeyword("this"));
                var2_2.append(CollectionsKt.joinToString$default((Iterable)((Iterable)var3_4), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)DescriptorRendererImpl$renderConstructor$1.INSTANCE, (int)24, null));
            }
        }
        if (this.getSecondaryConstructorsAsPrimary()) {
            v6 = var1_1.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(v6, (String)"");
            this.renderWhereSuffix(v6, var2_2);
        }
    }

    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> object, StringBuilder stringBuilder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList arrayList = new ArrayList(0);
        object = object.iterator();
        while (object.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)object.next();
            List<KotlinType> list = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            Object object2 = CollectionsKt.drop((Iterable)list, (int)1);
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3 = object2.next();
                object3 = (KotlinType)object3;
                Collection collection = arrayList;
                StringBuilder stringBuilder2 = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                StringBuilder stringBuilder3 = stringBuilder2.append(this.renderName(name, false)).append(" : ");
                Intrinsics.checkNotNull(object3);
                collection.add(stringBuilder3.append(this.renderType((KotlinType)object3)).toString());
            }
        }
        if (!((Collection)arrayList).isEmpty()) {
            stringBuilder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default((Iterable)arrayList, (Appendable)stringBuilder, (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
        }
    }

    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> object, boolean bl, StringBuilder stringBuilder) {
        bl = this.shouldRenderParameterNames(bl);
        int n = object.size();
        this.getValueParametersHandler().appendBeforeValueParameters(n, stringBuilder);
        object = object.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            int n3 = n2++;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)object.next();
            this.getValueParametersHandler().appendBeforeValueParameter(valueParameterDescriptor, n3, n, stringBuilder);
            this.renderValueParameter(valueParameterDescriptor, bl, stringBuilder, false);
            this.getValueParametersHandler().appendAfterValueParameter(valueParameterDescriptor, n3, n, stringBuilder);
        }
        this.getValueParametersHandler().appendAfterValueParameters(n, stringBuilder);
    }

    private final boolean shouldRenderParameterNames(boolean bl) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$1[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return !bl;
            }
            case 3: {
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * Unable to fully structure code
     */
    private final void renderValueParameter(ValueParameterDescriptor var1_1, boolean var2_2, StringBuilder var3_3, boolean var4_4) {
        if (var4_4) {
            var3_3.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            var3_3.append("/*").append(var1_1.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl.renderAnnotations$default(this, var3_3, var1_1, null, 2, null);
        this.renderModifier(var3_3, var1_1.isCrossinline(), "crossinline");
        this.renderModifier(var3_3, var1_1.isNoinline(), "noinline");
        if (!this.getRenderPrimaryConstructorParametersAsProperties()) ** GOTO lbl-1000
        var5_5 = var1_1.getContainingDeclaration();
        v0 = var5_5 instanceof ClassConstructorDescriptor != false ? (ClassConstructorDescriptor)var5_5 : null;
        v1 = v0 != null ? v0.isPrimary() : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = var5_6 = false;
        }
        if (v2) {
            this.renderModifier(var3_3, this.getActualPropertiesInPrimaryConstructor(), "actual");
        }
        this.renderVariable(var1_1, var2_2, var3_3, var4_4, var5_6);
        if (this.getDefaultParameterValueRenderer() != null && (this.getDebugMode() != false ? var1_1.declaresDefaultValue() : DescriptorUtilsKt.declaresOrInheritsDefaultValue(var1_1)) != false ? true : (var2_2 = false)) {
            v3 = new StringBuilder(" = ");
            v4 = this.getDefaultParameterValueRenderer();
            Intrinsics.checkNotNull(v4);
            var3_3.append(v3.append((String)v4.invoke((Object)var1_1)).toString());
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variableDescriptor, StringBuilder stringBuilder, boolean bl) {
        if (bl || !(variableDescriptor instanceof ValueParameterDescriptor)) {
            stringBuilder.append(this.renderKeyword(variableDescriptor.isVar() ? "var" : "val")).append(" ");
        }
    }

    static /* synthetic */ void renderValVarPrefix$default(DescriptorRendererImpl descriptorRendererImpl, VariableDescriptor variableDescriptor, StringBuilder stringBuilder, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        descriptorRendererImpl.renderValVarPrefix(variableDescriptor, stringBuilder, bl);
    }

    private final void renderVariable(VariableDescriptor variableDescriptor, boolean bl, StringBuilder stringBuilder, boolean bl2, boolean bl3) {
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = kotlinType;
        ValueParameterDescriptor valueParameterDescriptor = variableDescriptor instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)variableDescriptor : null;
        KotlinType kotlinType3 = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType4 = kotlinType3;
        if (kotlinType3 == null) {
            kotlinType4 = kotlinType2;
        }
        KotlinType kotlinType5 = kotlinType4;
        this.renderModifier(stringBuilder, kotlinType3 != null, "vararg");
        if (bl3 || bl2 && !this.getStartFromName()) {
            this.renderValVarPrefix(variableDescriptor, stringBuilder, bl3);
        }
        if (bl) {
            this.renderName(variableDescriptor, stringBuilder, bl2);
            stringBuilder.append(": ");
        }
        stringBuilder.append(this.renderType(kotlinType5));
        this.renderInitializer(variableDescriptor, stringBuilder);
        if (this.getVerbose() && kotlinType3 != null) {
            stringBuilder.append(" /*").append(this.renderType(kotlinType2)).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor propertyDescriptor, StringBuilder stringBuilder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                this.renderPropertyAnnotations(propertyDescriptor, stringBuilder);
                List<ReceiverParameterDescriptor> list = propertyDescriptor.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                this.renderContextReceivers(list, stringBuilder);
                DescriptorVisibility descriptorVisibility = propertyDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
                this.renderVisibility(descriptorVisibility, stringBuilder);
                this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.CONST) && propertyDescriptor.isConst(), "const");
                this.renderMemberModifiers(propertyDescriptor, stringBuilder);
                this.renderModalityForCallable(propertyDescriptor, stringBuilder);
                this.renderOverride(propertyDescriptor, stringBuilder);
                this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.LATEINIT) && propertyDescriptor.isLateInit(), "lateinit");
                this.renderMemberKind(propertyDescriptor, stringBuilder);
            }
            DescriptorRendererImpl.renderValVarPrefix$default(this, propertyDescriptor, stringBuilder, false, 4, null);
            List<TypeParameterDescriptor> list = propertyDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            this.renderTypeParameters(list, stringBuilder, true);
            this.renderReceiver(propertyDescriptor, stringBuilder);
        }
        this.renderName(propertyDescriptor, stringBuilder, true);
        StringBuilder stringBuilder2 = stringBuilder.append(": ");
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        stringBuilder2.append(this.renderType(kotlinType));
        this.renderReceiverAfterName(propertyDescriptor, stringBuilder);
        this.renderInitializer(propertyDescriptor, stringBuilder);
        List<TypeParameterDescriptor> list = propertyDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        this.renderWhereSuffix(list, stringBuilder);
    }

    private final void renderPropertyAnnotations(PropertyDescriptor callableDescriptor, StringBuilder stringBuilder) {
        Annotated annotated;
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, callableDescriptor, null, 2, null);
        FieldDescriptor fieldDescriptor = callableDescriptor.getBackingField();
        if (fieldDescriptor != null) {
            annotated = fieldDescriptor;
            this.renderAnnotations(stringBuilder, annotated, AnnotationUseSiteTarget.FIELD);
        }
        FieldDescriptor fieldDescriptor2 = callableDescriptor.getDelegateField();
        if (fieldDescriptor2 != null) {
            annotated = fieldDescriptor2;
            this.renderAnnotations(stringBuilder, annotated, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
        }
        if (this.getPropertyAccessorRenderingPolicy() == PropertyAccessorRenderingPolicy.NONE) {
            PropertyGetterDescriptor propertyGetterDescriptor = callableDescriptor.getGetter();
            if (propertyGetterDescriptor != null) {
                annotated = propertyGetterDescriptor;
                this.renderAnnotations(stringBuilder, annotated, AnnotationUseSiteTarget.PROPERTY_GETTER);
            }
            PropertySetterDescriptor propertySetterDescriptor = callableDescriptor.getSetter();
            if (propertySetterDescriptor != null) {
                annotated = propertySetterDescriptor;
                callableDescriptor = propertySetterDescriptor;
                this.renderAnnotations(stringBuilder, callableDescriptor, AnnotationUseSiteTarget.PROPERTY_SETTER);
                List<ValueParameterDescriptor> list = annotated.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                callableDescriptor = (ValueParameterDescriptor)CollectionsKt.single(list);
                Intrinsics.checkNotNull((Object)callableDescriptor);
                this.renderAnnotations(stringBuilder, callableDescriptor, AnnotationUseSiteTarget.SETTER_PARAMETER);
                return;
            }
        }
    }

    private final void renderInitializer(VariableDescriptor object, StringBuilder stringBuilder) {
        if (this.getIncludePropertyConstant()) {
            ConstantValue<?> constantValue = object.getCompileTimeInitializer();
            if (constantValue != null) {
                object = constantValue;
                if ((object = this.renderConstant((ConstantValue<?>)object)) != null) {
                    stringBuilder.append(" = ").append(this.escape((String)object));
                }
                return;
            }
        }
    }

    private final void renderTypeAlias(TypeAliasDescriptor typeAliasDescriptor, StringBuilder stringBuilder) {
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, typeAliasDescriptor, null, 2, null);
        DescriptorVisibility descriptorVisibility = typeAliasDescriptor.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
        this.renderVisibility(descriptorVisibility, stringBuilder);
        this.renderMemberModifiers(typeAliasDescriptor, stringBuilder);
        stringBuilder.append(this.renderKeyword("typealias")).append(" ");
        this.renderName(typeAliasDescriptor, stringBuilder, true);
        List<TypeParameterDescriptor> list = typeAliasDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        this.renderTypeParameters(list, stringBuilder, false);
        this.renderCapturedTypeParametersIfRequired(typeAliasDescriptor, stringBuilder);
        stringBuilder.append(" = ").append(this.renderType(typeAliasDescriptor.getUnderlyingType()));
    }

    private final void renderCapturedTypeParametersIfRequired(ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters, StringBuilder stringBuilder) {
        List<TypeParameterDescriptor> list = classifierDescriptorWithTypeParameters.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        List<TypeParameterDescriptor> list2 = list;
        List<TypeParameterDescriptor> list3 = classifierDescriptorWithTypeParameters.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"");
        List<TypeParameterDescriptor> list4 = list3;
        if (this.getVerbose() && classifierDescriptorWithTypeParameters.isInner() && list4.size() > list2.size()) {
            stringBuilder.append(" /*captured type parameters: ");
            this.renderTypeParameterList(stringBuilder, list4.subList(list2.size(), list4.size()));
            stringBuilder.append("*/");
        }
    }

    private final void renderClass(ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        ClassConstructorDescriptor classConstructorDescriptor;
        boolean bl;
        boolean bl2 = bl = classDescriptor.getKind() == ClassKind.ENUM_ENTRY;
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, classDescriptor, null, 2, null);
            List<ReceiverParameterDescriptor> list = classDescriptor.getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            this.renderContextReceivers(list, stringBuilder);
            if (!bl) {
                DescriptorVisibility descriptorVisibility = classDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
                this.renderVisibility(descriptorVisibility, stringBuilder);
            }
            if (!(classDescriptor.getKind() == ClassKind.INTERFACE && classDescriptor.getModality() == Modality.ABSTRACT || classDescriptor.getKind().isSingleton() && classDescriptor.getModality() == Modality.FINAL)) {
                Modality modality = classDescriptor.getModality();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"");
                this.renderModality(modality, stringBuilder, this.implicitModalityWithoutExtensions(classDescriptor));
            }
            this.renderMemberModifiers(classDescriptor, stringBuilder);
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) && classDescriptor.isInner(), "inner");
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) && classDescriptor.isData(), "data");
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.INLINE) && classDescriptor.isInline(), "inline");
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.VALUE) && classDescriptor.isValue(), "value");
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.FUN) && classDescriptor.isFun(), "fun");
            this.renderClassKindPrefix(classDescriptor, stringBuilder);
        }
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(stringBuilder);
            }
            this.renderName(classDescriptor, stringBuilder, true);
        } else {
            this.renderCompanionObjectName(classDescriptor, stringBuilder);
        }
        if (bl) {
            return;
        }
        List<TypeParameterDescriptor> list = classDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        List<TypeParameterDescriptor> list2 = list;
        this.renderTypeParameters(list2, stringBuilder, false);
        this.renderCapturedTypeParametersIfRequired(classDescriptor, stringBuilder);
        if (!classDescriptor.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
            stringBuilder.append(" ");
            DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, classConstructorDescriptor, null, 2, null);
            DescriptorVisibility descriptorVisibility = classConstructorDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
            this.renderVisibility(descriptorVisibility, stringBuilder);
            stringBuilder.append(this.renderKeyword("constructor"));
            List<ValueParameterDescriptor> list3 = classConstructorDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"");
            this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list3, classConstructorDescriptor.hasSynthesizedParameterNames(), stringBuilder);
        }
        this.renderSuperTypes(classDescriptor, stringBuilder);
        this.renderWhereSuffix(list2, stringBuilder);
    }

    private final void renderSuperTypes(ClassDescriptor object, StringBuilder stringBuilder) {
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (KotlinBuiltIns.isNothing(object.getDefaultType())) {
            return;
        }
        Collection<KotlinType> collection = object.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        object = collection;
        if (collection.isEmpty() || object.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny((KotlinType)object.iterator().next())) {
            return;
        }
        this.renderSpaceIfNeeded(stringBuilder);
        stringBuilder.append(": ");
        CollectionsKt.joinTo$default((Iterable)((Iterable)object), (Appendable)stringBuilder, (CharSequence)", ", null, null, (int)0, null, (Function1)new DescriptorRendererImpl$renderSuperTypes$1(this), (int)60, null);
    }

    private final void renderClassKindPrefix(ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        stringBuilder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassifierKindPrefix(classDescriptor)));
    }

    private final void renderPackageView(PackageViewDescriptor packageViewDescriptor, StringBuilder stringBuilder) {
        this.renderPackageHeader(packageViewDescriptor.getFqName(), "package", stringBuilder);
        if (this.getDebugMode()) {
            stringBuilder.append(" in context of ");
            this.renderName(packageViewDescriptor.getModule(), stringBuilder, false);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor packageFragmentDescriptor, StringBuilder stringBuilder) {
        this.renderPackageHeader(packageFragmentDescriptor.getFqName(), "package-fragment", stringBuilder);
        if (this.getDebugMode()) {
            stringBuilder.append(" in ");
            this.renderName(packageFragmentDescriptor.getContainingDeclaration(), stringBuilder, false);
        }
    }

    private final void renderPackageHeader(FqName object, String string, StringBuilder stringBuilder) {
        stringBuilder.append(this.renderKeyword(string));
        FqNameUnsafe fqNameUnsafe = ((FqName)object).toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
        object = this.renderFqName(fqNameUnsafe);
        if (((CharSequence)object).length() > 0) {
            stringBuilder.append(" ");
            stringBuilder.append((String)object);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor propertyAccessorDescriptor, StringBuilder stringBuilder) {
        this.renderMemberModifiers(propertyAccessorDescriptor, stringBuilder);
    }

    private final void renderSpaceIfNeeded(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n == 0 || stringBuilder.charAt(n - 1) != ' ') {
            stringBuilder.append(' ');
        }
    }

    private final boolean overridesSomething(CallableMemberDescriptor callableMemberDescriptor) {
        return !callableMemberDescriptor.getOverriddenDescriptors().isEmpty();
    }

    public static final /* synthetic */ void access$renderValueParameter(DescriptorRendererImpl descriptorRendererImpl, ValueParameterDescriptor valueParameterDescriptor, boolean bl, StringBuilder stringBuilder, boolean bl2) {
        descriptorRendererImpl.renderValueParameter(valueParameterDescriptor, bl, stringBuilder, bl2);
    }

    public static final /* synthetic */ void access$renderProperty(DescriptorRendererImpl descriptorRendererImpl, PropertyDescriptor propertyDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderProperty(propertyDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderAccessorModifiers(DescriptorRendererImpl descriptorRendererImpl, PropertyAccessorDescriptor propertyAccessorDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderAccessorModifiers(propertyAccessorDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderFunction(DescriptorRendererImpl descriptorRendererImpl, FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderFunction(functionDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderConstructor(DescriptorRendererImpl descriptorRendererImpl, ConstructorDescriptor constructorDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderConstructor(constructorDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderTypeParameter(DescriptorRendererImpl descriptorRendererImpl, TypeParameterDescriptor typeParameterDescriptor, StringBuilder stringBuilder, boolean bl) {
        descriptorRendererImpl.renderTypeParameter(typeParameterDescriptor, stringBuilder, bl);
    }

    public static final /* synthetic */ void access$renderPackageFragment(DescriptorRendererImpl descriptorRendererImpl, PackageFragmentDescriptor packageFragmentDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderPackageFragment(packageFragmentDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderPackageView(DescriptorRendererImpl descriptorRendererImpl, PackageViewDescriptor packageViewDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderPackageView(packageViewDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderName(DescriptorRendererImpl descriptorRendererImpl, DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder, boolean bl) {
        descriptorRendererImpl.renderName(declarationDescriptor, stringBuilder, bl);
    }

    public static final /* synthetic */ void access$renderClass(DescriptorRendererImpl descriptorRendererImpl, ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderClass(classDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderTypeAlias(DescriptorRendererImpl descriptorRendererImpl, TypeAliasDescriptor typeAliasDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderTypeAlias(typeAliasDescriptor, stringBuilder);
    }
}

