/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType$Companion;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;

public final class SpecialTypesKt {
    public static final AbbreviatedType getAbbreviatedType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        kotlinType = kotlinType.unwrap();
        if (kotlinType instanceof AbbreviatedType) {
            return (AbbreviatedType)kotlinType;
        }
        return null;
    }

    public static final SimpleType getAbbreviation(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        AbbreviatedType abbreviatedType = SpecialTypesKt.getAbbreviatedType(kotlinType);
        if (abbreviatedType != null) {
            return abbreviatedType.getAbbreviation();
        }
        return null;
    }

    public static final SimpleType withAbbreviation(SimpleType simpleType2, SimpleType simpleType3) {
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        Intrinsics.checkNotNullParameter((Object)simpleType3, (String)"");
        if (KotlinTypeKt.isError(simpleType2)) {
            return simpleType2;
        }
        return new AbbreviatedType(simpleType2, simpleType3);
    }

    public static final boolean isDefinitelyNotNullType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return kotlinType.unwrap() instanceof DefinitelyNotNullType;
    }

    public static final SimpleType makeSimpleTypeDefinitelyNotNullOrNotNull(SimpleType simpleType2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType$Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, simpleType2, bl, false, 4, null);
        if (definitelyNotNullType != null) {
            return definitelyNotNullType;
        }
        SimpleType simpleType3 = SpecialTypesKt.makeIntersectionTypeDefinitelyNotNullOrNotNull(simpleType2);
        if (simpleType3 == null) {
            simpleType3 = simpleType2.makeNullableAsSpecified(false);
        }
        return simpleType3;
    }

    public static /* synthetic */ SimpleType makeSimpleTypeDefinitelyNotNullOrNotNull$default(SimpleType simpleType2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull(simpleType2, bl);
    }

    public static final NewCapturedType withNotNullProjection(NewCapturedType newCapturedType) {
        Intrinsics.checkNotNullParameter((Object)newCapturedType, (String)"");
        return new NewCapturedType(newCapturedType.getCaptureStatus(), newCapturedType.getConstructor(), newCapturedType.getLowerType(), newCapturedType.getAttributes(), newCapturedType.isMarkedNullable(), true);
    }

    public static final UnwrappedType makeDefinitelyNotNullOrNotNull(UnwrappedType unwrappedType, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType$Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, unwrappedType, bl, false, 4, null);
        if (definitelyNotNullType != null) {
            return definitelyNotNullType;
        }
        SimpleType simpleType2 = SpecialTypesKt.makeIntersectionTypeDefinitelyNotNullOrNotNull(unwrappedType);
        if (simpleType2 != null) {
            return simpleType2;
        }
        return unwrappedType.makeNullableAsSpecified(false);
    }

    public static /* synthetic */ UnwrappedType makeDefinitelyNotNullOrNotNull$default(UnwrappedType unwrappedType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(unwrappedType, bl);
    }

    private static final SimpleType makeIntersectionTypeDefinitelyNotNullOrNotNull(KotlinType object) {
        IntersectionTypeConstructor intersectionTypeConstructor = (object = ((KotlinType)object).getConstructor()) instanceof IntersectionTypeConstructor ? (IntersectionTypeConstructor)object : null;
        if (intersectionTypeConstructor == null) {
            return null;
        }
        object = intersectionTypeConstructor;
        IntersectionTypeConstructor intersectionTypeConstructor2 = SpecialTypesKt.makeDefinitelyNotNullOrNotNull(intersectionTypeConstructor);
        if (intersectionTypeConstructor2 == null) {
            return null;
        }
        object = intersectionTypeConstructor2;
        return intersectionTypeConstructor2.createType();
    }

    private static final IntersectionTypeConstructor makeDefinitelyNotNullOrNotNull(IntersectionTypeConstructor intersectionTypeConstructor) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        Object object4 = object3 = (Iterable)intersectionTypeConstructor.getSupertypes();
        object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        object4 = object4.iterator();
        while (object4.hasNext()) {
            Object object5;
            Object object6 = object4.next();
            object6 = (KotlinType)object6;
            Iterable iterable = object3;
            object2 = object6;
            if (TypeUtils.isNullableType(object2)) {
                bl = true;
                object2 = object6;
                object5 = SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(((KotlinType)object2).unwrap(), false, 1, null);
            } else {
                object5 = object6;
            }
            iterable.add(object5);
        }
        object4 = (List)object3;
        if (!bl) {
            return null;
        }
        KotlinType kotlinType = intersectionTypeConstructor.getAlternativeType();
        if (kotlinType != null) {
            object3 = kotlinType;
            object2 = kotlinType;
            if (TypeUtils.isNullableType(kotlinType)) {
                object2 = object3;
                object = SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(((KotlinType)object2).unwrap(), false, 1, null);
            } else {
                object = object3;
            }
        } else {
            object = null;
        }
        object3 = object;
        return new IntersectionTypeConstructor((Collection)object4).setAlternative((KotlinType)object3);
    }
}

