/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.ELFAnalyser$ArmAeabiAttributesTag;
import com.sun.jna.ELFAnalyser$ELFSectionHeaderEntry;
import com.sun.jna.ELFAnalyser$ELFSectionHeaders;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ELFAnalyser {
    private static final byte[] ELF_MAGIC = new byte[]{127, 69, 76, 70};
    private static final int EF_ARM_ABI_FLOAT_HARD = 1024;
    private static final int EF_ARM_ABI_FLOAT_SOFT = 512;
    private static final int EI_DATA_BIG_ENDIAN = 2;
    private static final int E_MACHINE_ARM = 40;
    private static final int EI_CLASS_64BIT = 2;
    private final String filename;
    private boolean ELF = false;
    private boolean _64Bit = false;
    private boolean bigEndian = false;
    private boolean armHardFloatFlag = false;
    private boolean armSoftFloatFlag = false;
    private boolean armEabiAapcsVfp = false;
    private boolean arm = false;

    public static ELFAnalyser analyse(String object) {
        object = new ELFAnalyser((String)object);
        ((ELFAnalyser)object).runDetection();
        return object;
    }

    public boolean isELF() {
        return this.ELF;
    }

    public boolean is64Bit() {
        return this._64Bit;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isArmHardFloat() {
        return this.isArmEabiAapcsVfp() || this.isArmHardFloatFlag();
    }

    public boolean isArmEabiAapcsVfp() {
        return this.armEabiAapcsVfp;
    }

    public boolean isArmHardFloatFlag() {
        return this.armHardFloatFlag;
    }

    public boolean isArmSoftFloatFlag() {
        return this.armSoftFloatFlag;
    }

    public boolean isArm() {
        return this.arm;
    }

    private ELFAnalyser(String string) {
        this.filename = string;
    }

    private void runDetection() {
        RandomAccessFile randomAccessFile;
        block12: {
            block11: {
                randomAccessFile = new RandomAccessFile(this.filename, "r");
                try {
                    if (randomAccessFile.length() > 4L) {
                        byte[] byArray = new byte[4];
                        randomAccessFile.seek(0L);
                        randomAccessFile.read(byArray);
                        if (Arrays.equals(byArray, ELF_MAGIC)) {
                            this.ELF = true;
                        }
                    }
                    if (this.ELF) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    randomAccessFile.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
            randomAccessFile.seek(4L);
            byte by = randomAccessFile.readByte();
            int n = randomAccessFile.readByte();
            this._64Bit = by == 2;
            this.bigEndian = n == 2;
            randomAccessFile.seek(0L);
            ByteBuffer byteBuffer = ByteBuffer.allocate(this._64Bit ? 64 : 52);
            randomAccessFile.getChannel().read(byteBuffer, 0L);
            byteBuffer.order(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            boolean bl = this.arm = byteBuffer.get(18) == 40;
            if (!this.arm) break block12;
            n = byteBuffer.getInt(this._64Bit ? 48 : 36);
            this.armHardFloatFlag = (n & 0x400) == 1024;
            this.armSoftFloatFlag = (n & 0x200) == 512;
            this.parseEabiAapcsVfp(byteBuffer, randomAccessFile);
        }
        try {
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void parseEabiAapcsVfp(ByteBuffer iterator, RandomAccessFile randomAccessFile) {
        iterator = new ELFAnalyser$ELFSectionHeaders(this._64Bit, this.bigEndian, (ByteBuffer)((Object)iterator), randomAccessFile);
        for (ELFAnalyser$ELFSectionHeaderEntry eLFAnalyser$ELFSectionHeaderEntry : ((ELFAnalyser$ELFSectionHeaders)((Object)iterator)).getEntries()) {
            if (!".ARM.attributes".equals(eLFAnalyser$ELFSectionHeaderEntry.getName())) continue;
            ByteBuffer byteBuffer = ByteBuffer.allocate(eLFAnalyser$ELFSectionHeaderEntry.getSize());
            byteBuffer.order(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            randomAccessFile.getChannel().read(byteBuffer, eLFAnalyser$ELFSectionHeaderEntry.getOffset());
            byteBuffer.rewind();
            Map<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>> map = ELFAnalyser.parseArmAttributes(byteBuffer);
            Map<ELFAnalyser$ArmAeabiAttributesTag, Object> map2 = map.get(1);
            if (map2 == null) continue;
            Object object = map2.get(ELFAnalyser$ArmAeabiAttributesTag.ABI_VFP_args);
            if (object instanceof Integer && ((Integer)object).equals(1)) {
                this.armEabiAapcsVfp = true;
                continue;
            }
            if (!(object instanceof BigInteger) || ((BigInteger)object).intValue() != 1) continue;
            this.armEabiAapcsVfp = true;
        }
    }

    private static Map<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>> parseArmAttributes(ByteBuffer byteBuffer) {
        int n = byteBuffer.get();
        if (n != 65) {
            return Collections.EMPTY_MAP;
        }
        while (byteBuffer.position() < byteBuffer.limit()) {
            n = byteBuffer.position();
            int n2 = byteBuffer.getInt();
            if (n2 <= 0) break;
            String string = ELFAnalyser.readNTBS(byteBuffer, null);
            if ("aeabi".equals(string)) {
                return ELFAnalyser.parseAEABI(byteBuffer);
            }
            ((Buffer)byteBuffer).position(n + n2);
        }
        return Collections.EMPTY_MAP;
    }

    private static Map<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>> parseAEABI(ByteBuffer byteBuffer) {
        HashMap<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>> hashMap = new HashMap<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>>();
        while (byteBuffer.position() < byteBuffer.limit()) {
            int n = byteBuffer.position();
            int n2 = ELFAnalyser.readULEB128(byteBuffer).intValue();
            int n3 = byteBuffer.getInt();
            if (n2 == 1) {
                hashMap.put(n2, ELFAnalyser.parseFileAttribute(byteBuffer));
            }
            ((Buffer)byteBuffer).position(n + n3);
        }
        return hashMap;
    }

    private static Map<ELFAnalyser$ArmAeabiAttributesTag, Object> parseFileAttribute(ByteBuffer byteBuffer) {
        HashMap<ELFAnalyser$ArmAeabiAttributesTag, Object> hashMap = new HashMap<ELFAnalyser$ArmAeabiAttributesTag, Object>();
        while (byteBuffer.position() < byteBuffer.limit()) {
            int n = ELFAnalyser.readULEB128(byteBuffer).intValue();
            ELFAnalyser$ArmAeabiAttributesTag eLFAnalyser$ArmAeabiAttributesTag = ELFAnalyser$ArmAeabiAttributesTag.getByValue(n);
            switch (eLFAnalyser$ArmAeabiAttributesTag.getParameterType()) {
                case UINT32: {
                    hashMap.put(eLFAnalyser$ArmAeabiAttributesTag, byteBuffer.getInt());
                    break;
                }
                case NTBS: {
                    hashMap.put(eLFAnalyser$ArmAeabiAttributesTag, ELFAnalyser.readNTBS(byteBuffer, null));
                    break;
                }
                case ULEB128: {
                    hashMap.put(eLFAnalyser$ArmAeabiAttributesTag, ELFAnalyser.readULEB128(byteBuffer));
                }
            }
        }
        return hashMap;
    }

    private static String readNTBS(ByteBuffer byteBuffer, Integer n) {
        int n2;
        if (n != null) {
            ((Buffer)byteBuffer).position(n);
        }
        int n3 = byteBuffer.position();
        while ((n2 = byteBuffer.get()) != 0 && byteBuffer.position() <= byteBuffer.limit()) {
        }
        n2 = byteBuffer.position();
        byte[] byArray = new byte[n2 - n3 - 1];
        ((Buffer)byteBuffer).position(n3);
        byteBuffer.get(byArray);
        ByteBuffer byteBuffer2 = byteBuffer;
        ((Buffer)byteBuffer2).position(byteBuffer2.position() + 1);
        try {
            return new String(byArray, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static BigInteger readULEB128(ByteBuffer byteBuffer) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (true) {
            byte by = byteBuffer.get();
            bigInteger = bigInteger.or(BigInteger.valueOf(by & 0x7F).shiftLeft(n));
            if ((by & 0x80) == 0) break;
            n += 7;
        }
        return bigInteger;
    }
}

