/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;

public final class DirectJson {
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private static final byte QUOTE = 34;
    private static final byte ENTRY_SEP = 58;
    private static final byte KV_SEP = 44;
    private static final byte DOT = 46;
    private static final byte OPEN_OBJ = 123;
    private static final byte CLOSE_OBJ = 125;
    private static final byte OPEN_ARR = 91;
    private static final byte CLOSE_ARR = 93;
    private static final byte[] NEWLINE = new byte[]{92, 110};
    private static final byte[] ESCAPE = new byte[]{92, 92};
    private static final byte[] LINEBREAK = new byte[]{92, 114};
    private static final byte[] TAB = new byte[]{92, 116};
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};
    private ByteBuffer buffer = ByteBuffer.allocateDirect(1024);

    public final void openObject() {
        this.buffer.put((byte)123);
    }

    public final void openArray() {
        this.buffer.put((byte)91);
    }

    public final void openObject(String string) {
        this.writeString(string);
        this.writeEntrySep();
        this.buffer.put((byte)123);
    }

    public final void openArray(String string) {
        this.writeString(string);
        this.writeEntrySep();
        this.buffer.put((byte)91);
    }

    public final void closeObject() {
        int n = this.buffer.position() - 1;
        if (44 == this.buffer.get(n)) {
            this.buffer.put(n, (byte)125);
            return;
        }
        this.buffer.put((byte)125);
    }

    public final void closeArray() {
        int n = this.buffer.position() - 1;
        if (44 == this.buffer.get(n)) {
            this.buffer.put(n, (byte)93);
            return;
        }
        this.buffer.put((byte)93);
    }

    public final void writeRaw(String string) {
        block6: for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            switch (n) {
                case 92: {
                    this.buffer.put(ESCAPE);
                    continue block6;
                }
                case 10: {
                    this.buffer.put(NEWLINE);
                    continue block6;
                }
                case 13: {
                    this.buffer.put(LINEBREAK);
                    continue block6;
                }
                case 9: {
                    this.buffer.put(TAB);
                    continue block6;
                }
                default: {
                    if (n >= 128 && n <= 0x10FFFF) {
                        this.buffer.put(String.valueOf(string.charAt(i)).getBytes());
                        continue block6;
                    }
                    if (n <= 31) continue block6;
                    this.buffer.put((byte)n);
                }
            }
        }
    }

    public final void writeRaw(char c) {
        this.buffer.put((byte)c);
    }

    public final void writeRaw(byte[] byArray) {
        this.buffer.put(byArray);
    }

    public final void writeQuote() {
        this.buffer.put((byte)34);
    }

    public final void writeString(String string) {
        this.checkSpace(string.length() + 3);
        this.buffer.put((byte)34);
        this.writeRaw(string);
        this.buffer.put((byte)34);
        this.buffer.put((byte)44);
    }

    public final void writeSep() {
        this.buffer.put((byte)44);
    }

    public final void writeNumberRaw(long l) {
        int n = this.buffer.position();
        int n2 = (int)Math.log10(l) + 1;
        long l2 = l;
        for (int i = n2 - 1; i >= 0; --i) {
            byte by = (byte)(l2 % 10L);
            l2 /= 10L;
            by = (byte)(by + 48);
            this.buffer.put(n + i, by);
        }
        this.buffer.position(n + n2);
    }

    public final void writeNumber(long l) {
        int n = this.buffer.position();
        int n2 = l == 0L ? 1 : (int)Math.log10(l) + 1;
        long l2 = l;
        for (int i = n2 - 1; i >= 0; --i) {
            byte by = (byte)(l2 % 10L);
            l2 /= 10L;
            by = (byte)(by + 48);
            this.buffer.put(n + i, by);
        }
        this.buffer.position(n + n2);
        this.buffer.put((byte)44);
    }

    public final void writeNumber(double d) {
        int n;
        int n2 = this.buffer.position();
        long l = (long)d;
        int n3 = (int)Math.log10(l) + 1;
        for (int i = n3 - 1; i >= 0; --i) {
            n = (int)(l % 10L);
            l /= 10L;
            n = (byte)(n + 48);
            this.buffer.put(n2 + i, (byte)n);
        }
        this.buffer.position(n2 + n3);
        this.buffer.put((byte)46);
        n2 = this.buffer.position();
        BigDecimal bigDecimal = BigDecimal.valueOf(d).remainder(BigDecimal.ONE);
        n = 0;
        while (!bigDecimal.equals(BigDecimal.ZERO)) {
            bigDecimal = bigDecimal.movePointRight(1);
            byte by = (byte)(bigDecimal.intValue() + 48);
            bigDecimal = bigDecimal.remainder(BigDecimal.ONE);
            ++n;
            this.buffer.put(by);
        }
        this.buffer.position(n2 + n);
        this.buffer.put((byte)44);
    }

    public final void writeEntrySep() {
        this.buffer.put(this.buffer.position() - 1, (byte)58);
    }

    public final void writeStringValue(String string, String string2) {
        this.writeString(string);
        this.writeEntrySep();
        this.writeString(string2);
    }

    public final void writeNumberValue(String string, long l) {
        this.writeString(string);
        this.writeEntrySep();
        this.writeNumber(l);
    }

    public final void writeNumberValue(String string, double d) {
        this.writeString(string);
        this.writeEntrySep();
        this.writeNumber(d);
    }

    public final void writeBoolean(boolean bl) {
        this.buffer.put(bl ? TRUE : FALSE);
        this.buffer.put((byte)44);
    }

    public final void writeNull() {
        this.buffer.put(NULL);
        this.buffer.put((byte)44);
    }

    public final void checkSpace(int n) {
        if (this.buffer.position() + n >= this.buffer.capacity()) {
            n = this.buffer.capacity() + n << 1;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
            this.buffer.flip();
            byteBuffer.put(this.buffer);
            this.buffer = byteBuffer;
        }
    }

    public final byte[] flush() {
        byte[] byArray = new byte[this.buffer.position()];
        this.buffer.flip();
        this.buffer.get(byArray);
        this.buffer.clear();
        return byArray;
    }
}

