/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.ExecutorServiceUtil$1;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorServiceUtil {
    private static final String NEW_VIRTUAL_TPT_METHOD_NAME = "newVirtualThreadPerTaskExecutor";
    private static final ThreadFactory THREAD_FACTORY_FOR_SCHEDULED_EXECUTION_SERVICE = new ExecutorServiceUtil$1();

    public static ScheduledExecutorService newScheduledExecutorService() {
        return new ScheduledThreadPoolExecutor(4, THREAD_FACTORY_FOR_SCHEDULED_EXECUTION_SERVICE);
    }

    public static ExecutorService newExecutorService() {
        return ExecutorServiceUtil.newThreadPoolExecutor();
    }

    public static ThreadPoolExecutor newThreadPoolExecutor() {
        return new ThreadPoolExecutor(0, 32, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), THREAD_FACTORY_FOR_SCHEDULED_EXECUTION_SERVICE);
    }

    public static void shutdown(ExecutorService executorService) {
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    public static ExecutorService newAlternateThreadPoolExecutor() {
        if (EnvUtil.isJDK21OrHigher()) {
            try {
                Method method = Executors.class.getMethod(NEW_VIRTUAL_TPT_METHOD_NAME, new Class[0]);
                return (ExecutorService)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return ExecutorServiceUtil.newThreadPoolExecutor();
            }
        }
        return ExecutorServiceUtil.newThreadPoolExecutor();
    }
}

