/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import javax.xml.datatype.FactoryFinder$ConfigurationError;
import javax.xml.datatype.SecuritySupport;

final class FactoryFinder {
    private static final String CLASS_NAME = "javax.xml.datatype.FactoryFinder";
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static final int DEFAULT_LINE_LENGTH = 80;
    static Class class$javax$xml$datatype$FactoryFinder;

    private FactoryFinder() {
    }

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("javax.xml.datatype.FactoryFinder:" + string);
        }
    }

    private static ClassLoader findClassLoader() {
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (debug) {
            FactoryFinder.debugPrintln("Using context class loader: " + classLoader);
        }
        if (classLoader == null) {
            classLoader = (class$javax$xml$datatype$FactoryFinder == null ? (class$javax$xml$datatype$FactoryFinder = FactoryFinder.class$(CLASS_NAME)) : class$javax$xml$datatype$FactoryFinder).getClassLoader();
            if (debug) {
                FactoryFinder.debugPrintln("Using the class loader of FactoryFinder: " + classLoader);
            }
        }
        return classLoader;
    }

    static Object newInstance(String string, ClassLoader clazz) {
        try {
            clazz = clazz == null ? Class.forName(string) : ((ClassLoader)((Object)clazz)).loadClass(string);
            if (debug) {
                FactoryFinder.debugPrintln("Loaded " + string + " from " + FactoryFinder.which(clazz));
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryFinder$ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new FactoryFinder$ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string, String string2) {
        Object object;
        ClassLoader classLoader;
        block18: {
            classLoader = FactoryFinder.findClassLoader();
            try {
                object = SecuritySupport.getSystemProperty(string);
                if (object != null && ((String)object).length() > 0) {
                    if (debug) {
                        FactoryFinder.debugPrintln("found " + (String)object + " in the system property " + string);
                    }
                    return FactoryFinder.newInstance((String)object, classLoader);
                }
            }
            catch (SecurityException securityException) {}
            try {
                object = SecuritySupport.getSystemProperty("java.home");
                object = (String)object + File.separator + "lib" + File.separator + "jaxp.properties";
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            object = new File((String)object);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist((File)object)) {
                                if (debug) {
                                    FactoryFinder.debugPrintln("Read properties file " + object);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream((File)object));
                            }
                        }
                    }
                }
                object = cacheProps.getProperty(string);
                if (debug) {
                    FactoryFinder.debugPrintln("found " + (String)object + " in $java.home/jaxp.properties");
                }
                if (object != null) {
                    return FactoryFinder.newInstance((String)object, classLoader);
                }
            }
            catch (Exception exception) {
                if (!debug) break block18;
                exception.printStackTrace();
            }
        }
        if ((object = FactoryFinder.findJarServiceProvider(string)) != null) {
            return object;
        }
        if (string2 == null) {
            throw new FactoryFinder$ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        if (debug) {
            FactoryFinder.debugPrintln("loaded from fallback value: " + string2);
        }
        return FactoryFinder.newInstance(string2, classLoader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object findJarServiceProvider(String object) {
        String string;
        InputStream inputStream;
        object = "META-INF/services/" + (String)object;
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (classLoader != null) {
            inputStream = SecuritySupport.getResourceAsStream(classLoader, (String)object);
            if (inputStream == null) {
                classLoader = (class$javax$xml$datatype$FactoryFinder == null ? (class$javax$xml$datatype$FactoryFinder = FactoryFinder.class$(CLASS_NAME)) : class$javax$xml$datatype$FactoryFinder).getClassLoader();
                inputStream = SecuritySupport.getResourceAsStream(classLoader, (String)object);
            }
        } else {
            classLoader = (class$javax$xml$datatype$FactoryFinder == null ? (class$javax$xml$datatype$FactoryFinder = FactoryFinder.class$(CLASS_NAME)) : class$javax$xml$datatype$FactoryFinder).getClassLoader();
            inputStream = SecuritySupport.getResourceAsStream(classLoader, (String)object);
        }
        if (inputStream == null) {
            return null;
        }
        if (debug) {
            FactoryFinder.debugPrintln("found jar resource=" + (String)object + " using ClassLoader: " + classLoader);
        }
        try {
            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        try {
            try {
                string = ((BufferedReader)object).readLine();
            }
            catch (IOException iOException) {
                Object var4_4 = null;
                inputStream = null;
                try {
                    ((BufferedReader)object).close();
                    return var4_4;
                }
                catch (IOException iOException2) {}
                return var4_4;
            }
            inputStream = null;
            {
            }
        }
        catch (Throwable throwable) {
            inputStream = null;
            try {}
            catch (IOException iOException) {}
            ((BufferedReader)object).close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((BufferedReader)object).close();
        if (string == null) return null;
        if ("".equals(string)) return null;
        if (!debug) return FactoryFinder.newInstance(string, classLoader);
        FactoryFinder.debugPrintln("found in resource, value=" + string);
        return FactoryFinder.newInstance(string, classLoader);
    }

    private static String which(Class object) {
        block5: {
            try {
                String string = ((Class)object).getName().replace('.', '/') + ".class";
                object = ((Class)object).getClassLoader();
                object = object != null ? ((ClassLoader)object).getResource(string) : ClassLoader.getSystemResource(string);
                if (object != null) {
                    return ((URL)object).toString();
                }
            }
            catch (VirtualMachineError virtualMachineError) {
                VirtualMachineError virtualMachineError2 = virtualMachineError;
                throw virtualMachineError;
            }
            catch (ThreadDeath threadDeath) {
                object = threadDeath;
                throw threadDeath;
            }
            catch (Throwable throwable) {
                if (!debug) break block5;
                throwable.printStackTrace();
            }
        }
        return "unknown location";
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (Exception exception) {
            debug = false;
        }
    }
}

