/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.svg;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.svg.SVGLength;
import org.jetbrains.skia.svg.SVGLengthContext$WhenMappings;
import org.jetbrains.skia.svg.SVGLengthType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0015J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0006R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/jetbrains/skia/svg/SVGLengthContext;", "", "size", "Lorg/jetbrains/skia/Point;", "(Lorg/jetbrains/skia/Point;)V", "width", "", "height", "dpi", "(FFF)V", "getDpi", "()F", "getHeight", "getWidth", "equals", "", "other", "hashCode", "", "resolve", "length", "Lorg/jetbrains/skia/svg/SVGLength;", "type", "Lorg/jetbrains/skia/svg/SVGLengthType;", "resolveRect", "Lorg/jetbrains/skia/Rect;", "x", "y", "toString", "", "withDpi", "_dpi", "withHeight", "_height", "withWidth", "_width", "skiko"})
public final class SVGLengthContext {
    private final float width;
    private final float height;
    private final float dpi;

    public SVGLengthContext(float f, float f2, float f3) {
        this.width = f;
        this.height = f2;
        this.dpi = f3;
    }

    public /* synthetic */ SVGLengthContext(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f3 = 90.0f;
        }
        this(f, f2, f3);
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getDpi() {
        return this.dpi;
    }

    public SVGLengthContext(Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        this(point.getX(), point.getY(), 90.0f);
    }

    public final float resolve(SVGLength sVGLength, SVGLengthType sVGLengthType) {
        Intrinsics.checkNotNullParameter((Object)sVGLength, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)sVGLengthType), (String)"");
        switch (SVGLengthContext$WhenMappings.$EnumSwitchMapping$1[sVGLength.getUnit().ordinal()]) {
            case 1: {
                return sVGLength.getValue();
            }
            case 2: {
                return sVGLength.getValue();
            }
            case 3: {
                switch (SVGLengthContext$WhenMappings.$EnumSwitchMapping$0[sVGLengthType.ordinal()]) {
                    case 1: {
                        return sVGLength.getValue() * this.width / 100.0f;
                    }
                    case 2: {
                        return sVGLength.getValue() * this.height / 100.0f;
                    }
                    case 3: {
                        return (float)((double)sVGLength.getValue() * Math.hypot(this.width, this.height) / Math.sqrt(2.0) / 100.0);
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                return sVGLength.getValue() * this.dpi / 2.54f;
            }
            case 5: {
                return sVGLength.getValue() * this.dpi / 25.4f;
            }
            case 6: {
                return sVGLength.getValue() * this.dpi;
            }
            case 7: {
                return sVGLength.getValue() * this.dpi / 72.272f;
            }
            case 8: {
                return sVGLength.getValue() * this.dpi * 12.0f / 72.272f;
            }
        }
        throw new IllegalArgumentException("Unknown SVGLengthUnit: " + (Object)((Object)sVGLength.getUnit()));
    }

    public final Rect resolveRect(SVGLength sVGLength, SVGLength sVGLength2, SVGLength sVGLength3, SVGLength sVGLength4) {
        Intrinsics.checkNotNullParameter((Object)sVGLength, (String)"");
        Intrinsics.checkNotNullParameter((Object)sVGLength2, (String)"");
        Intrinsics.checkNotNullParameter((Object)sVGLength3, (String)"");
        Intrinsics.checkNotNullParameter((Object)sVGLength4, (String)"");
        return Rect.Companion.makeXYWH(this.resolve(sVGLength, SVGLengthType.HORIZONTAL), this.resolve(sVGLength2, SVGLengthType.VERTICAL), this.resolve(sVGLength3, SVGLengthType.HORIZONTAL), this.resolve(sVGLength4, SVGLengthType.VERTICAL));
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SVGLengthContext)) {
            return false;
        }
        if (Float.compare(this.width, ((SVGLengthContext)object).width) != 0) {
            return false;
        }
        if (Float.compare(this.height, ((SVGLengthContext)object).height) != 0) {
            return false;
        }
        return Float.compare(this.dpi, ((SVGLengthContext)object).dpi) == 0;
    }

    public final int hashCode() {
        int n = 59 + Float.floatToIntBits(this.width);
        n = n * 59 + Float.floatToIntBits(this.height);
        n = n * 59 + Float.floatToIntBits(this.dpi);
        return n;
    }

    public final String toString() {
        return "SVGLengthContext(_width=" + this.width + ", _height=" + this.height + ", _dpi=" + this.dpi + ')';
    }

    public final SVGLengthContext withWidth(float f) {
        if (this.width == f) {
            return this;
        }
        return new SVGLengthContext(f, this.height, this.dpi);
    }

    public final SVGLengthContext withHeight(float f) {
        if (this.height == f) {
            return this;
        }
        return new SVGLengthContext(this.width, f, this.dpi);
    }

    public final SVGLengthContext withDpi(float f) {
        if (this.dpi == f) {
            return this;
        }
        return new SVGLengthContext(this.width, this.height, f);
    }
}

