/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.P;
import kotlinx.coroutines.aE;
import kotlinx.coroutines.aF;
import kotlinx.coroutines.l;
import kotlinx.coroutines.v;
import org.jetbrains.skiko.FrameDispatcher;
import org.jetbrains.skiko.FrameLimiter;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.HardwareLayerKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerAnalytics$DeviceAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.context.SoftwareContextHandler;
import org.jetbrains.skiko.redrawer.AWTRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;
import org.jetbrains.skiko.redrawer.SoftwareRedrawer$frameDispatcher$1;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/skiko/redrawer/SoftwareRedrawer;", "Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "contextHandler", "Lorg/jetbrains/skiko/context/SoftwareContextHandler;", "frameDispatcher", "Lorg/jetbrains/skiko/FrameDispatcher;", "frameJob", "Lkotlinx/coroutines/CompletableJob;", "frameLimiter", "Lorg/jetbrains/skiko/FrameLimiter;", "renderInfo", "", "getRenderInfo", "()Ljava/lang/String;", "dispose", "", "needRedraw", "redrawImmediately", "skiko"})
public final class SoftwareRedrawer
extends AWTRedrawer {
    private final SkiaLayer layer;
    private final SkiaLayerProperties properties;
    private final SoftwareContextHandler contextHandler;
    private final v frameJob;
    private final FrameLimiter frameLimiter;
    private final FrameDispatcher frameDispatcher;

    public SoftwareRedrawer(SkiaLayer skiaLayer, SkiaLayerAnalytics skiaLayerAnalytics, SkiaLayerProperties skiaLayerProperties) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerProperties, (String)"");
        super(skiaLayer, skiaLayerAnalytics, GraphicsApi.SOFTWARE_FAST);
        this.layer = skiaLayer;
        this.properties = skiaLayerProperties;
        this.onDeviceChosen("Software");
        this.contextHandler = new SoftwareContextHandler(this.layer);
        this.frameJob = l.a(null, (int)1, null);
        this.frameLimiter = HardwareLayerKt.layerFrameLimiter$default(P.a((CoroutineContext)((CoroutineContext)this.frameJob)), this.layer.getBackedLayer$skiko(), null, 4, null);
        this.frameDispatcher = new FrameDispatcher((CoroutineContext)MainUIDispatcher_awtKt.getMainUIDispatcher(), (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new SoftwareRedrawer$frameDispatcher$1(this, null)));
        this.onContextInit();
    }

    @Override
    public final String getRenderInfo() {
        return this.contextHandler.rendererInfo();
    }

    @Override
    public final void dispose() {
        aF.a((aE)((aE)this.frameJob), null, (int)1, null);
        this.frameDispatcher.cancel();
        this.contextHandler.dispose();
        super.dispose();
    }

    @Override
    public final void needRedraw() {
        this.frameDispatcher.scheduleFrame();
    }

    @Override
    public final void redrawImmediately() {
        this.update(System.nanoTime());
        Object object = this;
        Object object2 = this.contextHandler;
        if (AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object) == null) {
            object = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(object.toString());
        }
        if (!AWTRedrawer.access$isDisposed((AWTRedrawer)object)) {
            block12: {
                if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)object)) {
                    SkiaLayerAnalytics$DeviceAnalytics skiaLayerAnalytics$DeviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object);
                    if (skiaLayerAnalytics$DeviceAnalytics != null) {
                        skiaLayerAnalytics$DeviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayer skiaLayer = AWTRedrawer.access$getLayer$p((AWTRedrawer)object);
                if (!SwingUtilities.isEventDispatchThread()) {
                    object2 = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(object2.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(skiaLayer))) {
                    object2 = "SkiaLayer is disposed";
                    throw new IllegalStateException(object2.toString());
                }
                try {
                    ((ContextHandler)object2).draw();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException renderException) {
                    if (SkiaLayer.access$isDisposed$p(skiaLayer)) break block12;
                    object2 = Logger.INSTANCE;
                    if (((Logger)object2).getLoggerImpl().isWarnEnabled()) {
                        SkikoLoggerInterface skikoLoggerInterface = ((Logger)object2).getLoggerImpl();
                        object2 = renderException;
                        SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface2.warn((Throwable)object2, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(skiaLayer), false, 1, null);
                    Redrawer redrawer = skiaLayer.getRedrawer$skiko();
                    if (redrawer == null) break block12;
                    redrawer.redrawImmediately();
                }
            }
            if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)object) && !AWTRedrawer.access$isDisposed((AWTRedrawer)object)) {
                SkiaLayerAnalytics$DeviceAnalytics skiaLayerAnalytics$DeviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object);
                if (skiaLayerAnalytics$DeviceAnalytics != null) {
                    skiaLayerAnalytics$DeviceAnalytics.afterFirstFrameRender();
                }
            }
            AWTRedrawer.access$setFirstFrameRendered$p((AWTRedrawer)object, true);
        }
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SoftwareRedrawer softwareRedrawer) {
        return softwareRedrawer.properties;
    }

    public static final /* synthetic */ FrameLimiter access$getFrameLimiter$p(SoftwareRedrawer softwareRedrawer) {
        return softwareRedrawer.frameLimiter;
    }

    public static final /* synthetic */ SkiaLayer access$getLayer$p(SoftwareRedrawer softwareRedrawer) {
        return softwareRedrawer.layer;
    }

    public static final /* synthetic */ SoftwareContextHandler access$getContextHandler$p(SoftwareRedrawer softwareRedrawer) {
        return softwareRedrawer.contextHandler;
    }
}

