/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.DB;

public abstract class Function {
    public static final int FLAG_DETERMINISTIC = 2048;
    private SQLiteConnection conn;
    private DB db;
    long context = 0L;
    long value = 0L;
    int args = 0;

    public static void create(Connection connection, String string, Function function) {
        Function.create(connection, string, function, 0);
    }

    public static void create(Connection connection, String string, Function function, int n) {
        Function.create(connection, string, function, -1, n);
    }

    public static void create(Connection connection, String string, Function function, int n, int n2) {
        if (!(connection instanceof SQLiteConnection)) {
            throw new SQLException("connection must be to an SQLite db");
        }
        if (connection.isClosed()) {
            throw new SQLException("connection closed");
        }
        function.conn = (SQLiteConnection)connection;
        function.db = function.conn.getDatabase();
        if (n < -1 || n > 127) {
            throw new SQLException("invalid args provided: " + n);
        }
        if (function.db.create_function(string, function, n, n2) != 0) {
            throw new SQLException("error creating function");
        }
    }

    public static void destroy(Connection connection, String string, int n) {
        if (!(connection instanceof SQLiteConnection)) {
            throw new SQLException("connection must be to an SQLite db");
        }
        ((SQLiteConnection)connection).getDatabase().destroy_function(string);
    }

    public static void destroy(Connection connection, String string) {
        Function.destroy(connection, string, -1);
    }

    protected abstract void xFunc();

    protected final synchronized int args() {
        this.checkContext();
        return this.args;
    }

    protected final synchronized void result(byte[] byArray) {
        this.checkContext();
        this.db.result_blob(this.context, byArray);
    }

    protected final synchronized void result(double d) {
        this.checkContext();
        this.db.result_double(this.context, d);
    }

    protected final synchronized void result(int n) {
        this.checkContext();
        this.db.result_int(this.context, n);
    }

    protected final synchronized void result(long l) {
        this.checkContext();
        this.db.result_long(this.context, l);
    }

    protected final synchronized void result() {
        this.checkContext();
        this.db.result_null(this.context);
    }

    protected final synchronized void result(String string) {
        this.checkContext();
        this.db.result_text(this.context, string);
    }

    protected final synchronized void error(String string) {
        this.checkContext();
        this.db.result_error(this.context, string);
    }

    protected final synchronized String value_text(int n) {
        this.checkValue(n);
        return this.db.value_text(this, n);
    }

    protected final synchronized byte[] value_blob(int n) {
        this.checkValue(n);
        return this.db.value_blob(this, n);
    }

    protected final synchronized double value_double(int n) {
        this.checkValue(n);
        return this.db.value_double(this, n);
    }

    protected final synchronized int value_int(int n) {
        this.checkValue(n);
        return this.db.value_int(this, n);
    }

    protected final synchronized long value_long(int n) {
        this.checkValue(n);
        return this.db.value_long(this, n);
    }

    protected final synchronized int value_type(int n) {
        this.checkValue(n);
        return this.db.value_type(this, n);
    }

    private void checkContext() {
        if (this.conn == null || this.conn.getDatabase() == null || this.context == 0L) {
            throw new SQLException("no context, not allowed to read value");
        }
    }

    private void checkValue(int n) {
        if (this.conn == null || this.conn.getDatabase() == null || this.value == 0L) {
            throw new SQLException("not in value access state");
        }
        if (n >= this.args) {
            throw new SQLException("arg " + n + " out bounds [0," + this.args + ")");
        }
    }
}

