/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CorePreparedStatement;
import org.sqlite.core.DB;
import org.sqlite.jdbc3.JDBC3Connection;

public abstract class JDBC3PreparedStatement
extends CorePreparedStatement {
    protected JDBC3PreparedStatement(SQLiteConnection sQLiteConnection, String string) {
        super(sQLiteConnection, string);
    }

    public void clearParameters() {
        this.checkOpen();
        this.pointer.safeRunConsume(DB::clear_bindings);
        if (this.batch != null) {
            for (int i = this.batchPos; i < this.batchPos + this.paramCount; ++i) {
                this.batch[i] = null;
            }
        }
    }

    public boolean execute() {
        this.checkOpen();
        this.rs.close();
        this.pointer.safeRunConsume(DB::reset);
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        JDBC3PreparedStatement jDBC3PreparedStatement = this;
        return jDBC3PreparedStatement.withConnectionTimeout(() -> {
            boolean bl = false;
            try {
                JDBC3PreparedStatement jDBC3PreparedStatement = this;
                this.resultsWaiting = this.conn.getDatabase().execute(jDBC3PreparedStatement, jDBC3PreparedStatement.batch);
                bl = true;
                this.updateCount = this.getDatabase().changes();
                Boolean bl2 = this.columnCount != 0;
                return bl2;
            }
            catch (Throwable throwable) {
                if (!bl && !this.pointer.isClosed()) {
                    this.pointer.safeRunConsume(DB::reset);
                }
                throw throwable;
            }
        });
    }

    public ResultSet executeQuery() {
        this.checkOpen();
        if (this.columnCount == 0) {
            throw new SQLException("Query does not return results");
        }
        this.rs.close();
        this.pointer.safeRunConsume(DB::reset);
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        JDBC3PreparedStatement jDBC3PreparedStatement = this;
        return jDBC3PreparedStatement.withConnectionTimeout(() -> {
            try {
                JDBC3PreparedStatement jDBC3PreparedStatement = this;
                this.resultsWaiting = this.conn.getDatabase().execute(jDBC3PreparedStatement, jDBC3PreparedStatement.batch);
            }
            catch (Throwable throwable) {
                if (!this.pointer.isClosed()) {
                    this.pointer.safeRunInt(DB::reset);
                }
                throw throwable;
            }
            return this.getResultSet();
        });
    }

    public int executeUpdate() {
        return (int)this.executeLargeUpdate();
    }

    public long executeLargeUpdate() {
        this.checkOpen();
        if (this.columnCount != 0) {
            throw new SQLException("Query returns results");
        }
        this.rs.close();
        this.pointer.safeRunConsume(DB::reset);
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        JDBC3PreparedStatement jDBC3PreparedStatement = this;
        return jDBC3PreparedStatement.withConnectionTimeout(() -> {
            JDBC3PreparedStatement jDBC3PreparedStatement = this;
            return this.conn.getDatabase().executeUpdate(jDBC3PreparedStatement, jDBC3PreparedStatement.batch);
        });
    }

    public void addBatch() {
        this.checkOpen();
        this.batchPos += this.paramCount;
        ++this.batchQueryCount;
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
        }
        if (this.batchPos + this.paramCount > this.batch.length) {
            Object[] objectArray = new Object[this.batch.length << 1];
            System.arraycopy(this.batch, 0, objectArray, 0, this.batch.length);
            this.batch = objectArray;
        }
        System.arraycopy(this.batch, this.batchPos - this.paramCount, this.batch, this.batchPos, this.paramCount);
    }

    public ParameterMetaData getParameterMetaData() {
        return (ParameterMetaData)((Object)this);
    }

    public int getParameterCount() {
        this.checkOpen();
        return this.paramCount;
    }

    public String getParameterClassName(int n) {
        this.checkOpen();
        return "java.lang.String";
    }

    public String getParameterTypeName(int n) {
        this.checkIndex(n);
        return JDBCType.valueOf(this.getParameterType(n)).getName();
    }

    public int getParameterType(int n) {
        this.checkIndex(n);
        Object object = this.batch[n - 1];
        if (object == null) {
            return 0;
        }
        if (object instanceof Integer || object instanceof Short || object instanceof Boolean) {
            return 4;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof Double || object instanceof Float) {
            return 7;
        }
        return 12;
    }

    public int getParameterMode(int n) {
        return 1;
    }

    public int getPrecision(int n) {
        return 0;
    }

    public int getScale(int n) {
        return 0;
    }

    public int isNullable(int n) {
        return 1;
    }

    public boolean isSigned(int n) {
        return true;
    }

    public Statement getStatement() {
        return this;
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.batch(n, bigDecimal == null ? null : bigDecimal.toString());
    }

    private byte[] readBytes(InputStream inputStream, int n) {
        if (n < 0) {
            throw new SQLException("Error reading stream. Length should be non-negative");
        }
        byte[] byArray = new byte[n];
        try {
            int n2;
            for (int i = 0; i < n; i += n2) {
                n2 = inputStream.read(byArray, i, n - i);
                if (n2 != -1) continue;
                throw new IOException("End of stream has been reached");
            }
            return byArray;
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException("Error reading stream");
            sQLException.initCause(iOException);
            throw sQLException;
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) {
        if (inputStream == null && n2 == 0) {
            this.setBytes(n, null);
        }
        this.setBytes(n, this.readBytes(inputStream, n2));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) {
        this.setUnicodeStream(n, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream object, int n2) {
        if (object == null && n2 == 0) {
            this.setString(n, null);
        }
        try {
            this.setString(n, new String(this.readBytes((InputStream)object, n2), "UTF-8"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new SQLException("UTF-8 is not supported");
            ((Throwable)object).initCause(unsupportedEncodingException);
            throw object;
        }
    }

    public void setBoolean(int n, boolean bl) {
        this.setInt(n, bl ? 1 : 0);
    }

    public void setByte(int n, byte by) {
        this.setInt(n, by);
    }

    public void setBytes(int n, byte[] byArray) {
        this.batch(n, byArray);
    }

    public void setDouble(int n, double d) {
        this.batch(n, d);
    }

    public void setFloat(int n, float f) {
        this.batch(n, Float.valueOf(f));
    }

    public void setInt(int n, int n2) {
        this.batch(n, n2);
    }

    public void setLong(int n, long l) {
        this.batch(n, new Long(l));
    }

    public void setNull(int n, int n2) {
        this.setNull(n, n2, null);
    }

    public void setNull(int n, int n2, String string) {
        this.batch(n, null);
    }

    public void setObject(int n, Object object) {
        if (object == null) {
            this.batch(n, null);
            return;
        }
        if (object instanceof java.util.Date) {
            this.setDateByMilliseconds(n, ((java.util.Date)object).getTime(), Calendar.getInstance());
            return;
        }
        if (object instanceof Long) {
            this.batch(n, object);
            return;
        }
        if (object instanceof Integer) {
            this.batch(n, object);
            return;
        }
        if (object instanceof Short) {
            this.batch(n, new Integer(((Short)object).intValue()));
            return;
        }
        if (object instanceof Float) {
            this.batch(n, object);
            return;
        }
        if (object instanceof Double) {
            this.batch(n, object);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
            return;
        }
        if (object instanceof byte[]) {
            this.batch(n, object);
            return;
        }
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
            return;
        }
        this.batch(n, object.toString());
    }

    public void setObject(int n, Object object, int n2) {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2, int n3) {
        this.setObject(n, object);
    }

    public void setShort(int n, short s) {
        this.setInt(n, s);
    }

    public void setString(int n, String string) {
        this.batch(n, string);
    }

    public void setCharacterStream(int n, Reader reader, int n2) {
        try {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[8192];
            while ((n3 = reader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n3);
            }
            this.setString(n, stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            throw new SQLException("Cannot read from character stream, exception message: " + iOException.getMessage());
        }
    }

    public void setDate(int n, Date date) {
        this.setDate(n, date, Calendar.getInstance());
    }

    public void setDate(int n, Date date, Calendar calendar) {
        if (date == null) {
            this.setObject(n, null);
            return;
        }
        this.setDateByMilliseconds(n, date.getTime(), calendar);
    }

    public void setTime(int n, Time time) {
        this.setTime(n, time, Calendar.getInstance());
    }

    public void setTime(int n, Time time, Calendar calendar) {
        if (time == null) {
            this.setObject(n, null);
            return;
        }
        this.setDateByMilliseconds(n, time.getTime(), calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.setTimestamp(n, timestamp, Calendar.getInstance());
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            this.setObject(n, null);
            return;
        }
        this.setDateByMilliseconds(n, timestamp.getTime(), calendar);
    }

    public ResultSetMetaData getMetaData() {
        this.checkOpen();
        return (ResultSetMetaData)((Object)this.rs);
    }

    @Override
    protected SQLException unsupported() {
        return new SQLFeatureNotSupportedException("not implemented by SQLite JDBC driver");
    }

    protected SQLException invalid() {
        return new SQLException("method cannot be called on a PreparedStatement");
    }

    public void setArray(int n, Array array) {
        throw this.unsupported();
    }

    public void setBlob(int n, Blob blob) {
        throw this.unsupported();
    }

    public void setClob(int n, Clob clob) {
        throw this.unsupported();
    }

    public void setRef(int n, Ref ref) {
        throw this.unsupported();
    }

    public void setURL(int n, URL uRL) {
        throw this.unsupported();
    }

    @Override
    public boolean execute(String string) {
        throw this.invalid();
    }

    @Override
    public boolean execute(String string, int n) {
        throw this.invalid();
    }

    @Override
    public boolean execute(String string, int[] nArray) {
        throw this.invalid();
    }

    @Override
    public boolean execute(String string, String[] stringArray) {
        throw this.invalid();
    }

    @Override
    public int executeUpdate(String string) {
        throw this.invalid();
    }

    @Override
    public int executeUpdate(String string, int n) {
        throw this.invalid();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) {
        throw this.invalid();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) {
        throw this.invalid();
    }

    @Override
    public long executeLargeUpdate(String string) {
        throw this.invalid();
    }

    @Override
    public long executeLargeUpdate(String string, int n) {
        throw this.invalid();
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) {
        throw this.invalid();
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) {
        throw this.invalid();
    }

    @Override
    public ResultSet executeQuery(String string) {
        throw this.invalid();
    }

    @Override
    public void addBatch(String string) {
        throw this.invalid();
    }
}

