/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.a.d.e;
import org.apache.a.d.f;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser$LiteralName;
import org.apache.fontbox.cmap.CMapParser$Operator;
import org.apache.fontbox.cmap.CodespaceRange;

public class CMapParser {
    private static final String MARK_END_OF_DICTIONARY = ">>";
    private static final String MARK_END_OF_ARRAY = "]";
    private final byte[] tokenParserByteBuffer = new byte[512];
    private boolean strictMode = false;

    public CMapParser() {
    }

    public CMapParser(boolean bl) {
        this.strictMode = bl;
    }

    public CMap parsePredefined(String string) {
        string = this.getExternalCMap(string);
        Throwable throwable = null;
        try {
            this.strictMode = false;
            CMap cMap = this.parse((e)string);
            return cMap;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            if (string != null) {
                if (throwable != null) {
                    try {
                        string.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    string.close();
                }
            }
        }
    }

    public CMap parse(e e2) {
        CMap cMap = new CMap();
        Object object = null;
        Object object2 = this.parseNextToken(e2);
        while (object2 != null) {
            if (object2 instanceof CMapParser$Operator) {
                CMapParser$Operator cMapParser$Operator = (CMapParser$Operator)object2;
                if (CMapParser$Operator.access$000(cMapParser$Operator).equals("endcmap")) break;
                if (CMapParser$Operator.access$000(cMapParser$Operator).equals("usecmap") && object instanceof CMapParser$LiteralName) {
                    this.parseUsecmap((CMapParser$LiteralName)object, cMap);
                } else if (object instanceof Number) {
                    if (CMapParser$Operator.access$000(cMapParser$Operator).equals("begincodespacerange")) {
                        this.parseBegincodespacerange((Number)object, e2, cMap);
                    } else if (CMapParser$Operator.access$000(cMapParser$Operator).equals("beginbfchar")) {
                        this.parseBeginbfchar((Number)object, e2, cMap);
                    } else if (CMapParser$Operator.access$000(cMapParser$Operator).equals("beginbfrange")) {
                        this.parseBeginbfrange((Number)object, e2, cMap);
                    } else if (CMapParser$Operator.access$000(cMapParser$Operator).equals("begincidchar")) {
                        this.parseBegincidchar((Number)object, e2, cMap);
                    } else if (CMapParser$Operator.access$000(cMapParser$Operator).equals("begincidrange") && object instanceof Integer) {
                        this.parseBegincidrange((Integer)object, e2, cMap);
                    }
                }
            } else if (object2 instanceof CMapParser$LiteralName) {
                this.parseLiteralName((CMapParser$LiteralName)object2, e2, cMap);
            }
            object = object2;
            object2 = this.parseNextToken(e2);
        }
        return cMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseUsecmap(CMapParser$LiteralName cMapParser$LiteralName, CMap cMap) {
        block9: {
            cMapParser$LiteralName = this.getExternalCMap(CMapParser$LiteralName.access$100(cMapParser$LiteralName));
            Throwable throwable = null;
            try {
                CMap cMap2 = this.parse((e)cMapParser$LiteralName);
                cMap.useCmap(cMap2);
                if (cMapParser$LiteralName == null) return;
                if (throwable == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4 = throwable2;
                    throwable = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (cMapParser$LiteralName == null) throw throwable5;
                    if (throwable == null) {
                        cMapParser$LiteralName.close();
                        throw throwable5;
                    }
                    try {
                        cMapParser$LiteralName.close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            try {
                cMapParser$LiteralName.close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        cMapParser$LiteralName.close();
    }

    private void parseLiteralName(CMapParser$LiteralName object, e e2, CMap cMap) {
        switch (CMapParser$LiteralName.access$100((CMapParser$LiteralName)object)) {
            case "WMode": {
                object = this.parseNextToken(e2);
                if (!(object instanceof Integer)) break;
                cMap.setWMode((Integer)object);
                return;
            }
            case "CMapName": {
                object = this.parseNextToken(e2);
                if (!(object instanceof CMapParser$LiteralName)) break;
                cMap.setName(CMapParser$LiteralName.access$100((CMapParser$LiteralName)object));
                return;
            }
            case "CMapVersion": {
                object = this.parseNextToken(e2);
                if (object instanceof Number) {
                    cMap.setVersion(object.toString());
                    return;
                }
                if (!(object instanceof String)) break;
                cMap.setVersion((String)object);
                return;
            }
            case "CMapType": {
                object = this.parseNextToken(e2);
                if (!(object instanceof Integer)) break;
                cMap.setType((Integer)object);
                return;
            }
            case "Registry": {
                object = this.parseNextToken(e2);
                if (!(object instanceof String)) break;
                cMap.setRegistry((String)object);
                return;
            }
            case "Ordering": {
                object = this.parseNextToken(e2);
                if (!(object instanceof String)) break;
                cMap.setOrdering((String)object);
                return;
            }
            case "Supplement": {
                object = this.parseNextToken(e2);
                if (!(object instanceof Integer)) break;
                cMap.setSupplement((Integer)object);
            }
        }
    }

    private void checkExpectedOperator(CMapParser$Operator cMapParser$Operator, String string, String string2) {
        if (!CMapParser$Operator.access$000(cMapParser$Operator).equals(string)) {
            throw new IOException("Error : ~" + string2 + " contains an unexpected operator : " + CMapParser$Operator.access$000(cMapParser$Operator));
        }
    }

    private void parseBegincodespacerange(Number number, e e2, CMap cMap) {
        for (int i = 0; i < number.intValue(); ++i) {
            Object object = this.parseNextToken(e2);
            if (object instanceof CMapParser$Operator) {
                this.checkExpectedOperator((CMapParser$Operator)object, "endcodespacerange", "codespacerange");
                return;
            }
            if (!(object instanceof byte[])) {
                throw new IOException("start range missing");
            }
            object = (byte[])object;
            byte[] byArray = this.parseByteArray(e2);
            try {
                cMap.addCodespaceRange(new CodespaceRange((byte[])object, byArray));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException);
            }
        }
    }

    private void parseBeginbfchar(Number number, e e2, CMap cMap) {
        for (int i = 0; i < number.intValue(); ++i) {
            Object object = this.parseNextToken(e2);
            if (object instanceof CMapParser$Operator) {
                this.checkExpectedOperator((CMapParser$Operator)object, "endbfchar", "bfchar");
                return;
            }
            if (!(object instanceof byte[])) {
                throw new IOException("input code missing");
            }
            byte[] byArray = (byte[])object;
            object = this.parseNextToken(e2);
            if (object instanceof byte[]) {
                object = (byte[])object;
                object = this.createStringFromBytes((byte[])object);
                cMap.addCharMapping(byArray, (String)object);
                continue;
            }
            if (object instanceof CMapParser$LiteralName) {
                cMap.addCharMapping(byArray, CMapParser$LiteralName.access$100((CMapParser$LiteralName)object));
                continue;
            }
            throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + object);
        }
    }

    private void parseBegincidrange(int n, e e2, CMap cMap) {
        for (int i = 0; i < n; ++i) {
            Object object = this.parseNextToken(e2);
            if (object instanceof CMapParser$Operator) {
                this.checkExpectedOperator((CMapParser$Operator)object, "endcidrange", "cidrange");
                return;
            }
            if (!(object instanceof byte[])) {
                throw new IOException("start code missing");
            }
            object = (byte[])object;
            byte[] byArray = this.parseByteArray(e2);
            int n2 = this.parseInteger(e2);
            if (((Object)object).length == byArray.length) {
                if (Arrays.equals((byte[])object, byArray)) {
                    cMap.addCIDMapping((byte[])object, n2);
                    continue;
                }
                cMap.addCIDRange((byte[])object, byArray, n2);
                continue;
            }
            throw new IOException("Error : ~cidrange values must not have different byte lengths");
        }
    }

    private void parseBegincidchar(Number number, e e2, CMap cMap) {
        for (int i = 0; i < number.intValue(); ++i) {
            Object object = this.parseNextToken(e2);
            if (object instanceof CMapParser$Operator) {
                this.checkExpectedOperator((CMapParser$Operator)object, "endcidchar", "cidchar");
                return;
            }
            if (!(object instanceof byte[])) {
                throw new IOException("input code missing");
            }
            object = (byte[])object;
            int n = this.parseInteger(e2);
            cMap.addCIDMapping((byte[])object, n);
        }
    }

    private void parseBeginbfrange(Number number, e e2, CMap cMap) {
        for (int i = 0; i < number.intValue(); ++i) {
            Object object = this.parseNextToken(e2);
            if (object instanceof CMapParser$Operator) {
                this.checkExpectedOperator((CMapParser$Operator)object, "endbfrange", "bfrange");
                return;
            }
            if (!(object instanceof byte[])) {
                throw new IOException("start code missing");
            }
            byte[] byArray = (byte[])object;
            object = this.parseNextToken(e2);
            if (object instanceof CMapParser$Operator) {
                this.checkExpectedOperator((CMapParser$Operator)object, "endbfrange", "bfrange");
                return;
            }
            if (!(object instanceof byte[])) {
                throw new IOException("end code missing");
            }
            object = (byte[])object;
            int n = CMap.toInt(byArray);
            int n2 = CMap.toInt((byte[])object);
            if (n2 < n) break;
            object = this.parseNextToken(e2);
            if (object instanceof List) {
                if ((object = (List)object).isEmpty() || object.size() < n2 - n) continue;
                this.addMappingFrombfrange(cMap, byArray, (List<byte[]>)object);
                continue;
            }
            if (!(object instanceof byte[])) continue;
            byte[] byArray2 = (byte[])object;
            object = byArray2;
            if (byArray2.length <= 0) continue;
            if (((Object)object).length == 2 && n == 0 && n2 == 65535 && object[0] == false && object[1] == false) {
                for (n = 0; n < 256; ++n) {
                    byArray[0] = (byte)n;
                    byArray[1] = 0;
                    object[0] = (byte)n;
                    object[1] = false;
                    this.addMappingFrombfrange(cMap, byArray, 256, (byte[])object);
                }
                continue;
            }
            this.addMappingFrombfrange(cMap, byArray, n2 - n + 1, (byte[])object);
        }
    }

    private void addMappingFrombfrange(CMap cMap, byte[] byArray, List<byte[]> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (byte[])object.next();
            object2 = this.createStringFromBytes((byte[])object2);
            cMap.addCharMapping(byArray, (String)object2);
            this.increment(byArray, byArray.length - 1, false);
        }
    }

    private void addMappingFrombfrange(CMap cMap, byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < n; ++i) {
            String string = this.createStringFromBytes(byArray2);
            cMap.addCharMapping(byArray, string);
            if (!this.increment(byArray2, byArray2.length - 1, this.strictMode)) break;
            this.increment(byArray, byArray.length - 1, false);
        }
    }

    private e getExternalCMap(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Error: Could not find referenced cmap stream " + string);
        }
        return new f(inputStream);
    }

    private Object parseNextToken(e e2) {
        int n = e2.a();
        while (n == 9 || n == 32 || n == 13 || n == 10) {
            n = e2.a();
        }
        switch (n) {
            case 37: {
                return this.readLine(e2, n);
            }
            case 40: {
                return this.readString(e2);
            }
            case 62: {
                if (e2.a() == 62) {
                    return MARK_END_OF_DICTIONARY;
                }
                throw new IOException("Error: expected the end of a dictionary.");
            }
            case 93: {
                return MARK_END_OF_ARRAY;
            }
            case 91: {
                return this.readArray(e2);
            }
            case 60: {
                return this.readDictionary(e2);
            }
            case 47: {
                return this.readLiteralName(e2);
            }
            case -1: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.readNumber(e2, n);
            }
            default: {
                return this.readOperator(e2, n);
            }
        }
        return null;
    }

    private Integer parseInteger(e object) {
        if ((object = this.parseNextToken((e)object)) == null) {
            throw new IOException("expected integer value is missing");
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new IOException("invalid type for next token");
    }

    private byte[] parseByteArray(e object) {
        if ((object = this.parseNextToken((e)object)) == null) {
            throw new IOException("expected byte[] value is missing");
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new IOException("invalid type for next token");
    }

    private List<Object> readArray(e e2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.parseNextToken(e2);
        while (object != null && !MARK_END_OF_ARRAY.equals(object)) {
            arrayList.add(object);
            object = this.parseNextToken(e2);
        }
        return arrayList;
    }

    private String readString(e e2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = e2.a();
        while (n != -1 && n != 41) {
            stringBuilder.append((char)n);
            n = e2.a();
        }
        return stringBuilder.toString();
    }

    private String readLine(e e2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n);
        this.readUntilEndOfLine(e2, stringBuilder);
        return stringBuilder.toString();
    }

    private CMapParser$LiteralName readLiteralName(e e2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = e2.a();
        while (!this.isWhitespaceOrEOF(n) && !this.isDelimiter(n)) {
            stringBuilder.append((char)n);
            n = e2.a();
        }
        if (this.isDelimiter(n)) {
            e2.a(1);
        }
        return new CMapParser$LiteralName(stringBuilder.toString(), null);
    }

    private CMapParser$Operator readOperator(e e2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n);
        n = e2.a();
        while (!(this.isWhitespaceOrEOF(n) || this.isDelimiter(n) || Character.isDigit(n))) {
            stringBuilder.append((char)n);
            n = e2.a();
        }
        if (this.isDelimiter(n) || Character.isDigit(n)) {
            e2.a(1);
        }
        return new CMapParser$Operator(stringBuilder.toString(), null);
    }

    private Number readNumber(e object, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n);
        n = object.a();
        while (!this.isWhitespaceOrEOF(n) && (Character.isDigit((char)n) || n == 46)) {
            stringBuilder.append((char)n);
            n = object.a();
        }
        object.a(1);
        object = stringBuilder.toString();
        try {
            if (((String)object).indexOf(46) >= 0) {
                return Double.valueOf((String)object);
            }
            return Integer.valueOf((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid number '" + (String)object + "'", numberFormatException);
        }
    }

    private Object readDictionary(e e2) {
        int n = e2.a();
        if (n == 60) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Object object = this.parseNextToken(e2);
            while (object instanceof CMapParser$LiteralName && !MARK_END_OF_DICTIONARY.equals(CMapParser$LiteralName.access$100((CMapParser$LiteralName)object))) {
                Object object2 = this.parseNextToken(e2);
                hashMap.put(CMapParser$LiteralName.access$100((CMapParser$LiteralName)object), object2);
                object = this.parseNextToken(e2);
            }
            return hashMap;
        }
        int n2 = 16;
        int n3 = -1;
        while (n != -1 && n != 62) {
            if (this.isWhitespaceOrEOF(n)) {
                n = e2.a();
                continue;
            }
            if (n >= 48 && n <= 57) {
                n -= 48;
            } else if (n >= 65 && n <= 70) {
                n = n + 10 - 65;
            } else if (n >= 97 && n <= 102) {
                n = n + 10 - 97;
            } else {
                throw new IOException("Error: expected hex character and not " + (char)n + ":" + n);
            }
            n *= n2;
            if (n2 == 16) {
                if (++n3 >= this.tokenParserByteBuffer.length) {
                    throw new IOException("cmap token ist larger than buffer size " + this.tokenParserByteBuffer.length);
                }
                this.tokenParserByteBuffer[n3] = 0;
                n2 = 1;
            } else {
                n2 = 16;
            }
            int n4 = n3;
            this.tokenParserByteBuffer[n4] = (byte)(this.tokenParserByteBuffer[n4] + n);
            n = e2.a();
        }
        byte[] byArray = new byte[n3 + 1];
        System.arraycopy(this.tokenParserByteBuffer, 0, byArray, 0, n3 + 1);
        return byArray;
    }

    private void readUntilEndOfLine(e e2, StringBuilder stringBuilder) {
        int n = e2.a();
        while (n != -1 && n != 13 && n != 10) {
            stringBuilder.append((char)n);
            n = e2.a();
        }
    }

    private boolean isWhitespaceOrEOF(int n) {
        return n == -1 || n == 32 || n == 13 || n == 10;
    }

    private boolean isDelimiter(int n) {
        switch (n) {
            case 37: 
            case 40: 
            case 41: 
            case 47: 
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private boolean increment(byte[] byArray, int n, boolean bl) {
        if (n > 0 && (byArray[n] & 0xFF) == 255) {
            if (bl) {
                return false;
            }
            byArray[n] = 0;
            this.increment(byArray, n - 1, bl);
        } else {
            byArray[n] = (byte)(byArray[n] + 1);
        }
        return true;
    }

    private String createStringFromBytes(byte[] byArray) {
        return new String(byArray, byArray.length == 1 ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_16BE);
    }
}

