/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.gsub.GlyphSubstitutionDataExtractor$ScriptTableDetails;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.Language;
import org.apache.fontbox.ttf.model.MapBackedGsubData;
import org.apache.fontbox.ttf.table.common.CoverageTable;
import org.apache.fontbox.ttf.table.common.FeatureListTable;
import org.apache.fontbox.ttf.table.common.FeatureRecord;
import org.apache.fontbox.ttf.table.common.LangSysTable;
import org.apache.fontbox.ttf.table.common.LookupListTable;
import org.apache.fontbox.ttf.table.common.LookupSubTable;
import org.apache.fontbox.ttf.table.common.LookupTable;
import org.apache.fontbox.ttf.table.common.ScriptTable;
import org.apache.fontbox.ttf.table.gsub.LigatureSetTable;
import org.apache.fontbox.ttf.table.gsub.LigatureTable;
import org.apache.fontbox.ttf.table.gsub.LookupTypeLigatureSubstitutionSubstFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeMultipleSubstitutionFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeSingleSubstFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeSingleSubstFormat2;

public class GlyphSubstitutionDataExtractor {
    private static final Log LOG = LogFactory.getLog(GlyphSubstitutionDataExtractor.class);

    public GsubData getGsubData(Map<String, ScriptTable> object, FeatureListTable featureListTable, LookupListTable lookupListTable) {
        if ((object = this.getSupportedLanguage((Map<String, ScriptTable>)object)) == null) {
            return GsubData.NO_DATA_FOUND;
        }
        return this.buildMapBackedGsubData(featureListTable, lookupListTable, (GlyphSubstitutionDataExtractor$ScriptTableDetails)object);
    }

    public GsubData getGsubData(String object, ScriptTable scriptTable, FeatureListTable featureListTable, LookupListTable lookupListTable) {
        object = new GlyphSubstitutionDataExtractor$ScriptTableDetails(Language.UNSPECIFIED, (String)object, scriptTable, null);
        return this.buildMapBackedGsubData(featureListTable, lookupListTable, (GlyphSubstitutionDataExtractor$ScriptTableDetails)object);
    }

    private MapBackedGsubData buildMapBackedGsubData(FeatureListTable featureListTable, LookupListTable lookupListTable, GlyphSubstitutionDataExtractor$ScriptTableDetails glyphSubstitutionDataExtractor$ScriptTableDetails) {
        ScriptTable scriptTable = glyphSubstitutionDataExtractor$ScriptTableDetails.getScriptTable();
        LinkedHashMap<String, Map<List<Integer>, Integer>> linkedHashMap = new LinkedHashMap<String, Map<List<Integer>, Integer>>();
        if (scriptTable.getDefaultLangSysTable() != null) {
            this.populateGsubData(linkedHashMap, scriptTable.getDefaultLangSysTable(), featureListTable, lookupListTable);
        }
        for (LangSysTable langSysTable : scriptTable.getLangSysTables().values()) {
            this.populateGsubData(linkedHashMap, langSysTable, featureListTable, lookupListTable);
        }
        return new MapBackedGsubData(glyphSubstitutionDataExtractor$ScriptTableDetails.getLanguage(), glyphSubstitutionDataExtractor$ScriptTableDetails.getFeatureName(), linkedHashMap);
    }

    private GlyphSubstitutionDataExtractor$ScriptTableDetails getSupportedLanguage(Map<String, ScriptTable> map) {
        for (Language language : Language.values()) {
            for (String string : language.getScriptNames()) {
                ScriptTable scriptTable = map.get(string);
                if (scriptTable == null) continue;
                return new GlyphSubstitutionDataExtractor$ScriptTableDetails(language, string, scriptTable, null);
            }
        }
        return null;
    }

    private void populateGsubData(Map<String, Map<List<Integer>, Integer>> map, LangSysTable object, FeatureListTable featureRecordArray, LookupListTable lookupListTable) {
        featureRecordArray = featureRecordArray.getFeatureRecords();
        int[] nArray = ((LangSysTable)object).getFeatureIndices();
        object = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = object[i];
            if (object2 >= featureRecordArray.length) continue;
            this.populateGsubData(map, featureRecordArray[object2], lookupListTable);
        }
    }

    private void populateGsubData(Map<String, Map<List<Integer>, Integer>> map, FeatureRecord featureRecord, LookupListTable lookupTableArray) {
        lookupTableArray = lookupTableArray.getLookups();
        LinkedHashMap<List<Integer>, Integer> linkedHashMap = new LinkedHashMap<List<Integer>, Integer>();
        for (int n : featureRecord.getFeatureTable().getLookupListIndices()) {
            if (n >= lookupTableArray.length) continue;
            this.extractData(linkedHashMap, lookupTableArray[n]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*********** extracting GSUB data for the feature: " + featureRecord.getFeatureTag() + ", glyphSubstitutionMap: " + linkedHashMap));
        }
        map.put(featureRecord.getFeatureTag(), Collections.unmodifiableMap(linkedHashMap));
    }

    private void extractData(Map<List<Integer>, Integer> map, LookupTable lookupSubTableArray) {
        for (LookupSubTable lookupSubTable : lookupSubTableArray.getSubTables()) {
            if (lookupSubTable instanceof LookupTypeLigatureSubstitutionSubstFormat1) {
                this.extractDataFromLigatureSubstitutionSubstFormat1Table(map, (LookupTypeLigatureSubstitutionSubstFormat1)lookupSubTable);
                continue;
            }
            if (lookupSubTable instanceof LookupTypeSingleSubstFormat1) {
                this.extractDataFromSingleSubstTableFormat1Table(map, (LookupTypeSingleSubstFormat1)lookupSubTable);
                continue;
            }
            if (lookupSubTable instanceof LookupTypeSingleSubstFormat2) {
                this.extractDataFromSingleSubstTableFormat2Table(map, (LookupTypeSingleSubstFormat2)lookupSubTable);
                continue;
            }
            if (lookupSubTable instanceof LookupTypeMultipleSubstitutionFormat1) {
                this.extractDataFromMultipleSubstitutionFormat1Table(map, (LookupTypeMultipleSubstitutionFormat1)lookupSubTable);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("The type " + lookupSubTable + " is not yet supported, will be ignored"));
        }
    }

    private void extractDataFromSingleSubstTableFormat1Table(Map<List<Integer>, Integer> map, LookupTypeSingleSubstFormat1 lookupTypeSingleSubstFormat1) {
        CoverageTable coverageTable = lookupTypeSingleSubstFormat1.getCoverageTable();
        for (int i = 0; i < coverageTable.getSize(); ++i) {
            int n = coverageTable.getGlyphId(i);
            int n2 = n + lookupTypeSingleSubstFormat1.getDeltaGlyphID();
            this.putNewSubstitutionEntry(map, n2, Collections.singletonList(n));
        }
    }

    private void extractDataFromSingleSubstTableFormat2Table(Map<List<Integer>, Integer> map, LookupTypeSingleSubstFormat2 lookupTypeSingleSubstFormat2) {
        CoverageTable coverageTable = lookupTypeSingleSubstFormat2.getCoverageTable();
        if (coverageTable.getSize() != lookupTypeSingleSubstFormat2.getSubstituteGlyphIDs().length) {
            LOG.warn((Object)("The coverage table size (" + coverageTable.getSize() + ") should be the same as the count of the substituteGlyphIDs tables (" + lookupTypeSingleSubstFormat2.getSubstituteGlyphIDs().length + ")"));
            return;
        }
        for (int i = 0; i < coverageTable.getSize(); ++i) {
            int n = coverageTable.getGlyphId(i);
            int n2 = n + lookupTypeSingleSubstFormat2.getSubstituteGlyphIDs()[i];
            this.putNewSubstitutionEntry(map, n2, Collections.singletonList(n));
        }
    }

    private void extractDataFromMultipleSubstitutionFormat1Table(Map<List<Integer>, Integer> object, LookupTypeMultipleSubstitutionFormat1 lookupTypeMultipleSubstitutionFormat1) {
        object = lookupTypeMultipleSubstitutionFormat1.getCoverageTable();
        if (((CoverageTable)object).getSize() != lookupTypeMultipleSubstitutionFormat1.getSequenceTables().length) {
            LOG.warn((Object)("The coverage table size (" + ((CoverageTable)object).getSize() + ") should be the same as the count of the sequence tables (" + lookupTypeMultipleSubstitutionFormat1.getSequenceTables().length + ")"));
            return;
        }
        for (int i = 0; i < ((CoverageTable)object).getSize(); ++i) {
            ((CoverageTable)object).getGlyphId(i);
            lookupTypeMultipleSubstitutionFormat1.getSequenceTables();
        }
    }

    private void extractDataFromLigatureSubstitutionSubstFormat1Table(Map<List<Integer>, Integer> map, LookupTypeLigatureSubstitutionSubstFormat1 ligatureSetTableArray) {
        for (LigatureSetTable ligatureSetTable : ligatureSetTableArray.getLigatureSetTables()) {
            for (LigatureTable ligatureTable : ligatureSetTable.getLigatureTables()) {
                this.extractDataFromLigatureTable(map, ligatureTable);
            }
        }
    }

    private void extractDataFromLigatureTable(Map<List<Integer>, Integer> map, LigatureTable ligatureTable) {
        int[] nArray = ligatureTable.getComponentGlyphIDs();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n : nArray) {
            arrayList.add(n);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("glyphsToBeSubstituted: " + arrayList));
        }
        this.putNewSubstitutionEntry(map, ligatureTable.getLigatureGlyph(), arrayList);
    }

    private void putNewSubstitutionEntry(Map<List<Integer>, Integer> object, int n, List<Integer> list) {
        if ((object = object.put(list, n)) != null && LOG.isDebugEnabled()) {
            object = "For the newGlyph: " + n + ", newValue: " + list + " is trying to override the oldValue: " + object;
            LOG.debug(object);
        }
    }
}

