/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.type1;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.EncodedFont;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.cff.Type1CharStringParser;
import org.apache.fontbox.encoding.Encoding;
import org.apache.fontbox.pfb.PfbParser;
import org.apache.fontbox.type1.Type1CharStringReader;
import org.apache.fontbox.type1.Type1Parser;
import org.apache.fontbox.util.BoundingBox;

public final class Type1Font
implements EncodedFont,
FontBoxFont,
Type1CharStringReader {
    String fontName = "";
    Encoding encoding = null;
    int paintType;
    int fontType;
    List<Number> fontMatrix = Collections.emptyList();
    List<Number> fontBBox = Collections.emptyList();
    int uniqueID;
    float strokeWidth;
    String fontID = "";
    String version = "";
    String notice = "";
    String fullName = "";
    String familyName = "";
    String weight = "";
    float italicAngle;
    boolean isFixedPitch;
    float underlinePosition;
    float underlineThickness;
    List<Number> blueValues = Collections.emptyList();
    List<Number> otherBlues = Collections.emptyList();
    List<Number> familyBlues = Collections.emptyList();
    List<Number> familyOtherBlues = Collections.emptyList();
    float blueScale;
    int blueShift;
    int blueFuzz;
    List<Number> stdHW = Collections.emptyList();
    List<Number> stdVW = Collections.emptyList();
    List<Number> stemSnapH = Collections.emptyList();
    List<Number> stemSnapV = Collections.emptyList();
    boolean forceBold;
    int languageGroup;
    final List<byte[]> subrs = new ArrayList<byte[]>();
    final Map<String, byte[]> charstrings = new LinkedHashMap<String, byte[]>();
    private final Map<String, Type1CharString> charStringCache = new ConcurrentHashMap<String, Type1CharString>();
    private Type1CharStringParser charStringParser = null;
    private final byte[] segment1;
    private final byte[] segment2;

    public static Type1Font createWithPFB(InputStream object) {
        object = new PfbParser((InputStream)object);
        Type1Parser type1Parser = new Type1Parser();
        return type1Parser.parse(((PfbParser)object).getSegment1(), ((PfbParser)object).getSegment2());
    }

    public static Type1Font createWithPFB(byte[] object) {
        object = new PfbParser((byte[])object);
        Type1Parser type1Parser = new Type1Parser();
        return type1Parser.parse(((PfbParser)object).getSegment1(), ((PfbParser)object).getSegment2());
    }

    public static Type1Font createWithSegments(byte[] byArray, byte[] byArray2) {
        Type1Parser type1Parser = new Type1Parser();
        return type1Parser.parse(byArray, byArray2);
    }

    Type1Font(byte[] byArray, byte[] byArray2) {
        this.segment1 = byArray;
        this.segment2 = byArray2;
    }

    public final List<byte[]> getSubrsArray() {
        return Collections.unmodifiableList(this.subrs);
    }

    public final Map<String, byte[]> getCharStringsDict() {
        return Collections.unmodifiableMap(this.charstrings);
    }

    @Override
    public final String getName() {
        return this.fontName;
    }

    @Override
    public final GeneralPath getPath(String string) {
        return this.getType1CharString(string).getPath();
    }

    @Override
    public final float getWidth(String string) {
        return this.getType1CharString(string).getWidth();
    }

    @Override
    public final boolean hasGlyph(String string) {
        return this.charstrings.get(string) != null;
    }

    @Override
    public final Type1CharString getType1CharString(String string) {
        Object object = this.charStringCache.get(string);
        if (object == null) {
            byte[] byArray = this.charstrings.get(string);
            object = byArray;
            if (byArray == null) {
                byte[] byArray2 = this.charstrings.get(".notdef");
                object = byArray2;
                if (byArray2 == null) {
                    throw new IOException(".notdef is not defined");
                }
            }
            object = this.getParser().parse((byte[])object, this.subrs, string);
            Type1Font type1Font = this;
            object = new Type1CharString(type1Font, type1Font.fontName, string, (List<Object>)object);
            this.charStringCache.put(string, (Type1CharString)object);
        }
        return object;
    }

    private Type1CharStringParser getParser() {
        if (this.charStringParser == null) {
            this.charStringParser = new Type1CharStringParser(this.fontName);
        }
        return this.charStringParser;
    }

    public final String getFontName() {
        return this.fontName;
    }

    @Override
    public final Encoding getEncoding() {
        return this.encoding;
    }

    public final int getPaintType() {
        return this.paintType;
    }

    public final int getFontType() {
        return this.fontType;
    }

    @Override
    public final List<Number> getFontMatrix() {
        return Collections.unmodifiableList(this.fontMatrix);
    }

    @Override
    public final BoundingBox getFontBBox() {
        if (this.fontBBox.size() < 4) {
            throw new IOException("FontBBox must have 4 numbers, but is " + this.fontBBox);
        }
        return new BoundingBox(this.fontBBox);
    }

    public final int getUniqueID() {
        return this.uniqueID;
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final String getFontID() {
        return this.fontID;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getNotice() {
        return this.notice;
    }

    public final String getFullName() {
        return this.fullName;
    }

    public final String getFamilyName() {
        return this.familyName;
    }

    public final String getWeight() {
        return this.weight;
    }

    public final float getItalicAngle() {
        return this.italicAngle;
    }

    public final boolean isFixedPitch() {
        return this.isFixedPitch;
    }

    public final float getUnderlinePosition() {
        return this.underlinePosition;
    }

    public final float getUnderlineThickness() {
        return this.underlineThickness;
    }

    public final List<Number> getBlueValues() {
        return Collections.unmodifiableList(this.blueValues);
    }

    public final List<Number> getOtherBlues() {
        return Collections.unmodifiableList(this.otherBlues);
    }

    public final List<Number> getFamilyBlues() {
        return Collections.unmodifiableList(this.familyBlues);
    }

    public final List<Number> getFamilyOtherBlues() {
        return Collections.unmodifiableList(this.familyOtherBlues);
    }

    public final float getBlueScale() {
        return this.blueScale;
    }

    public final int getBlueShift() {
        return this.blueShift;
    }

    public final int getBlueFuzz() {
        return this.blueFuzz;
    }

    public final List<Number> getStdHW() {
        return Collections.unmodifiableList(this.stdHW);
    }

    public final List<Number> getStdVW() {
        return Collections.unmodifiableList(this.stdVW);
    }

    public final List<Number> getStemSnapH() {
        return Collections.unmodifiableList(this.stemSnapH);
    }

    public final List<Number> getStemSnapV() {
        return Collections.unmodifiableList(this.stemSnapV);
    }

    public final boolean isForceBold() {
        return this.forceBold;
    }

    public final int getLanguageGroup() {
        return this.languageGroup;
    }

    public final byte[] getASCIISegment() {
        return this.segment1;
    }

    public final byte[] getBinarySegment() {
        return this.segment2;
    }

    public final String toString() {
        return this.getClass().getName() + "[fontName=" + this.fontName + ", fullName=" + this.fullName + ", encoding=" + this.encoding + ", charStringsDict=" + this.charstrings + "]";
    }
}

