/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.spi.ThreadExecutor;

class JobStoreSupport$ClusterManager
extends Thread {
    private volatile boolean shutdown = false;
    private int numFails = 0;
    final /* synthetic */ JobStoreSupport this$0;

    JobStoreSupport$ClusterManager(JobStoreSupport jobStoreSupport) {
        this.this$0 = jobStoreSupport;
        this.setPriority(7);
        this.setName("QuartzScheduler_" + jobStoreSupport.instanceName + "-" + jobStoreSupport.instanceId + "_ClusterManager");
        this.setDaemon(jobStoreSupport.getMakeThreadsDaemons());
    }

    public void initialize() {
        this.manage();
        ThreadExecutor threadExecutor = this.this$0.getThreadExecutor();
        threadExecutor.execute(this);
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    private boolean manage() {
        boolean bl = false;
        try {
            bl = this.this$0.doCheckin();
            this.numFails = 0;
            this.this$0.getLog().debug("ClusterManager: Check-in complete.");
        }
        catch (Exception exception) {
            if (this.numFails % 4 == 0) {
                this.this$0.getLog().error("ClusterManager: Error managing cluster: " + exception.getMessage(), (Throwable)exception);
            }
            ++this.numFails;
        }
        return bl;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            if (!this.shutdown) {
                long l = this.this$0.getClusterCheckinInterval();
                long l2 = System.currentTimeMillis() - this.this$0.lastCheckin;
                if ((l -= l2) <= 0L) {
                    l = 100L;
                }
                if (this.numFails > 0) {
                    l = Math.max(this.this$0.getDbRetryInterval(), l);
                }
                try {
                    Thread.sleep(l);
                }
                catch (Exception exception) {}
            }
            if (this.shutdown || !this.manage()) continue;
            this.this$0.signalSchedulingChangeImmediately(0L);
        }
    }
}

