/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.DirtyFlagMap;

public class PropertySettingJobFactory
extends SimpleJobFactory {
    private boolean warnIfNotFound = false;
    private boolean throwIfNotFound = false;

    @Override
    public Job newJob(TriggerFiredBundle triggerFiredBundle, Scheduler scheduler) {
        Job job = super.newJob(triggerFiredBundle, scheduler);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAll(scheduler.getContext());
        jobDataMap.putAll(triggerFiredBundle.getJobDetail().getJobDataMap());
        jobDataMap.putAll(triggerFiredBundle.getTrigger().getJobDataMap());
        this.setBeanProps(job, jobDataMap);
        return job;
    }

    /*
     * WARNING - void declaration
     */
    protected void setBeanProps(Object object, JobDataMap object2) {
        void illegalArgumentException;
        Object object32 = null;
        try {
            BeanInfo numberFormatException = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            this.handleError("Unable to introspect Job class.", introspectionException);
        }
        PropertyDescriptor[] propertyDescriptorArray = illegalArgumentException.getPropertyDescriptors();
        for (Map.Entry invocationTargetException : ((DirtyFlagMap)((Object)object2)).getWrappedMap().entrySet()) {
            String string = (String)invocationTargetException.getKey();
            Object object3 = string.substring(0, 1).toUpperCase(Locale.US);
            object3 = "set" + (String)object3 + string.substring(1);
            object3 = this.getSetMethod((String)object3, propertyDescriptorArray);
            Class<?> clazz = null;
            Object object4 = null;
            try {
                void var3_27;
                if (object3 == null) {
                    this.handleError("No setter on Job class " + object.getClass().getName() + " for property '" + string + "'");
                    continue;
                }
                clazz = ((Method)object3).getParameterTypes()[0];
                object4 = invocationTargetException.getValue();
                Object var3_8 = null;
                if (clazz.isPrimitive()) {
                    if (object4 == null) {
                        this.handleError("Cannot set primitive property '" + string + "' on Job class " + object.getClass().getName() + " to null.");
                        continue;
                    }
                    if (clazz.equals(Integer.TYPE)) {
                        if (object4 instanceof String) {
                            Integer n = Integer.valueOf((String)object4);
                        } else if (object4 instanceof Integer) {
                            Object object5 = object4;
                        }
                    } else if (clazz.equals(Long.TYPE)) {
                        if (object4 instanceof String) {
                            Long l = Long.valueOf((String)object4);
                        } else if (object4 instanceof Long) {
                            Object object6 = object4;
                        }
                    } else if (clazz.equals(Float.TYPE)) {
                        if (object4 instanceof String) {
                            Float f = Float.valueOf((String)object4);
                        } else if (object4 instanceof Float) {
                            Object object7 = object4;
                        }
                    } else if (clazz.equals(Double.TYPE)) {
                        if (object4 instanceof String) {
                            Double d = Double.valueOf((String)object4);
                        } else if (object4 instanceof Double) {
                            Object object8 = object4;
                        }
                    } else if (clazz.equals(Boolean.TYPE)) {
                        if (object4 instanceof String) {
                            Boolean bl = Boolean.valueOf((String)object4);
                        } else if (object4 instanceof Boolean) {
                            Object object9 = object4;
                        }
                    } else if (clazz.equals(Byte.TYPE)) {
                        if (object4 instanceof String) {
                            Byte by = Byte.valueOf((String)object4);
                        } else if (object4 instanceof Byte) {
                            Object object10 = object4;
                        }
                    } else if (clazz.equals(Short.TYPE)) {
                        if (object4 instanceof String) {
                            Short s = Short.valueOf((String)object4);
                        } else if (object4 instanceof Short) {
                            Object object11 = object4;
                        }
                    } else if (clazz.equals(Character.TYPE)) {
                        if (object4 instanceof String) {
                            String string2 = (String)object4;
                            if (string2.length() == 1) {
                                Character c = Character.valueOf(string2.charAt(0));
                            }
                        } else if (object4 instanceof Character) {
                            Object object12 = object4;
                        }
                    }
                } else if (object4 != null && clazz.isAssignableFrom(object4.getClass())) {
                    Object object13 = object4;
                }
                if (object4 != null && var3_27 == null) {
                    this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object4.getClass().getName());
                    continue;
                }
                ((Method)object3).invoke(object, var3_27);
            }
            catch (NumberFormatException numberFormatException) {
                this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object4.getClass().getName(), numberFormatException);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object4.getClass().getName(), illegalArgumentException2);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' could not be accessed.", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException2) {
                this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' could not be invoked.", invocationTargetException2);
            }
        }
    }

    private void handleError(String string) {
        this.handleError(string, null);
    }

    private void handleError(String string, Exception exception) {
        if (this.isThrowIfPropertyNotFound()) {
            throw new SchedulerException(string, exception);
        }
        if (this.isWarnIfPropertyNotFound()) {
            if (exception == null) {
                this.getLog().warn(string);
                return;
            }
            this.getLog().warn(string, (Throwable)exception);
        }
    }

    private Method getSetMethod(String string, PropertyDescriptor[] propertyDescriptorArray) {
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Method method = propertyDescriptorArray[i].getWriteMethod();
            if (method == null || method.getParameterTypes().length != 1 || !method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    public boolean isThrowIfPropertyNotFound() {
        return this.throwIfNotFound;
    }

    public void setThrowIfPropertyNotFound(boolean bl) {
        this.throwIfNotFound = bl;
    }

    public boolean isWarnIfPropertyNotFound() {
        return this.warnIfNotFound;
    }

    public void setWarnIfPropertyNotFound(boolean bl) {
        this.warnIfNotFound = bl;
    }
}

