/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder$IntervalUnit;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.MutableTrigger;
import org.quartz.xml.ValidationException;
import org.quartz.xml.XMLSchedulingDataProcessor$1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSchedulingDataProcessor
implements ErrorHandler {
    public static final String QUARTZ_NS = "http://www.quartz-scheduler.org/xml/JobSchedulingData";
    public static final String QUARTZ_SCHEMA_WEB_URL = "http://www.quartz-scheduler.org/xml/job_scheduling_data_2_0.xsd";
    public static final String QUARTZ_XSD_PATH_IN_JAR = "org/quartz/xml/job_scheduling_data_2_0.xsd";
    public static final String QUARTZ_XML_DEFAULT_FILE_NAME = "quartz_data.xml";
    public static final String QUARTZ_SYSTEM_ID_JAR_PREFIX = "jar:";
    protected List<String> jobGroupsToDelete = new LinkedList<String>();
    protected List<String> triggerGroupsToDelete = new LinkedList<String>();
    protected List<JobKey> jobsToDelete = new LinkedList<JobKey>();
    protected List<TriggerKey> triggersToDelete = new LinkedList<TriggerKey>();
    protected List<JobDetail> loadedJobs = new LinkedList<JobDetail>();
    protected List<MutableTrigger> loadedTriggers = new LinkedList<MutableTrigger>();
    private boolean overWriteExistingData = true;
    private boolean ignoreDuplicates = false;
    protected Collection<Exception> validationExceptions = new ArrayList<Exception>();
    protected ClassLoadHelper classLoadHelper;
    protected List<String> jobGroupsToNeverDelete = new LinkedList<String>();
    protected List<String> triggerGroupsToNeverDelete = new LinkedList<String>();
    private DocumentBuilder docBuilder = null;
    private XPath xpath = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public XMLSchedulingDataProcessor(ClassLoadHelper classLoadHelper) {
        this.classLoadHelper = classLoadHelper;
        this.initDocumentParser();
    }

    protected void initDocumentParser() {
        Object object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setNamespaceAware(true);
        ((DocumentBuilderFactory)object).setValidating(true);
        ((DocumentBuilderFactory)object).setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        ((DocumentBuilderFactory)object).setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.resolveSchemaSource());
        ((DocumentBuilderFactory)object).setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        ((DocumentBuilderFactory)object).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        ((DocumentBuilderFactory)object).setFeature("http://xml.org/sax/features/external-general-entities", false);
        ((DocumentBuilderFactory)object).setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        ((DocumentBuilderFactory)object).setXIncludeAware(false);
        ((DocumentBuilderFactory)object).setExpandEntityReferences(false);
        this.docBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        this.docBuilder.setErrorHandler(this);
        object = new XMLSchedulingDataProcessor$1(this);
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xpath.setNamespaceContext((NamespaceContext)object);
    }

    protected Object resolveSchemaSource() {
        Object object = null;
        try {
            object = this.classLoadHelper.getResourceAsStream(QUARTZ_XSD_PATH_IN_JAR);
        }
        finally {
            if (object == null) {
                this.log.info("Unable to load local schema packaged in quartz distribution jar. Utilizing schema online at http://www.quartz-scheduler.org/xml/job_scheduling_data_2_0.xsd");
                return QUARTZ_SCHEMA_WEB_URL;
            }
            object = new InputSource((InputStream)object);
            ((InputSource)object).setSystemId(QUARTZ_SCHEMA_WEB_URL);
            this.log.debug("Utilizing schema packaged in local quartz distribution jar.");
        }
        return object;
    }

    public boolean isOverWriteExistingData() {
        return this.overWriteExistingData;
    }

    protected void setOverWriteExistingData(boolean bl) {
        this.overWriteExistingData = bl;
    }

    public boolean isIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public void setIgnoreDuplicates(boolean bl) {
        this.ignoreDuplicates = bl;
    }

    public void addJobGroupToNeverDelete(String string) {
        if (string != null) {
            this.jobGroupsToNeverDelete.add(string);
        }
    }

    public boolean removeJobGroupToNeverDelete(String string) {
        return string != null && this.jobGroupsToNeverDelete.remove(string);
    }

    public List<String> getJobGroupsToNeverDelete() {
        return Collections.unmodifiableList(this.jobGroupsToDelete);
    }

    public void addTriggerGroupToNeverDelete(String string) {
        if (string != null) {
            this.triggerGroupsToNeverDelete.add(string);
        }
    }

    public boolean removeTriggerGroupToNeverDelete(String string) {
        if (string != null) {
            return this.triggerGroupsToNeverDelete.remove(string);
        }
        return false;
    }

    public List<String> getTriggerGroupsToNeverDelete() {
        return Collections.unmodifiableList(this.triggerGroupsToDelete);
    }

    protected void processFile() {
        this.processFile(QUARTZ_XML_DEFAULT_FILE_NAME);
    }

    protected void processFile(String string) {
        this.processFile(string, this.getSystemIdForFileName(string));
    }

    protected String getSystemIdForFileName(String string) {
        Serializable serializable = new File(string);
        if (((File)serializable).exists()) {
            try {
                new FileInputStream((File)serializable).close();
                return ((File)serializable).toURI().toString();
            }
            catch (IOException iOException) {
                return string;
            }
        }
        serializable = this.getURL(string);
        if (serializable == null) {
            return string;
        }
        try {
            ((URL)serializable).openStream().close();
            return ((URL)serializable).toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    protected URL getURL(String string) {
        return this.classLoadHelper.getResource(string);
    }

    protected void prepForProcessing() {
        this.clearValidationExceptions();
        this.setOverWriteExistingData(true);
        this.setIgnoreDuplicates(false);
        this.jobGroupsToDelete.clear();
        this.jobsToDelete.clear();
        this.triggerGroupsToDelete.clear();
        this.triggersToDelete.clear();
        this.loadedJobs.clear();
        this.loadedTriggers.clear();
    }

    protected void processFile(String object, String string) {
        this.prepForProcessing();
        this.log.info("Parsing XML file: " + (String)object + " with systemId: " + string);
        object = new InputSource(this.getInputStream((String)object));
        ((InputSource)object).setSystemId(string);
        this.process((InputSource)object);
        this.maybeThrowValidationException();
    }

    public void processStreamAndScheduleJobs(InputStream object, String string, Scheduler scheduler) {
        this.prepForProcessing();
        this.log.info("Parsing XML from stream with systemId: " + string);
        object = new InputSource((InputStream)object);
        ((InputSource)object).setSystemId(string);
        this.process((InputSource)object);
        this.executePreProcessCommands(scheduler);
        this.scheduleJobs(scheduler);
        this.maybeThrowValidationException();
    }

    protected void process(InputSource object) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        String string2;
        String string3;
        Object object6;
        Object object7;
        object = this.docBuilder.parse((InputSource)object);
        Object object8 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-jobs-in-group", object, XPathConstants.NODESET);
        this.log.debug("Found " + object8.getLength() + " delete job group commands.");
        for (int i = 0; i < object8.getLength(); ++i) {
            Node node = object8.item(i);
            object7 = node.getTextContent();
            if (object7 == null || ((String)(object7 = ((String)object7).trim())).length() == 0) continue;
            this.jobGroupsToDelete.add((String)object7);
        }
        Object object9 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-triggers-in-group", object, XPathConstants.NODESET);
        this.log.debug("Found " + object9.getLength() + " delete trigger group commands.");
        for (int i = 0; i < object9.getLength(); ++i) {
            object7 = object9.item(i);
            object8 = object7.getTextContent();
            if (object8 == null || ((String)(object8 = ((String)object8).trim())).length() == 0) continue;
            this.triggerGroupsToDelete.add((String)object8);
        }
        Object object10 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-job", object, XPathConstants.NODESET);
        this.log.debug("Found " + object10.getLength() + " delete job commands.");
        for (int i = 0; i < object10.getLength(); ++i) {
            object8 = object10.item(i);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor = this;
            object9 = xMLSchedulingDataProcessor.getTrimmedToNullString(xMLSchedulingDataProcessor.xpath, "q:name", (Node)object8);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor2 = this;
            object6 = xMLSchedulingDataProcessor2.getTrimmedToNullString(xMLSchedulingDataProcessor2.xpath, "q:group", (Node)object8);
            if (object9 == null) {
                throw new ParseException("Encountered a 'delete-job' command without a name specified.", -1);
            }
            this.jobsToDelete.add(new JobKey((String)object9, (String)object6));
        }
        Object object11 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-trigger", object, XPathConstants.NODESET);
        this.log.debug("Found " + object11.getLength() + " delete trigger commands.");
        for (int i = 0; i < object11.getLength(); ++i) {
            object9 = object11.item(i);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor = this;
            object6 = xMLSchedulingDataProcessor.getTrimmedToNullString(xMLSchedulingDataProcessor.xpath, "q:name", (Node)object9);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor3 = this;
            object9 = xMLSchedulingDataProcessor3.getTrimmedToNullString(xMLSchedulingDataProcessor3.xpath, "q:group", (Node)object9);
            if (object6 == null) {
                throw new ParseException("Encountered a 'delete-trigger' command without a name specified.", -1);
            }
            this.triggersToDelete.add(new TriggerKey((String)object6, (String)object9));
        }
        XMLSchedulingDataProcessor xMLSchedulingDataProcessor = this;
        Object object12 = xMLSchedulingDataProcessor.getBoolean(xMLSchedulingDataProcessor.xpath, "/q:job-scheduling-data/q:processing-directives/q:overwrite-existing-data", (Document)object);
        if (object12 == null) {
            this.log.debug("Directive 'overwrite-existing-data' not specified, defaulting to " + this.isOverWriteExistingData());
        } else {
            this.log.debug("Directive 'overwrite-existing-data' specified as: " + object12);
            this.setOverWriteExistingData((Boolean)object12);
        }
        XMLSchedulingDataProcessor xMLSchedulingDataProcessor4 = this;
        object9 = xMLSchedulingDataProcessor4.getBoolean(xMLSchedulingDataProcessor4.xpath, "/q:job-scheduling-data/q:processing-directives/q:ignore-duplicates", (Document)object);
        if (object9 == null) {
            this.log.debug("Directive 'ignore-duplicates' not specified, defaulting to " + this.isIgnoreDuplicates());
        } else {
            this.log.debug("Directive 'ignore-duplicates' specified as: " + object9);
            this.setIgnoreDuplicates((Boolean)object9);
        }
        object6 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:schedule/q:job", object, XPathConstants.NODESET);
        this.log.debug("Found " + object6.getLength() + " job definitions.");
        for (int i = 0; i < object6.getLength(); ++i) {
            object12 = object6.item(i);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor5 = this;
            object11 = xMLSchedulingDataProcessor5.getTrimmedToNullString(xMLSchedulingDataProcessor5.xpath, "q:name", (Node)object12);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor6 = this;
            string3 = xMLSchedulingDataProcessor6.getTrimmedToNullString(xMLSchedulingDataProcessor6.xpath, "q:group", (Node)object12);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor7 = this;
            string2 = xMLSchedulingDataProcessor7.getTrimmedToNullString(xMLSchedulingDataProcessor7.xpath, "q:description", (Node)object12);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor8 = this;
            string = xMLSchedulingDataProcessor8.getTrimmedToNullString(xMLSchedulingDataProcessor8.xpath, "q:job-class", (Node)object12);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor9 = this;
            object10 = xMLSchedulingDataProcessor9.getTrimmedToNullString(xMLSchedulingDataProcessor9.xpath, "q:durability", (Node)object12);
            int n = object10 != null && ((String)object10).equals("true") ? 1 : 0;
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor10 = this;
            object10 = xMLSchedulingDataProcessor10.getTrimmedToNullString(xMLSchedulingDataProcessor10.xpath, "q:recover", (Node)object12);
            boolean bl = object10 != null && ((String)object10).equals("true");
            object5 = this.classLoadHelper.loadClass(string, Job.class);
            object4 = JobBuilder.newJob(object5).withIdentity((String)object11, string3).withDescription(string2).storeDurably(n != 0).requestRecovery(bl).build();
            NodeList nodeList = (NodeList)this.xpath.evaluate("q:job-data-map/q:entry", object12, XPathConstants.NODESET);
            for (n = 0; n < nodeList.getLength(); ++n) {
                object3 = nodeList.item(n);
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor11 = this;
                object2 = xMLSchedulingDataProcessor11.getTrimmedToNullString(xMLSchedulingDataProcessor11.xpath, "q:key", (Node)object3);
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor12 = this;
                object3 = xMLSchedulingDataProcessor12.getTrimmedToNullString(xMLSchedulingDataProcessor12.xpath, "q:value", (Node)object3);
                object4.getJobDataMap().put((String)object2, (String)object3);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Parsed job definition: " + object4);
            }
            this.addJobToSchedule((JobDetail)object4);
        }
        NodeList nodeList = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:schedule/q:trigger/*", object, XPathConstants.NODESET);
        this.log.debug("Found " + nodeList.getLength() + " trigger definitions.");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            object10 = nodeList.item(i);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor13 = this;
            object11 = xMLSchedulingDataProcessor13.getTrimmedToNullString(xMLSchedulingDataProcessor13.xpath, "q:name", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor14 = this;
            string3 = xMLSchedulingDataProcessor14.getTrimmedToNullString(xMLSchedulingDataProcessor14.xpath, "q:group", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor15 = this;
            string2 = xMLSchedulingDataProcessor15.getTrimmedToNullString(xMLSchedulingDataProcessor15.xpath, "q:description", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor16 = this;
            string = xMLSchedulingDataProcessor16.getTrimmedToNullString(xMLSchedulingDataProcessor16.xpath, "q:misfire-instruction", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor17 = this;
            Object object13 = xMLSchedulingDataProcessor17.getTrimmedToNullString(xMLSchedulingDataProcessor17.xpath, "q:priority", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor18 = this;
            String string4 = xMLSchedulingDataProcessor18.getTrimmedToNullString(xMLSchedulingDataProcessor18.xpath, "q:calendar-name", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor19 = this;
            object5 = xMLSchedulingDataProcessor19.getTrimmedToNullString(xMLSchedulingDataProcessor19.xpath, "q:job-name", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor20 = this;
            object4 = xMLSchedulingDataProcessor20.getTrimmedToNullString(xMLSchedulingDataProcessor20.xpath, "q:job-group", (Node)object10);
            int n2 = 5;
            if (object13 != null) {
                n2 = Integer.valueOf((String)object13);
            }
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor21 = this;
            object13 = xMLSchedulingDataProcessor21.getTrimmedToNullString(xMLSchedulingDataProcessor21.xpath, "q:start-time", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor22 = this;
            object3 = xMLSchedulingDataProcessor22.getTrimmedToNullString(xMLSchedulingDataProcessor22.xpath, "q:start-time-seconds-in-future", (Node)object10);
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor23 = this;
            object2 = xMLSchedulingDataProcessor23.getTrimmedToNullString(xMLSchedulingDataProcessor23.xpath, "q:end-time", (Node)object10);
            object3 = object3 != null ? new Date(System.currentTimeMillis() + Long.valueOf((String)object3) * 1000L) : (object13 == null || ((String)object13).length() == 0 ? new Date() : DatatypeConverter.parseDateTime((String)object13).getTime());
            object = object2 == null || ((String)object2).length() == 0 ? null : DatatypeConverter.parseDateTime((String)object2).getTime();
            object6 = TriggerKey.triggerKey((String)object11, string3);
            if (object10.getNodeName().equals("simple")) {
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor24 = this;
                object13 = xMLSchedulingDataProcessor24.getTrimmedToNullString(xMLSchedulingDataProcessor24.xpath, "q:repeat-count", (Node)object10);
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor25 = this;
                object2 = xMLSchedulingDataProcessor25.getTrimmedToNullString(xMLSchedulingDataProcessor25.xpath, "q:repeat-interval", (Node)object10);
                n = object13 == null ? 0 : Integer.parseInt((String)object13);
                long l = object2 == null ? 0L : Long.parseLong((String)object2);
                object13 = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(l).withRepeatCount(n);
                if (string != null && string.length() != 0) {
                    if (string.equals("MISFIRE_INSTRUCTION_FIRE_NOW")) {
                        ((SimpleScheduleBuilder)object13).withMisfireHandlingInstructionFireNow();
                    } else if (string.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT")) {
                        ((SimpleScheduleBuilder)object13).withMisfireHandlingInstructionNextWithExistingCount();
                    } else if (string.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT")) {
                        ((SimpleScheduleBuilder)object13).withMisfireHandlingInstructionNextWithRemainingCount();
                    } else if (string.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT")) {
                        ((SimpleScheduleBuilder)object13).withMisfireHandlingInstructionNowWithExistingCount();
                    } else if (string.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT")) {
                        ((SimpleScheduleBuilder)object13).withMisfireHandlingInstructionNowWithRemainingCount();
                    } else if (!string.equals("MISFIRE_INSTRUCTION_SMART_POLICY")) {
                        throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + string + "', for trigger: " + object6, -1);
                    }
                }
            } else if (object10.getNodeName().equals("cron")) {
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor26 = this;
                object13 = xMLSchedulingDataProcessor26.getTrimmedToNullString(xMLSchedulingDataProcessor26.xpath, "q:cron-expression", (Node)object10);
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor27 = this;
                object2 = xMLSchedulingDataProcessor27.getTrimmedToNullString(xMLSchedulingDataProcessor27.xpath, "q:time-zone", (Node)object10);
                TimeZone timeZone = object2 == null ? null : TimeZone.getTimeZone((String)object2);
                object13 = CronScheduleBuilder.cronSchedule((String)object13).inTimeZone(timeZone);
                if (string != null && string.length() != 0) {
                    if (string.equals("MISFIRE_INSTRUCTION_DO_NOTHING")) {
                        ((CronScheduleBuilder)object13).withMisfireHandlingInstructionDoNothing();
                    } else if (string.equals("MISFIRE_INSTRUCTION_FIRE_ONCE_NOW")) {
                        ((CronScheduleBuilder)object13).withMisfireHandlingInstructionFireAndProceed();
                    } else if (!string.equals("MISFIRE_INSTRUCTION_SMART_POLICY")) {
                        throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + string + "', for trigger: " + object6, -1);
                    }
                }
            } else if (object10.getNodeName().equals("calendar-interval")) {
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor28 = this;
                object13 = xMLSchedulingDataProcessor28.getTrimmedToNullString(xMLSchedulingDataProcessor28.xpath, "q:repeat-interval", (Node)object10);
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor29 = this;
                object2 = xMLSchedulingDataProcessor29.getTrimmedToNullString(xMLSchedulingDataProcessor29.xpath, "q:repeat-interval-unit", (Node)object10);
                n = Integer.parseInt((String)object13);
                DateBuilder$IntervalUnit dateBuilder$IntervalUnit = DateBuilder$IntervalUnit.valueOf((String)object2);
                object13 = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withInterval(n, dateBuilder$IntervalUnit);
                if (string != null && string.length() != 0) {
                    if (string.equals("MISFIRE_INSTRUCTION_DO_NOTHING")) {
                        ((CalendarIntervalScheduleBuilder)object13).withMisfireHandlingInstructionDoNothing();
                    } else if (string.equals("MISFIRE_INSTRUCTION_FIRE_ONCE_NOW")) {
                        ((CalendarIntervalScheduleBuilder)object13).withMisfireHandlingInstructionFireAndProceed();
                    } else if (!string.equals("MISFIRE_INSTRUCTION_SMART_POLICY")) {
                        throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + string + "', for trigger: " + object6, -1);
                    }
                }
            } else {
                throw new ParseException("Unknown trigger type: " + object10.getNodeName(), -1);
            }
            object13 = (MutableTrigger)TriggerBuilder.newTrigger().withIdentity((String)object11, string3).withDescription(string2).forJob((String)object5, (String)object4).startAt((Date)object3).endAt((Date)object).withPriority(n2).modifiedByCalendar(string4).withSchedule(object13).build();
            object2 = (NodeList)this.xpath.evaluate("q:job-data-map/q:entry", object10, XPathConstants.NODESET);
            for (n = 0; n < object2.getLength(); ++n) {
                Node node = object2.item(n);
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor30 = this;
                String string5 = xMLSchedulingDataProcessor30.getTrimmedToNullString(xMLSchedulingDataProcessor30.xpath, "q:key", node);
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor31 = this;
                object = xMLSchedulingDataProcessor31.getTrimmedToNullString(xMLSchedulingDataProcessor31.xpath, "q:value", node);
                object13.getJobDataMap().put(string5, (String)object);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Parsed trigger definition: " + object13);
            }
            this.addTriggerToSchedule((MutableTrigger)object13);
        }
    }

    protected String getTrimmedToNullString(XPath object, String string, Node node) {
        if ((object = (String)object.evaluate(string, node, XPathConstants.STRING)) != null) {
            object = ((String)object).trim();
        }
        if (object != null && ((String)object).length() == 0) {
            object = null;
        }
        return object;
    }

    protected Boolean getBoolean(XPath object, String string, Document document) {
        if ((object = (Node)object.evaluate(string, document, XPathConstants.NODE)) == null || object.getTextContent() == null) {
            return null;
        }
        if (((String)(object = object.getTextContent())).equalsIgnoreCase("true") || ((String)object).equalsIgnoreCase("yes") || ((String)object).equalsIgnoreCase("y")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void processFileAndScheduleJobs(Scheduler scheduler, boolean bl) {
        String string = QUARTZ_XML_DEFAULT_FILE_NAME;
        this.processFile(string, this.getSystemIdForFileName(string));
        this.setOverWriteExistingData(bl);
        this.executePreProcessCommands(scheduler);
        this.scheduleJobs(scheduler);
    }

    public void processFileAndScheduleJobs(String string, Scheduler scheduler) {
        this.processFileAndScheduleJobs(string, this.getSystemIdForFileName(string), scheduler);
    }

    public void processFileAndScheduleJobs(String string, String string2, Scheduler scheduler) {
        this.processFile(string, string2);
        this.executePreProcessCommands(scheduler);
        this.scheduleJobs(scheduler);
    }

    protected List<JobDetail> getLoadedJobs() {
        return Collections.unmodifiableList(this.loadedJobs);
    }

    protected List<MutableTrigger> getLoadedTriggers() {
        return Collections.unmodifiableList(this.loadedTriggers);
    }

    protected InputStream getInputStream(String string) {
        return this.classLoadHelper.getResourceAsStream(string);
    }

    protected void addJobToSchedule(JobDetail jobDetail) {
        this.loadedJobs.add(jobDetail);
    }

    protected void addTriggerToSchedule(MutableTrigger mutableTrigger) {
        this.loadedTriggers.add(mutableTrigger);
    }

    private Map<JobKey, List<MutableTrigger>> buildTriggersByFQJobNameMap(List<MutableTrigger> object) {
        HashMap<JobKey, List<MutableTrigger>> hashMap = new HashMap<JobKey, List<MutableTrigger>>();
        object = object.iterator();
        while (object.hasNext()) {
            MutableTrigger mutableTrigger = (MutableTrigger)object.next();
            LinkedList<MutableTrigger> linkedList = (LinkedList<MutableTrigger>)hashMap.get(mutableTrigger.getJobKey());
            if (linkedList == null) {
                linkedList = new LinkedList<MutableTrigger>();
                hashMap.put(mutableTrigger.getJobKey(), linkedList);
            }
            linkedList.add(mutableTrigger);
        }
        return hashMap;
    }

    protected void executePreProcessCommands(Scheduler scheduler) {
        for (String string : this.jobGroupsToDelete) {
            if (string.equals("*")) {
                this.log.info("Deleting all jobs in ALL groups.");
                for (Object object : scheduler.getJobGroupNames()) {
                    if (this.jobGroupsToNeverDelete.contains(object)) continue;
                    object = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)object)).iterator();
                    while (object.hasNext()) {
                        JobKey jobKey = object.next();
                        scheduler.deleteJob(jobKey);
                    }
                }
                continue;
            }
            if (this.jobGroupsToNeverDelete.contains(string)) continue;
            this.log.info("Deleting all jobs in group: {}", (Object)string);
            for (Object object : scheduler.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                scheduler.deleteJob((JobKey)object);
            }
        }
        for (String string : this.triggerGroupsToDelete) {
            if (string.equals("*")) {
                this.log.info("Deleting all triggers in ALL groups.");
                for (Object object : scheduler.getTriggerGroupNames()) {
                    if (this.triggerGroupsToNeverDelete.contains(object)) continue;
                    object = scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals(object)).iterator();
                    while (object.hasNext()) {
                        TriggerKey triggerKey = object.next();
                        scheduler.unscheduleJob(triggerKey);
                    }
                }
                continue;
            }
            if (this.triggerGroupsToNeverDelete.contains(string)) continue;
            this.log.info("Deleting all triggers in group: {}", (Object)string);
            for (Object object : scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals(string))) {
                scheduler.unscheduleJob((TriggerKey)object);
            }
        }
        for (JobKey jobKey : this.jobsToDelete) {
            if (this.jobGroupsToNeverDelete.contains(jobKey.getGroup())) continue;
            this.log.info("Deleting job: {}", (Object)jobKey);
            scheduler.deleteJob(jobKey);
        }
        for (TriggerKey triggerKey : this.triggersToDelete) {
            if (this.triggerGroupsToNeverDelete.contains(triggerKey.getGroup())) continue;
            this.log.info("Deleting trigger: {}", (Object)triggerKey);
            scheduler.unscheduleJob(triggerKey);
        }
    }

    protected void scheduleJobs(Scheduler scheduler) {
        Iterator iterator;
        Object object = new LinkedList<JobDetail>(this.getLoadedJobs());
        LinkedList<MutableTrigger> linkedList = new LinkedList<MutableTrigger>(this.getLoadedTriggers());
        this.log.info("Adding " + object.size() + " jobs, " + linkedList.size() + " triggers.");
        Map<JobKey, List<MutableTrigger>> map = this.buildTriggersByFQJobNameMap(linkedList);
        object = object.iterator();
        while (object.hasNext()) {
            JobDetail jobDetail = (JobDetail)object.next();
            object.remove();
            JobDetail jobDetail2 = null;
            try {
                jobDetail2 = scheduler.getJobDetail(jobDetail.getKey());
            }
            catch (JobPersistenceException jobPersistenceException) {
                iterator = jobPersistenceException;
                if (jobPersistenceException.getCause() instanceof ClassNotFoundException && this.isOverWriteExistingData()) {
                    this.log.info("Removing job: " + jobDetail.getKey());
                    scheduler.deleteJob(jobDetail.getKey());
                }
                throw iterator;
            }
            if (jobDetail2 != null) {
                if (!this.isOverWriteExistingData() && this.isIgnoreDuplicates()) {
                    this.log.info("Not overwriting existing job: " + jobDetail2.getKey());
                    continue;
                }
                if (!this.isOverWriteExistingData() && !this.isIgnoreDuplicates()) {
                    throw new ObjectAlreadyExistsException(jobDetail);
                }
            }
            if (jobDetail2 != null) {
                this.log.info("Replacing job: " + jobDetail.getKey());
            } else {
                this.log.info("Adding job: " + jobDetail.getKey());
            }
            iterator = map.get(jobDetail.getKey());
            if (!(jobDetail.isDurable() || iterator != null && iterator.size() != 0)) {
                if (jobDetail2 == null) {
                    throw new SchedulerException("A new job defined without any triggers must be durable: " + jobDetail.getKey());
                }
                if (jobDetail2.isDurable() && scheduler.getTriggersOfJob(jobDetail.getKey()).size() == 0) {
                    throw new SchedulerException("Can't change existing durable job without triggers to non-durable: " + jobDetail.getKey());
                }
            }
            if (jobDetail2 != null || jobDetail.isDurable()) {
                if (iterator != null && iterator.size() > 0) {
                    scheduler.addJob(jobDetail, true, true);
                    continue;
                }
                scheduler.addJob(jobDetail, true, false);
                continue;
            }
            boolean bl = true;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Trigger trigger;
                MutableTrigger mutableTrigger = (MutableTrigger)iterator.next();
                linkedList.remove(mutableTrigger);
                if (mutableTrigger.getStartTime() == null) {
                    mutableTrigger.setStartTime(new Date());
                }
                if ((trigger = scheduler.getTrigger(mutableTrigger.getKey())) != null) {
                    if (this.isOverWriteExistingData()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Rescheduling job: " + mutableTrigger.getJobKey() + " with updated trigger: " + mutableTrigger.getKey());
                        }
                    } else {
                        if (this.isIgnoreDuplicates()) {
                            this.log.info("Not overwriting existing trigger: " + trigger.getKey());
                            continue;
                        }
                        throw new ObjectAlreadyExistsException(mutableTrigger);
                    }
                    if (!trigger.getJobKey().equals(mutableTrigger.getJobKey())) {
                        this.log.warn("Possibly duplicately named ({}) triggers in jobs xml file! ", (Object)mutableTrigger.getKey());
                    }
                    scheduler.rescheduleJob(mutableTrigger.getKey(), mutableTrigger);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Scheduling job: " + mutableTrigger.getJobKey() + " with trigger: " + mutableTrigger.getKey());
                }
                try {
                    if (bl) {
                        scheduler.scheduleJob(jobDetail, mutableTrigger);
                        bl = false;
                        continue;
                    }
                    scheduler.scheduleJob(mutableTrigger);
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Adding trigger: " + mutableTrigger.getKey() + " for job: " + jobDetail.getKey() + " failed because the trigger already existed.  This is likely due to a race condition between multiple instances " + "in the cluster.  Will try to reschedule instead.");
                    }
                    scheduler.rescheduleJob(mutableTrigger.getKey(), mutableTrigger);
                }
            }
        }
        for (MutableTrigger mutableTrigger : linkedList) {
            if (mutableTrigger.getStartTime() == null) {
                mutableTrigger.setStartTime(new Date());
            }
            if ((iterator = scheduler.getTrigger(mutableTrigger.getKey())) != null) {
                if (this.isOverWriteExistingData()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Rescheduling job: " + mutableTrigger.getJobKey() + " with updated trigger: " + mutableTrigger.getKey());
                    }
                } else {
                    if (this.isIgnoreDuplicates()) {
                        this.log.info("Not overwriting existing trigger: " + iterator.getKey());
                        continue;
                    }
                    throw new ObjectAlreadyExistsException(mutableTrigger);
                }
                if (!iterator.getJobKey().equals(mutableTrigger.getJobKey())) {
                    this.log.warn("Possibly duplicately named ({}) triggers in jobs xml file! ", (Object)mutableTrigger.getKey());
                }
                scheduler.rescheduleJob(mutableTrigger.getKey(), mutableTrigger);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Scheduling job: " + mutableTrigger.getJobKey() + " with trigger: " + mutableTrigger.getKey());
            }
            try {
                scheduler.scheduleJob(mutableTrigger);
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Adding trigger: " + mutableTrigger.getKey() + " for job: " + mutableTrigger.getJobKey() + " failed because the trigger already existed.  This is likely due to a race condition between multiple instances " + "in the cluster.  Will try to reschedule instead.");
                }
                scheduler.rescheduleJob(mutableTrigger.getKey(), mutableTrigger);
            }
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        this.addValidationException(sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        this.addValidationException(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        this.addValidationException(sAXParseException);
    }

    protected void addValidationException(SAXException sAXException) {
        this.validationExceptions.add(sAXException);
    }

    protected void clearValidationExceptions() {
        this.validationExceptions.clear();
    }

    protected void maybeThrowValidationException() {
        if (this.validationExceptions.size() > 0) {
            throw new ValidationException("Encountered " + this.validationExceptions.size() + " validation exceptions.", this.validationExceptions);
        }
    }
}

