/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.HexFormat;
import kotlin.text.HexFormat$BytesHexFormat;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0004\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a@\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0000\u001a@\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0000\u001a \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u001a,\u0010\u0016\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a,\u0010\u001b\u001a\u00020\u001c*\u00020\u00032\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u001c\u0010!\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002\u001a\u0014\u0010\"\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\tH\u0002\u001a*\u0010#\u001a\u00020$*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010#\u001a\u00020$*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010'\u001a\u00020(*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010'\u001a\u00020(*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010)\u001a\u00020\t*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010)\u001a\u00020\t*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010*\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010*\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a0\u0010+\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\tH\u0003\u001a*\u0010,\u001a\u00020-*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010,\u001a\u00020-*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010.\u001a\u00020\u0003*\u00020(2\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020(2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020\u00062\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020-2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u001c\u0010/\u001a\u00020\u0003*\u00020\u00062\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u00020\tH\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"HEX_DIGITS_TO_DECIMAL", "", "LOWER_CASE_HEX_DIGITS", "", "UPPER_CASE_HEX_DIGITS", "charsPerSet", "", "charsPerElement", "elementsPerSet", "", "elementSeparatorLength", "formattedStringLength", "totalBytes", "bytesPerLine", "bytesPerGroup", "groupSeparatorLength", "byteSeparatorLength", "bytePrefixLength", "byteSuffixLength", "parsedByteArrayMaxSize", "stringLength", "wholeElementsPerSet", "checkContainsAt", "part", "index", "endIndex", "partName", "checkHexLength", "", "startIndex", "maxDigits", "requireMaxLength", "", "checkNewLineAt", "decimalFromHexDigitAt", "hexToByte", "", "format", "Lkotlin/text/HexFormat;", "hexToByteArray", "", "hexToInt", "hexToLong", "hexToLongImpl", "hexToShort", "", "toHexString", "toHexStringImpl", "bits", "kotlin-stdlib"})
public final class HexExtensionsKt {
    private static final String LOWER_CASE_HEX_DIGITS = "0123456789abcdef";
    private static final String UPPER_CASE_HEX_DIGITS = "0123456789ABCDEF";
    private static final int[] HEX_DIGITS_TO_DECIMAL;

    public static final String toHexString(byte[] byArray, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.toHexString(byArray, 0, byArray.length, hexFormat);
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(byArray, hexFormat);
    }

    public static final String toHexString(byte[] byArray, int n, int n2, HexFormat object) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(object, "");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n, n2, byArray.length);
        if (n == n2) {
            return "";
        }
        String string = ((HexFormat)object).getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        object = ((HexFormat)object).getBytes();
        int n3 = ((HexFormat$BytesHexFormat)object).getBytesPerLine();
        int n4 = ((HexFormat$BytesHexFormat)object).getBytesPerGroup();
        String string2 = ((HexFormat$BytesHexFormat)object).getBytePrefix();
        String string3 = ((HexFormat$BytesHexFormat)object).getByteSuffix();
        String string4 = ((HexFormat$BytesHexFormat)object).getByteSeparator();
        object = ((HexFormat$BytesHexFormat)object).getGroupSeparator();
        int n5 = HexExtensionsKt.formattedStringLength(n2 - n, n3, n4, ((String)object).length(), string4.length(), string2.length(), string3.length());
        int n6 = 0;
        int n7 = 0;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder(n5);
        while (n < n2) {
            int n8 = byArray[n] & 0xFF;
            if (n6 == n3) {
                stringBuilder2.append('\n');
                n6 = 0;
                n7 = 0;
            } else if (n7 == n4) {
                stringBuilder2.append((String)object);
                n7 = 0;
            }
            if (n7 != 0) {
                stringBuilder2.append(string4);
            }
            stringBuilder2.append(string2);
            stringBuilder2.append(string.charAt(n8 >> 4));
            stringBuilder2.append(string.charAt(n8 & 0xF));
            stringBuilder2.append(string3);
            ++n7;
            ++n6;
            ++n;
        }
        n = n5 == stringBuilder2.length() ? 1 : 0;
        if (n == 0) {
            String string5 = "Check failed.";
            throw new IllegalStateException(string5.toString());
        }
        String string6 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string6, "");
        return string6;
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byArray.length;
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(byArray, n, n2, hexFormat);
    }

    public static final int formattedStringLength(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n > 0 ? 1 : 0;
        if (n8 == 0) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        n8 = (n - 1) / n2;
        int n9 = (n2 - 1) / n3;
        int n10 = n % n2;
        n2 = n10 == 0 ? n2 : n10;
        n10 = (n2 - 1) / n3;
        long l = (long)n8 + (long)(n2 = n8 * n9 + n10) * (long)n4 + (long)(n3 = n - 1 - n8 - n2) * (long)n5 + (long)n * ((long)n6 + 2L + (long)n7);
        if (!RangesKt.intRangeContains((ClosedRange<Integer>)new IntRange(0, Integer.MAX_VALUE), l)) {
            throw new IllegalArgumentException("The resulting string length is too big: " + ULong.toString-impl(ULong.constructor-impl(l)));
        }
        return (int)l;
    }

    public static final byte[] hexToByteArray(String string, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.hexToByteArray(string, 0, string.length(), hexFormat);
    }

    public static /* synthetic */ byte[] hexToByteArray$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByteArray(string, hexFormat);
    }

    private static final byte[] hexToByteArray(String string, int n, int n2, HexFormat object) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n, n2, string.length());
        if (n == n2) {
            return new byte[0];
        }
        object = ((HexFormat)object).getBytes();
        int n3 = ((HexFormat$BytesHexFormat)object).getBytesPerLine();
        int n4 = ((HexFormat$BytesHexFormat)object).getBytesPerGroup();
        String string2 = ((HexFormat$BytesHexFormat)object).getBytePrefix();
        String string3 = ((HexFormat$BytesHexFormat)object).getByteSuffix();
        String string4 = ((HexFormat$BytesHexFormat)object).getByteSeparator();
        object = ((HexFormat$BytesHexFormat)object).getGroupSeparator();
        int n5 = HexExtensionsKt.parsedByteArrayMaxSize(n2 - n, n3, n4, ((String)object).length(), string4.length(), string2.length(), string3.length());
        byte[] byArray = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n < n2) {
            if (n7 == n3) {
                n = HexExtensionsKt.checkNewLineAt(string, n, n2);
                n7 = 0;
                n8 = 0;
            } else if (n8 == n4) {
                n = HexExtensionsKt.checkContainsAt(string, (String)object, n, n2, "group separator");
                n8 = 0;
            } else if (n8 != 0) {
                n = HexExtensionsKt.checkContainsAt(string, string4, n, n2, "byte separator");
            }
            ++n7;
            ++n8;
            int n9 = n = HexExtensionsKt.checkContainsAt(string, string2, n, n2, "byte prefix");
            HexExtensionsKt.checkHexLength(string, n9, RangesKt.coerceAtMost(n9 + 2, n2), 2, true);
            byArray[n6++] = (byte)(HexExtensionsKt.decimalFromHexDigitAt(string, n++) << 4 | HexExtensionsKt.decimalFromHexDigitAt(string, n++));
            n = HexExtensionsKt.checkContainsAt(string, string3, n, n2, "byte suffix");
        }
        if (n6 == n5) {
            return byArray;
        }
        byte[] byArray2 = Arrays.copyOf(byArray, n6);
        Intrinsics.checkNotNullExpressionValue(byArray2, "");
        return byArray2;
    }

    static /* synthetic */ byte[] hexToByteArray$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByteArray(string, n, n2, hexFormat);
    }

    public static final int parsedByteArrayMaxSize(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        long l;
        boolean bl = n > 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long l2 = (long)n6 + 2L + (long)n7;
        long l3 = HexExtensionsKt.charsPerSet(l2, n3, n5);
        if (n2 <= n3) {
            l = HexExtensionsKt.charsPerSet(l2, n2, n5);
        } else {
            int n8 = n2 / n3;
            long l4 = HexExtensionsKt.charsPerSet(l3, n8, n4);
            int n9 = n2 % n3;
            if (n9 != 0) {
                l4 += (long)n4;
                l4 += HexExtensionsKt.charsPerSet(l2, n9, n5);
            }
            l = l4;
        }
        long l5 = l;
        long l6 = n;
        long l7 = HexExtensionsKt.wholeElementsPerSet(l6, l5, 1);
        long l8 = HexExtensionsKt.wholeElementsPerSet(l6 -= l7 * (l5 + 1L), l3, n4);
        long l9 = HexExtensionsKt.wholeElementsPerSet(l6 -= l8 * (l3 + (long)n4), l2, n5);
        n = (l6 -= l9 * (l2 + (long)n5)) > 0L ? 1 : 0;
        return (int)(l7 * (long)n2 + l8 * (long)n3 + l9 + (long)n);
    }

    private static final long charsPerSet(long l, int n, int n2) {
        boolean bl = n > 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return l * (long)n + (long)n2 * ((long)n - 1L);
    }

    private static final long wholeElementsPerSet(long l, long l2, int n) {
        if (l <= 0L || l2 <= 0L) {
            return 0L;
        }
        return (l + (long)n) / (l2 + (long)n);
    }

    private static final int checkNewLineAt(String string, int n, int n2) {
        if (string.charAt(n) == '\r') {
            if (n + 1 < n2 && string.charAt(n + 1) == '\n') {
                return n + 2;
            }
            return n + 1;
        }
        if (string.charAt(n) == '\n') {
            return n + 1;
        }
        throw new NumberFormatException("Expected a new line at index " + n + ", but was " + string.charAt(n));
    }

    public static final String toHexString(byte by, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.toHexStringImpl(by, hexFormat, 8);
    }

    public static /* synthetic */ String toHexString$default(byte by, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(by, hexFormat);
    }

    public static final byte hexToByte(String string, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.hexToByte(string, 0, string.length(), hexFormat);
    }

    public static /* synthetic */ byte hexToByte$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByte(string, hexFormat);
    }

    private static final byte hexToByte(String string, int n, int n2, HexFormat hexFormat) {
        return (byte)HexExtensionsKt.hexToLongImpl(string, n, n2, hexFormat, 2);
    }

    static /* synthetic */ byte hexToByte$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByte(string, n, n2, hexFormat);
    }

    public static final String toHexString(short s, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.toHexStringImpl(s, hexFormat, 16);
    }

    public static /* synthetic */ String toHexString$default(short s, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(s, hexFormat);
    }

    public static final short hexToShort(String string, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.hexToShort(string, 0, string.length(), hexFormat);
    }

    public static /* synthetic */ short hexToShort$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToShort(string, hexFormat);
    }

    private static final short hexToShort(String string, int n, int n2, HexFormat hexFormat) {
        return (short)HexExtensionsKt.hexToLongImpl(string, n, n2, hexFormat, 4);
    }

    static /* synthetic */ short hexToShort$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToShort(string, n, n2, hexFormat);
    }

    public static final String toHexString(int n, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.toHexStringImpl(n, hexFormat, 32);
    }

    public static /* synthetic */ String toHexString$default(int n, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(n, hexFormat);
    }

    public static final int hexToInt(String string, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.hexToInt(string, 0, string.length(), hexFormat);
    }

    public static /* synthetic */ int hexToInt$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToInt(string, hexFormat);
    }

    private static final int hexToInt(String string, int n, int n2, HexFormat hexFormat) {
        return (int)HexExtensionsKt.hexToLongImpl(string, n, n2, hexFormat, 8);
    }

    static /* synthetic */ int hexToInt$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToInt(string, n, n2, hexFormat);
    }

    public static final String toHexString(long l, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.toHexStringImpl(l, hexFormat, 64);
    }

    public static /* synthetic */ String toHexString$default(long l, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(l, hexFormat);
    }

    public static final long hexToLong(String string, HexFormat hexFormat) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(hexFormat, "");
        return HexExtensionsKt.hexToLong(string, 0, string.length(), hexFormat);
    }

    public static /* synthetic */ long hexToLong$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string, hexFormat);
    }

    private static final long hexToLong(String string, int n, int n2, HexFormat hexFormat) {
        return HexExtensionsKt.hexToLongImpl(string, n, n2, hexFormat, 16);
    }

    static /* synthetic */ long hexToLong$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string, n, n2, hexFormat);
    }

    private static final String toHexStringImpl(long l, HexFormat hexFormat, int n) {
        StringBuilder stringBuilder;
        boolean bl = (n & 3) == 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = hexFormat.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        String string2 = hexFormat.getNumber().getPrefix();
        String string3 = hexFormat.getNumber().getSuffix();
        int n2 = string2.length() + (n >> 2) + string3.length();
        boolean bl2 = hexFormat.getNumber().getRemoveLeadingZeros();
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string2);
        while (n > 0) {
            int n3 = (int)(l >> (n -= 4) & 0xFL);
            if (bl2 = bl2 && n3 == 0 && n > 0) continue;
            stringBuilder2.append(string.charAt(n3));
        }
        stringBuilder2.append(string3);
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "");
        return string4;
    }

    private static final long hexToLongImpl(String string, int n, int n2, HexFormat object, int n3) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n, n2, string.length());
        String string2 = ((HexFormat)object).getNumber().getPrefix();
        object = ((HexFormat)object).getNumber().getSuffix();
        if (string2.length() + ((String)object).length() >= n2 - n) {
            StringBuilder stringBuilder = new StringBuilder("Expected a hexadecimal number with prefix \"").append(string2).append("\" and suffix \"").append((String)object).append("\", but was ");
            String string3 = string;
            Intrinsics.checkNotNull(string3);
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string4, "");
            throw new NumberFormatException(stringBuilder.append(string4).toString());
        }
        n = HexExtensionsKt.checkContainsAt(string, string2, n, n2, "prefix");
        int n4 = n2 - ((String)object).length();
        HexExtensionsKt.checkContainsAt(string, (String)object, n4, n2, "suffix");
        HexExtensionsKt.checkHexLength(string, n, n4, n3, false);
        long l = 0L;
        while (n < n4) {
            l = l << 4 | (long)HexExtensionsKt.decimalFromHexDigitAt(string, n);
            ++n;
        }
        return l;
    }

    static /* synthetic */ long hexToLongImpl$default(String string, int n, int n2, HexFormat hexFormat, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = string.length();
        }
        return HexExtensionsKt.hexToLongImpl(string, n, n2, hexFormat, n3);
    }

    private static final int checkContainsAt(String string, String string2, int n, int n2, String string3) {
        int n3 = n + string2.length();
        if (n3 > n2 || !StringsKt.regionMatches(string, n, string2, 0, string2.length(), true)) {
            StringBuilder stringBuilder = new StringBuilder("Expected ").append(string3).append(" \"").append(string2).append("\" at index ").append(n).append(", but was ");
            int n4 = RangesKt.coerceAtMost(n3, n2);
            Intrinsics.checkNotNull(string);
            String string4 = string.substring(n, n4);
            Intrinsics.checkNotNullExpressionValue(string4, "");
            throw new NumberFormatException(stringBuilder.append(string4).toString());
        }
        return n3;
    }

    private static final void checkHexLength(String string, int n, int n2, int n3, boolean bl) {
        boolean bl2;
        int n4 = n2 - n;
        boolean bl3 = bl ? n4 == n3 : (bl2 = n4 <= n3);
        if (!bl3) {
            String string2 = bl ? "exactly" : "at most";
            String string3 = string;
            Intrinsics.checkNotNull(string3);
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string4, "");
            string = string4;
            throw new NumberFormatException("Expected " + string2 + ' ' + n3 + " hexadecimal digits at index " + n + ", but was " + string + " of length " + n4);
        }
    }

    private static final int decimalFromHexDigitAt(String string, int n) {
        char c = string.charAt(n);
        if (c > '\u007f' || HEX_DIGITS_TO_DECIMAL[c] < 0) {
            throw new NumberFormatException("Expected a hexadecimal digit at index " + n + ", but was " + string.charAt(n));
        }
        return HEX_DIGITS_TO_DECIMAL[c];
    }

    static {
        int n;
        char c;
        int n2;
        int n3 = 0;
        int[] nArray = new int[128];
        while (n3 < 128) {
            int n4 = n3++;
            nArray[n4] = -1;
        }
        int[] nArray2 = nArray;
        CharSequence charSequence = LOWER_CASE_HEX_DIGITS;
        int n5 = 0;
        for (n2 = 0; n2 < charSequence.length(); ++n2) {
            c = charSequence.charAt(n2);
            nArray[c] = n = n5++;
        }
        charSequence = UPPER_CASE_HEX_DIGITS;
        n5 = 0;
        for (n2 = 0; n2 < charSequence.length(); ++n2) {
            c = charSequence.charAt(n2);
            nArray[c] = n = n5++;
        }
        HEX_DIGITS_TO_DECIMAL = nArray2;
    }
}

