/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.builders.ListBuilder$Companion;
import kotlin.collections.builders.ListBuilder$Itr;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.collections.builders.SerializedCollection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 X*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00060\u0006j\u0002`\u0007:\u0002XYB\u0007\b\u0016\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBM\b\u0002\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000\u0012\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u001e\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0016\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J&\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010&\u001a\u00020\nH\u0002J\u001d\u0010'\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)J\b\u0010*\u001a\u00020\u001eH\u0002J\b\u0010+\u001a\u00020\u001eH\u0002J\b\u0010,\u001a\u00020\u001eH\u0016J\u0014\u0010-\u001a\u00020\u00112\n\u0010.\u001a\u0006\u0012\u0002\b\u00030)H\u0002J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\nH\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\nH\u0002J\u0013\u00102\u001a\u00020\u00112\b\u0010.\u001a\u0004\u0018\u000103H\u0096\u0002J\u0016\u00104\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u00020\nH\u0016J\u0015\u00107\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002J\b\u0010:\u001a\u00020\u0011H\u0016J\u000f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000<H\u0096\u0002J\u0015\u0010=\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00108J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000?H\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000?2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010@\u001a\u00020\u001eH\u0002J\u0015\u0010A\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010B\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0015\u0010C\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u00105J\u0015\u0010D\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u00105J\u0018\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\nH\u0002J\u0016\u0010H\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J.\u0010I\u001a\u00020\n2\u0006\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010J\u001a\u00020\u0011H\u0002J\u001e\u0010K\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010LJ\u001e\u0010M\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\nH\u0016J\u0015\u0010P\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030\rH\u0016\u00a2\u0006\u0002\u0010QJ'\u0010P\u001a\b\u0012\u0004\u0012\u0002HR0\r\"\u0004\b\u0001\u0010R2\f\u0010S\u001a\b\u0012\u0004\u0012\u0002HR0\rH\u0016\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u00020VH\u0016J\b\u0010W\u001a\u000203H\u0002R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006Z"}, d2={"Lkotlin/collections/builders/ListBuilder;", "E", "", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "Lkotlin/collections/AbstractMutableList;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "()V", "initialCapacity", "", "(I)V", "array", "", "offset", "length", "isReadOnly", "", "backing", "root", "([Ljava/lang/Object;IIZLkotlin/collections/builders/ListBuilder;Lkotlin/collections/builders/ListBuilder;)V", "[Ljava/lang/Object;", "isEffectivelyReadOnly", "()Z", "size", "getSize", "()I", "add", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "addAllInternal", "i", "n", "addAtInternal", "build", "", "checkForComodification", "checkIsMutable", "clear", "contentEquals", "other", "ensureCapacityInternal", "minCapacity", "ensureExtraCapacity", "equals", "", "get", "(I)Ljava/lang/Object;", "hashCode", "indexOf", "(Ljava/lang/Object;)I", "insertAtInternal", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "registerModification", "remove", "removeAll", "removeAt", "removeAtInternal", "removeRangeInternal", "rangeOffset", "rangeLength", "retainAll", "retainOrRemoveAllInternal", "retain", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "toArray", "()[Ljava/lang/Object;", "T", "destination", "([Ljava/lang/Object;)[Ljava/lang/Object;", "toString", "", "writeReplace", "Companion", "Itr", "kotlin-stdlib"})
public final class ListBuilder<E>
extends AbstractMutableList<E>
implements Serializable,
List<E>,
RandomAccess,
KMutableList {
    private static final ListBuilder$Companion Companion;
    private E[] array;
    private int offset;
    private int length;
    private boolean isReadOnly;
    private final ListBuilder<E> backing;
    private final ListBuilder<E> root;
    private static final ListBuilder Empty;

    private ListBuilder(E[] EArray, int n, int n2, boolean bl, ListBuilder<E> listBuilder, ListBuilder<E> listBuilder2) {
        this.array = EArray;
        this.offset = n;
        this.length = n2;
        this.isReadOnly = bl;
        this.backing = listBuilder;
        this.root = listBuilder2;
        if (this.backing != null) {
            this.modCount = this.backing.modCount;
        }
    }

    public ListBuilder() {
        this(10);
    }

    public ListBuilder(int n) {
        this(ListBuilderKt.arrayOfUninitializedElements(n), 0, 0, false, null, null);
    }

    public final List<E> build() {
        if (this.backing != null) {
            throw new IllegalStateException();
        }
        this.checkIsMutable();
        this.isReadOnly = true;
        if (this.length > 0) {
            return this;
        }
        return Empty;
    }

    private final Object writeReplace() {
        if (this.isEffectivelyReadOnly()) {
            return new SerializedCollection(this, 0);
        }
        throw new NotSerializableException("The list cannot be serialized while it is being built.");
    }

    @Override
    public final int getSize() {
        this.checkForComodification();
        return this.length;
    }

    @Override
    public final boolean isEmpty() {
        this.checkForComodification();
        return this.length == 0;
    }

    @Override
    public final E get(int n) {
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        return this.array[this.offset + n];
    }

    @Override
    public final E set(int n, E e) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        E e2 = this.array[this.offset + n];
        this.array[this.offset + n] = e;
        return e2;
    }

    @Override
    public final int indexOf(Object object) {
        this.checkForComodification();
        for (int i = 0; i < this.length; ++i) {
            if (!Intrinsics.areEqual(this.array[this.offset + i], object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        this.checkForComodification();
        for (int i = this.length - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual(this.array[this.offset + i], object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public final ListIterator<E> listIterator(int n) {
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        return new ListBuilder$Itr(this, n);
    }

    @Override
    public final boolean add(E e) {
        this.checkIsMutable();
        this.checkForComodification();
        ListBuilder listBuilder = this;
        listBuilder.addAtInternal(listBuilder.offset + this.length, e);
        return true;
    }

    @Override
    public final void add(int n, E e) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        ListBuilder listBuilder = this;
        listBuilder.addAtInternal(listBuilder.offset + n, e);
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        this.checkIsMutable();
        this.checkForComodification();
        int n = collection.size();
        ListBuilder listBuilder = this;
        listBuilder.addAllInternal(listBuilder.offset + this.length, collection, n);
        return n > 0;
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        int n2 = collection.size();
        ListBuilder listBuilder = this;
        listBuilder.addAllInternal(listBuilder.offset + n, collection, n2);
        return n2 > 0;
    }

    @Override
    public final void clear() {
        this.checkIsMutable();
        this.checkForComodification();
        ListBuilder listBuilder = this;
        listBuilder.removeRangeInternal(listBuilder.offset, this.length);
    }

    @Override
    public final E removeAt(int n) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        ListBuilder listBuilder = this;
        return listBuilder.removeAtInternal(listBuilder.offset + n);
    }

    @Override
    public final boolean remove(Object object) {
        this.checkIsMutable();
        this.checkForComodification();
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
        }
        return n >= 0;
    }

    @Override
    public final boolean removeAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        this.checkIsMutable();
        this.checkForComodification();
        ListBuilder listBuilder = this;
        return listBuilder.retainOrRemoveAllInternal(listBuilder.offset, this.length, collection, false) > 0;
    }

    @Override
    public final boolean retainAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        this.checkIsMutable();
        this.checkForComodification();
        ListBuilder listBuilder = this;
        return listBuilder.retainOrRemoveAllInternal(listBuilder.offset, this.length, collection, true) > 0;
    }

    @Override
    public final List<E> subList(int n, int n2) {
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(n, n2, this.length);
        ListBuilder listBuilder = this;
        ListBuilder listBuilder2 = listBuilder.root;
        if (listBuilder2 == null) {
            listBuilder2 = this;
        }
        return new ListBuilder<E>(this.array, this.offset + n, n2 - n, this.isReadOnly, listBuilder, listBuilder2);
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        this.checkForComodification();
        if (TArray.length < this.length) {
            T[] TArray2 = Arrays.copyOfRange(this.array, this.offset, this.offset + this.length, TArray.getClass());
            Intrinsics.checkNotNullExpressionValue(TArray2, "");
            return TArray2;
        }
        ArraysKt.copyInto(this.array, TArray, 0, this.offset, this.offset + this.length);
        return CollectionsKt.terminateCollectionToArray(this.length, TArray);
    }

    @Override
    public final Object[] toArray() {
        this.checkForComodification();
        E[] EArray = this.array;
        int n = this.offset;
        int n2 = this.offset + this.length;
        return ArraysKt.copyOfRange(EArray, n, n2);
    }

    @Override
    public final boolean equals(Object object) {
        this.checkForComodification();
        return object == this || object instanceof List && this.contentEquals((List)object);
    }

    @Override
    public final int hashCode() {
        this.checkForComodification();
        return ListBuilderKt.access$subarrayContentHashCode(this.array, this.offset, this.length);
    }

    @Override
    public final String toString() {
        this.checkForComodification();
        return ListBuilderKt.access$subarrayContentToString(this.array, this.offset, this.length, this);
    }

    private final void registerModification() {
        ++this.modCount;
    }

    private final void checkForComodification() {
        if (this.root != null && this.root.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private final void checkIsMutable() {
        if (this.isEffectivelyReadOnly()) {
            throw new UnsupportedOperationException();
        }
    }

    private final boolean isEffectivelyReadOnly() {
        return this.isReadOnly || this.root != null && this.root.isReadOnly;
    }

    private final void ensureExtraCapacity(int n) {
        ListBuilder listBuilder = this;
        listBuilder.ensureCapacityInternal(listBuilder.length + n);
    }

    private final void ensureCapacityInternal(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        if (n > this.array.length) {
            n = AbstractList.Companion.newCapacity$kotlin_stdlib(this.array.length, n);
            this.array = ListBuilderKt.copyOfUninitializedElements(this.array, n);
        }
    }

    private final boolean contentEquals(List<?> list) {
        return ListBuilderKt.access$subarrayContentEquals(this.array, this.offset, this.length, list);
    }

    private final void insertAtInternal(int n, int n2) {
        this.ensureExtraCapacity(n2);
        E[] EArray = this.array;
        E[] EArray2 = this.array;
        int n3 = this.offset + this.length;
        int n4 = n + n2;
        ArraysKt.copyInto(EArray, EArray2, n4, n, n3);
        this.length += n2;
    }

    private final void addAtInternal(int n, E e) {
        this.registerModification();
        if (this.backing != null) {
            super.addAtInternal(n, e);
            this.array = this.backing.array;
            n = this.length;
            this.length = n + 1;
            return;
        }
        this.insertAtInternal(n, 1);
        this.array[n] = e;
    }

    private final void addAllInternal(int n, Collection<? extends E> object, int n2) {
        this.registerModification();
        if (this.backing != null) {
            super.addAllInternal(n, (Collection<E>)object, n2);
            this.array = this.backing.array;
            this.length += n2;
            return;
        }
        this.insertAtInternal(n, n2);
        object = object.iterator();
        for (int i = 0; i < n2; ++i) {
            this.array[n + i] = object.next();
        }
    }

    private final E removeAtInternal(int n) {
        this.registerModification();
        if (this.backing != null) {
            E e = super.removeAtInternal(n);
            int n2 = this.length;
            this.length = n2 + -1;
            return e;
        }
        E e = this.array[n];
        E[] EArray = this.array;
        E[] EArray2 = this.array;
        int n3 = n + 1;
        int n4 = this.offset + this.length;
        ArraysKt.copyInto(EArray, EArray2, n, n3, n4);
        ListBuilderKt.resetAt(this.array, this.offset + this.length - 1);
        int n5 = this.length;
        this.length = n5 + -1;
        return e;
    }

    private final void removeRangeInternal(int n, int n2) {
        if (n2 > 0) {
            this.registerModification();
        }
        if (this.backing != null) {
            super.removeRangeInternal(n, n2);
        } else {
            E[] EArray = this.array;
            E[] EArray2 = this.array;
            int n3 = n + n2;
            int n4 = this.length;
            ArraysKt.copyInto(EArray, EArray2, n, n3, n4);
            ListBuilderKt.resetRange(this.array, this.length - n2, this.length);
        }
        this.length -= n2;
    }

    private final int retainOrRemoveAllInternal(int n, int n2, Collection<? extends E> collection, boolean bl) {
        int n3;
        if (this.backing != null) {
            n3 = super.retainOrRemoveAllInternal(n, n2, collection, bl);
        } else {
            int n4 = 0;
            int n5 = 0;
            while (n4 < n2) {
                if (collection.contains(this.array[n + n4]) == bl) {
                    this.array[n + n5++] = this.array[n + n4++];
                    continue;
                }
                ++n4;
            }
            int n6 = n2 - n5;
            E[] EArray = this.array;
            E[] EArray2 = this.array;
            n2 = n + n2;
            int n7 = this.length;
            ArraysKt.copyInto(EArray, EArray2, n += n5, n2, n7);
            ListBuilderKt.resetRange(this.array, this.length - n6, this.length);
            n3 = n = n6;
        }
        if (n3 > 0) {
            this.registerModification();
        }
        this.length -= n;
        return n;
    }

    public static final /* synthetic */ int access$getModCount$p$s-2084097795(ListBuilder listBuilder) {
        return listBuilder.modCount;
    }

    public static final /* synthetic */ int access$getLength$p(ListBuilder listBuilder) {
        return listBuilder.length;
    }

    public static final /* synthetic */ Object[] access$getArray$p(ListBuilder listBuilder) {
        return listBuilder.array;
    }

    public static final /* synthetic */ int access$getOffset$p(ListBuilder listBuilder) {
        return listBuilder.offset;
    }

    static {
        ListBuilder listBuilder;
        Companion = new ListBuilder$Companion(null);
        ListBuilder listBuilder2 = listBuilder = new ListBuilder(0);
        listBuilder.isReadOnly = true;
        Empty = listBuilder;
    }
}

