/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.core.JobRunShellFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.ee.jta.JTAAnnotationAwareJobRunShellFactory;
import org.quartz.ee.jta.JTAJobRunShellFactory;
import org.quartz.ee.jta.UserTransactionHelper;
import org.quartz.impl.DefaultThreadExecutor;
import org.quartz.impl.RemoteMBeanScheduler;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerDetailsSetter;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.TablePrefixAware;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.management.ManagementRESTServiceConfiguration;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.InstanceIdGenerator;
import org.quartz.spi.JobFactory;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.ThreadPool;
import org.quartz.utils.C3p0PoolingConnectionProvider;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.JNDIConnectionProvider;
import org.quartz.utils.PoolingConnectionProvider;
import org.quartz.utils.PropertiesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdSchedulerFactory
implements SchedulerFactory {
    public static final String PROPERTIES_FILE = "org.quartz.properties";
    public static final String PROP_SCHED_INSTANCE_NAME = "org.quartz.scheduler.instanceName";
    public static final String PROP_SCHED_INSTANCE_ID = "org.quartz.scheduler.instanceId";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX = "org.quartz.scheduler.instanceIdGenerator";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS = "org.quartz.scheduler.instanceIdGenerator.class";
    public static final String PROP_SCHED_THREAD_NAME = "org.quartz.scheduler.threadName";
    public static final String PROP_SCHED_BATCH_TIME_WINDOW = "org.quartz.scheduler.batchTriggerAcquisitionFireAheadTimeWindow";
    public static final String PROP_SCHED_MAX_BATCH_SIZE = "org.quartz.scheduler.batchTriggerAcquisitionMaxCount";
    public static final String PROP_SCHED_JMX_EXPORT = "org.quartz.scheduler.jmx.export";
    public static final String PROP_SCHED_JMX_OBJECT_NAME = "org.quartz.scheduler.jmx.objectName";
    public static final String PROP_SCHED_JMX_PROXY = "org.quartz.scheduler.jmx.proxy";
    public static final String PROP_SCHED_JMX_PROXY_CLASS = "org.quartz.scheduler.jmx.proxy.class";
    public static final String PROP_SCHED_RMI_EXPORT = "org.quartz.scheduler.rmi.export";
    public static final String PROP_SCHED_RMI_PROXY = "org.quartz.scheduler.rmi.proxy";
    public static final String PROP_SCHED_RMI_HOST = "org.quartz.scheduler.rmi.registryHost";
    public static final String PROP_SCHED_RMI_PORT = "org.quartz.scheduler.rmi.registryPort";
    public static final String PROP_SCHED_RMI_SERVER_PORT = "org.quartz.scheduler.rmi.serverPort";
    public static final String PROP_SCHED_RMI_CREATE_REGISTRY = "org.quartz.scheduler.rmi.createRegistry";
    public static final String PROP_SCHED_RMI_BIND_NAME = "org.quartz.scheduler.rmi.bindName";
    public static final String PROP_SCHED_WRAP_JOB_IN_USER_TX = "org.quartz.scheduler.wrapJobExecutionInUserTransaction";
    public static final String PROP_SCHED_USER_TX_URL = "org.quartz.scheduler.userTransactionURL";
    public static final String PROP_SCHED_IDLE_WAIT_TIME = "org.quartz.scheduler.idleWaitTime";
    public static final String PROP_SCHED_DB_FAILURE_RETRY_INTERVAL = "org.quartz.scheduler.dbFailureRetryInterval";
    public static final String PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON = "org.quartz.scheduler.makeSchedulerThreadDaemon";
    public static final String PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD = "org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer";
    public static final String PROP_SCHED_CLASS_LOAD_HELPER_CLASS = "org.quartz.scheduler.classLoadHelper.class";
    public static final String PROP_SCHED_JOB_FACTORY_CLASS = "org.quartz.scheduler.jobFactory.class";
    public static final String PROP_SCHED_JOB_FACTORY_PREFIX = "org.quartz.scheduler.jobFactory";
    public static final String PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN = "org.quartz.scheduler.interruptJobsOnShutdown";
    public static final String PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN_WITH_WAIT = "org.quartz.scheduler.interruptJobsOnShutdownWithWait";
    public static final String PROP_SCHED_CONTEXT_PREFIX = "org.quartz.context.key";
    public static final String PROP_THREAD_POOL_PREFIX = "org.quartz.threadPool";
    public static final String PROP_THREAD_POOL_CLASS = "org.quartz.threadPool.class";
    public static final String PROP_JOB_STORE_PREFIX = "org.quartz.jobStore";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_PREFIX = "org.quartz.jobStore.lockHandler";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_CLASS = "org.quartz.jobStore.lockHandler.class";
    public static final String PROP_TABLE_PREFIX = "tablePrefix";
    public static final String PROP_SCHED_NAME = "schedName";
    public static final String PROP_JOB_STORE_CLASS = "org.quartz.jobStore.class";
    public static final String PROP_JOB_STORE_USE_PROP = "org.quartz.jobStore.useProperties";
    public static final String PROP_DATASOURCE_PREFIX = "org.quartz.dataSource";
    public static final String PROP_CONNECTION_PROVIDER_CLASS = "connectionProvider.class";
    @Deprecated
    public static final String PROP_DATASOURCE_DRIVER = "driver";
    @Deprecated
    public static final String PROP_DATASOURCE_URL = "URL";
    @Deprecated
    public static final String PROP_DATASOURCE_USER = "user";
    @Deprecated
    public static final String PROP_DATASOURCE_PASSWORD = "password";
    @Deprecated
    public static final String PROP_DATASOURCE_MAX_CONNECTIONS = "maxConnections";
    @Deprecated
    public static final String PROP_DATASOURCE_VALIDATION_QUERY = "validationQuery";
    public static final String PROP_DATASOURCE_JNDI_URL = "jndiURL";
    public static final String PROP_DATASOURCE_JNDI_ALWAYS_LOOKUP = "jndiAlwaysLookup";
    public static final String PROP_DATASOURCE_JNDI_INITIAL = "java.naming.factory.initial";
    public static final String PROP_DATASOURCE_JNDI_PROVDER = "java.naming.provider.url";
    public static final String PROP_DATASOURCE_JNDI_PRINCIPAL = "java.naming.security.principal";
    public static final String PROP_DATASOURCE_JNDI_CREDENTIALS = "java.naming.security.credentials";
    public static final String PROP_PLUGIN_PREFIX = "org.quartz.plugin";
    public static final String PROP_PLUGIN_CLASS = "class";
    public static final String PROP_JOB_LISTENER_PREFIX = "org.quartz.jobListener";
    public static final String PROP_TRIGGER_LISTENER_PREFIX = "org.quartz.triggerListener";
    public static final String PROP_LISTENER_CLASS = "class";
    public static final String DEFAULT_INSTANCE_ID = "NON_CLUSTERED";
    public static final String AUTO_GENERATE_INSTANCE_ID = "AUTO";
    public static final String PROP_THREAD_EXECUTOR = "org.quartz.threadExecutor";
    public static final String PROP_THREAD_EXECUTOR_CLASS = "org.quartz.threadExecutor.class";
    public static final String SYSTEM_PROPERTY_AS_INSTANCE_ID = "SYS_PROP";
    public static final String MANAGEMENT_REST_SERVICE_ENABLED = "org.quartz.managementRESTService.enabled";
    public static final String MANAGEMENT_REST_SERVICE_HOST_PORT = "org.quartz.managementRESTService.bind";
    private SchedulerException initException = null;
    private String propSrc = null;
    private PropertiesParser cfg;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public StdSchedulerFactory() {
    }

    public StdSchedulerFactory(Properties properties) {
        this.initialize(properties);
    }

    public StdSchedulerFactory(String string) {
        this.initialize(string);
    }

    public Logger getLog() {
        return this.log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() {
        Properties properties;
        block22: {
            if (this.cfg != null) {
                return;
            }
            if (this.initException != null) {
                throw this.initException;
            }
            String string = System.getProperty(PROPERTIES_FILE);
            String string2 = string != null ? string : "quartz.properties";
            Object object = new File(string2);
            properties = new Properties();
            InputStream inputStream = null;
            try {
                if (((File)object).exists()) {
                    try {
                        this.propSrc = string != null ? "specified file: '" + string + "'" : "default file in current working dir: 'quartz.properties'";
                        inputStream = new BufferedInputStream(new FileInputStream(string2));
                        properties.load(inputStream);
                    }
                    catch (IOException iOException) {
                        this.initException = new SchedulerException("Properties file: '" + string2 + "' could not be read.", iOException);
                        throw this.initException;
                    }
                }
                if (string != null) {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                    if (inputStream == null) {
                        this.initException = new SchedulerException("Properties file: '" + string + "' could not be found.");
                        throw this.initException;
                    }
                    this.propSrc = "specified file: '" + string + "' in the class resource path.";
                    inputStream = new BufferedInputStream(inputStream);
                    try {
                        properties.load(inputStream);
                    }
                    catch (IOException iOException) {
                        this.initException = new SchedulerException("Properties file: '" + string + "' could not be read.", iOException);
                        throw this.initException;
                    }
                }
                this.propSrc = "default resource file in Quartz package: 'quartz.properties'";
                object = this.getClass().getClassLoader();
                if (object == null) {
                    object = this.findClassloader();
                }
                if (object == null) {
                    throw new SchedulerConfigException("Unable to find a class loader on the current thread or class.");
                }
                inputStream = ((ClassLoader)object).getResourceAsStream("quartz.properties");
                if (inputStream == null) {
                    inputStream = ((ClassLoader)object).getResourceAsStream("/quartz.properties");
                }
                if (inputStream == null) {
                    inputStream = ((ClassLoader)object).getResourceAsStream("org/quartz/quartz.properties");
                }
                if (inputStream == null) {
                    this.initException = new SchedulerException("Default quartz.properties not found in class path");
                    throw this.initException;
                }
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    this.initException = new SchedulerException("Resource properties file: 'org/quartz/quartz.properties' could not be read from the classpath.", iOException);
                    throw this.initException;
                }
                if (inputStream == null) break block22;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.initialize(StdSchedulerFactory.overrideWithSysProps(properties, this.getLog()));
    }

    static Properties overrideWithSysProps(Properties properties, Logger object) {
        Properties properties2 = null;
        try {
            properties2 = System.getProperties();
        }
        catch (AccessControlException accessControlException) {
            object.warn("Skipping overriding quartz properties with System properties during initialization because of an AccessControlException.  This is likely due to not having read/write access for java.util.PropertyPermission as required by java.lang.System.getProperties().  To resolve this warning, either add this permission to your policy file or use a non-default version of initialize().", (Throwable)accessControlException);
        }
        if (properties2 != null) {
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                Object object2 = properties2.get(object);
                if (!(object instanceof String) || !(object2 instanceof String)) continue;
                properties.setProperty((String)object, (String)object2);
            }
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(String string) {
        if (this.cfg != null) {
            return;
        }
        if (this.initException != null) {
            throw this.initException;
        }
        Properties properties = new Properties();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        try {
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
                this.propSrc = "the specified file : '" + string + "' from the class resource path.";
            } else {
                inputStream = new BufferedInputStream(new FileInputStream(string));
                this.propSrc = "the specified file : '" + string + "'";
            }
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            try {
                this.initException = new SchedulerException("Properties file: '" + string + "' could not be read.", iOException);
                throw this.initException;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        this.initialize(properties);
    }

    public void initialize(InputStream inputStream) {
        if (this.cfg != null) {
            return;
        }
        if (this.initException != null) {
            throw this.initException;
        }
        Properties properties = new Properties();
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                this.propSrc = "an externally opened InputStream.";
            }
            catch (IOException iOException) {
                this.initException = new SchedulerException("Error loading property data from InputStream", iOException);
                throw this.initException;
            }
        } else {
            this.initException = new SchedulerException("Error loading property data from InputStream - InputStream is null.");
            throw this.initException;
        }
        this.initialize(properties);
    }

    public void initialize(Properties properties) {
        if (this.propSrc == null) {
            this.propSrc = "an externally provided properties instance.";
        }
        this.cfg = new PropertiesParser(properties);
    }

    private Scheduler instantiate() {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        ClassLoadHelper classLoadHelper;
        if (this.cfg == null) {
            this.initialize();
        }
        if (this.initException != null) {
            throw this.initException;
        }
        QuartzScheduler quartzScheduler = null;
        DBConnectionManager dBConnectionManager = null;
        Object object9 = null;
        String string = null;
        boolean bl = false;
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        String string2 = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "QuartzScheduler");
        String string3 = this.cfg.getStringProperty(PROP_SCHED_THREAD_NAME, string2 + "_QuartzSchedulerThread");
        String string4 = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_ID, DEFAULT_INSTANCE_ID);
        if (string4.equals(AUTO_GENERATE_INSTANCE_ID)) {
            bl = true;
            object9 = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS, "org.quartz.simpl.SimpleInstanceIdGenerator");
        } else if (string4.equals(SYSTEM_PROPERTY_AS_INSTANCE_ID)) {
            bl = true;
            object9 = "org.quartz.simpl.SystemPropertyInstanceIdGenerator";
        }
        string = this.cfg.getStringProperty(PROP_SCHED_USER_TX_URL, string);
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        Object object10 = this.cfg.getStringProperty(PROP_SCHED_CLASS_LOAD_HELPER_CLASS, "org.quartz.simpl.CascadingClassLoadHelper");
        boolean bl2 = this.cfg.getBooleanProperty(PROP_SCHED_WRAP_JOB_IN_USER_TX, false);
        Object object11 = this.cfg.getStringProperty(PROP_SCHED_JOB_FACTORY_CLASS, null);
        long l = this.cfg.getLongProperty(PROP_SCHED_IDLE_WAIT_TIME, -1L);
        if (l > -1L && l < 1000L) {
            throw new SchedulerException("org.quartz.scheduler.idleWaitTime of less than 1000ms is not legal.");
        }
        long l2 = this.cfg.getLongProperty(PROP_SCHED_DB_FAILURE_RETRY_INTERVAL, 15000L);
        if (l2 < 0L) {
            throw new SchedulerException("org.quartz.scheduler.dbFailureRetryInterval of less than 0 ms is not legal.");
        }
        boolean bl3 = this.cfg.getBooleanProperty(PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON);
        boolean bl4 = this.cfg.getBooleanProperty(PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD);
        long l3 = this.cfg.getLongProperty(PROP_SCHED_BATCH_TIME_WINDOW, 0L);
        int n2 = this.cfg.getIntProperty(PROP_SCHED_MAX_BATCH_SIZE, 1);
        boolean bl5 = this.cfg.getBooleanProperty(PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN, false);
        boolean bl6 = this.cfg.getBooleanProperty(PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN_WITH_WAIT, false);
        boolean bl7 = this.cfg.getBooleanProperty(PROP_SCHED_JMX_EXPORT);
        String string5 = this.cfg.getStringProperty(PROP_SCHED_JMX_OBJECT_NAME);
        boolean bl8 = this.cfg.getBooleanProperty(PROP_SCHED_JMX_PROXY);
        Object object12 = this.cfg.getStringProperty(PROP_SCHED_JMX_PROXY_CLASS);
        boolean bl9 = this.cfg.getBooleanProperty(PROP_SCHED_RMI_EXPORT, false);
        boolean bl10 = this.cfg.getBooleanProperty(PROP_SCHED_RMI_PROXY, false);
        String string6 = this.cfg.getStringProperty(PROP_SCHED_RMI_HOST, "localhost");
        int n3 = this.cfg.getIntProperty(PROP_SCHED_RMI_PORT, 1099);
        int n4 = this.cfg.getIntProperty(PROP_SCHED_RMI_SERVER_PORT, -1);
        String string7 = this.cfg.getStringProperty(PROP_SCHED_RMI_CREATE_REGISTRY, "never");
        String string8 = this.cfg.getStringProperty(PROP_SCHED_RMI_BIND_NAME);
        if (bl8 && bl10) {
            throw new SchedulerConfigException("Cannot proxy both RMI and JMX.");
        }
        boolean bl11 = this.cfg.getBooleanProperty(MANAGEMENT_REST_SERVICE_ENABLED, false);
        String string9 = this.cfg.getStringProperty(MANAGEMENT_REST_SERVICE_HOST_PORT, "0.0.0.0:9889");
        Properties properties = this.cfg.getPropertyGroup(PROP_SCHED_CONTEXT_PREFIX, true);
        if (bl10) {
            if (bl) {
                string4 = DEFAULT_INSTANCE_ID;
            }
            String string10 = string8 == null ? QuartzSchedulerResources.getUniqueIdentifier(string2, string4) : string8;
            RemoteScheduler remoteScheduler = new RemoteScheduler(string10, string6, n3);
            schedulerRepository.bind(remoteScheduler);
            return remoteScheduler;
        }
        try {
            classLoadHelper = (ClassLoadHelper)this.loadClass((String)object10).newInstance();
        }
        catch (Exception exception) {
            throw new SchedulerConfigException("Unable to instantiate class load helper class: " + exception.getMessage(), exception);
        }
        classLoadHelper.initialize();
        if (bl8) {
            RemoteMBeanScheduler remoteMBeanScheduler;
            if (bl) {
                string4 = DEFAULT_INSTANCE_ID;
            }
            if (object12 == null) {
                throw new SchedulerConfigException("No JMX Proxy Scheduler class provided");
            }
            try {
                remoteMBeanScheduler = (RemoteMBeanScheduler)classLoadHelper.loadClass((String)object12).newInstance();
            }
            catch (Exception exception) {
                throw new SchedulerConfigException("Unable to instantiate RemoteMBeanScheduler class.", exception);
            }
            if (string5 == null) {
                string5 = QuartzSchedulerResources.generateJMXObjectName(string2, string4);
            }
            remoteMBeanScheduler.setSchedulerObjectName(string5);
            Properties properties2 = this.cfg.getPropertyGroup(PROP_SCHED_JMX_PROXY, true);
            try {
                this.setBeanProps(remoteMBeanScheduler, properties2);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("RemoteMBeanScheduler class '" + (String)object12 + "' props could not be configured.", exception);
                throw this.initException;
            }
            remoteMBeanScheduler.initialize();
            schedulerRepository.bind(remoteMBeanScheduler);
            return remoteMBeanScheduler;
        }
        JobFactory jobFactory = null;
        if (object11 != null) {
            try {
                jobFactory = (JobFactory)classLoadHelper.loadClass((String)object11).newInstance();
            }
            catch (Exception exception) {
                throw new SchedulerConfigException("Unable to instantiate JobFactory class: " + exception.getMessage(), exception);
            }
            Properties properties3 = this.cfg.getPropertyGroup(PROP_SCHED_JOB_FACTORY_PREFIX, true);
            try {
                this.setBeanProps(jobFactory, properties3);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobFactory class '" + (String)object11 + "' props could not be configured.", exception);
                throw this.initException;
            }
        }
        InstanceIdGenerator instanceIdGenerator = null;
        if (object9 != null) {
            try {
                instanceIdGenerator = (InstanceIdGenerator)classLoadHelper.loadClass((String)object9).newInstance();
            }
            catch (Exception exception) {
                throw new SchedulerConfigException("Unable to instantiate InstanceIdGenerator class: " + exception.getMessage(), exception);
            }
            Properties properties4 = this.cfg.getPropertyGroup(PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX, true);
            try {
                this.setBeanProps(instanceIdGenerator, properties4);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("InstanceIdGenerator class '" + (String)object9 + "' props could not be configured.", exception);
                throw this.initException;
            }
        }
        if ((object11 = this.cfg.getStringProperty(PROP_THREAD_POOL_CLASS, SimpleThreadPool.class.getName())) == null) {
            this.initException = new SchedulerException("ThreadPool class not specified. ");
            throw this.initException;
        }
        try {
            object10 = (ThreadPool)classLoadHelper.loadClass((String)object11).newInstance();
        }
        catch (Exception exception) {
            this.initException = new SchedulerException("ThreadPool class '" + (String)object11 + "' could not be instantiated.", exception);
            throw this.initException;
        }
        Object object13 = this.cfg.getPropertyGroup(PROP_THREAD_POOL_PREFIX, true);
        try {
            this.setBeanProps(object10, (Properties)object13);
        }
        catch (Exception exception) {
            this.initException = new SchedulerException("ThreadPool class '" + (String)object11 + "' props could not be configured.", exception);
            throw this.initException;
        }
        object12 = this.cfg.getStringProperty(PROP_JOB_STORE_CLASS, RAMJobStore.class.getName());
        if (object12 == null) {
            this.initException = new SchedulerException("JobStore class not specified. ");
            throw this.initException;
        }
        try {
            object9 = (JobStore)classLoadHelper.loadClass((String)object12).newInstance();
        }
        catch (Exception exception) {
            this.initException = new SchedulerException("JobStore class '" + (String)object12 + "' could not be instantiated.", exception);
            throw this.initException;
        }
        SchedulerDetailsSetter.setDetails(object9, string2, string4);
        object13 = this.cfg.getPropertyGroup(PROP_JOB_STORE_PREFIX, true, new String[]{PROP_JOB_STORE_LOCK_HANDLER_PREFIX});
        try {
            this.setBeanProps(object9, (Properties)object13);
        }
        catch (Exception exception) {
            this.initException = new SchedulerException("JobStore class '" + (String)object12 + "' props could not be configured.", exception);
            throw this.initException;
        }
        if (object9 instanceof JobStoreSupport && (object11 = this.cfg.getStringProperty(PROP_JOB_STORE_LOCK_HANDLER_CLASS)) != null) {
            try {
                object12 = (Semaphore)classLoadHelper.loadClass((String)object11).newInstance();
                object13 = this.cfg.getPropertyGroup(PROP_JOB_STORE_LOCK_HANDLER_PREFIX, true);
                if (object12 instanceof TablePrefixAware) {
                    ((Properties)object13).setProperty(PROP_TABLE_PREFIX, ((JobStoreSupport)object9).getTablePrefix());
                    ((Properties)object13).setProperty(PROP_SCHED_NAME, string2);
                }
                try {
                    this.setBeanProps(object12, (Properties)object13);
                }
                catch (Exception exception) {
                    this.initException = new SchedulerException("JobStore LockHandler class '" + (String)object11 + "' props could not be configured.", exception);
                    throw this.initException;
                }
                ((JobStoreSupport)object9).setLockHandler((Semaphore)object12);
                this.getLog().info("Using custom data access locking (synchronization): " + (String)object11);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobStore LockHandler class '" + (String)object11 + "' could not be instantiated.", exception);
                throw this.initException;
            }
        }
        object11 = this.cfg.getPropertyGroups(PROP_DATASOURCE_PREFIX);
        for (int i = 0; i < ((String[])object11).length; ++i) {
            object8 = new PropertiesParser(this.cfg.getPropertyGroup("org.quartz.dataSource." + object11[i], true));
            object13 = ((PropertiesParser)object8).getStringProperty(PROP_CONNECTION_PROVIDER_CLASS, null);
            if (object13 != null) {
                try {
                    object7 = (ConnectionProvider)classLoadHelper.loadClass((String)object13).newInstance();
                }
                catch (Exception exception) {
                    this.initException = new SchedulerException("ConnectionProvider class '" + (String)object13 + "' could not be instantiated.", exception);
                    throw this.initException;
                }
                try {
                    ((PropertiesParser)object8).getUnderlyingProperties().remove(PROP_CONNECTION_PROVIDER_CLASS);
                    if (object7 instanceof PoolingConnectionProvider) {
                        this.populateProviderWithExtraProps((PoolingConnectionProvider)object7, ((PropertiesParser)object8).getUnderlyingProperties());
                    } else {
                        this.setBeanProps(object7, ((PropertiesParser)object8).getUnderlyingProperties());
                    }
                    object7.initialize();
                }
                catch (Exception exception) {
                    this.initException = new SchedulerException("ConnectionProvider class '" + (String)object13 + "' props could not be configured.", exception);
                    throw this.initException;
                }
                dBConnectionManager = DBConnectionManager.getInstance();
                dBConnectionManager.addConnectionProvider(object11[i], (ConnectionProvider)object7);
                continue;
            }
            object7 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_URL, null);
            if (object7 != null) {
                boolean bl12 = ((PropertiesParser)object8).getBooleanProperty(PROP_DATASOURCE_JNDI_ALWAYS_LOOKUP);
                object6 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_INITIAL);
                object5 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_PROVDER);
                object4 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_PRINCIPAL);
                object3 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_CREDENTIALS);
                object2 = null;
                if (object6 != null || object5 != null || object4 != null || object3 != null) {
                    object2 = new Properties();
                    if (object6 != null) {
                        ((Properties)object2).put(PROP_DATASOURCE_JNDI_INITIAL, object6);
                    }
                    if (object5 != null) {
                        ((Properties)object2).put(PROP_DATASOURCE_JNDI_PROVDER, object5);
                    }
                    if (object4 != null) {
                        ((Properties)object2).put(PROP_DATASOURCE_JNDI_PRINCIPAL, object4);
                    }
                    if (object3 != null) {
                        ((Properties)object2).put(PROP_DATASOURCE_JNDI_CREDENTIALS, object3);
                    }
                }
                object7 = new JNDIConnectionProvider((String)object7, (Properties)object2, bl12);
                dBConnectionManager = DBConnectionManager.getInstance();
                dBConnectionManager.addConnectionProvider(object11[i], (ConnectionProvider)object7);
                continue;
            }
            String string11 = ((PropertiesParser)object8).getStringProperty("provider");
            object6 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_DRIVER);
            object5 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_URL);
            if (object6 == null) {
                this.initException = new SchedulerException("Driver not specified for DataSource: " + object11[i]);
                throw this.initException;
            }
            if (object5 == null) {
                this.initException = new SchedulerException("DB URL not specified for DataSource: " + object11[i]);
                throw this.initException;
            }
            object13 = string11 != null && string11.equals("hikaricp") ? "org.quartz.utils.HikariCpPoolingConnectionProvider" : "org.quartz.utils.C3p0PoolingConnectionProvider";
            this.log.info("Using ConnectionProvider class '" + (String)object13 + "' for data source '" + object11[i] + "'");
            try {
                try {
                    object3 = classLoadHelper.loadClass((String)object13).getConstructor(Properties.class);
                    object4 = (ConnectionProvider)((Constructor)object3).newInstance(((PropertiesParser)object8).getUnderlyingProperties());
                }
                catch (Exception exception) {
                    this.initException = new SchedulerException("ConnectionProvider class '" + (String)object13 + "' could not be instantiated.", exception);
                    throw this.initException;
                }
                dBConnectionManager = DBConnectionManager.getInstance();
                dBConnectionManager.addConnectionProvider(object11[i], (ConnectionProvider)object4);
                this.populateProviderWithExtraProps((PoolingConnectionProvider)object4, ((PropertiesParser)object8).getUnderlyingProperties());
                continue;
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("Could not initialize DataSource: " + object11[i], exception);
                throw this.initException;
            }
        }
        String[] stringArray = this.cfg.getPropertyGroups(PROP_PLUGIN_PREFIX);
        object8 = new SchedulerPlugin[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            object7 = this.cfg.getPropertyGroup("org.quartz.plugin." + stringArray[i], true);
            String string12 = ((Properties)object7).getProperty("class", null);
            if (string12 == null) {
                this.initException = new SchedulerException("SchedulerPlugin class not specified for plugin '" + stringArray[i] + "'");
                throw this.initException;
            }
            try {
                object6 = (SchedulerPlugin)classLoadHelper.loadClass(string12).newInstance();
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("SchedulerPlugin class '" + string12 + "' could not be instantiated.", exception);
                throw this.initException;
            }
            try {
                this.setBeanProps(object6, (Properties)object7);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobStore SchedulerPlugin '" + string12 + "' props could not be configured.", exception);
                throw this.initException;
            }
            object8[i] = object6;
        }
        Object object14 = new Class[]{String.class};
        object7 = this.cfg.getPropertyGroups(PROP_JOB_LISTENER_PREFIX);
        JobListener[] jobListenerArray = new JobListener[((String[])object7).length];
        for (int i = 0; i < ((String[])object7).length; ++i) {
            object5 = this.cfg.getPropertyGroup("org.quartz.jobListener." + object7[i], true);
            object4 = object5.getProperty("class", null);
            if (object4 == null) {
                this.initException = new SchedulerException("JobListener class not specified for listener '" + (String)object7[i] + "'");
                throw this.initException;
            }
            try {
                object3 = (JobListener)classLoadHelper.loadClass((String)object4).newInstance();
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobListener class '" + (String)object4 + "' could not be instantiated.", exception);
                throw this.initException;
            }
            try {
                object2 = null;
                try {
                    object2 = object3.getClass().getMethod("setName", (Class<?>)object14);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (object2 != null) {
                    ((Method)object2).invoke(object3, object7[i]);
                }
                this.setBeanProps(object3, (Properties)object5);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobListener '" + (String)object4 + "' props could not be configured.", exception);
                throw this.initException;
            }
            jobListenerArray[i] = object3;
        }
        String[] stringArray2 = this.cfg.getPropertyGroups(PROP_TRIGGER_LISTENER_PREFIX);
        object5 = new TriggerListener[stringArray2.length];
        for (n = 0; n < stringArray2.length; ++n) {
            object3 = this.cfg.getPropertyGroup("org.quartz.triggerListener." + stringArray2[n], true);
            object2 = ((Properties)object3).getProperty("class", null);
            if (object2 == null) {
                this.initException = new SchedulerException("TriggerListener class not specified for listener '" + stringArray2[n] + "'");
                throw this.initException;
            }
            try {
                object7 = (TriggerListener)classLoadHelper.loadClass((String)object2).newInstance();
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("TriggerListener class '" + (String)object2 + "' could not be instantiated.", exception);
                throw this.initException;
            }
            try {
                object = null;
                try {
                    object = object7.getClass().getMethod("setName", (Class<?>)object14);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (object != null) {
                    ((Method)object).invoke(object7, stringArray2[n]);
                }
                this.setBeanProps(object7, (Properties)object3);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("TriggerListener '" + (String)object2 + "' props could not be configured.", exception);
                throw this.initException;
            }
            object5[n] = object7;
        }
        n = 0;
        boolean bl13 = false;
        object2 = this.cfg.getStringProperty(PROP_THREAD_EXECUTOR_CLASS);
        if (object2 != null) {
            object14 = this.cfg.getPropertyGroup(PROP_THREAD_EXECUTOR, true);
            try {
                object11 = (ThreadExecutor)classLoadHelper.loadClass((String)object2).newInstance();
                this.log.info("Using custom implementation for ThreadExecutor: " + (String)object2);
                this.setBeanProps(object11, (Properties)object14);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("ThreadExecutor class '" + (String)object2 + "' could not be instantiated.", exception);
                throw this.initException;
            }
        } else {
            this.log.info("Using default implementation for ThreadExecutor");
            object11 = new DefaultThreadExecutor();
        }
        try {
            int n5;
            if (string != null) {
                UserTransactionHelper.setUserTxLocation(string);
            }
            object7 = bl2 ? new JTAJobRunShellFactory() : new JTAAnnotationAwareJobRunShellFactory();
            if (bl) {
                try {
                    string4 = DEFAULT_INSTANCE_ID;
                    if (object9.isClustered()) {
                        string4 = instanceIdGenerator.generateInstanceId();
                    }
                }
                catch (Exception exception) {
                    this.getLog().error("Couldn't generate instance Id!", (Throwable)exception);
                    throw new IllegalStateException("Cannot run without an instance id.");
                }
            }
            if (object9.getClass().getName().startsWith("org.terracotta.quartz")) {
                try {
                    object = (String)object9.getClass().getMethod("getUUID", new Class[0]).invoke(object9, new Object[0]);
                    if (string4.equals(DEFAULT_INSTANCE_ID)) {
                        string4 = "TERRACOTTA_CLUSTERED,node=" + (String)object;
                        if (string5 == null) {
                            string5 = QuartzSchedulerResources.generateJMXObjectName(string2, string4);
                        }
                    } else if (string5 == null) {
                        string5 = QuartzSchedulerResources.generateJMXObjectName(string2, string4 + ",node=" + (String)object);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Problem obtaining node id from TerracottaJobStore.", exception);
                }
                if (null == this.cfg.getStringProperty(PROP_SCHED_JMX_EXPORT)) {
                    bl7 = true;
                }
            }
            if (object9 instanceof JobStoreSupport) {
                object = (JobStoreSupport)object9;
                ((JobStoreSupport)object).setDbRetryInterval(l2);
                if (bl4) {
                    ((JobStoreSupport)object).setThreadsInheritInitializersClassLoadContext(bl4);
                }
                ((JobStoreSupport)object).setThreadExecutor((ThreadExecutor)object11);
            }
            object = new QuartzSchedulerResources();
            ((QuartzSchedulerResources)object).setName(string2);
            ((QuartzSchedulerResources)object).setThreadName(string3);
            ((QuartzSchedulerResources)object).setInstanceId(string4);
            ((QuartzSchedulerResources)object).setJobRunShellFactory((JobRunShellFactory)object7);
            ((QuartzSchedulerResources)object).setMakeSchedulerThreadDaemon(bl3);
            ((QuartzSchedulerResources)object).setThreadsInheritInitializersClassLoadContext(bl4);
            ((QuartzSchedulerResources)object).setBatchTimeWindow(l3);
            ((QuartzSchedulerResources)object).setMaxBatchSize(n2);
            ((QuartzSchedulerResources)object).setInterruptJobsOnShutdown(bl5);
            ((QuartzSchedulerResources)object).setInterruptJobsOnShutdownWithWait(bl6);
            ((QuartzSchedulerResources)object).setJMXExport(bl7);
            ((QuartzSchedulerResources)object).setJMXObjectName(string5);
            if (bl11) {
                object14 = new ManagementRESTServiceConfiguration();
                ((ManagementRESTServiceConfiguration)object14).setBind(string9);
                ((ManagementRESTServiceConfiguration)object14).setEnabled(bl11);
                ((QuartzSchedulerResources)object).setManagementRESTServiceConfiguration((ManagementRESTServiceConfiguration)object14);
            }
            if (bl9) {
                ((QuartzSchedulerResources)object).setRMIRegistryHost(string6);
                ((QuartzSchedulerResources)object).setRMIRegistryPort(n3);
                ((QuartzSchedulerResources)object).setRMIServerPort(n4);
                ((QuartzSchedulerResources)object).setRMICreateRegistryStrategy(string7);
                ((QuartzSchedulerResources)object).setRMIBindName(string8);
            }
            SchedulerDetailsSetter.setDetails(object10, string2, string4);
            ((QuartzSchedulerResources)object).setThreadExecutor((ThreadExecutor)object11);
            object11.initialize();
            ((QuartzSchedulerResources)object).setThreadPool((ThreadPool)object10);
            if (object10 instanceof SimpleThreadPool && bl4) {
                ((SimpleThreadPool)object10).setThreadsInheritContextClassLoaderOfInitializingThread(bl4);
            }
            object10.initialize();
            n = 1;
            ((QuartzSchedulerResources)object).setJobStore((JobStore)object9);
            for (int i = 0; i < ((Object)object8).length; ++i) {
                ((QuartzSchedulerResources)object).addSchedulerPlugin((SchedulerPlugin)object8[i]);
            }
            quartzScheduler = new QuartzScheduler((QuartzSchedulerResources)object, l, l2);
            bl13 = true;
            Scheduler scheduler = this.instantiate((QuartzSchedulerResources)object, quartzScheduler);
            if (jobFactory != null) {
                quartzScheduler.setJobFactory(jobFactory);
            }
            for (n5 = 0; n5 < ((Object)object8).length; ++n5) {
                object8[n5].initialize(stringArray[n5], scheduler, classLoadHelper);
            }
            for (n5 = 0; n5 < jobListenerArray.length; ++n5) {
                quartzScheduler.getListenerManager().addJobListener(jobListenerArray[n5], (Matcher<JobKey>)EverythingMatcher.allJobs());
            }
            for (n5 = 0; n5 < ((TriggerListener[])object5).length; ++n5) {
                quartzScheduler.getListenerManager().addTriggerListener(object5[n5], (Matcher<TriggerKey>)EverythingMatcher.allTriggers());
            }
            for (Object object15 : properties.keySet()) {
                String string13 = properties.getProperty((String)object15);
                scheduler.getContext().put((String)object15, string13);
            }
            object9.setInstanceId(string4);
            object9.setInstanceName(string2);
            object9.setThreadPoolSize(object10.getPoolSize());
            object9.initialize(classLoadHelper, quartzScheduler.getSchedulerSignaler());
            object7.initialize(scheduler);
            quartzScheduler.initialize();
            this.getLog().info("Quartz scheduler '" + scheduler.getSchedulerName() + "' initialized from " + this.propSrc);
            this.getLog().info("Quartz scheduler version: " + quartzScheduler.getVersion());
            quartzScheduler.addNoGCObject(schedulerRepository);
            if (dBConnectionManager != null) {
                quartzScheduler.addNoGCObject(dBConnectionManager);
            }
            schedulerRepository.bind(scheduler);
            return scheduler;
        }
        catch (SchedulerException schedulerException) {
            this.shutdownFromInstantiateException((ThreadPool)object10, quartzScheduler, n != 0, bl13);
            throw schedulerException;
        }
        catch (RuntimeException runtimeException) {
            this.shutdownFromInstantiateException((ThreadPool)object10, quartzScheduler, n != 0, bl13);
            throw runtimeException;
        }
        catch (Error error) {
            this.shutdownFromInstantiateException((ThreadPool)object10, quartzScheduler, n != 0, bl13);
            throw error;
        }
    }

    private void populateProviderWithExtraProps(PoolingConnectionProvider poolingConnectionProvider, Properties properties) {
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        properties2.remove(PROP_DATASOURCE_DRIVER);
        properties2.remove(PROP_DATASOURCE_URL);
        properties2.remove(PROP_DATASOURCE_USER);
        properties2.remove(PROP_DATASOURCE_PASSWORD);
        properties2.remove(PROP_DATASOURCE_MAX_CONNECTIONS);
        properties2.remove(PROP_DATASOURCE_VALIDATION_QUERY);
        properties2.remove("provider");
        if (poolingConnectionProvider instanceof C3p0PoolingConnectionProvider) {
            properties2.remove("maxCachedStatementsPerConnection");
            properties2.remove("validateOnCheckout");
            properties2.remove("idleConnectionValidationSeconds");
            properties2.remove("maxIdleTime");
        }
        this.setBeanProps(poolingConnectionProvider.getDataSource(), properties2);
    }

    private void shutdownFromInstantiateException(ThreadPool threadPool, QuartzScheduler quartzScheduler, boolean bl, boolean bl2) {
        try {
            if (!bl2) {
                if (bl) {
                    threadPool.shutdown(false);
                }
                return;
            }
            quartzScheduler.shutdown(false);
        }
        catch (Exception exception) {
            this.getLog().error("Got another exception while shutting down after instantiation exception", (Throwable)exception);
        }
    }

    protected Scheduler instantiate(QuartzSchedulerResources object, QuartzScheduler quartzScheduler) {
        object = new StdScheduler(quartzScheduler);
        return object;
    }

    private void setBeanProps(Object object, Properties object2) {
        ((Properties)object2).remove("class");
        ((Properties)object2).remove("provider");
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass());
        propertyDescriptorArray = propertyDescriptorArray.getPropertyDescriptors();
        PropertiesParser propertiesParser = new PropertiesParser((Properties)object2);
        object2 = ((Properties)object2).keys();
        while (object2.hasMoreElements()) {
            String string = (String)object2.nextElement();
            Object object3 = string.substring(0, 1).toUpperCase(Locale.US);
            object3 = "set" + (String)object3 + string.substring(1);
            object3 = this.getSetMethod((String)object3, propertyDescriptorArray);
            try {
                if (object3 == null) {
                    throw new NoSuchMethodException("No setter for property '" + string + "'");
                }
                Class<?>[] classArray = ((Method)object3).getParameterTypes();
                if (classArray.length != 1) {
                    throw new NoSuchMethodException("No 1-argument setter for property '" + string + "'");
                }
                PropertiesParser propertiesParser2 = propertiesParser;
                String string2 = propertiesParser.getStringProperty(string);
                if (string2 != null && string2.startsWith("$@")) {
                    string2 = string2.substring(2);
                    propertiesParser2 = this.cfg;
                } else {
                    string2 = string;
                }
                if (classArray[0].equals(Integer.TYPE)) {
                    ((Method)object3).invoke(object, propertiesParser2.getIntProperty(string2));
                    continue;
                }
                if (classArray[0].equals(Long.TYPE)) {
                    ((Method)object3).invoke(object, propertiesParser2.getLongProperty(string2));
                    continue;
                }
                if (classArray[0].equals(Float.TYPE)) {
                    ((Method)object3).invoke(object, Float.valueOf(propertiesParser2.getFloatProperty(string2)));
                    continue;
                }
                if (classArray[0].equals(Double.TYPE)) {
                    ((Method)object3).invoke(object, propertiesParser2.getDoubleProperty(string2));
                    continue;
                }
                if (classArray[0].equals(Boolean.TYPE)) {
                    ((Method)object3).invoke(object, propertiesParser2.getBooleanProperty(string2));
                    continue;
                }
                if (classArray[0].equals(String.class)) {
                    ((Method)object3).invoke(object, propertiesParser2.getStringProperty(string2));
                    continue;
                }
                throw new NoSuchMethodException("No primitive-type setter for property '" + string + "'");
            }
            catch (NumberFormatException numberFormatException) {
                throw new SchedulerConfigException("Could not parse property '" + string + "' into correct data type: " + numberFormatException.toString());
            }
        }
    }

    private Method getSetMethod(String string, PropertyDescriptor[] propertyDescriptorArray) {
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Method method = propertyDescriptorArray[i].getWriteMethod();
            if (method == null || !method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    private Class<?> loadClass(String string) {
        try {
            ClassLoader classLoader = this.findClassloader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            throw new SchedulerConfigException("Unable to find a class loader on the current thread or class.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.getClass().getClassLoader() != null) {
                return this.getClass().getClassLoader().loadClass(string);
            }
            throw classNotFoundException;
        }
    }

    private ClassLoader findClassloader() {
        if (Thread.currentThread().getContextClassLoader() == null && this.getClass().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private String getSchedulerName() {
        return this.cfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "QuartzScheduler");
    }

    @Override
    public Scheduler getScheduler() {
        SchedulerRepository schedulerRepository;
        Scheduler scheduler;
        if (this.cfg == null) {
            this.initialize();
        }
        if ((scheduler = (schedulerRepository = SchedulerRepository.getInstance()).lookup(this.getSchedulerName())) != null) {
            if (scheduler.isShutdown()) {
                schedulerRepository.remove(this.getSchedulerName());
            } else {
                return scheduler;
            }
        }
        scheduler = this.instantiate();
        return scheduler;
    }

    public static Scheduler getDefaultScheduler() {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        return stdSchedulerFactory.getScheduler();
    }

    @Override
    public Scheduler getScheduler(String string) {
        return SchedulerRepository.getInstance().lookup(string);
    }

    @Override
    public Collection<Scheduler> getAllSchedulers() {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

