/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.Trigger$CompletedExecutionInstruction;
import org.quartz.Trigger$TriggerState;
import org.quartz.TriggerKey;
import org.quartz.impl.DefaultThreadExecutor;
import org.quartz.impl.jdbcjobstore.AttributeRestoringConnectionInvocationHandler;
import org.quartz.impl.jdbcjobstore.Constants;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$1;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$10;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$11;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$12;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$13;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$14;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$15;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$16;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$17;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$18;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$19;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$2;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$20;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$21;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$22;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$23;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$24;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$25;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$26;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$27;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$28;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$29;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$3;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$30;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$31;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$32;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$33;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$34;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$35;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$36;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$37;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$38;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$39;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$4;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$40;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$41;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$42;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$43;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$44;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$45;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$46;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$47;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$5;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$6;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$7;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$8;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$9;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$ClusterManager;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$MisfireHandler;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$RecoverMisfiredJobsResult;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$TransactionCallback;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$TransactionValidator;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.MSSQLDelegate;
import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.SimpleSemaphore;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.jdbcjobstore.StdRowLockSemaphore;
import org.quartz.impl.jdbcjobstore.TriggerStatus;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher$StringOperatorName;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobStoreSupport
implements Constants,
JobStore {
    protected static final String LOCK_TRIGGER_ACCESS = "TRIGGER_ACCESS";
    protected static final String LOCK_STATE_ACCESS = "STATE_ACCESS";
    protected String dsName;
    protected String tablePrefix = "QRTZ_";
    protected boolean useProperties = false;
    protected String instanceId;
    protected String instanceName;
    protected String delegateClassName;
    protected String delegateInitString;
    protected Class<? extends DriverDelegate> delegateClass = StdJDBCDelegate.class;
    protected HashMap<String, Calendar> calendarCache = new HashMap();
    private DriverDelegate delegate;
    private long misfireThreshold = 60000L;
    private boolean dontSetAutoCommitFalse = false;
    private boolean isClustered = false;
    private boolean useDBLocks = false;
    private boolean lockOnInsert = true;
    private Semaphore lockHandler = null;
    private String selectWithLockSQL = null;
    private long clusterCheckinInterval = 7500L;
    private JobStoreSupport$ClusterManager clusterManagementThread = null;
    private JobStoreSupport$MisfireHandler misfireHandler = null;
    private ClassLoadHelper classLoadHelper;
    private SchedulerSignaler schedSignaler;
    protected int maxToRecoverAtATime = 20;
    private boolean setTxIsolationLevelSequential = false;
    private boolean acquireTriggersWithinLock = false;
    private long dbRetryInterval = 15000L;
    private boolean makeThreadsDaemons = false;
    private boolean threadsInheritInitializersClassLoadContext = false;
    private ClassLoader initializersLoader = null;
    private boolean doubleCheckLockMisfireHandler = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ThreadExecutor threadExecutor = new DefaultThreadExecutor();
    private volatile boolean schedulerRunning = false;
    private volatile boolean shutdown = false;
    private static long ftrCtr = System.currentTimeMillis();
    protected ThreadLocal<Long> sigChangeForTxCompletion = new ThreadLocal();
    protected boolean firstCheckIn = true;
    protected long lastCheckin = System.currentTimeMillis();

    public void setDataSource(String string) {
        this.dsName = string;
    }

    public String getDataSource() {
        return this.dsName;
    }

    public void setTablePrefix(String string) {
        if (string == null) {
            string = "";
        }
        this.tablePrefix = string;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setUseProperties(String string) {
        if (string == null) {
            string = "false";
        }
        this.useProperties = Boolean.valueOf(string);
    }

    public boolean canUseProperties() {
        return this.useProperties;
    }

    @Override
    public void setInstanceId(String string) {
        this.instanceId = string;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    @Override
    public void setThreadPoolSize(int n) {
    }

    public void setThreadExecutor(ThreadExecutor threadExecutor) {
        this.threadExecutor = threadExecutor;
    }

    public ThreadExecutor getThreadExecutor() {
        return this.threadExecutor;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 70L;
    }

    public void setIsClustered(boolean bl) {
        this.isClustered = bl;
    }

    @Override
    public boolean isClustered() {
        return this.isClustered;
    }

    public long getClusterCheckinInterval() {
        return this.clusterCheckinInterval;
    }

    public void setClusterCheckinInterval(long l) {
        this.clusterCheckinInterval = l;
    }

    public int getMaxMisfiresToHandleAtATime() {
        return this.maxToRecoverAtATime;
    }

    public void setMaxMisfiresToHandleAtATime(int n) {
        this.maxToRecoverAtATime = n;
    }

    public long getDbRetryInterval() {
        return this.dbRetryInterval;
    }

    public void setDbRetryInterval(long l) {
        this.dbRetryInterval = l;
    }

    public void setUseDBLocks(boolean bl) {
        this.useDBLocks = bl;
    }

    public boolean getUseDBLocks() {
        return this.useDBLocks;
    }

    public boolean isLockOnInsert() {
        return this.lockOnInsert;
    }

    public void setLockOnInsert(boolean bl) {
        this.lockOnInsert = bl;
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Misfirethreshold must be larger than 0");
        }
        this.misfireThreshold = l;
    }

    public boolean isDontSetAutoCommitFalse() {
        return this.dontSetAutoCommitFalse;
    }

    public void setDontSetAutoCommitFalse(boolean bl) {
        this.dontSetAutoCommitFalse = bl;
    }

    public boolean isTxIsolationLevelSerializable() {
        return this.setTxIsolationLevelSequential;
    }

    public void setTxIsolationLevelSerializable(boolean bl) {
        this.setTxIsolationLevelSequential = bl;
    }

    public boolean isAcquireTriggersWithinLock() {
        return this.acquireTriggersWithinLock;
    }

    public void setAcquireTriggersWithinLock(boolean bl) {
        this.acquireTriggersWithinLock = bl;
    }

    public void setDriverDelegateClass(String string) {
        JobStoreSupport jobStoreSupport = this;
        synchronized (jobStoreSupport) {
            this.delegateClassName = string;
            return;
        }
    }

    public String getDriverDelegateClass() {
        return this.delegateClassName;
    }

    public void setDriverDelegateInitString(String string) {
        this.delegateInitString = string;
    }

    public String getDriverDelegateInitString() {
        return this.delegateInitString;
    }

    public String getSelectWithLockSQL() {
        return this.selectWithLockSQL;
    }

    public void setSelectWithLockSQL(String string) {
        this.selectWithLockSQL = string;
    }

    protected ClassLoadHelper getClassLoadHelper() {
        return this.classLoadHelper;
    }

    public boolean getMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean bl) {
        this.makeThreadsDaemons = bl;
    }

    public boolean isThreadsInheritInitializersClassLoadContext() {
        return this.threadsInheritInitializersClassLoadContext;
    }

    public void setThreadsInheritInitializersClassLoadContext(boolean bl) {
        this.threadsInheritInitializersClassLoadContext = bl;
    }

    public boolean getDoubleCheckLockMisfireHandler() {
        return this.doubleCheckLockMisfireHandler;
    }

    public void setDoubleCheckLockMisfireHandler(boolean bl) {
        this.doubleCheckLockMisfireHandler = bl;
    }

    @Override
    public long getAcquireRetryDelay(int n) {
        return this.dbRetryInterval;
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void initialize(ClassLoadHelper object, SchedulerSignaler schedulerSignaler) {
        if (this.dsName == null) {
            throw new SchedulerConfigException("DataSource name not set.");
        }
        this.classLoadHelper = object;
        if (this.isThreadsInheritInitializersClassLoadContext()) {
            this.log.info("JDBCJobStore threads will inherit ContextClassLoader of thread: " + Thread.currentThread().getName());
            this.initializersLoader = Thread.currentThread().getContextClassLoader();
        }
        this.schedSignaler = schedulerSignaler;
        if (this.getLockHandler() == null) {
            if (this.isClustered()) {
                this.setUseDBLocks(true);
            }
            if (this.getUseDBLocks()) {
                if (this.getDriverDelegateClass() != null && this.getDriverDelegateClass().equals(MSSQLDelegate.class.getName()) && this.getSelectWithLockSQL() == null) {
                    object = "SELECT * FROM {0}LOCKS WITH (UPDLOCK,ROWLOCK) WHERE SCHED_NAME = {1} AND LOCK_NAME = ?";
                    this.getLog().info("Detected usage of MSSQLDelegate class - defaulting 'selectWithLockSQL' to '" + (String)object + "'.");
                    this.setSelectWithLockSQL((String)object);
                }
                this.getLog().info("Using db table-based data access locking (synchronization).");
                this.setLockHandler(new StdRowLockSemaphore(this.getTablePrefix(), this.getInstanceName(), this.getSelectWithLockSQL()));
                return;
            }
            this.getLog().info("Using thread monitor-based data access locking (synchronization).");
            this.setLockHandler(new SimpleSemaphore());
        }
    }

    @Override
    public void schedulerStarted() {
        if (this.isClustered()) {
            this.clusterManagementThread = new JobStoreSupport$ClusterManager(this);
            if (this.initializersLoader != null) {
                this.clusterManagementThread.setContextClassLoader(this.initializersLoader);
            }
            this.clusterManagementThread.initialize();
        } else {
            try {
                this.recoverJobs();
            }
            catch (SchedulerException schedulerException) {
                throw new SchedulerConfigException("Failure occured during job recovery.", schedulerException);
            }
        }
        this.misfireHandler = new JobStoreSupport$MisfireHandler(this);
        if (this.initializersLoader != null) {
            this.misfireHandler.setContextClassLoader(this.initializersLoader);
        }
        this.misfireHandler.initialize();
        this.schedulerRunning = true;
        this.getLog().debug("JobStore background threads started (as scheduler was started).");
    }

    @Override
    public void schedulerPaused() {
        this.schedulerRunning = false;
    }

    @Override
    public void schedulerResumed() {
        this.schedulerRunning = true;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.misfireHandler != null) {
            this.misfireHandler.shutdown();
            try {
                this.misfireHandler.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.clusterManagementThread != null) {
            this.clusterManagementThread.shutdown();
            try {
                this.clusterManagementThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            DBConnectionManager.getInstance().shutdown(this.getDataSource());
        }
        catch (SQLException sQLException) {
            this.getLog().warn("Database connection shutdown unsuccessful.", (Throwable)sQLException);
        }
        this.getLog().debug("JobStore background threads shutdown.");
    }

    @Override
    public boolean supportsPersistence() {
        return true;
    }

    protected abstract Connection getNonManagedTXConnection();

    protected Connection getAttributeRestoringConnection(Connection connection) {
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new AttributeRestoringConnectionInvocationHandler(connection));
    }

    protected Connection getConnection() {
        Connection connection;
        try {
            connection = DBConnectionManager.getInstance().getConnection(this.getDataSource());
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + sQLException.toString(), sQLException);
        }
        catch (Throwable throwable) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + throwable.toString(), throwable);
        }
        if (connection == null) {
            throw new JobPersistenceException("Could not get connection from DataSource '" + this.getDataSource() + "'");
        }
        connection = this.getAttributeRestoringConnection(connection);
        try {
            if (!this.isDontSetAutoCommitFalse()) {
                connection.setAutoCommit(false);
            }
            if (this.isTxIsolationLevelSerializable()) {
                connection.setTransactionIsolation(8);
            }
        }
        catch (SQLException sQLException) {
            this.getLog().warn("Failed to override connection auto commit/transaction isolation.", (Throwable)sQLException);
        }
        catch (Throwable throwable) {
            try {
                connection.close();
            }
            catch (Throwable throwable2) {}
            throw new JobPersistenceException("Failure setting up connection.", throwable);
        }
        return connection;
    }

    protected void releaseLock(String string, boolean bl) {
        if (bl) {
            try {
                this.getLockHandler().releaseLock(string);
                return;
            }
            catch (LockException lockException) {
                this.getLog().error("Error returning lock: " + lockException.getMessage(), (Throwable)lockException);
            }
        }
    }

    protected void recoverJobs() {
        this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$1(this), null);
    }

    protected void recoverJobs(Connection connection) {
        try {
            int n = this.getDelegate().updateTriggerStatesFromOtherStates(connection, "WAITING", "ACQUIRED", "BLOCKED");
            this.getLog().info("Freed " + (n += this.getDelegate().updateTriggerStatesFromOtherStates(connection, "PAUSED", "PAUSED_BLOCKED", "PAUSED_BLOCKED")) + " triggers from 'acquired' / 'blocked' state.");
            this.recoverMisfiredJobs(connection, true);
            List<TriggerKey> list = this.getDelegate().selectTriggersForRecoveringJobs(connection);
            this.getLog().info("Recovering " + list.size() + " jobs that were in-progress at the time of the last shut-down.");
            for (OperableTrigger object : list) {
                if (!this.jobExists(connection, object.getJobKey())) continue;
                object.computeFirstFireTime(null);
                this.storeTrigger(connection, object, null, false, "WAITING", false, true);
            }
            this.getLog().info("Recovery complete.");
            list = this.getDelegate().selectTriggersInState(connection, "COMPLETE");
            for (TriggerKey triggerKey : list) {
                this.removeTrigger(connection, triggerKey);
            }
            this.getLog().info("Removed " + list.size() + " 'complete' triggers.");
            int n2 = this.getDelegate().deleteFiredTriggers(connection);
            this.getLog().info("Removed " + n2 + " stale fired job entries.");
            return;
        }
        catch (JobPersistenceException jobPersistenceException) {
            JobPersistenceException jobPersistenceException2 = jobPersistenceException;
            throw jobPersistenceException;
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't recover jobs: " + exception.getMessage(), exception);
        }
    }

    protected long getMisfireTime() {
        long l = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            l -= this.getMisfireThreshold();
        }
        if (l > 0L) {
            return l;
        }
        return 0L;
    }

    protected JobStoreSupport$RecoverMisfiredJobsResult recoverMisfiredJobs(Connection connection, boolean bl) {
        int n = bl ? -1 : this.getMaxMisfiresToHandleAtATime();
        LinkedList<TriggerKey> linkedList = new LinkedList<TriggerKey>();
        long l = Long.MAX_VALUE;
        boolean bl2 = this.getDelegate().hasMisfiredTriggersInState(connection, "WAITING", this.getMisfireTime(), n, linkedList);
        n = bl2 ? 1 : 0;
        if (bl2) {
            this.getLog().info("Handling the first " + linkedList.size() + " triggers that missed their scheduled fire-time.  More misfired triggers remain to be processed.");
        } else if (linkedList.size() > 0) {
            this.getLog().info("Handling " + linkedList.size() + " trigger(s) that missed their scheduled fire-time.");
        } else {
            this.getLog().debug("Found 0 triggers that missed their scheduled fire-time.");
            return JobStoreSupport$RecoverMisfiredJobsResult.NO_OP;
        }
        for (TriggerKey triggerKey : linkedList) {
            OperableTrigger comparable = this.retrieveTrigger(connection, triggerKey);
            if (comparable == null) continue;
            this.doUpdateOfMisfiredTrigger(connection, comparable, false, "WAITING", bl);
            if (comparable.getNextFireTime() == null || comparable.getNextFireTime().getTime() >= l) continue;
            l = comparable.getNextFireTime().getTime();
        }
        return new JobStoreSupport$RecoverMisfiredJobsResult(n != 0, linkedList.size(), l);
    }

    protected boolean updateMisfiredTrigger(Connection connection, TriggerKey triggerKey, String string, boolean bl) {
        try {
            OperableTrigger operableTrigger = this.retrieveTrigger(connection, triggerKey);
            long l = System.currentTimeMillis();
            if (this.getMisfireThreshold() > 0L) {
                l -= this.getMisfireThreshold();
            }
            if (operableTrigger.getNextFireTime().getTime() > l) {
                return false;
            }
            this.doUpdateOfMisfiredTrigger(connection, operableTrigger, bl, string, false);
            return true;
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't update misfired trigger '" + triggerKey + "': " + exception.getMessage(), exception);
        }
    }

    private void doUpdateOfMisfiredTrigger(Connection connection, OperableTrigger operableTrigger, boolean bl, String string, boolean bl2) {
        Calendar calendar = null;
        if (operableTrigger.getCalendarName() != null) {
            calendar = this.retrieveCalendar(connection, operableTrigger.getCalendarName());
        }
        this.schedSignaler.notifyTriggerListenersMisfired(operableTrigger);
        operableTrigger.updateAfterMisfire(calendar);
        if (operableTrigger.getNextFireTime() == null) {
            this.storeTrigger(connection, operableTrigger, null, true, "COMPLETE", bl, bl2);
            this.schedSignaler.notifySchedulerListenersFinalized(operableTrigger);
            return;
        }
        this.storeTrigger(connection, operableTrigger, null, true, string, bl, bl2);
    }

    @Override
    public void storeJobAndTrigger(JobDetail jobDetail, OperableTrigger operableTrigger) {
        JobStoreSupport jobStoreSupport = this;
        jobStoreSupport.executeInLock(jobStoreSupport.isLockOnInsert() ? LOCK_TRIGGER_ACCESS : null, new JobStoreSupport$2(this, jobDetail, operableTrigger));
    }

    @Override
    public void storeJob(JobDetail jobDetail, boolean bl) {
        JobStoreSupport jobStoreSupport = this;
        jobStoreSupport.executeInLock(jobStoreSupport.isLockOnInsert() || bl ? LOCK_TRIGGER_ACCESS : null, new JobStoreSupport$3(this, jobDetail, bl));
    }

    protected void storeJob(Connection connection, JobDetail jobDetail, boolean bl) {
        boolean bl2 = this.jobExists(connection, jobDetail.getKey());
        try {
            if (bl2) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(jobDetail);
                }
            } else {
                this.getDelegate().insertJobDetail(connection, jobDetail);
                return;
            }
            this.getDelegate().updateJobDetail(connection, jobDetail);
        }
        catch (IOException iOException) {
            throw new JobPersistenceException("Couldn't store job: " + iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't store job: " + sQLException.getMessage(), sQLException);
        }
    }

    protected boolean jobExists(Connection connection, JobKey jobKey) {
        try {
            return this.getDelegate().jobExists(connection, jobKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine job existence (" + jobKey + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void storeTrigger(OperableTrigger operableTrigger, boolean bl) {
        JobStoreSupport jobStoreSupport = this;
        jobStoreSupport.executeInLock(jobStoreSupport.isLockOnInsert() || bl ? LOCK_TRIGGER_ACCESS : null, new JobStoreSupport$4(this, operableTrigger, bl));
    }

    protected void storeTrigger(Connection connection, OperableTrigger operableTrigger, JobDetail jobDetail, boolean bl, String string, boolean bl2, boolean bl3) {
        boolean bl4 = this.triggerExists(connection, operableTrigger.getKey());
        if (bl4 && !bl) {
            throw new ObjectAlreadyExistsException(operableTrigger);
        }
        try {
            if (!bl2) {
                bl = this.getDelegate().isTriggerGroupPaused(connection, operableTrigger.getKey().getGroup());
                if (!bl && (bl = this.getDelegate().isTriggerGroupPaused(connection, "_$_ALL_GROUPS_PAUSED_$_"))) {
                    this.getDelegate().insertPausedTriggerGroup(connection, operableTrigger.getKey().getGroup());
                }
                if (bl && (string.equals("WAITING") || string.equals("ACQUIRED"))) {
                    string = "PAUSED";
                }
            }
            if (jobDetail == null) {
                jobDetail = this.retrieveJob(connection, operableTrigger.getJobKey());
            }
            if (jobDetail == null) {
                throw new JobPersistenceException("The job (" + operableTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            if (jobDetail.isConcurrentExectionDisallowed() && !bl3) {
                string = this.checkBlockedState(connection, jobDetail.getKey(), string);
            }
            if (!bl4) {
                this.getDelegate().insertTrigger(connection, operableTrigger, string, jobDetail);
                return;
            }
            this.getDelegate().updateTrigger(connection, operableTrigger, string, jobDetail);
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't store trigger '" + operableTrigger.getKey() + "' for '" + operableTrigger.getJobKey() + "' job:" + exception.getMessage(), exception);
        }
    }

    protected boolean triggerExists(Connection connection, TriggerKey triggerKey) {
        try {
            return this.getDelegate().triggerExists(connection, triggerKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine trigger existence (" + triggerKey + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean removeJob(JobKey jobKey) {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$5(this, jobKey));
    }

    protected boolean removeJob(Connection connection, JobKey jobKey) {
        try {
            Object object = this.getDelegate().selectTriggerKeysForJob(connection, jobKey);
            object = object.iterator();
            while (object.hasNext()) {
                TriggerKey triggerKey = (TriggerKey)object.next();
                this.deleteTriggerAndChildren(connection, triggerKey);
            }
            return this.deleteJobAndChildren(connection, jobKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't remove job: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean removeJobs(List<JobKey> list) {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$6(this, list));
    }

    @Override
    public boolean removeTriggers(List<TriggerKey> list) {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$7(this, list));
    }

    @Override
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) {
        JobStoreSupport jobStoreSupport = this;
        jobStoreSupport.executeInLock(jobStoreSupport.isLockOnInsert() || bl ? LOCK_TRIGGER_ACCESS : null, new JobStoreSupport$8(this, map, bl));
    }

    private boolean deleteJobAndChildren(Connection connection, JobKey jobKey) {
        return this.getDelegate().deleteJobDetail(connection, jobKey) > 0;
    }

    private boolean deleteTriggerAndChildren(Connection connection, TriggerKey triggerKey) {
        return this.getDelegate().deleteTrigger(connection, triggerKey) > 0;
    }

    @Override
    public JobDetail retrieveJob(JobKey jobKey) {
        return (JobDetail)this.executeWithoutLock(new JobStoreSupport$9(this, jobKey));
    }

    protected JobDetail retrieveJob(Connection connection, JobKey jobKey) {
        try {
            return this.getDelegate().selectJobDetail(connection, jobKey, this.getClassLoadHelper());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't retrieve job because a required class was not found: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (IOException iOException) {
            throw new JobPersistenceException("Couldn't retrieve job because the BLOB couldn't be deserialized: " + iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't retrieve job: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$10(this, triggerKey));
    }

    protected boolean removeTrigger(Connection connection, TriggerKey triggerKey) {
        boolean bl;
        try {
            int n;
            JobDetail jobDetail = this.getDelegate().selectJobForTrigger(connection, this.getClassLoadHelper(), triggerKey, false);
            bl = this.deleteTriggerAndChildren(connection, triggerKey);
            if (jobDetail != null && !jobDetail.isDurable() && (n = this.getDelegate().selectNumTriggersForJob(connection, jobDetail.getKey())) == 0) {
                this.deleteJobAndChildren(connection, jobDetail.getKey());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't remove trigger: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't remove trigger: " + sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger operableTrigger) {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$11(this, triggerKey, operableTrigger));
    }

    protected boolean replaceTrigger(Connection connection, TriggerKey triggerKey, OperableTrigger operableTrigger) {
        try {
            JobDetail jobDetail = this.getDelegate().selectJobForTrigger(connection, this.getClassLoadHelper(), triggerKey);
            if (jobDetail == null) {
                return false;
            }
            if (!operableTrigger.getJobKey().equals(jobDetail.getKey())) {
                throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
            }
            boolean bl = this.deleteTriggerAndChildren(connection, triggerKey);
            this.storeTrigger(connection, operableTrigger, jobDetail, false, "WAITING", false, false);
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't remove trigger: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't remove trigger: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) {
        return (OperableTrigger)this.executeWithoutLock(new JobStoreSupport$12(this, triggerKey));
    }

    protected OperableTrigger retrieveTrigger(Connection connection, TriggerKey triggerKey) {
        try {
            return this.getDelegate().selectTrigger(connection, triggerKey);
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't retrieve trigger: " + exception.getMessage(), exception);
        }
    }

    @Override
    public Trigger$TriggerState getTriggerState(TriggerKey triggerKey) {
        return (Trigger$TriggerState)((Object)this.executeWithoutLock(new JobStoreSupport$13(this, triggerKey)));
    }

    public Trigger$TriggerState getTriggerState(Connection object, TriggerKey triggerKey) {
        try {
            object = this.getDelegate().selectTriggerState((Connection)object, triggerKey);
            if (object == null) {
                return Trigger$TriggerState.NONE;
            }
            if (((String)object).equals("DELETED")) {
                return Trigger$TriggerState.NONE;
            }
            if (((String)object).equals("COMPLETE")) {
                return Trigger$TriggerState.COMPLETE;
            }
            if (((String)object).equals("PAUSED")) {
                return Trigger$TriggerState.PAUSED;
            }
            if (((String)object).equals("PAUSED_BLOCKED")) {
                return Trigger$TriggerState.PAUSED;
            }
            if (((String)object).equals("ERROR")) {
                return Trigger$TriggerState.ERROR;
            }
            if (((String)object).equals("BLOCKED")) {
                return Trigger$TriggerState.BLOCKED;
            }
            return Trigger$TriggerState.NORMAL;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine state of trigger (" + triggerKey + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void resetTriggerFromErrorState(TriggerKey triggerKey) {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$14(this, triggerKey));
    }

    void resetTriggerFromErrorState(Connection connection, TriggerKey triggerKey) {
        try {
            String string = "WAITING";
            if (this.getDelegate().isTriggerGroupPaused(connection, triggerKey.getGroup())) {
                string = "PAUSED";
            }
            this.getDelegate().updateTriggerStateFromOtherState(connection, triggerKey, string, "ERROR");
            this.getLog().info("Trigger " + triggerKey + " reset from ERROR state to: " + string);
            return;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't reset from error state of trigger (" + triggerKey + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void storeCalendar(String string, Calendar calendar, boolean bl, boolean bl2) {
        JobStoreSupport jobStoreSupport = this;
        jobStoreSupport.executeInLock(jobStoreSupport.isLockOnInsert() || bl2 ? LOCK_TRIGGER_ACCESS : null, new JobStoreSupport$15(this, string, calendar, bl, bl2));
    }

    protected void storeCalendar(Connection connection, String string, Calendar calendar, boolean bl, boolean bl2) {
        try {
            boolean bl3 = this.calendarExists(connection, string);
            if (bl3 && !bl) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + string + "' already exists.");
            }
            if (bl3) {
                if (this.getDelegate().updateCalendar(connection, string, calendar) <= 0) {
                    throw new JobPersistenceException("Couldn't store calendar.  Update failed.");
                }
                if (bl2) {
                    Object object = this.getDelegate().selectTriggersForCalendar(connection, string);
                    object = object.iterator();
                    while (object.hasNext()) {
                        OperableTrigger operableTrigger = (OperableTrigger)object.next();
                        operableTrigger.updateWithNewCalendar(calendar, this.getMisfireThreshold());
                        this.storeTrigger(connection, operableTrigger, null, true, "WAITING", false, false);
                    }
                }
            } else if (this.getDelegate().insertCalendar(connection, string, calendar) <= 0) {
                throw new JobPersistenceException("Couldn't store calendar.  Insert failed.");
            }
            if (!this.isClustered) {
                this.calendarCache.put(string, calendar);
            }
            return;
        }
        catch (IOException iOException) {
            throw new JobPersistenceException("Couldn't store calendar because the BLOB couldn't be serialized: " + iOException.getMessage(), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't store calendar: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't store calendar: " + sQLException.getMessage(), sQLException);
        }
    }

    protected boolean calendarExists(Connection connection, String string) {
        try {
            return this.getDelegate().calendarExists(connection, string);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine calendar existence (" + string + "): " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean removeCalendar(String string) {
        return (Boolean)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$16(this, string));
    }

    protected boolean removeCalendar(Connection connection, String string) {
        try {
            if (this.getDelegate().calendarIsReferenced(connection, string)) {
                throw new JobPersistenceException("Calender cannot be removed if it referenced by a trigger!");
            }
            if (!this.isClustered) {
                this.calendarCache.remove(string);
            }
            return this.getDelegate().deleteCalendar(connection, string) > 0;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't remove calendar: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Calendar retrieveCalendar(String string) {
        return (Calendar)this.executeWithoutLock(new JobStoreSupport$17(this, string));
    }

    protected Calendar retrieveCalendar(Connection connection, String string) {
        Calendar calendar = this.isClustered ? null : this.calendarCache.get(string);
        if (calendar != null) {
            return calendar;
        }
        try {
            calendar = this.getDelegate().selectCalendar(connection, string);
            if (!this.isClustered) {
                this.calendarCache.put(string, calendar);
            }
            return calendar;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JobPersistenceException("Couldn't retrieve calendar because a required class was not found: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (IOException iOException) {
            throw new JobPersistenceException("Couldn't retrieve calendar because the BLOB couldn't be deserialized: " + iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't retrieve calendar: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public int getNumberOfJobs() {
        return (Integer)this.executeWithoutLock(new JobStoreSupport$18(this));
    }

    protected int getNumberOfJobs(Connection connection) {
        try {
            return this.getDelegate().selectNumJobs(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain number of jobs: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public int getNumberOfTriggers() {
        return (Integer)this.executeWithoutLock(new JobStoreSupport$19(this));
    }

    protected int getNumberOfTriggers(Connection connection) {
        try {
            return this.getDelegate().selectNumTriggers(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain number of triggers: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public int getNumberOfCalendars() {
        return (Integer)this.executeWithoutLock(new JobStoreSupport$20(this));
    }

    protected int getNumberOfCalendars(Connection connection) {
        try {
            return this.getDelegate().selectNumCalendars(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain number of calendars: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) {
        return (Set)this.executeWithoutLock(new JobStoreSupport$21(this, groupMatcher));
    }

    protected Set<JobKey> getJobNames(Connection object, GroupMatcher<JobKey> groupMatcher) {
        try {
            object = this.getDelegate().selectJobsInGroup((Connection)object, groupMatcher);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain job names: " + sQLException.getMessage(), sQLException);
        }
        return object;
    }

    @Override
    public boolean checkExists(JobKey jobKey) {
        return (Boolean)this.executeWithoutLock(new JobStoreSupport$22(this, jobKey));
    }

    protected boolean checkExists(Connection connection, JobKey jobKey) {
        try {
            return this.getDelegate().jobExists(connection, jobKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't check for existence of job: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) {
        return (Boolean)this.executeWithoutLock(new JobStoreSupport$23(this, triggerKey));
    }

    protected boolean checkExists(Connection connection, TriggerKey triggerKey) {
        try {
            return this.getDelegate().triggerExists(connection, triggerKey);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't check for existence of job: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void clearAllSchedulingData() {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$24(this));
    }

    protected void clearAllSchedulingData(Connection connection) {
        try {
            this.getDelegate().clearData(connection);
            return;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Error clearing scheduling data: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) {
        return (Set)this.executeWithoutLock(new JobStoreSupport$25(this, groupMatcher));
    }

    protected Set<TriggerKey> getTriggerNames(Connection object, GroupMatcher<TriggerKey> groupMatcher) {
        try {
            object = this.getDelegate().selectTriggersInGroup((Connection)object, groupMatcher);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain trigger names: " + sQLException.getMessage(), sQLException);
        }
        return object;
    }

    @Override
    public List<String> getJobGroupNames() {
        return (List)this.executeWithoutLock(new JobStoreSupport$26(this));
    }

    protected List<String> getJobGroupNames(Connection object) {
        try {
            object = this.getDelegate().selectJobGroups((Connection)object);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain job groups: " + sQLException.getMessage(), sQLException);
        }
        return object;
    }

    @Override
    public List<String> getTriggerGroupNames() {
        return (List)this.executeWithoutLock(new JobStoreSupport$27(this));
    }

    protected List<String> getTriggerGroupNames(Connection object) {
        try {
            object = this.getDelegate().selectTriggerGroups((Connection)object);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain trigger groups: " + sQLException.getMessage(), sQLException);
        }
        return object;
    }

    @Override
    public List<String> getCalendarNames() {
        return (List)this.executeWithoutLock(new JobStoreSupport$28(this));
    }

    protected List<String> getCalendarNames(Connection connection) {
        try {
            return this.getDelegate().selectCalendars(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't obtain trigger groups: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) {
        return (List)this.executeWithoutLock(new JobStoreSupport$29(this, jobKey));
    }

    protected List<OperableTrigger> getTriggersForJob(Connection object, JobKey jobKey) {
        try {
            object = this.getDelegate().selectTriggersForJob((Connection)object, jobKey);
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Couldn't obtain triggers for job: " + exception.getMessage(), exception);
        }
        return object;
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$30(this, triggerKey));
    }

    public void pauseTrigger(Connection connection, TriggerKey triggerKey) {
        try {
            String string = this.getDelegate().selectTriggerState(connection, triggerKey);
            if (!string.equals("WAITING") && !string.equals("ACQUIRED")) {
                if (string.equals("BLOCKED")) {
                    this.getDelegate().updateTriggerState(connection, triggerKey, "PAUSED_BLOCKED");
                }
                return;
            }
            this.getDelegate().updateTriggerState(connection, triggerKey, "PAUSED");
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't pause trigger '" + triggerKey + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void pauseJob(JobKey jobKey) {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$31(this, jobKey));
    }

    public Set<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) {
        return (Set)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$32(this, groupMatcher));
    }

    protected String checkBlockedState(Connection object, JobKey jobKey, String string) {
        if (!string.equals("WAITING") && !string.equals("PAUSED")) {
            return string;
        }
        try {
            object = this.getDelegate().selectFiredTriggerRecordsByJob((Connection)object, jobKey.getName(), jobKey.getGroup());
            if (object.size() > 0 && ((FiredTriggerRecord)(object = (FiredTriggerRecord)object.get(0))).isJobDisallowsConcurrentExecution()) {
                if ("PAUSED".equals(string)) {
                    return "PAUSED_BLOCKED";
                }
                return "BLOCKED";
            }
            return string;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine if trigger should be in a blocked state '" + jobKey + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$33(this, triggerKey));
    }

    public void resumeTrigger(Connection connection, TriggerKey triggerKey) {
        try {
            String string;
            block9: {
                block8: {
                    TriggerStatus triggerStatus = this.getDelegate().selectTriggerStatus(connection, triggerKey);
                    if (triggerStatus == null || triggerStatus.getNextFireTime() == null) {
                        return;
                    }
                    boolean bl = false;
                    if ("PAUSED_BLOCKED".equals(triggerStatus.getStatus())) {
                        bl = true;
                    }
                    string = this.checkBlockedState(connection, triggerStatus.getJobKey(), "WAITING");
                    boolean bl2 = false;
                    if (this.schedulerRunning && triggerStatus.getNextFireTime().before(new Date())) {
                        bl2 = this.updateMisfiredTrigger(connection, triggerKey, string, true);
                    }
                    if (bl2) break block8;
                    if (bl) break block9;
                    this.getDelegate().updateTriggerStateFromOtherState(connection, triggerKey, string, "PAUSED");
                }
                return;
            }
            this.getDelegate().updateTriggerStateFromOtherState(connection, triggerKey, string, "PAUSED_BLOCKED");
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't resume trigger '" + triggerKey + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void resumeJob(JobKey jobKey) {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$34(this, jobKey));
    }

    public Set<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) {
        return (Set)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$35(this, groupMatcher));
    }

    public Set<String> pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        return (Set)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$36(this, groupMatcher));
    }

    public Set<String> pauseTriggerGroup(Connection connection, GroupMatcher<TriggerKey> groupMatcher) {
        try {
            this.getDelegate().updateTriggerGroupStateFromOtherStates(connection, groupMatcher, "PAUSED", "ACQUIRED", "WAITING", "WAITING");
            this.getDelegate().updateTriggerGroupStateFromOtherState(connection, groupMatcher, "PAUSED_BLOCKED", "BLOCKED");
            List<String> list = this.getDelegate().selectTriggerGroups(connection, groupMatcher);
            StringMatcher$StringOperatorName stringMatcher$StringOperatorName = groupMatcher.getCompareWithOperator();
            if (stringMatcher$StringOperatorName.equals((Object)StringMatcher$StringOperatorName.EQUALS) && !list.contains(groupMatcher.getCompareToValue())) {
                list.add(groupMatcher.getCompareToValue());
            }
            for (String string : list) {
                if (this.getDelegate().isTriggerGroupPaused(connection, string)) continue;
                this.getDelegate().insertPausedTriggerGroup(connection, string);
            }
            return new HashSet<String>(list);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't pause trigger group '" + groupMatcher + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Set<String> getPausedTriggerGroups() {
        return (Set)this.executeWithoutLock(new JobStoreSupport$37(this));
    }

    public Set<String> getPausedTriggerGroups(Connection connection) {
        try {
            return this.getDelegate().selectPausedTriggerGroups(connection);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't determine paused trigger groups: " + sQLException.getMessage(), sQLException);
        }
    }

    public Set<String> resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        return (Set)this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$38(this, groupMatcher));
    }

    public Set<String> resumeTriggerGroup(Connection connection, GroupMatcher<TriggerKey> groupMatcher) {
        try {
            this.getDelegate().deletePausedTriggerGroup(connection, groupMatcher);
            HashSet<String> hashSet = new HashSet<String>();
            Object object = this.getDelegate().selectTriggersInGroup(connection, groupMatcher);
            object = object.iterator();
            while (object.hasNext()) {
                TriggerKey triggerKey = (TriggerKey)object.next();
                this.resumeTrigger(connection, triggerKey);
                hashSet.add(triggerKey.getGroup());
            }
            return hashSet;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't pause trigger group '" + groupMatcher + "': " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void pauseAll() {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$39(this));
    }

    public void pauseAll(Connection connection) {
        Object object = this.getTriggerGroupNames(connection);
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.pauseTriggerGroup(connection, GroupMatcher.triggerGroupEquals(string));
        }
        try {
            if (!this.getDelegate().isTriggerGroupPaused(connection, "_$_ALL_GROUPS_PAUSED_$_")) {
                this.getDelegate().insertPausedTriggerGroup(connection, "_$_ALL_GROUPS_PAUSED_$_");
            }
            return;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't pause all trigger groups: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void resumeAll() {
        this.executeInLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$40(this));
    }

    public void resumeAll(Connection connection) {
        Object object = this.getTriggerGroupNames(connection);
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.resumeTriggerGroup(connection, GroupMatcher.triggerGroupEquals(string));
        }
        try {
            this.getDelegate().deletePausedTriggerGroup(connection, "_$_ALL_GROUPS_PAUSED_$_");
            return;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't resume all trigger groups: " + sQLException.getMessage(), sQLException);
        }
    }

    protected synchronized String getFiredTriggerRecordId() {
        return this.getInstanceId() + ftrCtr++;
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(long l, int n, long l2) {
        String string = this.isAcquireTriggersWithinLock() || n > 1 ? LOCK_TRIGGER_ACCESS : null;
        return this.executeInNonManagedTXLock(string, new JobStoreSupport$41(this, l, n, l2), new JobStoreSupport$42(this));
    }

    protected List<OperableTrigger> acquireNextTrigger(Connection connection, long l, int n, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        ArrayList<OperableTrigger> arrayList = new ArrayList<OperableTrigger>();
        HashSet<Comparable<Key<JobKey>>> hashSet = new HashSet<Comparable<Key<JobKey>>>();
        int n2 = 0;
        while (true) {
            ++n2;
            try {
                Object object = this.getDelegate().selectTriggerToAcquire(connection, l + l2, this.getMisfireTime(), n);
                if (object == null || object.size() == 0) {
                    return arrayList;
                }
                long l3 = l;
                object = object.iterator();
                while (object.hasNext()) {
                    JobDetail jobDetail;
                    TriggerKey triggerKey = (TriggerKey)object.next();
                    OperableTrigger operableTrigger = this.retrieveTrigger(connection, triggerKey);
                    if (operableTrigger == null) continue;
                    Comparable<Key<JobKey>> comparable = operableTrigger.getJobKey();
                    try {
                        jobDetail = this.retrieveJob(connection, (JobKey)comparable);
                    }
                    catch (JobPersistenceException jobPersistenceException) {
                        try {
                            this.getLog().error("Error retrieving job, setting trigger state to ERROR.", (Throwable)jobPersistenceException);
                            this.getDelegate().updateTriggerState(connection, triggerKey, "ERROR");
                        }
                        catch (SQLException sQLException) {
                            this.getLog().error("Unable to set trigger state to ERROR.", (Throwable)sQLException);
                        }
                        continue;
                    }
                    if (jobDetail.isConcurrentExectionDisallowed()) {
                        if (hashSet.contains(comparable)) continue;
                        hashSet.add(comparable);
                    }
                    if ((comparable = operableTrigger.getNextFireTime()) == null) {
                        this.log.warn("Trigger {} returned null on nextFireTime and yet still exists in DB!", (Object)operableTrigger.getKey());
                        continue;
                    }
                    if (((Date)comparable).getTime() > l3) break;
                    int n3 = this.getDelegate().updateTriggerStateFromOtherState(connection, triggerKey, "ACQUIRED", "WAITING");
                    if (n3 <= 0) continue;
                    operableTrigger.setFireInstanceId(this.getFiredTriggerRecordId());
                    this.getDelegate().insertFiredTrigger(connection, operableTrigger, "ACQUIRED", null);
                    if (arrayList.isEmpty()) {
                        l3 = Math.max(((Date)comparable).getTime(), System.currentTimeMillis()) + l2;
                    }
                    arrayList.add(operableTrigger);
                }
                if (arrayList.size() != 0 || n2 >= 3) break;
            }
            catch (Exception exception) {
                throw new JobPersistenceException("Couldn't acquire next trigger: " + exception.getMessage(), exception);
            }
        }
        return arrayList;
    }

    @Override
    public void releaseAcquiredTrigger(OperableTrigger operableTrigger) {
        this.retryExecuteInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$43(this, operableTrigger));
    }

    protected void releaseAcquiredTrigger(Connection connection, OperableTrigger operableTrigger) {
        try {
            this.getDelegate().updateTriggerStateFromOtherState(connection, operableTrigger.getKey(), "WAITING", "ACQUIRED");
            this.getDelegate().updateTriggerStateFromOtherState(connection, operableTrigger.getKey(), "WAITING", "BLOCKED");
            this.getDelegate().deleteFiredTrigger(connection, operableTrigger.getFireInstanceId());
            return;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't release acquired trigger: " + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> list) {
        return this.executeInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$44(this, list), new JobStoreSupport$45(this));
    }

    protected TriggerFiredBundle triggerFired(Connection connection, OperableTrigger operableTrigger) {
        JobDetail jobDetail;
        Object object;
        Calendar calendar = null;
        try {
            object = this.getDelegate().selectTriggerState(connection, operableTrigger.getKey());
            if (!((String)object).equals("ACQUIRED")) {
                return null;
            }
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't select trigger state: " + sQLException.getMessage(), sQLException);
        }
        try {
            jobDetail = this.retrieveJob(connection, operableTrigger.getJobKey());
            if (jobDetail == null) {
                return null;
            }
        }
        catch (JobPersistenceException jobPersistenceException) {
            try {
                this.getLog().error("Error retrieving job, setting trigger state to ERROR.", (Throwable)jobPersistenceException);
                this.getDelegate().updateTriggerState(connection, operableTrigger.getKey(), "ERROR");
            }
            catch (SQLException sQLException) {
                this.getLog().error("Unable to set trigger state to ERROR.", (Throwable)sQLException);
            }
            throw jobPersistenceException;
        }
        if (operableTrigger.getCalendarName() != null && (calendar = this.retrieveCalendar(connection, operableTrigger.getCalendarName())) == null) {
            return null;
        }
        try {
            this.getDelegate().updateFiredTrigger(connection, operableTrigger, "EXECUTING", jobDetail);
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't insert fired trigger: " + sQLException.getMessage(), sQLException);
        }
        object = operableTrigger.getPreviousFireTime();
        operableTrigger.triggered(calendar);
        String string = "WAITING";
        boolean bl = true;
        if (jobDetail.isConcurrentExectionDisallowed()) {
            string = "BLOCKED";
            bl = false;
            try {
                this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "BLOCKED", "WAITING");
                this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "BLOCKED", "ACQUIRED");
                this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "PAUSED_BLOCKED", "PAUSED");
            }
            catch (SQLException sQLException) {
                throw new JobPersistenceException("Couldn't update states of blocked triggers: " + sQLException.getMessage(), sQLException);
            }
        }
        if (operableTrigger.getNextFireTime() == null) {
            string = "COMPLETE";
            bl = true;
        }
        this.storeTrigger(connection, operableTrigger, jobDetail, true, string, bl, false);
        jobDetail.getJobDataMap().clearDirtyFlag();
        return new TriggerFiredBundle(jobDetail, operableTrigger, calendar, operableTrigger.getKey().getGroup().equals("RECOVERING_JOBS"), new Date(), operableTrigger.getPreviousFireTime(), (Date)object, operableTrigger.getNextFireTime());
    }

    @Override
    public void triggeredJobComplete(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger$CompletedExecutionInstruction trigger$CompletedExecutionInstruction) {
        this.retryExecuteInNonManagedTXLock(LOCK_TRIGGER_ACCESS, new JobStoreSupport$46(this, operableTrigger, jobDetail, trigger$CompletedExecutionInstruction));
    }

    protected void triggeredJobComplete(Connection connection, OperableTrigger operableTrigger, JobDetail jobDetail, Trigger$CompletedExecutionInstruction object) {
        block21: {
            try {
                if (object == Trigger$CompletedExecutionInstruction.DELETE_TRIGGER) {
                    if (operableTrigger.getNextFireTime() == null) {
                        object = this.getDelegate().selectTriggerStatus(connection, operableTrigger.getKey());
                        if (object != null && ((TriggerStatus)object).getNextFireTime() == null) {
                            this.removeTrigger(connection, operableTrigger.getKey());
                        }
                    } else {
                        this.removeTrigger(connection, operableTrigger.getKey());
                        this.signalSchedulingChangeOnTxCompletion(0L);
                    }
                } else if (object == Trigger$CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                    this.getDelegate().updateTriggerState(connection, operableTrigger.getKey(), "COMPLETE");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                } else if (object == Trigger$CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                    this.getLog().info("Trigger " + operableTrigger.getKey() + " set to ERROR state.");
                    this.getDelegate().updateTriggerState(connection, operableTrigger.getKey(), "ERROR");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                } else if (object == Trigger$CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                    this.getDelegate().updateTriggerStatesForJob(connection, operableTrigger.getJobKey(), "COMPLETE");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                } else if (object == Trigger$CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                    this.getLog().info("All triggers of Job " + operableTrigger.getKey() + " set to ERROR state.");
                    this.getDelegate().updateTriggerStatesForJob(connection, operableTrigger.getJobKey(), "ERROR");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                }
                if (jobDetail.isConcurrentExectionDisallowed()) {
                    this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "WAITING", "BLOCKED");
                    this.getDelegate().updateTriggerStatesForJobFromOtherState(connection, jobDetail.getKey(), "PAUSED", "PAUSED_BLOCKED");
                    this.signalSchedulingChangeOnTxCompletion(0L);
                }
                if (!jobDetail.isPersistJobDataAfterExecution()) break block21;
                try {
                    if (jobDetail.getJobDataMap().isDirty()) {
                        this.getDelegate().updateJobData(connection, jobDetail);
                    }
                }
                catch (IOException iOException) {
                    throw new JobPersistenceException("Couldn't serialize job data: " + iOException.getMessage(), iOException);
                }
                catch (SQLException sQLException) {
                    throw new JobPersistenceException("Couldn't update job data: " + sQLException.getMessage(), sQLException);
                }
            }
            catch (SQLException sQLException) {
                throw new JobPersistenceException("Couldn't update trigger state(s): " + sQLException.getMessage(), sQLException);
            }
        }
        try {
            this.getDelegate().deleteFiredTrigger(connection, operableTrigger.getFireInstanceId());
            return;
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Couldn't delete fired trigger: " + sQLException.getMessage(), sQLException);
        }
    }

    protected DriverDelegate getDelegate() {
        JobStoreSupport jobStoreSupport = this;
        synchronized (jobStoreSupport) {
            if (this.delegate == null) {
                try {
                    if (this.delegateClassName != null) {
                        this.delegateClass = this.getClassLoadHelper().loadClass(this.delegateClassName, DriverDelegate.class);
                    }
                    this.delegate = this.delegateClass.newInstance();
                    this.delegate.initialize(this.getLog(), this.tablePrefix, this.instanceName, this.instanceId, this.getClassLoadHelper(), this.canUseProperties(), this.getDriverDelegateInitString());
                }
                catch (InstantiationException instantiationException) {
                    throw new NoSuchDelegateException("Couldn't create delegate: " + instantiationException.getMessage(), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new NoSuchDelegateException("Couldn't create delegate: " + illegalAccessException.getMessage(), illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchDelegateException("Couldn't load delegate class: " + classNotFoundException.getMessage(), classNotFoundException);
                }
            }
            return this.delegate;
        }
    }

    protected Semaphore getLockHandler() {
        return this.lockHandler;
    }

    public void setLockHandler(Semaphore semaphore) {
        this.lockHandler = semaphore;
    }

    protected JobStoreSupport$RecoverMisfiredJobsResult doRecoverMisfires() {
        boolean bl = false;
        Connection connection = this.getNonManagedTXConnection();
        try {
            JobStoreSupport$RecoverMisfiredJobsResult jobStoreSupport$RecoverMisfiredJobsResult = JobStoreSupport$RecoverMisfiredJobsResult.NO_OP;
            int n = this.getDoubleCheckLockMisfireHandler() ? this.getDelegate().countMisfiredTriggersInState(connection, "WAITING", this.getMisfireTime()) : Integer.MAX_VALUE;
            if (n == 0) {
                this.getLog().debug("Found 0 triggers that missed their scheduled fire-time.");
            } else {
                bl = this.getLockHandler().obtainLock(connection, LOCK_TRIGGER_ACCESS);
                jobStoreSupport$RecoverMisfiredJobsResult = this.recoverMisfiredJobs(connection, false);
            }
            this.commitConnection(connection);
            return jobStoreSupport$RecoverMisfiredJobsResult;
        }
        catch (JobPersistenceException jobPersistenceException) {
            this.rollbackConnection(connection);
            throw jobPersistenceException;
        }
        catch (SQLException sQLException) {
            this.rollbackConnection(connection);
            throw new JobPersistenceException("Database error recovering from misfires.", sQLException);
        }
        catch (RuntimeException runtimeException) {
            this.rollbackConnection(connection);
            throw new JobPersistenceException("Unexpected runtime exception: " + runtimeException.getMessage(), runtimeException);
        }
        finally {
            try {
                this.releaseLock(LOCK_TRIGGER_ACCESS, bl);
            }
            finally {
                this.cleanupConnection(connection);
            }
        }
    }

    protected void signalSchedulingChangeOnTxCompletion(long l) {
        Long l2 = this.sigChangeForTxCompletion.get();
        if (l2 == null && l >= 0L || l2 == null || l < l2) {
            this.sigChangeForTxCompletion.set(l);
        }
    }

    protected Long clearAndGetSignalSchedulingChangeOnTxCompletion() {
        Long l = this.sigChangeForTxCompletion.get();
        this.sigChangeForTxCompletion.set(null);
        return l;
    }

    protected void signalSchedulingChangeImmediately(long l) {
        this.schedSignaler.signalSchedulingChange(l);
    }

    protected boolean doCheckin() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Connection connection = this.getNonManagedTXConnection();
        try {
            List<SchedulerStateRecord> list = null;
            if (!this.firstCheckIn) {
                list = this.clusterCheckIn(connection);
                this.commitConnection(connection);
            }
            if (this.firstCheckIn || list.size() > 0) {
                this.getLockHandler().obtainLock(connection, LOCK_STATE_ACCESS);
                bl2 = true;
                list = this.firstCheckIn ? this.clusterCheckIn(connection) : this.findFailedInstances(connection);
                if (list.size() > 0) {
                    this.getLockHandler().obtainLock(connection, LOCK_TRIGGER_ACCESS);
                    bl = true;
                    this.clusterRecover(connection, list);
                    bl3 = true;
                }
            }
            this.commitConnection(connection);
        }
        catch (JobPersistenceException jobPersistenceException) {
            this.rollbackConnection(connection);
            throw jobPersistenceException;
        }
        finally {
            try {
                this.releaseLock(LOCK_TRIGGER_ACCESS, bl);
            }
            finally {
                try {
                    this.releaseLock(LOCK_STATE_ACCESS, bl2);
                }
                finally {
                    this.cleanupConnection(connection);
                }
            }
        }
        this.firstCheckIn = false;
        return bl3;
    }

    protected List<SchedulerStateRecord> findFailedInstances(Connection connection) {
        try {
            LinkedList<SchedulerStateRecord> linkedList = new LinkedList<SchedulerStateRecord>();
            boolean bl = false;
            long l = System.currentTimeMillis();
            List<SchedulerStateRecord> list = this.getDelegate().selectSchedulerStateRecords(connection, null);
            for (SchedulerStateRecord schedulerStateRecord : list) {
                if (schedulerStateRecord.getSchedulerInstanceId().equals(this.getInstanceId())) {
                    bl = true;
                    if (!this.firstCheckIn) continue;
                    linkedList.add(schedulerStateRecord);
                    continue;
                }
                if (this.calcFailedIfAfter(schedulerStateRecord) >= l) continue;
                linkedList.add(schedulerStateRecord);
            }
            if (this.firstCheckIn) {
                linkedList.addAll(this.findOrphanedFailedInstances(connection, list));
            }
            if (!bl && !this.firstCheckIn) {
                this.getLog().warn("This scheduler instance (" + this.getInstanceId() + ") is still active but was recovered by another instance in the cluster.  " + "This may cause inconsistent behavior.");
            }
            return linkedList;
        }
        catch (Exception exception) {
            this.lastCheckin = System.currentTimeMillis();
            throw new JobPersistenceException("Failure identifying failed instances when checking-in: " + exception.getMessage(), exception);
        }
    }

    private List<SchedulerStateRecord> findOrphanedFailedInstances(Connection set, List<SchedulerStateRecord> iterator) {
        ArrayList<SchedulerStateRecord> arrayList = new ArrayList<SchedulerStateRecord>();
        set = this.getDelegate().selectFiredTriggerInstanceNames((Connection)((Object)set));
        if (!set.isEmpty()) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                SchedulerStateRecord object = (SchedulerStateRecord)iterator.next();
                set.remove(object.getSchedulerInstanceId());
            }
            for (String string : set) {
                set = new SchedulerStateRecord();
                ((SchedulerStateRecord)((Object)set)).setSchedulerInstanceId(string);
                arrayList.add((SchedulerStateRecord)((Object)set));
                this.getLog().warn("Found orphaned fired triggers for instance: " + ((SchedulerStateRecord)((Object)set)).getSchedulerInstanceId());
            }
        }
        return arrayList;
    }

    protected long calcFailedIfAfter(SchedulerStateRecord schedulerStateRecord) {
        return schedulerStateRecord.getCheckinTimestamp() + Math.max(schedulerStateRecord.getCheckinInterval(), System.currentTimeMillis() - this.lastCheckin) + 7500L;
    }

    protected List<SchedulerStateRecord> clusterCheckIn(Connection connection) {
        List<SchedulerStateRecord> list = this.findFailedInstances(connection);
        try {
            this.lastCheckin = System.currentTimeMillis();
            if (this.getDelegate().updateSchedulerState(connection, this.getInstanceId(), this.lastCheckin) == 0) {
                this.getDelegate().insertSchedulerState(connection, this.getInstanceId(), this.lastCheckin, this.getClusterCheckinInterval());
            }
        }
        catch (Exception exception) {
            throw new JobPersistenceException("Failure updating scheduler state when checking-in: " + exception.getMessage(), exception);
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    protected void clusterRecover(Connection var1_1, List<SchedulerStateRecord> var2_2) {
        block10: {
            if (var2_2.size() <= 0) break block10;
            var3_4 = System.currentTimeMillis();
            this.logWarnIfNonZero(var2_2.size(), "ClusterManager: detected " + var2_2.size() + " failed or restarted instances.");
            try {
                var2_2 = var2_2.iterator();
                while (var2_2.hasNext()) {
                    var5_5 = (SchedulerStateRecord)var2_2.next();
                    this.getLog().info("ClusterManager: Scanning for instance \"" + var5_5.getSchedulerInstanceId() + "\"'s failed in-progress jobs.");
                    var6_7 = this.getDelegate().selectInstancesFiredTriggerRecords(var1_1, var5_5.getSchedulerInstanceId());
                    var7_8 = 0;
                    var8_9 = 0;
                    var9_10 = 0;
                    var10_11 = new HashSet<TriggerKey>();
                    var6_7 = var6_7.iterator();
                    while (var6_7.hasNext()) {
                        block12: {
                            block11: {
                                var11_12 = (FiredTriggerRecord)var6_7.next();
                                var12_13 = var11_12.getTriggerKey();
                                var13_14 = var11_12.getJobKey();
                                var10_11.add(var12_13);
                                if (var11_12.getFireInstanceState().equals("BLOCKED")) {
                                    this.getDelegate().updateTriggerStatesForJobFromOtherState(var1_1, (JobKey)var13_14, "WAITING", "BLOCKED");
                                } else if (var11_12.getFireInstanceState().equals("PAUSED_BLOCKED")) {
                                    this.getDelegate().updateTriggerStatesForJobFromOtherState(var1_1, (JobKey)var13_14, "PAUSED", "PAUSED_BLOCKED");
                                }
                                if (!var11_12.getFireInstanceState().equals("ACQUIRED")) break block11;
                                this.getDelegate().updateTriggerStateFromOtherState(var1_1, var12_13, "WAITING", "ACQUIRED");
                                ++var7_8;
                                break block12;
                            }
                            if (!var11_12.isJobRequestsRecovery()) ** GOTO lbl53
                            if (this.jobExists(var1_1, (JobKey)var13_14)) {
                                var14_15 = new SimpleTriggerImpl("recover_" + var5_5.getSchedulerInstanceId() + "_" + String.valueOf(var3_4++), "RECOVERING_JOBS", new Date(var11_12.getScheduleTimestamp()));
                                var14_15.setJobName(var13_14.getName());
                                var14_15.setJobGroup(var13_14.getGroup());
                                var14_15.setMisfireInstruction(-1);
                                var14_15.setPriority(var11_12.getPriority());
                                var15_16 = this.getDelegate().selectTriggerJobDataMap(var1_1, var12_13.getName(), var12_13.getGroup());
                                var15_16.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", var12_13.getName());
                                var15_16.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", var12_13.getGroup());
                                var15_16.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(var11_12.getFireTimestamp()));
                                var15_16.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_SCHEDULED_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(var11_12.getScheduleTimestamp()));
                                var14_15.setJobDataMap(var15_16);
                                var14_15.computeFirstFireTime(null);
                                this.storeTrigger(var1_1, var14_15, null, false, "WAITING", false, true);
                                ++var8_9;
                            } else {
                                this.getLog().warn("ClusterManager: failed job '" + var13_14 + "' no longer exists, cannot schedule recovery.");
lbl53:
                                // 2 sources

                                ++var9_10;
                            }
                        }
                        if (!var11_12.isJobDisallowsConcurrentExecution()) continue;
                        this.getDelegate().updateTriggerStatesForJobFromOtherState(var1_1, (JobKey)var13_14, "WAITING", "BLOCKED");
                        this.getDelegate().updateTriggerStatesForJobFromOtherState(var1_1, (JobKey)var13_14, "PAUSED", "PAUSED_BLOCKED");
                    }
                    this.getDelegate().deleteFiredTriggers(var1_1, var5_5.getSchedulerInstanceId());
                    var6_6 = 0;
                    for (TriggerKey var12_13 : var10_11) {
                        if (!this.getDelegate().selectTriggerState(var1_1, var12_13).equals("COMPLETE") || !(var13_14 = this.getDelegate().selectFiredTriggerRecords(var1_1, var12_13.getName(), var12_13.getGroup())).isEmpty() || !this.removeTrigger(var1_1, var12_13)) continue;
                        ++var6_6;
                    }
                    this.logWarnIfNonZero(var7_8, "ClusterManager: ......Freed " + var7_8 + " acquired trigger(s).");
                    this.logWarnIfNonZero(var6_6, "ClusterManager: ......Deleted " + var6_6 + " complete triggers(s).");
                    this.logWarnIfNonZero(var8_9, "ClusterManager: ......Scheduled " + var8_9 + " recoverable job(s) for recovery.");
                    this.logWarnIfNonZero(var9_10, "ClusterManager: ......Cleaned-up " + var9_10 + " other failed job(s).");
                    if (var5_5.getSchedulerInstanceId().equals(this.getInstanceId())) continue;
                    this.getDelegate().deleteSchedulerState(var1_1, var5_5.getSchedulerInstanceId());
                }
                return;
            }
            catch (Throwable var2_3) {
                throw new JobPersistenceException("Failure recovering jobs: " + var2_3.getMessage(), var2_3);
            }
        }
    }

    protected void logWarnIfNonZero(int n, String string) {
        if (n > 0) {
            this.getLog().info(string);
            return;
        }
        this.getLog().debug(string);
    }

    protected void cleanupConnection(Connection object) {
        if (object != null) {
            if (object instanceof Proxy) {
                Object object2 = (Proxy)object;
                if ((object2 = Proxy.getInvocationHandler(object2)) instanceof AttributeRestoringConnectionInvocationHandler) {
                    object = (AttributeRestoringConnectionInvocationHandler)object2;
                    ((AttributeRestoringConnectionInvocationHandler)object).restoreOriginalAtributes();
                    this.closeConnection(((AttributeRestoringConnectionInvocationHandler)object).getWrappedConnection());
                    return;
                }
            }
            this.closeConnection((Connection)object);
        }
    }

    protected void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                return;
            }
            catch (SQLException sQLException) {
                this.getLog().error("Failed to close Connection", (Throwable)sQLException);
                return;
            }
            catch (Throwable throwable) {
                this.getLog().error("Unexpected exception closing Connection.  This is often due to a Connection being returned after or during shutdown.", throwable);
            }
        }
    }

    protected void rollbackConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
                return;
            }
            catch (SQLException sQLException) {
                this.getLog().error("Couldn't rollback jdbc connection. " + sQLException.getMessage(), (Throwable)sQLException);
            }
        }
    }

    protected void commitConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.commit();
                return;
            }
            catch (SQLException sQLException) {
                throw new JobPersistenceException("Couldn't commit jdbc connection. " + sQLException.getMessage(), sQLException);
            }
        }
    }

    public <T> T executeWithoutLock(JobStoreSupport$TransactionCallback<T> jobStoreSupport$TransactionCallback) {
        return this.executeInLock(null, jobStoreSupport$TransactionCallback);
    }

    protected abstract <T> T executeInLock(String var1, JobStoreSupport$TransactionCallback<T> var2);

    protected <T> T retryExecuteInNonManagedTXLock(String string, JobStoreSupport$TransactionCallback<T> jobStoreSupport$TransactionCallback) {
        int n = 1;
        while (!this.shutdown) {
            try {
                return this.executeInNonManagedTXLock(string, jobStoreSupport$TransactionCallback, null);
            }
            catch (JobPersistenceException jobPersistenceException) {
                if (n % 4 == 0) {
                    this.schedSignaler.notifySchedulerListenersError("An error occurred while " + jobStoreSupport$TransactionCallback, jobPersistenceException);
                }
            }
            catch (RuntimeException runtimeException) {
                this.getLog().error("retryExecuteInNonManagedTXLock: RuntimeException " + runtimeException.getMessage(), (Throwable)runtimeException);
            }
            try {
                Thread.sleep(this.getDbRetryInterval());
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException("Received interrupted exception", interruptedException);
            }
            ++n;
        }
        throw new IllegalStateException("JobStore is shutdown - aborting retry");
    }

    protected <T> T executeInNonManagedTXLock(String string, JobStoreSupport$TransactionCallback<T> jobStoreSupport$TransactionCallback, JobStoreSupport$TransactionValidator<T> jobStoreSupport$TransactionValidator) {
        boolean bl = false;
        Connection connection = null;
        try {
            block17: {
                if (string != null) {
                    if (this.getLockHandler().requiresConnection()) {
                        connection = this.getNonManagedTXConnection();
                    }
                    bl = this.getLockHandler().obtainLock(connection, string);
                }
                if (connection == null) {
                    connection = this.getNonManagedTXConnection();
                }
                jobStoreSupport$TransactionCallback = jobStoreSupport$TransactionCallback.execute(connection);
                try {
                    this.commitConnection(connection);
                }
                catch (JobPersistenceException jobPersistenceException) {
                    this.rollbackConnection(connection);
                    if (jobStoreSupport$TransactionValidator != null && this.retryExecuteInNonManagedTXLock(string, new JobStoreSupport$47(this, jobStoreSupport$TransactionValidator, jobStoreSupport$TransactionCallback)).booleanValue()) break block17;
                    throw jobPersistenceException;
                }
            }
            Long l = this.clearAndGetSignalSchedulingChangeOnTxCompletion();
            if (l != null && l >= 0L) {
                this.signalSchedulingChangeImmediately(l);
            }
            return (T)jobStoreSupport$TransactionCallback;
        }
        catch (JobPersistenceException jobPersistenceException) {
            this.rollbackConnection(connection);
            throw jobPersistenceException;
        }
        catch (RuntimeException runtimeException) {
            this.rollbackConnection(connection);
            throw new JobPersistenceException("Unexpected runtime exception: " + runtimeException.getMessage(), runtimeException);
        }
        finally {
            try {
                this.releaseLock(string, bl);
            }
            finally {
                this.cleanupConnection(connection);
            }
        }
    }
}

