/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.quartz.SchedulerConfigException;
import org.quartz.simpl.SimpleThreadPool$WorkerThread;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleThreadPool
implements ThreadPool {
    private int count = -1;
    private int prio = 5;
    private boolean isShutdown = false;
    private boolean handoffPending = false;
    private boolean inheritLoader = false;
    private boolean inheritGroup = true;
    private boolean makeThreadsDaemons = false;
    private ThreadGroup threadGroup;
    private final Object nextRunnableLock = new Object();
    private List<SimpleThreadPool$WorkerThread> workers;
    private LinkedList<SimpleThreadPool$WorkerThread> availWorkers = new LinkedList();
    private LinkedList<SimpleThreadPool$WorkerThread> busyWorkers = new LinkedList();
    private String threadNamePrefix;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String schedulerInstanceName;

    public SimpleThreadPool() {
    }

    public SimpleThreadPool(int n, int n2) {
        this.setThreadCount(n);
        this.setThreadPriority(n2);
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public int getPoolSize() {
        return this.getThreadCount();
    }

    public void setThreadCount(int n) {
        this.count = n;
    }

    public int getThreadCount() {
        return this.count;
    }

    public void setThreadPriority(int n) {
        this.prio = n;
    }

    public int getThreadPriority() {
        return this.prio;
    }

    public void setThreadNamePrefix(String string) {
        this.threadNamePrefix = string;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public boolean isThreadsInheritContextClassLoaderOfInitializingThread() {
        return this.inheritLoader;
    }

    public void setThreadsInheritContextClassLoaderOfInitializingThread(boolean bl) {
        this.inheritLoader = bl;
    }

    public boolean isThreadsInheritGroupOfInitializingThread() {
        return this.inheritGroup;
    }

    public void setThreadsInheritGroupOfInitializingThread(boolean bl) {
        this.inheritGroup = bl;
    }

    public boolean isMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean bl) {
        this.makeThreadsDaemons = bl;
    }

    @Override
    public void setInstanceId(String string) {
    }

    @Override
    public void setInstanceName(String string) {
        this.schedulerInstanceName = string;
    }

    @Override
    public void initialize() {
        if (this.workers != null && this.workers.size() > 0) {
            return;
        }
        if (this.count <= 0) {
            throw new SchedulerConfigException("Thread count must be > 0");
        }
        if (this.prio <= 0 || this.prio > 9) {
            throw new SchedulerConfigException("Thread priority must be > 0 and <= 9");
        }
        if (this.isThreadsInheritGroupOfInitializingThread()) {
            this.threadGroup = Thread.currentThread().getThreadGroup();
        } else {
            this.threadGroup = Thread.currentThread().getThreadGroup();
            Object object = this.threadGroup;
            while (!((ThreadGroup)object).getName().equals("main")) {
                this.threadGroup = object;
                object = this.threadGroup.getParent();
            }
            this.threadGroup = new ThreadGroup((ThreadGroup)object, this.schedulerInstanceName + "-SimpleThreadPool");
            if (this.isMakeThreadsDaemons()) {
                this.threadGroup.setDaemon(true);
            }
        }
        if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
            this.getLog().info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
        }
        SimpleThreadPool simpleThreadPool = this;
        for (SimpleThreadPool$WorkerThread simpleThreadPool$WorkerThread : simpleThreadPool.createWorkerThreads(simpleThreadPool.count)) {
            simpleThreadPool$WorkerThread.start();
            this.availWorkers.add(simpleThreadPool$WorkerThread);
        }
    }

    protected List<SimpleThreadPool$WorkerThread> createWorkerThreads(int n) {
        this.workers = new LinkedList<SimpleThreadPool$WorkerThread>();
        for (int i = 1; i <= n; ++i) {
            Object object = this.getThreadNamePrefix();
            if (object == null) {
                object = this.schedulerInstanceName + "_Worker";
            }
            SimpleThreadPool simpleThreadPool = this;
            object = new SimpleThreadPool$WorkerThread(simpleThreadPool, simpleThreadPool, this.threadGroup, (String)object + "-" + i, this.getThreadPriority(), this.isMakeThreadsDaemons());
            if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
                ((Thread)object).setContextClassLoader(Thread.currentThread().getContextClassLoader());
            }
            this.workers.add((SimpleThreadPool$WorkerThread)object);
        }
        return this.workers;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    @Override
    public void shutdown(boolean bl) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.getLog().debug("Shutting down threadpool...");
            this.isShutdown = true;
            if (this.workers == null) {
                return;
            }
            for (SimpleThreadPool$WorkerThread simpleThreadPool$WorkerThread : this.workers) {
                simpleThreadPool$WorkerThread.shutdown();
                this.availWorkers.remove(simpleThreadPool$WorkerThread);
            }
            this.nextRunnableLock.notifyAll();
            if (bl) {
                boolean bl2 = false;
                try {
                    while (this.handoffPending) {
                        try {
                            this.nextRunnableLock.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                    while (this.busyWorkers.size() > 0) {
                        SimpleThreadPool$WorkerThread simpleThreadPool$WorkerThread = this.busyWorkers.getFirst();
                        try {
                            this.getLog().debug("Waiting for thread " + simpleThreadPool$WorkerThread.getName() + " to shut down");
                            this.nextRunnableLock.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                    Iterator<SimpleThreadPool$WorkerThread> iterator = this.workers.iterator();
                    while (iterator.hasNext()) {
                        SimpleThreadPool$WorkerThread simpleThreadPool$WorkerThread = iterator.next();
                        try {
                            simpleThreadPool$WorkerThread.join();
                            iterator.remove();
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                }
                finally {
                    if (bl2) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.getLog().debug("No executing jobs remaining, all threads stopped.");
            }
            this.getLog().debug("Shutdown of threadpool complete.");
            return;
        }
    }

    @Override
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.handoffPending = true;
            while (this.availWorkers.size() <= 0 && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.isShutdown) {
                SimpleThreadPool$WorkerThread simpleThreadPool$WorkerThread = this.availWorkers.removeFirst();
                this.busyWorkers.add(simpleThreadPool$WorkerThread);
                simpleThreadPool$WorkerThread.run(runnable);
            } else {
                SimpleThreadPool simpleThreadPool = this;
                SimpleThreadPool$WorkerThread simpleThreadPool$WorkerThread = new SimpleThreadPool$WorkerThread(simpleThreadPool, simpleThreadPool, this.threadGroup, "WorkerThread-LastJob", this.prio, this.isMakeThreadsDaemons(), runnable);
                this.busyWorkers.add(simpleThreadPool$WorkerThread);
                this.workers.add(simpleThreadPool$WorkerThread);
                simpleThreadPool$WorkerThread.start();
            }
            this.nextRunnableLock.notifyAll();
            this.handoffPending = false;
        }
        return true;
    }

    @Override
    public int blockForAvailableThreads() {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            while ((this.availWorkers.size() <= 0 || this.handoffPending) && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.availWorkers.size();
        }
    }

    protected void makeAvailable(SimpleThreadPool$WorkerThread simpleThreadPool$WorkerThread) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            if (!this.isShutdown) {
                this.availWorkers.add(simpleThreadPool$WorkerThread);
            }
            this.busyWorkers.remove(simpleThreadPool$WorkerThread);
            this.nextRunnableLock.notifyAll();
            return;
        }
    }

    protected void clearFromBusyWorkersList(SimpleThreadPool$WorkerThread simpleThreadPool$WorkerThread) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.busyWorkers.remove(simpleThreadPool$WorkerThread);
            this.nextRunnableLock.notifyAll();
            return;
        }
    }
}

