/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils.counter.sampled;

import org.quartz.utils.counter.Counter;
import org.quartz.utils.counter.CounterConfig;
import org.quartz.utils.counter.sampled.SampledCounterImpl;

public class SampledCounterConfig
extends CounterConfig {
    private final int intervalSecs;
    private final int historySize;
    private final boolean isReset;

    public SampledCounterConfig(int n, int n2, boolean bl, long l) {
        super(l);
        if (n <= 0) {
            throw new IllegalArgumentException("Interval (" + n + ") must be greater than or equal to 1");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("History size (" + n2 + ") must be greater than or equal to 1");
        }
        this.intervalSecs = n;
        this.historySize = n2;
        this.isReset = bl;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getIntervalSecs() {
        return this.intervalSecs;
    }

    public boolean isResetOnSample() {
        return this.isReset;
    }

    @Override
    public Counter createCounter() {
        return new SampledCounterImpl(this);
    }
}

