/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.LinkedHashMap;
import java.util.Map;

public final class CFFOperator {
    private static final Map<Integer, String> keyMap = new LinkedHashMap<Integer, String>(52);

    private CFFOperator() {
    }

    private static void register(int n, String string) {
        CFFOperator.register(n, 0, string);
    }

    private static void register(int n, int n2, String string) {
        keyMap.put(CFFOperator.calculateKey(n, n2), string);
    }

    public static String getOperator(int n) {
        return CFFOperator.getOperator(n, 0);
    }

    public static String getOperator(int n, int n2) {
        return keyMap.get(CFFOperator.calculateKey(n, n2));
    }

    private static int calculateKey(int n, int n2) {
        return (n2 << 8) + n;
    }

    static {
        CFFOperator.register(0, "version");
        CFFOperator.register(1, "Notice");
        CFFOperator.register(12, 0, "Copyright");
        CFFOperator.register(2, "FullName");
        CFFOperator.register(3, "FamilyName");
        CFFOperator.register(4, "Weight");
        CFFOperator.register(12, 1, "isFixedPitch");
        CFFOperator.register(12, 2, "ItalicAngle");
        CFFOperator.register(12, 3, "UnderlinePosition");
        CFFOperator.register(12, 4, "UnderlineThickness");
        CFFOperator.register(12, 5, "PaintType");
        CFFOperator.register(12, 6, "CharstringType");
        CFFOperator.register(12, 7, "FontMatrix");
        CFFOperator.register(13, "UniqueID");
        CFFOperator.register(5, "FontBBox");
        CFFOperator.register(12, 8, "StrokeWidth");
        CFFOperator.register(14, "XUID");
        CFFOperator.register(15, "charset");
        CFFOperator.register(16, "Encoding");
        CFFOperator.register(17, "CharStrings");
        CFFOperator.register(18, "Private");
        CFFOperator.register(12, 20, "SyntheticBase");
        CFFOperator.register(12, 21, "PostScript");
        CFFOperator.register(12, 22, "BaseFontName");
        CFFOperator.register(12, 23, "BaseFontBlend");
        CFFOperator.register(12, 30, "ROS");
        CFFOperator.register(12, 31, "CIDFontVersion");
        CFFOperator.register(12, 32, "CIDFontRevision");
        CFFOperator.register(12, 33, "CIDFontType");
        CFFOperator.register(12, 34, "CIDCount");
        CFFOperator.register(12, 35, "UIDBase");
        CFFOperator.register(12, 36, "FDArray");
        CFFOperator.register(12, 37, "FDSelect");
        CFFOperator.register(12, 38, "FontName");
        CFFOperator.register(6, "BlueValues");
        CFFOperator.register(7, "OtherBlues");
        CFFOperator.register(8, "FamilyBlues");
        CFFOperator.register(9, "FamilyOtherBlues");
        CFFOperator.register(12, 9, "BlueScale");
        CFFOperator.register(12, 10, "BlueShift");
        CFFOperator.register(12, 11, "BlueFuzz");
        CFFOperator.register(10, "StdHW");
        CFFOperator.register(11, "StdVW");
        CFFOperator.register(12, 12, "StemSnapH");
        CFFOperator.register(12, 13, "StemSnapV");
        CFFOperator.register(12, 14, "ForceBold");
        CFFOperator.register(12, 15, "LanguageGroup");
        CFFOperator.register(12, 16, "ExpansionFactor");
        CFFOperator.register(12, 17, "initialRandomSeed");
        CFFOperator.register(19, "Subrs");
        CFFOperator.register(20, "defaultWidthX");
        CFFOperator.register(21, "nominalWidthX");
    }
}

