/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.GeneralPath;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.EncodedFont;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFType1Font$PrivateType1CharStringReader;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.fontbox.cff.Type2CharStringParser;

public class CFFType1Font
extends CFFFont
implements EncodedFont {
    private final Map<String, Object> privateDict = new LinkedHashMap<String, Object>();
    private CFFEncoding encoding;
    private final Map<Integer, Type2CharString> charStringCache = new ConcurrentHashMap<Integer, Type2CharString>();
    private final CFFType1Font$PrivateType1CharStringReader reader = new CFFType1Font$PrivateType1CharStringReader(this, null);
    private Type2CharStringParser charStringParser = null;
    private int defaultWidthX = Integer.MIN_VALUE;
    private int nominalWidthX = Integer.MIN_VALUE;
    private byte[][] localSubrIndex;

    @Override
    public GeneralPath getPath(String string) {
        return this.getType1CharString(string).getPath();
    }

    @Override
    public float getWidth(String string) {
        return this.getType1CharString(string).getWidth();
    }

    @Override
    public boolean hasGlyph(String string) {
        int n = this.getCharset().getSID(string);
        n = this.getCharset().getGIDForSID(n);
        return n != 0;
    }

    public Type1CharString getType1CharString(String string) {
        int n = this.nameToGID(string);
        return this.getType2CharString(n, string);
    }

    public int nameToGID(String string) {
        int n = this.getCharset().getSID(string);
        return this.getCharset().getGIDForSID(n);
    }

    @Override
    public Type2CharString getType2CharString(int n) {
        String string = "GID+" + n;
        return this.getType2CharString(n, string);
    }

    private Type2CharString getType2CharString(int n, String string) {
        Object object = this.charStringCache.get(n);
        if (object == null) {
            object = null;
            if (n < this.charStrings.length) {
                object = this.charStrings[n];
            }
            if (object == null) {
                object = this.charStrings[0];
            }
            object = this.getParser().parse((byte[])object, this.globalSubrIndex, this.getLocalSubrIndex(), string);
            object = new Type2CharString(this.reader, this.getName(), string, n, (List<Object>)object, this.getDefaultWidthX(), this.getNominalWidthX());
            this.charStringCache.put(n, (Type2CharString)object);
        }
        return object;
    }

    private Type2CharStringParser getParser() {
        if (this.charStringParser == null) {
            this.charStringParser = new Type2CharStringParser(this.getName());
        }
        return this.charStringParser;
    }

    public Map<String, Object> getPrivateDict() {
        return this.privateDict;
    }

    void addToPrivateDict(String string, Object object) {
        if (object != null) {
            this.privateDict.put(string, object);
        }
    }

    @Override
    public CFFEncoding getEncoding() {
        return this.encoding;
    }

    void setEncoding(CFFEncoding cFFEncoding) {
        this.encoding = cFFEncoding;
    }

    private byte[][] getLocalSubrIndex() {
        if (this.localSubrIndex == null) {
            this.localSubrIndex = (byte[][])this.privateDict.get("Subrs");
        }
        return this.localSubrIndex;
    }

    private Object getProperty(String string) {
        Object v = this.topDict.get(string);
        if (v != null) {
            return v;
        }
        return this.privateDict.get(string);
    }

    private int getDefaultWidthX() {
        if (this.defaultWidthX == Integer.MIN_VALUE) {
            Number number = (Number)this.getProperty("defaultWidthX");
            this.defaultWidthX = number != null ? number.intValue() : 1000;
        }
        return this.defaultWidthX;
    }

    private int getNominalWidthX() {
        if (this.nominalWidthX == Integer.MIN_VALUE) {
            Number number = (Number)this.getProperty("nominalWidthX");
            this.nominalWidthX = number != null ? number.intValue() : 0;
        }
        return this.nominalWidthX;
    }
}

