/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor$DefaultImpls;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ValueParameterDescriptorImpl$Companion;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.VariableDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements ValueParameterDescriptor {
    public static final ValueParameterDescriptorImpl$Companion Companion = new ValueParameterDescriptorImpl$Companion(null);
    private final int index;
    private final boolean declaresDefaultValue;
    private final boolean isCrossinline;
    private final boolean isNoinline;
    private final KotlinType varargElementType;
    private final ValueParameterDescriptor original;

    public ValueParameterDescriptorImpl(CallableDescriptor callableDescriptor, ValueParameterDescriptor valueParameterDescriptor, int n, Annotations annotations2, Name name, KotlinType kotlinType, boolean bl, boolean bl2, boolean bl3, KotlinType kotlinType2, SourceElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
        super(callableDescriptor, annotations2, name, kotlinType, sourceElement);
        this.index = n;
        this.declaresDefaultValue = bl;
        this.isCrossinline = bl2;
        this.isNoinline = bl3;
        this.varargElementType = kotlinType2;
        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
        if (valueParameterDescriptor2 == null) {
            valueParameterDescriptor2 = this;
        }
        this.original = valueParameterDescriptor2;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isCrossinline() {
        return this.isCrossinline;
    }

    @Override
    public boolean isNoinline() {
        return this.isNoinline;
    }

    @Override
    public KotlinType getVarargElementType() {
        return this.varargElementType;
    }

    @Override
    public CallableDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = super.getContainingDeclaration();
        Intrinsics.checkNotNull((Object)declarationDescriptor);
        return (CallableDescriptor)declarationDescriptor;
    }

    @Override
    public boolean declaresDefaultValue() {
        if (this.declaresDefaultValue) {
            CallableDescriptor callableDescriptor = this.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)callableDescriptor);
            if (((CallableMemberDescriptor)callableDescriptor).getKind().isReal()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ValueParameterDescriptor getOriginal() {
        if (this.original == this) {
            return this;
        }
        return this.original.getOriginal();
    }

    @Override
    public ValueParameterDescriptor substitute(TypeSubstitutor typeSubstitutor2) {
        Intrinsics.checkNotNullParameter((Object)typeSubstitutor2, (String)"");
        if (typeSubstitutor2.isEmpty()) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> declarationDescriptorVisitor, D d) {
        Intrinsics.checkNotNullParameter(declarationDescriptorVisitor, (String)"");
        return declarationDescriptorVisitor.visitValueParameterDescriptor(this, d);
    }

    @Override
    public boolean isVar() {
        return false;
    }

    public Void getCompileTimeInitializer() {
        return null;
    }

    @Override
    public ValueParameterDescriptor copy(CallableDescriptor callableDescriptor, Name name, int n) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Annotations annotations2 = this.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"");
        KotlinType kotlinType = this.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        boolean bl = this.declaresDefaultValue();
        boolean bl2 = this.isCrossinline();
        boolean bl3 = this.isNoinline();
        KotlinType kotlinType2 = this.getVarargElementType();
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
        return new ValueParameterDescriptorImpl(callableDescriptor, null, n, annotations2, name, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
    }

    @Override
    public DescriptorVisibility getVisibility() {
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
        return descriptorVisibility;
    }

    @Override
    public Collection<ValueParameterDescriptor> getOverriddenDescriptors() {
        Collection<? extends CallableDescriptor> collection = this.getContainingDeclaration().getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        Iterable iterable = collection;
        Object object = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (CallableDescriptor)object2;
            Iterable iterable2 = iterable;
            iterable2.add(object2.getValueParameters().get(this.getIndex()));
        }
        return (List)iterable;
    }

    @Override
    public boolean isLateInit() {
        return ValueParameterDescriptor$DefaultImpls.isLateInit(this);
    }

    @JvmStatic
    public static final ValueParameterDescriptorImpl createWithDestructuringDeclarations(CallableDescriptor callableDescriptor, ValueParameterDescriptor valueParameterDescriptor, int n, Annotations annotations2, Name name, KotlinType kotlinType, boolean bl, boolean bl2, boolean bl3, KotlinType kotlinType2, SourceElement sourceElement, Function0<? extends List<? extends VariableDescriptor>> function0) {
        return Companion.createWithDestructuringDeclarations(callableDescriptor, valueParameterDescriptor, n, annotations2, name, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement, function0);
    }
}

