/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.reflect.jvm.internal.impl.protobuf.FieldSet$FieldDescriptorLite;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap$1;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap$EmptySet;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap$Entry;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap$EntrySet;

class SmallSortedMap<K extends Comparable<K>, V>
extends AbstractMap<K, V> {
    private final int maxArraySize;
    private List<SmallSortedMap$Entry> entryList;
    private Map<K, V> overflowEntries;
    private boolean isImmutable;
    private volatile SmallSortedMap$EntrySet lazyEntrySet;

    static <FieldDescriptorType extends FieldSet$FieldDescriptorLite<FieldDescriptorType>> SmallSortedMap<FieldDescriptorType, Object> newFieldMap(int n) {
        return new SmallSortedMap$1(n);
    }

    private SmallSortedMap(int n) {
        this.maxArraySize = n;
        this.entryList = Collections.emptyList();
        this.overflowEntries = Collections.emptyMap();
    }

    public void makeImmutable() {
        if (!this.isImmutable) {
            this.overflowEntries = this.overflowEntries.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntries);
            this.isImmutable = true;
        }
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public int getNumArrayEntries() {
        return this.entryList.size();
    }

    public Map.Entry<K, V> getArrayEntryAt(int n) {
        return this.entryList.get(n);
    }

    public Iterable<Map.Entry<K, V>> getOverflowEntries() {
        if (this.overflowEntries.isEmpty()) {
            return SmallSortedMap$EmptySet.iterable();
        }
        return this.overflowEntries.entrySet();
    }

    @Override
    public int size() {
        return this.entryList.size() + this.overflowEntries.size();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.binarySearchInArray(object = (Comparable)object) >= 0 || this.overflowEntries.containsKey(object);
    }

    @Override
    public V get(Object object) {
        int n = this.binarySearchInArray(object = (Comparable)object);
        if (n >= 0) {
            return this.entryList.get(n).getValue();
        }
        return this.overflowEntries.get(object);
    }

    @Override
    public V put(K k, V v) {
        this.checkMutable();
        int n = this.binarySearchInArray(k);
        if (n >= 0) {
            return this.entryList.get(n).setValue(v);
        }
        this.ensureEntryArrayMutable();
        n = -(n + 1);
        if (n >= this.maxArraySize) {
            return this.getOverflowEntriesMutable().put(k, v);
        }
        if (this.entryList.size() == this.maxArraySize) {
            SmallSortedMap$Entry smallSortedMap$Entry = this.entryList.remove(this.maxArraySize - 1);
            this.getOverflowEntriesMutable().put(smallSortedMap$Entry.getKey(), smallSortedMap$Entry.getValue());
        }
        this.entryList.add(n, new SmallSortedMap$Entry(this, k, v));
        return null;
    }

    @Override
    public void clear() {
        this.checkMutable();
        if (!this.entryList.isEmpty()) {
            this.entryList.clear();
        }
        if (!this.overflowEntries.isEmpty()) {
            this.overflowEntries.clear();
        }
    }

    @Override
    public V remove(Object object) {
        this.checkMutable();
        object = (Comparable)object;
        int n = this.binarySearchInArray(object);
        if (n >= 0) {
            return this.removeArrayEntryAt(n);
        }
        if (this.overflowEntries.isEmpty()) {
            return null;
        }
        return this.overflowEntries.remove(object);
    }

    private V removeArrayEntryAt(int n) {
        this.checkMutable();
        Object v = this.entryList.remove(n).getValue();
        if (!this.overflowEntries.isEmpty()) {
            Iterator<Map.Entry<K, V>> iterator2 = this.getOverflowEntriesMutable().entrySet().iterator();
            this.entryList.add(new SmallSortedMap$Entry(this, iterator2.next()));
            iterator2.remove();
        }
        return v;
    }

    private int binarySearchInArray(K k) {
        int n;
        int n2 = 0;
        int n3 = this.entryList.size() - 1;
        if (n3 >= 0) {
            n = k.compareTo((Object)this.entryList.get(n3).getKey());
            if (n > 0) {
                return -(n3 + 2);
            }
            if (n == 0) {
                return n3;
            }
        }
        while (n2 <= n3) {
            n = (n2 + n3) / 2;
            int n4 = k.compareTo((Object)this.entryList.get(n).getKey());
            if (n4 < 0) {
                n3 = n - 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n + 1;
                continue;
            }
            return n;
        }
        return -(n2 + 1);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.lazyEntrySet == null) {
            this.lazyEntrySet = new SmallSortedMap$EntrySet(this, null);
        }
        return this.lazyEntrySet;
    }

    private void checkMutable() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException();
        }
    }

    private SortedMap<K, V> getOverflowEntriesMutable() {
        this.checkMutable();
        if (this.overflowEntries.isEmpty() && !(this.overflowEntries instanceof TreeMap)) {
            this.overflowEntries = new TreeMap();
        }
        return (SortedMap)this.overflowEntries;
    }

    private void ensureEntryArrayMutable() {
        this.checkMutable();
        if (this.entryList.isEmpty() && !(this.entryList instanceof ArrayList)) {
            this.entryList = new ArrayList<SmallSortedMap$Entry>(this.maxArraySize);
        }
    }

    /* synthetic */ SmallSortedMap(int n, SmallSortedMap$1 smallSortedMap$1) {
        this(n);
    }

    static /* synthetic */ void access$200(SmallSortedMap smallSortedMap) {
        smallSortedMap.checkMutable();
    }

    static /* synthetic */ List access$400(SmallSortedMap smallSortedMap) {
        return smallSortedMap.entryList;
    }

    static /* synthetic */ Object access$500(SmallSortedMap smallSortedMap, int n) {
        return smallSortedMap.removeArrayEntryAt(n);
    }

    static /* synthetic */ Map access$600(SmallSortedMap smallSortedMap) {
        return smallSortedMap.overflowEntries;
    }
}

