/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaResolverCache;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaPackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageFragment;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public final class JavaDescriptorResolver {
    private final LazyJavaPackageFragmentProvider packageFragmentProvider;
    private final JavaResolverCache javaResolverCache;

    public JavaDescriptorResolver(LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider, JavaResolverCache javaResolverCache) {
        Intrinsics.checkNotNullParameter((Object)lazyJavaPackageFragmentProvider, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaResolverCache, (String)"");
        this.packageFragmentProvider = lazyJavaPackageFragmentProvider;
        this.javaResolverCache = javaResolverCache;
    }

    public final LazyJavaPackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    public final ClassDescriptor resolveClass(JavaClass object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object2 = object.getFqName();
        if (object2 != null && object.getLightClassOriginKind() == LightClassOriginKind.SOURCE) {
            return this.javaResolverCache.getClassResolvedFromSource((FqName)object2);
        }
        JavaClass javaClass = object.getOuterClass();
        if (javaClass != null) {
            object2 = javaClass;
            ClassDescriptor classDescriptor = this.resolveClass((JavaClass)object2);
            object2 = classDescriptor != null ? classDescriptor.getUnsubstitutedInnerClassesScope() : null;
            object = object2 != null ? object2.getContributedClassifier(object.getName(), NoLookupLocation.FROM_JAVA_LOADER) : null;
            if (object instanceof ClassDescriptor) {
                return (ClassDescriptor)object;
            }
            return null;
        }
        if (object2 == null) {
            return null;
        }
        FqName fqName2 = ((FqName)object2).parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        LazyJavaPackageFragment lazyJavaPackageFragment = (LazyJavaPackageFragment)CollectionsKt.firstOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (lazyJavaPackageFragment != null) {
            return lazyJavaPackageFragment.findClassifierByJavaClass$descriptors_jvm((JavaClass)object);
        }
        return null;
    }
}

