/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp.datasources.PooledConnectionManager;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements ConnectionEventListener,
PooledConnectionManager,
PoolableObjectFactory {
    private final ConnectionPoolDataSource a;
    private final String b;
    private final boolean c;
    private final ObjectPool d;
    private String e = null;
    private String f = null;
    private final Map g = new HashMap();
    private final WeakHashMap h = new WeakHashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, ObjectPool objectPool, String string, boolean bl, String string2, String string3) {
        this.a = connectionPoolDataSource;
        this.d = objectPool;
        objectPool.a((PoolableObjectFactory)this);
        this.b = string;
        this.e = string2;
        this.f = string3;
        this.c = bl;
    }

    public final ObjectPool a() {
        return this.d;
    }

    public final synchronized Object b() {
        PooledConnectionAndInfo pooledConnectionAndInfo;
        try {
            PooledConnection pooledConnection = this.e == null ? this.a.getPooledConnection() : this.a.getPooledConnection(this.e, this.f);
            if (pooledConnection == null) {
                throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
            }
            pooledConnection.addConnectionEventListener(this);
            pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, this.e, this.f);
            this.h.put(pooledConnection, pooledConnectionAndInfo);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
        return pooledConnectionAndInfo;
    }

    public final void a(Object object) {
        if (object instanceof PooledConnectionAndInfo) {
            object = ((PooledConnectionAndInfo)object).a();
            object.removeConnectionEventListener(this);
            this.h.remove(object);
            object.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean b(Object object) {
        boolean bl;
        Statement statement;
        Connection connection;
        PooledConnection pooledConnection;
        block32: {
            if (!(object instanceof PooledConnectionAndInfo)) {
                return false;
            }
            pooledConnection = ((PooledConnectionAndInfo)object).a();
            object = this.b;
            if (object == null) {
                return true;
            }
            connection = null;
            statement = null;
            ResultSet resultSet = null;
            this.g.put(pooledConnection, null);
            try {
                connection = pooledConnection.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery((String)object);
                bl = resultSet.next();
                if (this.c) {
                    connection.rollback();
                }
                if (resultSet == null) break block32;
            }
            catch (Exception exception) {
                bl = false;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {}
                }
                this.g.remove(pooledConnection);
                return bl;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable4) {}
                }
                this.g.remove(pooledConnection);
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable throwable) {}
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Throwable throwable) {}
        }
        this.g.remove(pooledConnection);
        return bl;
    }

    public final void c(Object object) {
    }

    public final void d(Object object) {
    }

    @Override
    public void connectionClosed(ConnectionEvent object) {
        if (!this.g.containsKey(object = (PooledConnection)((EventObject)object).getSource())) {
            Object v = this.h.get(object);
            if (v == null) {
                throw new IllegalStateException("close() was called on a Connection, but I have no record of the underlying PooledConnection.");
            }
            try {
                this.d.a(v);
                return;
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                object.removeConnectionEventListener(this);
                try {
                    this.a(v);
                    return;
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + v);
                    exception2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        connectionEvent = this.h.get(pooledConnection);
        if (connectionEvent == null) {
            throw new IllegalStateException("close() was called on a Connection, but I have no record of the underlying PooledConnection.");
        }
        try {
            this.d.b((Object)connectionEvent);
            return;
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + connectionEvent);
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public final void a(PooledConnection pooledConnection) {
        if ((pooledConnection = this.h.get(pooledConnection)) == null) {
            throw new IllegalStateException("close() was called on a Connection, but I have no record of the underlying PooledConnection.");
        }
        try {
            this.d.b((Object)pooledConnection);
            this.d.f();
            return;
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error invalidating connection").initCause(exception);
        }
    }

    @Override
    public final synchronized void a(String string) {
        this.f = string;
    }

    @Override
    public final void b(String string) {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (string == null || !string.equals(this.e)) {
                return;
            }
        }
        try {
            this.d.f();
            return;
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error closing connection pool").initCause(exception);
        }
    }
}

