/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.javax;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEventListener;
import org.sqlite.SQLiteConnection;
import org.sqlite.javax.SQLitePooledConnection$1;
import org.sqlite.jdbc4.JDBC4PooledConnection;

public class SQLitePooledConnection
extends JDBC4PooledConnection {
    protected SQLiteConnection physicalConn;
    protected volatile Connection handleConn;
    protected List<ConnectionEventListener> listeners = new ArrayList<ConnectionEventListener>();

    protected SQLitePooledConnection(SQLiteConnection sQLiteConnection) {
        this.physicalConn = sQLiteConnection;
    }

    public SQLiteConnection getPhysicalConn() {
        return this.physicalConn;
    }

    @Override
    public void close() {
        if (this.handleConn != null) {
            this.listeners.clear();
            this.handleConn.close();
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
                return;
            }
            finally {
                this.physicalConn = null;
            }
        }
    }

    @Override
    public Connection getConnection() {
        if (this.handleConn != null) {
            this.handleConn.close();
        }
        this.handleConn = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new SQLitePooledConnection$1(this));
        return this.handleConn;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    public List<ConnectionEventListener> getListeners() {
        return this.listeners;
    }
}

