/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileStoreUtil {
    static final String PATH_CLASS_STR = "java.nio.file.Path";
    static final String FILES_CLASS_STR = "java.nio.file.Files";

    public static boolean areOnSameFileStore(File file, File file2) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File [" + String.valueOf(file) + "] does not exist.");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("File [" + String.valueOf(file2) + "] does not exist.");
        }
        try {
            Object object = file.toPath();
            Object object2 = file2.toPath();
            object = Files.getFileStore((Path)object);
            object2 = Files.getFileStore((Path)object2);
            return object.equals(object2);
        }
        catch (Exception exception) {
            throw new RolloverFailure("Failed to check file store equality for [" + String.valueOf(file) + "] and [" + String.valueOf(file2) + "]", exception);
        }
    }
}

