/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public final class FilteredAnnotations
implements Annotations {
    private final Annotations delegate;
    private final boolean isDefinitelyNewInference;
    private final Function1<FqName, Boolean> fqNameFilter;

    public FilteredAnnotations(Annotations annotations2, boolean bl, Function1<? super FqName, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.delegate = annotations2;
        this.isDefinitelyNewInference = bl;
        this.fqNameFilter = function1;
    }

    public FilteredAnnotations(Annotations annotations2, Function1<? super FqName, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this(annotations2, false, function1);
    }

    @Override
    public final boolean hasAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        if (((Boolean)this.fqNameFilter.invoke((Object)fqName2)).booleanValue()) {
            return this.delegate.hasAnnotation(fqName2);
        }
        return false;
    }

    @Override
    public final AnnotationDescriptor findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        if (((Boolean)this.fqNameFilter.invoke((Object)fqName2)).booleanValue()) {
            return this.delegate.findAnnotation(fqName2);
        }
        return null;
    }

    @Override
    public final Iterator<AnnotationDescriptor> iterator() {
        Object object = this.delegate;
        Collection collection = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)e;
            if (!this.shouldBeReturned(annotationDescriptor)) continue;
            collection.add(e);
        }
        return ((List)collection).iterator();
    }

    @Override
    public final boolean isEmpty() {
        boolean bl;
        boolean bl2;
        Object object = this.delegate;
        if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                if (!this.shouldBeReturned((AnnotationDescriptor)(object2 = (AnnotationDescriptor)object2))) continue;
                bl2 = true;
                break;
            }
        } else {
            bl2 = bl = false;
        }
        if (this.isDefinitelyNewInference) {
            return !bl;
        }
        return bl;
    }

    private final boolean shouldBeReturned(AnnotationDescriptor object) {
        return (object = object.getFqName()) != null && (Boolean)this.fqNameFilter.invoke(object) != false;
    }
}

