/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.MultiFieldValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;

public final class InlineClassesUtilsKt {
    private static final FqName JVM_INLINE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmInline");
    private static final ClassId JVM_INLINE_ANNOTATION_CLASS_ID;

    public static final boolean isInlineClass(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return declarationDescriptor instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final boolean isMultiFieldValueClass(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return declarationDescriptor instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).getValueClassRepresentation() instanceof MultiFieldValueClassRepresentation;
    }

    public static final boolean isValueClass(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return InlineClassesUtilsKt.isInlineClass(declarationDescriptor) || InlineClassesUtilsKt.isMultiFieldValueClass(declarationDescriptor);
    }

    public static final KotlinType unsubstitutedUnderlyingType(KotlinType annotated) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"");
        annotated = annotated.getConstructor().getDeclarationDescriptor();
        Object object = annotated instanceof ClassDescriptor ? (ClassDescriptor)annotated : null;
        return object != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? (SimpleType)((InlineClassRepresentation)object).getUnderlyingType() : null;
    }

    public static final boolean isInlineClassType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            return InlineClassesUtilsKt.isInlineClass(classifierDescriptor);
        }
        return false;
    }

    public static final boolean isValueClassType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            return InlineClassesUtilsKt.isValueClass(classifierDescriptor);
        }
        return false;
    }

    public static final boolean needsMfvcFlattening(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            return InlineClassesUtilsKt.isMultiFieldValueClass(classifierDescriptor) && !SimpleClassicTypeSystemContext.INSTANCE.isNullableType(kotlinType);
        }
        return false;
    }

    public static final KotlinType substitutedUnderlyingType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = InlineClassesUtilsKt.unsubstitutedUnderlyingType(kotlinType);
        if (kotlinType2 != null) {
            KotlinType kotlinType3 = kotlinType2;
            return TypeSubstitutor.create(kotlinType).substitute(kotlinType3, Variance.INVARIANT);
        }
        return null;
    }

    public static final boolean isGetterOfUnderlyingPropertyOfValueClass(CallableDescriptor callableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        if (callableDescriptor instanceof PropertyGetterDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)callableDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"");
            if (InlineClassesUtilsKt.isUnderlyingPropertyOfValueClass(propertyDescriptor)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isUnderlyingPropertyOfInlineClass(VariableDescriptor variableDescriptor) {
        DeclarationDescriptor declarationDescriptor;
        Object object;
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"");
        return variableDescriptor.getExtensionReceiverParameter() == null && Intrinsics.areEqual((Object)((object = (declarationDescriptor = variableDescriptor.getContainingDeclaration()) instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? ((InlineClassRepresentation)object).getUnderlyingPropertyName() : null), (Object)variableDescriptor.getName());
    }

    public static final boolean isUnderlyingPropertyOfValueClass(VariableDescriptor variableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"");
        if (variableDescriptor.getExtensionReceiverParameter() == null) {
            boolean bl;
            DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
            Object object = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (object != null && (object = object.getValueClassRepresentation()) != null) {
                Name name = variableDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                bl = ((ValueClassRepresentation)object).containsPropertyWithName(name);
            } else {
                bl = false;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    static {
        ClassId classId = ClassId.topLevel(JVM_INLINE_ANNOTATION_FQ_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"");
        JVM_INLINE_ANNOTATION_CLASS_ID = classId;
    }
}

