/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreResultSet;
import org.sqlite.core.DB;
import org.sqlite.core.SafeStmtPtr;
import org.sqlite.jdbc3.JDBC3Connection;
import org.sqlite.jdbc4.JDBC4ResultSet;

public abstract class CoreStatement
implements Codes {
    public final SQLiteConnection conn;
    protected final CoreResultSet rs;
    public SafeStmtPtr pointer;
    protected String sql = null;
    protected int batchPos;
    protected Object[] batch = null;
    protected boolean resultsWaiting = false;

    protected CoreStatement(SQLiteConnection sQLiteConnection) {
        this.conn = sQLiteConnection;
        this.rs = new JDBC4ResultSet(this);
    }

    public DB getDatabase() {
        return this.conn.getDatabase();
    }

    public SQLiteConnectionConfig getConnectionConfig() {
        return this.conn.getConnectionConfig();
    }

    protected final void checkOpen() {
        if (this.pointer.isClosed()) {
            throw new SQLException("statement is not executing");
        }
    }

    boolean isOpen() {
        return !this.pointer.isClosed();
    }

    protected boolean exec() {
        if (this.sql == null) {
            throw new SQLException("SQLiteJDBC internal error: sql==null");
        }
        if (this.rs.isOpen()) {
            throw new SQLException("SQLite JDBC internal error: rs.isOpen() on exec.");
        }
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        boolean bl = false;
        try {
            bl = this.conn.getDatabase().execute(this, null);
            this.notifyFirstStatementExecuted();
            this.resultsWaiting = bl;
        }
        catch (Throwable throwable) {
            this.notifyFirstStatementExecuted();
            this.resultsWaiting = bl;
            this.pointer.close();
            throw throwable;
        }
        return this.pointer.safeRunInt(DB::column_count) != 0;
    }

    protected boolean exec(String string) {
        if (string == null) {
            throw new SQLException("SQLiteJDBC internal error: sql==null");
        }
        if (this.rs.isOpen()) {
            throw new SQLException("SQLite JDBC internal error: rs.isOpen() on exec.");
        }
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        boolean bl = false;
        try {
            bl = this.conn.getDatabase().execute(string, this.conn.getAutoCommit());
            this.notifyFirstStatementExecuted();
            this.resultsWaiting = bl;
        }
        catch (Throwable throwable) {
            this.notifyFirstStatementExecuted();
            this.resultsWaiting = bl;
            if (this.pointer != null) {
                this.pointer.close();
            }
            throw throwable;
        }
        return this.pointer.safeRunInt(DB::column_count) != 0;
    }

    protected void internalClose() {
        if (this.pointer != null && !this.pointer.isClosed()) {
            if (this.conn.isClosed()) {
                throw DB.newSQLException(1, "Connection is closed");
            }
            this.rs.close();
            this.batch = null;
            this.batchPos = 0;
            int n = this.pointer.close();
            if (n != 0 && n != 21) {
                this.conn.getDatabase().throwex(n);
            }
        }
    }

    protected void notifyFirstStatementExecuted() {
        this.conn.setFirstStatementExecuted(true);
    }

    public abstract ResultSet executeQuery(String var1, boolean var2);

    protected void checkIndex(int n) {
        if (n <= 0 || n > this.batch.length) {
            throw new SQLException("Parameter index is invalid");
        }
    }
}

