/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.conditional.IfModel$BranchState;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.OptionHelper;

public class IfModelHandler
extends ModelHandlerBase {
    public static final String MISSING_JANINO_MSG = "Could not find Janino library on the class path. Skipping conditional processing.";
    public static final String MISSING_JANINO_SEE = "See also http://logback.qos.ch/codes.html#ifJanino";
    IfModel ifModel = null;

    public IfModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new IfModelHandler(context);
    }

    protected Class<IfModel> getSupportedModelClass() {
        return IfModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext object, Model model) {
        this.ifModel = (IfModel)model;
        if (!EnvUtil.isJaninoAvailable()) {
            this.addError(MISSING_JANINO_MSG);
            this.addError(MISSING_JANINO_SEE);
            return;
        }
        ((ModelInterpretationContext)object).pushModel(this.ifModel);
        int n = model.getLineNumber();
        String string = this.ifModel.getCondition();
        if (!OptionHelper.isNullOrEmpty(string)) {
            try {
                string = OptionHelper.substVars(string, (PropertyContainer)object, this.context);
            }
            catch (ScanException scanException) {
                this.addError("Failed to parse input [" + string + "] on line " + n, scanException);
                this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
                return;
            }
            try {
                object = new PropertyEvalScriptBuilder((PropertyContainer)object);
                ((ContextAwareBase)object).setContext(this.context);
                object = ((PropertyEvalScriptBuilder)object).build(string);
            }
            catch (Exception | NoClassDefFoundError throwable) {
                this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
                this.addError("Failed to parse condition [" + string + "] on line " + n, throwable);
                return;
            }
            if (object != null) {
                boolean bl = object.evaluate();
                this.addInfo("Condition [" + string + "] evaluated to " + bl + " on line " + n);
                this.ifModel.setBranchState(bl);
                return;
            }
            this.addError("The condition variable is null. This should not occur.");
            this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
            return;
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (modelInterpretationContext.isModelStackEmpty()) {
            this.addError("Unexpected unexpected empty model stack.");
            return;
        }
        model = modelInterpretationContext.peekModel();
        if (model != this.ifModel) {
            this.addWarn("The object [" + String.valueOf(model) + "] on the top the of the stack is not the expected [" + String.valueOf(this.ifModel));
            return;
        }
        modelInterpretationContext.popModel();
    }
}

