/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.SSLConfigurable;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StringCollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class SSLParametersConfiguration
extends ContextAwareBase {
    private String includedProtocols;
    private String excludedProtocols;
    private String includedCipherSuites;
    private String excludedCipherSuites;
    private Boolean needClientAuth;
    private Boolean wantClientAuth;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private Boolean hostnameVerification;

    public void configure(SSLConfigurable sSLConfigurable) {
        sSLConfigurable.setEnabledProtocols(this.enabledProtocols(sSLConfigurable.getSupportedProtocols(), sSLConfigurable.getDefaultProtocols()));
        sSLConfigurable.setEnabledCipherSuites(this.enabledCipherSuites(sSLConfigurable.getSupportedCipherSuites(), sSLConfigurable.getDefaultCipherSuites()));
        if (this.isNeedClientAuth() != null) {
            sSLConfigurable.setNeedClientAuth(this.isNeedClientAuth());
        }
        if (this.isWantClientAuth() != null) {
            sSLConfigurable.setWantClientAuth(this.isWantClientAuth());
        }
        if (this.hostnameVerification != null) {
            SSLParametersConfiguration sSLParametersConfiguration = this;
            sSLParametersConfiguration.addInfo("hostnameVerification=" + sSLParametersConfiguration.hostnameVerification);
            sSLConfigurable.setHostnameVerification(this.hostnameVerification);
        }
    }

    public boolean getHostnameVerification() {
        if (this.hostnameVerification == null) {
            return false;
        }
        return this.hostnameVerification;
    }

    public void setHostnameVerification(boolean bl) {
        this.hostnameVerification = bl;
    }

    private String[] enabledProtocols(String[] stringArray, String[] stringArray2) {
        if (this.enabledProtocols == null) {
            this.enabledProtocols = OptionHelper.isNullOrEmpty(this.getIncludedProtocols()) && OptionHelper.isNullOrEmpty(this.getExcludedProtocols()) ? Arrays.copyOf(stringArray2, stringArray2.length) : this.includedStrings(stringArray, this.getIncludedProtocols(), this.getExcludedProtocols());
            stringArray = this.enabledProtocols;
            int n = this.enabledProtocols.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                this.addInfo("enabled protocol: " + string);
            }
        }
        return this.enabledProtocols;
    }

    private String[] enabledCipherSuites(String[] stringArray, String[] stringArray2) {
        if (this.enabledCipherSuites == null) {
            this.enabledCipherSuites = OptionHelper.isNullOrEmpty(this.getIncludedCipherSuites()) && OptionHelper.isNullOrEmpty(this.getExcludedCipherSuites()) ? Arrays.copyOf(stringArray2, stringArray2.length) : this.includedStrings(stringArray, this.getIncludedCipherSuites(), this.getExcludedCipherSuites());
            stringArray = this.enabledCipherSuites;
            int n = this.enabledCipherSuites.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                this.addInfo("enabled cipher suite: " + string);
            }
        }
        return this.enabledCipherSuites;
    }

    private String[] includedStrings(String[] stringArray, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        arrayList.addAll(Arrays.asList(stringArray));
        if (string != null) {
            StringCollectionUtil.retainMatching(arrayList, this.stringToArray(string));
        }
        if (string2 != null) {
            StringCollectionUtil.removeMatching(arrayList, this.stringToArray(string2));
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private String[] stringToArray(String string) {
        return string.split("\\s*,\\s*");
    }

    public String getIncludedProtocols() {
        return this.includedProtocols;
    }

    public void setIncludedProtocols(String string) {
        this.includedProtocols = string;
    }

    public String getExcludedProtocols() {
        return this.excludedProtocols;
    }

    public void setExcludedProtocols(String string) {
        this.excludedProtocols = string;
    }

    public String getIncludedCipherSuites() {
        return this.includedCipherSuites;
    }

    public void setIncludedCipherSuites(String string) {
        this.includedCipherSuites = string;
    }

    public String getExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    public void setExcludedCipherSuites(String string) {
        this.excludedCipherSuites = string;
    }

    public Boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(Boolean bl) {
        this.needClientAuth = bl;
    }

    public Boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(Boolean bl) {
        this.wantClientAuth = bl;
    }
}

