/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.CmapSubtable$SubHeader;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.TTFDataStream;

public class CmapSubtable
implements CmapLookup {
    private static final Log LOG = LogFactory.getLog(CmapSubtable.class);
    private static final long LEAD_OFFSET = 55232L;
    private static final long SURROGATE_OFFSET = -56613888L;
    private int platformId;
    private int platformEncodingId;
    private long subTableOffset;
    private int[] glyphIdToCharacterCode;
    private final Map<Integer, List<Integer>> glyphIdToCharacterCodeMultiple = new HashMap<Integer, List<Integer>>();
    private Map<Integer, Integer> characterCodeToGlyphId = Collections.emptyMap();

    void initData(TTFDataStream tTFDataStream) {
        this.platformId = tTFDataStream.readUnsignedShort();
        this.platformEncodingId = tTFDataStream.readUnsignedShort();
        this.subTableOffset = tTFDataStream.readUnsignedInt();
    }

    void initSubtable(CmapTable cmapTable, int n, TTFDataStream tTFDataStream) {
        tTFDataStream.seek(cmapTable.getOffset() + this.subTableOffset);
        int n2 = tTFDataStream.readUnsignedShort();
        if (n2 < 8) {
            tTFDataStream.readUnsignedShort();
            tTFDataStream.readUnsignedShort();
        } else {
            tTFDataStream.readUnsignedShort();
            tTFDataStream.readUnsignedInt();
            tTFDataStream.readUnsignedInt();
        }
        switch (n2) {
            case 0: {
                this.processSubtype0(tTFDataStream);
                return;
            }
            case 2: {
                this.processSubtype2(tTFDataStream, n);
                return;
            }
            case 4: {
                this.processSubtype4(tTFDataStream, n);
                return;
            }
            case 6: {
                this.processSubtype6(tTFDataStream, n);
                return;
            }
            case 8: {
                this.processSubtype8(tTFDataStream, n);
                return;
            }
            case 10: {
                this.processSubtype10(tTFDataStream, n);
                return;
            }
            case 12: {
                this.processSubtype12(tTFDataStream, n);
                return;
            }
            case 13: {
                this.processSubtype13(tTFDataStream, n);
                return;
            }
            case 14: {
                this.processSubtype14(tTFDataStream, n);
                return;
            }
        }
        throw new IOException("Unknown cmap format:" + n2);
    }

    void processSubtype8(TTFDataStream tTFDataStream, int n) {
        int[] nArray = tTFDataStream.readUnsignedByteArray(8192);
        long l = tTFDataStream.readUnsignedInt();
        if (l > 65536L) {
            throw new IOException("CMap ( Subtype8 ) is invalid");
        }
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        if (n == 0) {
            LOG.warn((Object)"subtable has no glyphs");
            return;
        }
        for (long i = 0L; i < l; ++i) {
            long l2 = tTFDataStream.readUnsignedInt();
            long l3 = tTFDataStream.readUnsignedInt();
            long l4 = tTFDataStream.readUnsignedInt();
            if (l2 > l3 || 0L > l2) {
                throw new IOException("Range invalid");
            }
            for (long j = l2; j <= l3; ++j) {
                long l5;
                int n2;
                if (j > Integer.MAX_VALUE) {
                    throw new IOException("[Sub Format 8] Invalid character code " + j);
                }
                if ((int)j / 8 >= nArray.length) {
                    throw new IOException("[Sub Format 8] Invalid character code " + j);
                }
                if ((nArray[(int)j / 8] & 1 << (int)j % 8) == 0) {
                    n2 = (int)j;
                } else {
                    l5 = 55232L + (j >> 10);
                    long l6 = 56320L + (j & 0x3FFL);
                    long l7 = (l5 << 10) + l6 + -56613888L;
                    if (l7 > Integer.MAX_VALUE) {
                        throw new IOException("[Sub Format 8] Invalid character code " + l7);
                    }
                    n2 = (int)l7;
                }
                l5 = l4 + (j - l2);
                if (l5 > (long)n || l5 > Integer.MAX_VALUE) {
                    throw new IOException("CMap contains an invalid glyph index");
                }
                this.glyphIdToCharacterCode[(int)l5] = n2;
                this.characterCodeToGlyphId.put(n2, (int)l5);
            }
        }
    }

    void processSubtype10(TTFDataStream tTFDataStream, int n) {
        long l = tTFDataStream.readUnsignedInt();
        long l2 = tTFDataStream.readUnsignedInt();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Invalid number of Characters");
        }
        if (l < 0L || l > 0x10FFFFL || l + l2 > 0x10FFFFL || l + l2 >= 55296L && l + l2 <= 57343L) {
            throw new IOException("Invalid character codes, " + String.format("startCode: 0x%X, numChars: %d", l, l2));
        }
    }

    void processSubtype12(TTFDataStream tTFDataStream, int n) {
        int n2 = 0;
        long l = tTFDataStream.readUnsignedInt();
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        if (n == 0) {
            LOG.warn((Object)"subtable has no glyphs");
            return;
        }
        block0: for (long i = 0L; i < l; ++i) {
            long l2 = tTFDataStream.readUnsignedInt();
            long l3 = tTFDataStream.readUnsignedInt();
            long l4 = tTFDataStream.readUnsignedInt();
            if (l2 < 0L || l2 > 0x10FFFFL || l2 >= 55296L && l2 <= 57343L) {
                throw new IOException("Invalid character code " + String.format("0x%X", l2));
            }
            if (l3 > 0L && l3 < l2 || l3 > 0x10FFFFL || l3 >= 55296L && l3 <= 57343L) {
                throw new IOException("Invalid character code " + String.format("0x%X", l3));
            }
            for (long j = 0L; j <= l3 - l2; ++j) {
                long l5 = l4 + j;
                if (l5 >= (long)n) {
                    LOG.warn((Object)"Format 12 cmap contains an invalid glyph index");
                    continue block0;
                }
                if (l2 + j > 0x10FFFFL) {
                    LOG.warn((Object)"Format 12 cmap contains character beyond UCS-4");
                }
                n2 = Math.max(n2, (int)l5);
                this.characterCodeToGlyphId.put((int)(l2 + j), (int)l5);
            }
        }
        this.buildGlyphIdToCharacterCodeLookup(n2);
    }

    void processSubtype13(TTFDataStream tTFDataStream, int n) {
        long l = tTFDataStream.readUnsignedInt();
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        if (n == 0) {
            LOG.warn((Object)"subtable has no glyphs");
            return;
        }
        for (long i = 0L; i < l; ++i) {
            long l2 = tTFDataStream.readUnsignedInt();
            long l3 = tTFDataStream.readUnsignedInt();
            long l4 = tTFDataStream.readUnsignedInt();
            if (l4 > (long)n) {
                LOG.warn((Object)"Format 13 cmap contains an invalid glyph index");
                return;
            }
            if (l2 < 0L || l2 > 0x10FFFFL || l2 >= 55296L && l2 <= 57343L) {
                throw new IOException("Invalid character code " + String.format("0x%X", l2));
            }
            if (l3 > 0L && l3 < l2 || l3 > 0x10FFFFL || l3 >= 55296L && l3 <= 57343L) {
                throw new IOException("Invalid character code " + String.format("0x%X", l3));
            }
            for (long j = 0L; j <= l3 - l2; ++j) {
                if (l2 + j > Integer.MAX_VALUE) {
                    throw new IOException("Character Code greater than Integer.MAX_VALUE");
                }
                if (l2 + j > 0x10FFFFL) {
                    LOG.warn((Object)"Format 13 cmap contains character beyond UCS-4");
                }
                this.glyphIdToCharacterCode[(int)l4] = (int)(l2 + j);
                this.characterCodeToGlyphId.put((int)(l2 + j), (int)l4);
            }
        }
    }

    void processSubtype14(TTFDataStream tTFDataStream, int n) {
        LOG.warn((Object)"Format 14 cmap table is not supported and will be ignored");
    }

    void processSubtype6(TTFDataStream object, int n) {
        int n2 = ((TTFDataStream)object).readUnsignedShort();
        int n3 = ((TTFDataStream)object).readUnsignedShort();
        if (n3 == 0) {
            return;
        }
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        object = ((TTFDataStream)object).readUnsignedShortArray(n3);
        n = 0;
        for (int i = 0; i < n3; ++i) {
            n = Math.max(n, (int)object[i]);
            this.characterCodeToGlyphId.put(n2 + i, (int)object[i]);
        }
        this.buildGlyphIdToCharacterCodeLookup(n);
    }

    void processSubtype4(TTFDataStream tTFDataStream, int n) {
        int n2 = tTFDataStream.readUnsignedShort();
        n2 /= 2;
        tTFDataStream.readUnsignedShort();
        tTFDataStream.readUnsignedShort();
        tTFDataStream.readUnsignedShort();
        int[] nArray = tTFDataStream.readUnsignedShortArray(n2);
        tTFDataStream.readUnsignedShort();
        int[] nArray2 = tTFDataStream.readUnsignedShortArray(n2);
        int[] nArray3 = tTFDataStream.readUnsignedShortArray(n2);
        long l = tTFDataStream.getCurrentPosition();
        int[] nArray4 = tTFDataStream.readUnsignedShortArray(n2);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray2[i];
            int n4 = nArray[i];
            int n5 = nArray3[i];
            int n6 = nArray4[i];
            long l2 = l + ((long)i << 1) + (long)n6;
            if (n3 == 65535 || n4 == 65535) continue;
            for (int j = n3; j <= n4; ++j) {
                if (n6 == 0) {
                    int n7 = j + n5 & 0xFFFF;
                    n = Math.max(n7, n);
                    this.characterCodeToGlyphId.put(j, n7);
                    continue;
                }
                long l3 = l2 + ((long)(j - n3) << 1);
                tTFDataStream.seek(l3);
                int n8 = tTFDataStream.readUnsignedShort();
                if (n8 == 0) continue;
                n8 = n8 + n5 & 0xFFFF;
                n = Math.max(n8, n);
                this.characterCodeToGlyphId.put(j, n8);
            }
        }
        if (this.characterCodeToGlyphId.isEmpty()) {
            LOG.warn((Object)"cmap format 4 subtable is empty");
            return;
        }
        this.buildGlyphIdToCharacterCodeLookup(n);
    }

    private void buildGlyphIdToCharacterCodeLookup(int n3) {
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n3 + 1);
        this.characterCodeToGlyphId.forEach((n, n2) -> {
            if (this.glyphIdToCharacterCode[n2] == -1) {
                this.glyphIdToCharacterCode[n2.intValue()] = n;
                return;
            }
            List<Integer> list = this.glyphIdToCharacterCodeMultiple.get(n2);
            if (list == null) {
                list = new ArrayList<Integer>(2);
                this.glyphIdToCharacterCodeMultiple.put((Integer)n2, list);
                list.add(this.glyphIdToCharacterCode[n2]);
                this.glyphIdToCharacterCode[n2.intValue()] = Integer.MIN_VALUE;
            }
            list.add((Integer)n);
        });
    }

    void processSubtype2(TTFDataStream tTFDataStream, int n) {
        int n2;
        int n3;
        int[] nArray = new int[256];
        int n4 = 0;
        for (int i = 0; i < 256; ++i) {
            nArray[i] = tTFDataStream.readUnsignedShort();
            n4 = Math.max(n4, nArray[i] / 8);
        }
        CmapSubtable$SubHeader[] cmapSubtable$SubHeaderArray = new CmapSubtable$SubHeader[n4 + 1];
        for (int i = 0; i <= n4; ++i) {
            int n5 = tTFDataStream.readUnsignedShort();
            int n6 = tTFDataStream.readUnsignedShort();
            n3 = tTFDataStream.readSignedShort();
            n2 = tTFDataStream.readUnsignedShort() - (n4 + 1 - i - 1 << 3) - 2;
            cmapSubtable$SubHeaderArray[i] = new CmapSubtable$SubHeader(n5, n6, (short)n3, n2, null);
        }
        long l = tTFDataStream.getCurrentPosition();
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        if (n == 0) {
            LOG.warn((Object)"subtable has no glyphs");
            return;
        }
        for (int i = 0; i <= n4; ++i) {
            CmapSubtable$SubHeader cmapSubtable$SubHeader = cmapSubtable$SubHeaderArray[i];
            n2 = CmapSubtable$SubHeader.access$100(cmapSubtable$SubHeader);
            int n7 = CmapSubtable$SubHeader.access$200(cmapSubtable$SubHeader);
            short s = CmapSubtable$SubHeader.access$300(cmapSubtable$SubHeader);
            n3 = CmapSubtable$SubHeader.access$400(cmapSubtable$SubHeader);
            tTFDataStream.seek(l + (long)n7);
            for (n7 = 0; n7 < n3; ++n7) {
                int n8 = i;
                n8 = (n8 << 8) + (n2 + n7);
                int n9 = tTFDataStream.readUnsignedShort();
                if (n9 > 0 && (n9 = (n9 + s) % 65536) < 0) {
                    n9 += 65536;
                }
                if (n9 >= n) {
                    LOG.warn((Object)("glyphId " + n9 + " for charcode " + n8 + " ignored, numGlyphs is " + n));
                    continue;
                }
                this.glyphIdToCharacterCode[n9] = n8;
                this.characterCodeToGlyphId.put(n8, n9);
            }
        }
    }

    void processSubtype0(TTFDataStream object) {
        object = ((TTFDataStream)object).read(256);
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(256);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(((Object)object).length);
        for (int i = 0; i < ((Object)object).length; ++i) {
            int n = object[i] & 0xFF;
            this.glyphIdToCharacterCode[n] = i;
            this.characterCodeToGlyphId.put(i, n);
        }
    }

    private int[] newGlyphIdToCharacterCode(int n) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    public int getPlatformEncodingId() {
        return this.platformEncodingId;
    }

    public void setPlatformEncodingId(int n) {
        this.platformEncodingId = n;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int n) {
        this.platformId = n;
    }

    @Override
    public int getGlyphId(int n) {
        Integer n2 = this.characterCodeToGlyphId.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    private int getCharCode(int n) {
        if (n < 0 || this.glyphIdToCharacterCode == null || n >= this.glyphIdToCharacterCode.length) {
            return -1;
        }
        return this.glyphIdToCharacterCode[n];
    }

    @Override
    public List<Integer> getCharCodes(int n) {
        int n2 = this.getCharCode(n);
        if (n2 == -1) {
            return null;
        }
        List<Integer> list = null;
        if (n2 == Integer.MIN_VALUE) {
            List<Integer> list2 = this.glyphIdToCharacterCodeMultiple.get(n);
            if (list2 != null) {
                list = new ArrayList<Integer>(list2);
                Collections.sort(list);
            }
        } else {
            list = Collections.singletonList(n2);
        }
        return list;
    }

    public String toString() {
        return "{" + this.getPlatformId() + " " + this.getPlatformEncodingId() + "}";
    }
}

