/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.jdbcjobstore.CalendarIntervalTriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.CronTriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.DailyTimeIntervalTriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.SimpleTriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate$TriggerPropertyBundle;
import org.quartz.impl.jdbcjobstore.TriggerStatus;
import org.quartz.impl.jdbcjobstore.Util;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.impl.matchers.StringMatcher$StringOperatorName;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.OperableTrigger;
import org.quartz.utils.Key;
import org.quartz.utils.StringKeyDirtyFlagMap;
import org.slf4j.Logger;

public class StdJDBCDelegate
implements DriverDelegate,
StdJDBCConstants {
    protected Logger logger = null;
    protected String tablePrefix = "QRTZ_";
    protected String instanceId;
    protected String schedName;
    protected boolean useProperties;
    protected ClassLoadHelper classLoadHelper;
    protected List<TriggerPersistenceDelegate> triggerPersistenceDelegates = new LinkedList<TriggerPersistenceDelegate>();
    private String schedNameLiteral = null;

    @Override
    public void initialize(Logger stringArray, String string, String string2, String stringArray2, ClassLoadHelper classLoadHelper, boolean bl, String string3) {
        this.logger = stringArray;
        this.tablePrefix = string;
        this.schedName = string2;
        this.instanceId = stringArray2;
        this.useProperties = bl;
        this.classLoadHelper = classLoadHelper;
        this.addDefaultTriggerPersistenceDelegates();
        if (string3 == null) {
            return;
        }
        String[] stringArray3 = string3.split("\\|");
        stringArray = stringArray3;
        stringArray = stringArray3;
        int n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            stringArray2 = stringArray[i];
            stringArray2 = stringArray2.split("=");
            String string4 = stringArray2[0];
            if (stringArray2.length == 1 || stringArray2[1] == null || stringArray2[1].equals("")) continue;
            if (string4.equals("triggerPersistenceDelegateClasses")) {
                String[] stringArray4 = stringArray2[1].split(",");
                stringArray2 = stringArray4;
                stringArray2 = stringArray4;
                int n2 = stringArray4.length;
                for (int j = 0; j < n2; ++j) {
                    String string5 = stringArray2[j];
                    try {
                        Class<?> clazz = classLoadHelper.loadClass(string5);
                        this.addTriggerPersistenceDelegate((TriggerPersistenceDelegate)clazz.newInstance());
                        continue;
                    }
                    catch (Exception exception) {
                        throw new NoSuchDelegateException("Error instantiating TriggerPersistenceDelegate of type: " + string5, exception);
                    }
                }
                continue;
            }
            throw new NoSuchDelegateException("Unknown setting: '" + string4 + "'");
        }
    }

    protected void addDefaultTriggerPersistenceDelegates() {
        this.addTriggerPersistenceDelegate(new SimpleTriggerPersistenceDelegate());
        this.addTriggerPersistenceDelegate(new CronTriggerPersistenceDelegate());
        this.addTriggerPersistenceDelegate(new CalendarIntervalTriggerPersistenceDelegate());
        this.addTriggerPersistenceDelegate(new DailyTimeIntervalTriggerPersistenceDelegate());
    }

    protected boolean canUseProperties() {
        return this.useProperties;
    }

    public void addTriggerPersistenceDelegate(TriggerPersistenceDelegate triggerPersistenceDelegate) {
        this.logger.debug("Adding TriggerPersistenceDelegate of type: " + triggerPersistenceDelegate.getClass().getCanonicalName());
        triggerPersistenceDelegate.initialize(this.tablePrefix, this.schedName);
        this.triggerPersistenceDelegates.add(triggerPersistenceDelegate);
    }

    public TriggerPersistenceDelegate findTriggerPersistenceDelegate(OperableTrigger operableTrigger) {
        for (TriggerPersistenceDelegate triggerPersistenceDelegate : this.triggerPersistenceDelegates) {
            if (!triggerPersistenceDelegate.canHandleTriggerType(operableTrigger)) continue;
            return triggerPersistenceDelegate;
        }
        return null;
    }

    public TriggerPersistenceDelegate findTriggerPersistenceDelegate(String string) {
        for (TriggerPersistenceDelegate triggerPersistenceDelegate : this.triggerPersistenceDelegates) {
            if (!triggerPersistenceDelegate.getHandledTriggerTypeDiscriminator().equals(string)) continue;
            return triggerPersistenceDelegate;
        }
        return null;
    }

    @Override
    public int updateTriggerStatesFromOtherStates(Connection connection, String string, String string2, String string3) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public List<TriggerKey> selectMisfiredTriggers(Connection object, long l) {
        Object object2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                String string = resultSet.getString("TRIGGER_NAME");
                String string2 = resultSet.getString("TRIGGER_GROUP");
                ((LinkedList)object).add(TriggerKey.triggerKey(string, string2));
            }
            object2 = object;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object2;
    }

    @Override
    public List<TriggerKey> selectTriggersInState(Connection object, String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ?"));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                ((LinkedList)object).add(TriggerKey.triggerKey(resultSet.getString(1), resultSet.getString(2)));
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public List<TriggerKey> selectMisfiredTriggersInState(Connection object, String object2, long l) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ? ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
            preparedStatement.setString(2, (String)object2);
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                object2 = resultSet.getString("TRIGGER_NAME");
                String string = resultSet.getString("TRIGGER_GROUP");
                ((LinkedList)object).add(TriggerKey.triggerKey((String)object2, string));
            }
            object2 = object;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object2;
    }

    @Override
    public boolean hasMisfiredTriggersInState(Connection connection, String string, long l, int n, List<TriggerKey> list) {
        boolean bl;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ? ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            boolean bl2 = false;
            while (resultSet.next() && !bl2) {
                if (list.size() == n) {
                    bl2 = true;
                    continue;
                }
                string = resultSet.getString("TRIGGER_NAME");
                String string2 = resultSet.getString("TRIGGER_GROUP");
                list.add(TriggerKey.triggerKey(string, string2));
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    @Override
    public int countMisfiredTriggersInState(Connection connection, String string, long l) {
        block3: {
            int n;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ?"));
                preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
                preparedStatement.setString(2, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return n;
        }
        throw new SQLException("No misfired trigger count returned.");
    }

    @Override
    public List<TriggerKey> selectMisfiredTriggersInGroupInState(Connection object, String string, String object2, long l) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ? ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, (String)object2);
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                object2 = resultSet.getString("TRIGGER_NAME");
                ((LinkedList)object).add(TriggerKey.triggerKey((String)object2, string));
            }
            object2 = object;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object2;
    }

    @Override
    public List<OperableTrigger> selectTriggersForRecoveringJobs(Connection connection) {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?"));
            preparedStatement.setString(1, this.instanceId);
            this.setBoolean(preparedStatement, 2, true);
            resultSet = preparedStatement.executeQuery();
            long l = System.currentTimeMillis();
            LinkedList<SimpleTriggerImpl> linkedList = new LinkedList<SimpleTriggerImpl>();
            while (resultSet.next()) {
                object = resultSet.getString("JOB_NAME");
                String string = resultSet.getString("JOB_GROUP");
                String string2 = resultSet.getString("TRIGGER_NAME");
                String string3 = resultSet.getString("TRIGGER_GROUP");
                long l2 = resultSet.getLong("FIRED_TIME");
                long l3 = resultSet.getLong("SCHED_TIME");
                int n = resultSet.getInt("PRIORITY");
                SimpleTriggerImpl simpleTriggerImpl = new SimpleTriggerImpl("recover_" + this.instanceId + "_" + String.valueOf(l++), "RECOVERING_JOBS", new Date(l3));
                simpleTriggerImpl.setJobName((String)object);
                simpleTriggerImpl.setJobGroup(string);
                simpleTriggerImpl.setPriority(n);
                simpleTriggerImpl.setMisfireInstruction(-1);
                object = this.selectTriggerJobDataMap(connection, string2, string3);
                ((StringKeyDirtyFlagMap)object).put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", string2);
                ((StringKeyDirtyFlagMap)object).put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", string3);
                ((StringKeyDirtyFlagMap)object).put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(l2));
                ((StringKeyDirtyFlagMap)object).put("QRTZ_FAILED_JOB_ORIG_TRIGGER_SCHEDULED_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(l3));
                simpleTriggerImpl.setJobDataMap((JobDataMap)object);
                linkedList.add(simpleTriggerImpl);
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public int deleteFiredTriggers(Connection connection) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1}"));
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int deleteFiredTriggers(Connection connection, String string) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public void clearData(Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}SIMPLE_TRIGGERS  WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}SIMPROP_TRIGGERS  WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}BLOB_TRIGGERS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}TRIGGERS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}CALENDARS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
    }

    @Override
    public int insertJobDetail(Connection connection, JobDetail jobDetail) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            preparedStatement.setString(1, jobDetail.getKey().getName());
            preparedStatement.setString(2, jobDetail.getKey().getGroup());
            preparedStatement.setString(3, jobDetail.getDescription());
            preparedStatement.setString(4, jobDetail.getJobClass().getName());
            this.setBoolean(preparedStatement, 5, jobDetail.isDurable());
            this.setBoolean(preparedStatement, 6, jobDetail.isConcurrentExectionDisallowed());
            this.setBoolean(preparedStatement, 7, jobDetail.isPersistJobDataAfterExecution());
            this.setBoolean(preparedStatement, 8, jobDetail.requestsRecovery());
            this.setBytes(preparedStatement, 9, byteArrayOutputStream);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateJobDetail(Connection connection, JobDetail jobDetail) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_NONCONCURRENT = ?, IS_UPDATE_DATA = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobDetail.getDescription());
            preparedStatement.setString(2, jobDetail.getJobClass().getName());
            this.setBoolean(preparedStatement, 3, jobDetail.isDurable());
            this.setBoolean(preparedStatement, 4, jobDetail.isConcurrentExectionDisallowed());
            this.setBoolean(preparedStatement, 5, jobDetail.isPersistJobDataAfterExecution());
            this.setBoolean(preparedStatement, 6, jobDetail.requestsRecovery());
            this.setBytes(preparedStatement, 7, byteArrayOutputStream);
            preparedStatement.setString(8, jobDetail.getKey().getName());
            preparedStatement.setString(9, jobDetail.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public List<TriggerKey> selectTriggerKeysForJob(Connection object, JobKey object2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, ((Key)object2).getName());
            preparedStatement.setString(2, ((Key)object2).getGroup());
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                object2 = resultSet.getString("TRIGGER_NAME");
                String string = resultSet.getString("TRIGGER_GROUP");
                ((LinkedList)object).add(TriggerKey.triggerKey((String)object2, string));
            }
            object2 = object;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object2;
    }

    @Override
    public int deleteJobDetail(Connection connection, JobKey jobKey) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Deleting job: " + jobKey);
            }
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobKey.getName());
            preparedStatement.setString(2, jobKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public boolean isJobNonConcurrent(Connection connection, JobKey jobKey) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT IS_NONCONCURRENT FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
                preparedStatement.setString(1, jobKey.getName());
                preparedStatement.setString(2, jobKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block3;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return false;
        }
        boolean bl = this.getBoolean(resultSet, "IS_NONCONCURRENT");
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    @Override
    public boolean jobExists(Connection connection, JobKey jobKey) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
                preparedStatement.setString(1, jobKey.getName());
                preparedStatement.setString(2, jobKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return true;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return false;
    }

    @Override
    public int updateJobData(Connection connection, JobDetail jobDetail) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            this.setBytes(preparedStatement, 1, byteArrayOutputStream);
            preparedStatement.setString(2, jobDetail.getKey().getName());
            preparedStatement.setString(3, jobDetail.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public JobDetail selectJobDetail(Connection object, JobKey map, ClassLoadHelper classLoadHelper) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, ((Key)((Object)map)).getName());
            preparedStatement.setString(2, ((Key)((Object)map)).getGroup());
            resultSet = preparedStatement.executeQuery();
            object = null;
            if (resultSet.next()) {
                object = new JobDetailImpl();
                ((JobDetailImpl)object).setName(resultSet.getString("JOB_NAME"));
                ((JobDetailImpl)object).setGroup(resultSet.getString("JOB_GROUP"));
                ((JobDetailImpl)object).setDescription(resultSet.getString("DESCRIPTION"));
                ((JobDetailImpl)object).setJobClass(classLoadHelper.loadClass(resultSet.getString("JOB_CLASS_NAME"), Job.class));
                ((JobDetailImpl)object).setDurability(this.getBoolean(resultSet, "IS_DURABLE"));
                ((JobDetailImpl)object).setRequestsRecovery(this.getBoolean(resultSet, "REQUESTS_RECOVERY"));
                map = this.canUseProperties() ? this.getMapFromProperties(resultSet) : (Map)this.getObjectFromBlob(resultSet, "JOB_DATA");
                if (map != null) {
                    ((JobDetailImpl)object).setJobDataMap(new JobDataMap(map));
                }
            }
            map = object;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return map;
    }

    private Map<?, ?> getMapFromProperties(ResultSet object) {
        if ((object = (InputStream)this.getJobDataFromBlob((ResultSet)object, "JOB_DATA")) == null) {
            return null;
        }
        Properties properties = new Properties();
        if (object != null) {
            try {
                properties.load((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        object = this.convertFromProperty(properties);
        return object;
    }

    @Override
    public int selectNumJobs(Connection connection) {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n2 = 0;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(JOB_NAME)  FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            n = n2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public List<String> selectJobGroups(Connection object) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT DISTINCT(JOB_GROUP) FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                ((LinkedList)object).add(resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public Set<JobKey> selectJobsInGroup(Connection hashSet, GroupMatcher<JobKey> groupMatcher) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (this.isMatcherEquals(groupMatcher)) {
                preparedStatement = hashSet.prepareStatement(this.rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_GROUP = ?"));
                preparedStatement.setString(1, this.toSqlEqualsClause(groupMatcher));
            } else {
                preparedStatement = hashSet.prepareStatement(this.rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_GROUP LIKE ?"));
                preparedStatement.setString(1, this.toSqlLikeClause(groupMatcher));
            }
            resultSet = preparedStatement.executeQuery();
            hashSet = new LinkedList();
            while (resultSet.next()) {
                ((LinkedList)((Object)hashSet)).add(JobKey.jobKey(resultSet.getString(1), resultSet.getString(2)));
            }
            hashSet = new HashSet<JobKey>(hashSet);
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return hashSet;
    }

    protected boolean isMatcherEquals(GroupMatcher<?> groupMatcher) {
        return groupMatcher.getCompareWithOperator().equals((Object)StringMatcher$StringOperatorName.EQUALS);
    }

    protected String toSqlEqualsClause(GroupMatcher<?> groupMatcher) {
        return groupMatcher.getCompareToValue();
    }

    protected String toSqlLikeClause(GroupMatcher<?> object) {
        switch (((StringMatcher)object).getCompareWithOperator()) {
            case EQUALS: {
                object = ((StringMatcher)object).getCompareToValue();
                break;
            }
            case CONTAINS: {
                object = "%" + ((StringMatcher)object).getCompareToValue() + "%";
                break;
            }
            case ENDS_WITH: {
                object = "%" + ((StringMatcher)object).getCompareToValue();
                break;
            }
            case STARTS_WITH: {
                object = ((StringMatcher)object).getCompareToValue() + "%";
                break;
            }
            case ANYTHING: {
                object = "%";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Don't know how to translate " + (Object)((Object)((StringMatcher)object).getCompareWithOperator()) + " into SQL");
            }
        }
        return object;
    }

    @Override
    public int insertTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) {
        int n;
        PreparedStatement preparedStatement;
        block9: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (operableTrigger.getJobDataMap().size() > 0) {
                byteArrayOutputStream = this.serializeJobData(operableTrigger.getJobDataMap());
            }
            preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA, PRIORITY)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                preparedStatement.setString(1, operableTrigger.getKey().getName());
                preparedStatement.setString(2, operableTrigger.getKey().getGroup());
                preparedStatement.setString(3, operableTrigger.getJobKey().getName());
                preparedStatement.setString(4, operableTrigger.getJobKey().getGroup());
                preparedStatement.setString(5, operableTrigger.getDescription());
                if (operableTrigger.getNextFireTime() != null) {
                    preparedStatement.setBigDecimal(6, new BigDecimal(String.valueOf(operableTrigger.getNextFireTime().getTime())));
                } else {
                    preparedStatement.setBigDecimal(6, null);
                }
                long l = -1L;
                if (operableTrigger.getPreviousFireTime() != null) {
                    l = operableTrigger.getPreviousFireTime().getTime();
                }
                preparedStatement.setBigDecimal(7, new BigDecimal(String.valueOf(l)));
                preparedStatement.setString(8, string);
                TriggerPersistenceDelegate triggerPersistenceDelegate = this.findTriggerPersistenceDelegate(operableTrigger);
                String string2 = "BLOB";
                if (triggerPersistenceDelegate != null) {
                    string2 = triggerPersistenceDelegate.getHandledTriggerTypeDiscriminator();
                }
                preparedStatement.setString(9, string2);
                preparedStatement.setBigDecimal(10, new BigDecimal(String.valueOf(operableTrigger.getStartTime().getTime())));
                long l2 = 0L;
                if (operableTrigger.getEndTime() != null) {
                    l2 = operableTrigger.getEndTime().getTime();
                }
                preparedStatement.setBigDecimal(11, new BigDecimal(String.valueOf(l2)));
                preparedStatement.setString(12, operableTrigger.getCalendarName());
                preparedStatement.setInt(13, operableTrigger.getMisfireInstruction());
                this.setBytes(preparedStatement, 14, byteArrayOutputStream);
                preparedStatement.setInt(15, operableTrigger.getPriority());
                n = preparedStatement.executeUpdate();
                if (triggerPersistenceDelegate == null) {
                    this.insertBlobTrigger(connection, operableTrigger);
                    break block9;
                }
                triggerPersistenceDelegate.insertExtendedTriggerProperties(connection, operableTrigger, string, jobDetail);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    public int insertBlobTrigger(Connection connection, OperableTrigger operableTrigger) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            Object object = new ByteArrayOutputStream();
            Closeable closeable = new ObjectOutputStream((OutputStream)object);
            closeable.writeObject(operableTrigger);
            closeable.close();
            object = ((ByteArrayOutputStream)object).toByteArray();
            closeable = new ByteArrayInputStream((byte[])object);
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}BLOB_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA)  VALUES({1}, ?, ?, ?)"));
            preparedStatement.setString(1, operableTrigger.getKey().getName());
            preparedStatement.setString(2, operableTrigger.getKey().getGroup());
            preparedStatement.setBinaryStream(3, (InputStream)closeable, ((Object)object).length);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) {
        PreparedStatement preparedStatement;
        int n;
        block10: {
            n = operableTrigger.getJobDataMap().isDirty();
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (n != 0) {
                byteArrayOutputStream = this.serializeJobData(operableTrigger.getJobDataMap());
            }
            preparedStatement = null;
            try {
                preparedStatement = n != 0 ? connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ?, JOB_DATA = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?")) : connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, operableTrigger.getJobKey().getName());
                preparedStatement.setString(2, operableTrigger.getJobKey().getGroup());
                preparedStatement.setString(3, operableTrigger.getDescription());
                long l = -1L;
                if (operableTrigger.getNextFireTime() != null) {
                    l = operableTrigger.getNextFireTime().getTime();
                }
                preparedStatement.setBigDecimal(4, new BigDecimal(String.valueOf(l)));
                long l2 = -1L;
                if (operableTrigger.getPreviousFireTime() != null) {
                    l2 = operableTrigger.getPreviousFireTime().getTime();
                }
                preparedStatement.setBigDecimal(5, new BigDecimal(String.valueOf(l2)));
                preparedStatement.setString(6, string);
                TriggerPersistenceDelegate triggerPersistenceDelegate = this.findTriggerPersistenceDelegate(operableTrigger);
                String string2 = "BLOB";
                if (triggerPersistenceDelegate != null) {
                    string2 = triggerPersistenceDelegate.getHandledTriggerTypeDiscriminator();
                }
                preparedStatement.setString(7, string2);
                preparedStatement.setBigDecimal(8, new BigDecimal(String.valueOf(operableTrigger.getStartTime().getTime())));
                long l3 = 0L;
                if (operableTrigger.getEndTime() != null) {
                    l3 = operableTrigger.getEndTime().getTime();
                }
                preparedStatement.setBigDecimal(9, new BigDecimal(String.valueOf(l3)));
                preparedStatement.setString(10, operableTrigger.getCalendarName());
                preparedStatement.setInt(11, operableTrigger.getMisfireInstruction());
                preparedStatement.setInt(12, operableTrigger.getPriority());
                if (n != 0) {
                    this.setBytes(preparedStatement, 13, byteArrayOutputStream);
                    preparedStatement.setString(14, operableTrigger.getKey().getName());
                    preparedStatement.setString(15, operableTrigger.getKey().getGroup());
                } else {
                    preparedStatement.setString(13, operableTrigger.getKey().getName());
                    preparedStatement.setString(14, operableTrigger.getKey().getGroup());
                }
                n = preparedStatement.executeUpdate();
                if (triggerPersistenceDelegate == null) {
                    this.updateBlobTrigger(connection, operableTrigger);
                    break block10;
                }
                triggerPersistenceDelegate.updateExtendedTriggerProperties(connection, operableTrigger, string, jobDetail);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    public int updateBlobTrigger(Connection connection, OperableTrigger operableTrigger) {
        int n;
        PreparedStatement preparedStatement = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            Object object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(operableTrigger);
            ((ObjectOutputStream)object).close();
            object = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}BLOB_TRIGGERS SET BLOB_DATA = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, ((Object)object).length);
            preparedStatement.setString(2, operableTrigger.getKey().getName());
            preparedStatement.setString(3, operableTrigger.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        byteArrayOutputStream.close();
        return n;
    }

    @Override
    public boolean triggerExists(Connection connection, TriggerKey triggerKey) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, triggerKey.getName());
                preparedStatement.setString(2, triggerKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return true;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return false;
    }

    @Override
    public int updateTriggerState(Connection connection, TriggerKey triggerKey, String string) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, triggerKey.getName());
            preparedStatement.setString(3, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateTriggerStateFromOtherStates(Connection connection, TriggerKey triggerKey, String string, String string2, String string3, String string4) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, triggerKey.getName());
            preparedStatement.setString(3, triggerKey.getGroup());
            preparedStatement.setString(4, string2);
            preparedStatement.setString(5, string3);
            preparedStatement.setString(6, string4);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateTriggerGroupStateFromOtherStates(Connection connection, GroupMatcher<TriggerKey> groupMatcher, String string, String string2, String string3, String string4) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, this.toSqlLikeClause(groupMatcher));
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string3);
            preparedStatement.setString(5, string4);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateTriggerStateFromOtherState(Connection connection, TriggerKey triggerKey, String string, String string2) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, triggerKey.getName());
            preparedStatement.setString(3, triggerKey.getGroup());
            preparedStatement.setString(4, string2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateTriggerGroupStateFromOtherState(Connection connection, GroupMatcher<TriggerKey> groupMatcher, String string, String string2) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ? AND TRIGGER_STATE = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, this.toSqlLikeClause(groupMatcher));
            preparedStatement.setString(3, string2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateTriggerStatesForJob(Connection connection, JobKey jobKey, String string) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, jobKey.getName());
            preparedStatement.setString(3, jobKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateTriggerStatesForJobFromOtherState(Connection connection, JobKey jobKey, String string, String string2) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ? AND TRIGGER_STATE = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, jobKey.getName());
            preparedStatement.setString(3, jobKey.getGroup());
            preparedStatement.setString(4, string2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    public int deleteBlobTrigger(Connection connection, TriggerKey triggerKey) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}BLOB_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int deleteTrigger(Connection connection, TriggerKey triggerKey) {
        int n;
        PreparedStatement preparedStatement = null;
        this.deleteTriggerExtension(connection, triggerKey);
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    protected void deleteTriggerExtension(Connection connection, TriggerKey triggerKey) {
        for (TriggerPersistenceDelegate triggerPersistenceDelegate : this.triggerPersistenceDelegates) {
            if (triggerPersistenceDelegate.deleteExtendedTriggerProperties(connection, triggerKey) <= 0) continue;
            return;
        }
        this.deleteBlobTrigger(connection, triggerKey);
    }

    @Override
    public int selectNumTriggersForJob(Connection connection, JobKey jobKey) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            int n;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
                preparedStatement.setString(1, jobKey.getName());
                preparedStatement.setString(2, jobKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return n;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return 0;
    }

    @Override
    public JobDetail selectJobForTrigger(Connection connection, ClassLoadHelper classLoadHelper, TriggerKey triggerKey) {
        return this.selectJobForTrigger(connection, classLoadHelper, triggerKey, true);
    }

    @Override
    public JobDetail selectJobForTrigger(Connection object, ClassLoadHelper classLoadHelper, TriggerKey triggerKey, boolean bl) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = object.prepareStatement(this.rtp("SELECT J.JOB_NAME, J.JOB_GROUP, J.IS_DURABLE, J.JOB_CLASS_NAME, J.REQUESTS_RECOVERY FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.SCHED_NAME = {1} AND J.SCHED_NAME = {1} AND T.TRIGGER_NAME = ? AND T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP"));
                preparedStatement.setString(1, triggerKey.getName());
                preparedStatement.setString(2, triggerKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                object = new JobDetailImpl();
                ((JobDetailImpl)object).setName(resultSet.getString(1));
                ((JobDetailImpl)object).setGroup(resultSet.getString(2));
                ((JobDetailImpl)object).setDurability(this.getBoolean(resultSet, 3));
                if (bl) {
                    ((JobDetailImpl)object).setJobClass(classLoadHelper.loadClass(resultSet.getString(4), Job.class));
                }
                ((JobDetailImpl)object).setRequestsRecovery(this.getBoolean(resultSet, 5));
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return object;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No job for trigger '" + triggerKey + "'.");
        }
        object = null;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public List<OperableTrigger> selectTriggersForJob(Connection connection, JobKey comparable) {
        LinkedList<OperableTrigger> linkedList = new LinkedList<OperableTrigger>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, comparable.getName());
            preparedStatement.setString(2, comparable.getGroup());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                comparable = this.selectTrigger(connection, TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
                if (comparable == null) continue;
                linkedList.add((OperableTrigger)comparable);
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    @Override
    public List<OperableTrigger> selectTriggersForCalendar(Connection connection, String string) {
        LinkedList<OperableTrigger> linkedList = new LinkedList<OperableTrigger>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                linkedList.add(this.selectTrigger(connection, TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP"))));
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OperableTrigger selectTrigger(Connection object, TriggerKey triggerBuilder) {
        String string;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object2 = null;
            preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, ((Key)((Object)triggerBuilder)).getName());
            preparedStatement.setString(2, ((Key)((Object)triggerBuilder)).getGroup());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string = resultSet.getString("JOB_NAME");
                String string2 = resultSet.getString("JOB_GROUP");
                String string3 = resultSet.getString("DESCRIPTION");
                long l = resultSet.getLong("NEXT_FIRE_TIME");
                long l2 = resultSet.getLong("PREV_FIRE_TIME");
                String string4 = resultSet.getString("TRIGGER_TYPE");
                long l3 = resultSet.getLong("START_TIME");
                long l4 = resultSet.getLong("END_TIME");
                String string5 = resultSet.getString("CALENDAR_NAME");
                int n = resultSet.getInt("MISFIRE_INSTR");
                int n2 = resultSet.getInt("PRIORITY");
                Map map = this.canUseProperties() ? this.getMapFromProperties(resultSet) : (Map)this.getObjectFromBlob(resultSet, "JOB_DATA");
                Date date = null;
                if (l > 0L) {
                    date = new Date(l);
                }
                Date date2 = null;
                if (l2 > 0L) {
                    date2 = new Date(l2);
                }
                Date date3 = new Date(l3);
                Date date4 = null;
                if (l4 > 0L) {
                    date4 = new Date(l4);
                }
                if (string4.equals("BLOB")) {
                    resultSet.close();
                    resultSet = null;
                    preparedStatement.close();
                    preparedStatement = null;
                    preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}BLOB_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                    preparedStatement.setString(1, ((Key)((Object)triggerBuilder)).getName());
                    preparedStatement.setString(2, ((Key)((Object)triggerBuilder)).getGroup());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        object2 = (OperableTrigger)this.getObjectFromBlob(resultSet, "BLOB_DATA");
                    }
                } else {
                    object2 = this.findTriggerPersistenceDelegate(string4);
                    if (object2 == null) {
                        throw new JobPersistenceException("No TriggerPersistenceDelegate for trigger discriminator type: " + string4);
                    }
                    try {
                        object = object2.loadExtendedTriggerProperties((Connection)object, (TriggerKey)((Object)triggerBuilder));
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (this.isTriggerStillPresent(preparedStatement)) {
                            throw illegalStateException;
                        }
                        object = null;
                        StdJDBCDelegate.closeResultSet(resultSet);
                        StdJDBCDelegate.closeStatement(preparedStatement);
                        return object;
                    }
                    triggerBuilder = TriggerBuilder.newTrigger().withDescription(string3).withPriority(n2).startAt(date3).endAt(date4).withIdentity((TriggerKey)((Object)triggerBuilder)).modifiedByCalendar(string5).withSchedule(((TriggerPersistenceDelegate$TriggerPropertyBundle)object).getScheduleBuilder()).forJob(JobKey.jobKey(string, string2));
                    if (map != null) {
                        triggerBuilder.usingJobData(new JobDataMap(map));
                    }
                    object2 = (OperableTrigger)triggerBuilder.build();
                    object2.setMisfireInstruction(n);
                    object2.setNextFireTime(date);
                    object2.setPreviousFireTime(date2);
                    this.setTriggerStateProperties((OperableTrigger)object2, (TriggerPersistenceDelegate$TriggerPropertyBundle)object);
                }
            }
            string = object2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return string;
    }

    private boolean isTriggerStillPresent(PreparedStatement preparedStatement) {
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
        finally {
            StdJDBCDelegate.closeResultSet(resultSet);
        }
    }

    private void setTriggerStateProperties(OperableTrigger operableTrigger, TriggerPersistenceDelegate$TriggerPropertyBundle triggerPersistenceDelegate$TriggerPropertyBundle) {
        if (triggerPersistenceDelegate$TriggerPropertyBundle.getStatePropertyNames() == null) {
            return;
        }
        Util.setBeanProps(operableTrigger, triggerPersistenceDelegate$TriggerPropertyBundle.getStatePropertyNames(), triggerPersistenceDelegate$TriggerPropertyBundle.getStatePropertyValues());
    }

    @Override
    public JobDataMap selectTriggerJobDataMap(Connection map, String string, String string2) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = map.prepareStatement(this.rtp("SELECT JOB_DATA FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                map = this.canUseProperties() ? this.getMapFromProperties(resultSet) : (Map)this.getObjectFromBlob(resultSet, "JOB_DATA");
                resultSet.close();
                preparedStatement.close();
                if (map == null) break block2;
                map = new JobDataMap(map);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return map;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return new JobDataMap();
    }

    @Override
    public String selectTriggerState(Connection object, TriggerKey triggerKey) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_STATE FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            object = resultSet.next() ? resultSet.getString("TRIGGER_STATE") : "DELETED";
            object = ((String)object).intern();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public TriggerStatus selectTriggerStatus(Connection object, TriggerKey triggerKey) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object2 = null;
            preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_STATE, NEXT_FIRE_TIME, JOB_NAME, JOB_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                object = resultSet.getString("TRIGGER_STATE");
                long l = resultSet.getLong("NEXT_FIRE_TIME");
                String string = resultSet.getString("JOB_NAME");
                String string2 = resultSet.getString("JOB_GROUP");
                object2 = null;
                if (l > 0L) {
                    object2 = new Date(l);
                }
                object2 = new TriggerStatus((String)object, (Date)object2);
                ((TriggerStatus)object2).setKey(triggerKey);
                ((TriggerStatus)object2).setJobKey(JobKey.jobKey(string, string2));
            }
            object = object2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public int selectNumTriggers(Connection connection) {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n2 = 0;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            n = n2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public List<String> selectTriggerGroups(Connection object) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT DISTINCT(TRIGGER_GROUP) FROM {0}TRIGGERS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                ((LinkedList)object).add(resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public List<String> selectTriggerGroups(Connection object, GroupMatcher<TriggerKey> groupMatcher) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT DISTINCT(TRIGGER_GROUP) FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ?"));
            preparedStatement.setString(1, this.toSqlLikeClause(groupMatcher));
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                ((LinkedList)object).add(resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public Set<TriggerKey> selectTriggersInGroup(Connection object, GroupMatcher<TriggerKey> groupMatcher) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (this.isMatcherEquals(groupMatcher)) {
                preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, this.toSqlEqualsClause(groupMatcher));
            } else {
                preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ?"));
                preparedStatement.setString(1, this.toSqlLikeClause(groupMatcher));
            }
            resultSet = preparedStatement.executeQuery();
            object = new HashSet();
            while (resultSet.next()) {
                object.add(TriggerKey.triggerKey(resultSet.getString(1), resultSet.getString(2)));
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public int insertPausedTriggerGroup(Connection connection, String string) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}PAUSED_TRIGGER_GRPS (SCHED_NAME, TRIGGER_GROUP) VALUES({1}, ?)"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int deletePausedTriggerGroup(Connection connection, String string) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int deletePausedTriggerGroup(Connection connection, GroupMatcher<TriggerKey> groupMatcher) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ?"));
            preparedStatement.setString(1, this.toSqlLikeClause(groupMatcher));
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int deleteAllPausedTriggerGroups(Connection connection) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1}"));
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public boolean isTriggerGroupPaused(Connection connection, String string) {
        boolean bl;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    @Override
    public boolean isExistingTriggerGroup(Connection connection, String string) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block3;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return false;
        }
        boolean bl = resultSet.getInt(1) > 0;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    @Override
    public int insertCalendar(Connection connection, String string, Calendar object) {
        int n;
        object = this.serializeObject(object);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (SCHED_NAME, CALENDAR_NAME, CALENDAR)  VALUES({1}, ?, ?)"));
            preparedStatement.setString(1, string);
            this.setBytes(preparedStatement, 2, (ByteArrayOutputStream)object);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateCalendar(Connection connection, String string, Calendar object) {
        int n;
        object = this.serializeObject(object);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
            this.setBytes(preparedStatement, 1, (ByteArrayOutputStream)object);
            preparedStatement.setString(2, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public boolean calendarExists(Connection connection, String string) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return true;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return false;
    }

    @Override
    public Calendar selectCalendar(Connection object, String string) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            preparedStatement = null;
            resultSet = null;
            try {
                String string2 = this.rtp("SELECT * FROM {0}CALENDARS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?");
                preparedStatement = object.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                object = null;
                if (resultSet.next()) {
                    object = (Calendar)this.getObjectFromBlob(resultSet, "CALENDAR");
                }
                if (object != null) break block3;
                this.logger.warn("Couldn't find calendar with name '" + string + "'.");
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public boolean calendarIsReferenced(Connection connection, String string) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return true;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return false;
    }

    @Override
    public int deleteCalendar(Connection connection, String string) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}CALENDARS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int selectNumCalendars(Connection connection) {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n2 = 0;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(CALENDAR_NAME)  FROM {0}CALENDARS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            n = n2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public List<String> selectCalendars(Connection object) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            object = new LinkedList();
            while (resultSet.next()) {
                ((LinkedList)object).add(resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public long selectNextFireTime(Connection connection) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            long l;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT MIN(NEXT_FIRE_TIME) AS ALIAS_NXT_FR_TM FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME >= 0"));
                preparedStatement.setString(1, "WAITING");
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                l = resultSet.getLong("ALIAS_NXT_FR_TM");
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return l;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return 0L;
    }

    public TriggerKey selectTriggerForFireTime(Connection object, long l) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME = ?"));
                preparedStatement.setString(1, "WAITING");
                preparedStatement.setBigDecimal(2, new BigDecimal(String.valueOf(l)));
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                object = new TriggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP"));
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return object;
        }
        object = null;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public List<TriggerKey> selectTriggerToAcquire(Connection connection, long l, long l2) {
        return this.selectTriggerToAcquire(connection, l, l2, 1);
    }

    @Override
    public List<TriggerKey> selectTriggerToAcquire(Connection object, long l, long l2, int n) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        LinkedList<TriggerKey> linkedList = new LinkedList<TriggerKey>();
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME, PRIORITY FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME <= ? AND (MISFIRE_INSTR = -1 OR (MISFIRE_INSTR != -1 AND NEXT_FIRE_TIME >= ?)) ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            if (n <= 0) {
                n = 1;
            }
            preparedStatement.setMaxRows(n);
            preparedStatement.setFetchSize(n);
            preparedStatement.setString(1, "WAITING");
            preparedStatement.setBigDecimal(2, new BigDecimal(String.valueOf(l)));
            preparedStatement.setBigDecimal(3, new BigDecimal(String.valueOf(l2)));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next() && linkedList.size() < n) {
                linkedList.add(TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public int insertFiredTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}FIRED_TRIGGERS (SCHED_NAME, ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, INSTANCE_NAME, FIRED_TIME, SCHED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_NONCONCURRENT, REQUESTS_RECOVERY, PRIORITY) VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            preparedStatement.setString(1, operableTrigger.getFireInstanceId());
            preparedStatement.setString(2, operableTrigger.getKey().getName());
            preparedStatement.setString(3, operableTrigger.getKey().getGroup());
            preparedStatement.setString(4, this.instanceId);
            preparedStatement.setBigDecimal(5, new BigDecimal(String.valueOf(System.currentTimeMillis())));
            preparedStatement.setBigDecimal(6, new BigDecimal(String.valueOf(operableTrigger.getNextFireTime().getTime())));
            preparedStatement.setString(7, string);
            if (jobDetail != null) {
                preparedStatement.setString(8, operableTrigger.getJobKey().getName());
                preparedStatement.setString(9, operableTrigger.getJobKey().getGroup());
                this.setBoolean(preparedStatement, 10, jobDetail.isConcurrentExectionDisallowed());
                this.setBoolean(preparedStatement, 11, jobDetail.requestsRecovery());
            } else {
                preparedStatement.setString(8, null);
                preparedStatement.setString(9, null);
                this.setBoolean(preparedStatement, 10, false);
                this.setBoolean(preparedStatement, 11, false);
            }
            preparedStatement.setInt(12, operableTrigger.getPriority());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateFiredTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}FIRED_TRIGGERS SET INSTANCE_NAME = ?, FIRED_TIME = ?, SCHED_TIME = ?, STATE = ?, JOB_NAME = ?, JOB_GROUP = ?, IS_NONCONCURRENT = ?, REQUESTS_RECOVERY = ? WHERE SCHED_NAME = {1} AND ENTRY_ID = ?"));
            preparedStatement.setString(1, this.instanceId);
            preparedStatement.setBigDecimal(2, new BigDecimal(String.valueOf(System.currentTimeMillis())));
            preparedStatement.setBigDecimal(3, new BigDecimal(String.valueOf(operableTrigger.getNextFireTime().getTime())));
            preparedStatement.setString(4, string);
            if (jobDetail != null) {
                preparedStatement.setString(5, operableTrigger.getJobKey().getName());
                preparedStatement.setString(6, operableTrigger.getJobKey().getGroup());
                this.setBoolean(preparedStatement, 7, jobDetail.isConcurrentExectionDisallowed());
                this.setBoolean(preparedStatement, 8, jobDetail.requestsRecovery());
            } else {
                preparedStatement.setString(5, null);
                preparedStatement.setString(6, null);
                this.setBoolean(preparedStatement, 7, false);
                this.setBoolean(preparedStatement, 8, false);
            }
            preparedStatement.setString(9, operableTrigger.getFireInstanceId());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public List<FiredTriggerRecord> selectFiredTriggerRecords(Connection object, String string, String string2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            if (string != null) {
                preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
            } else {
                preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, string2);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new FiredTriggerRecord();
                ((FiredTriggerRecord)object).setFireInstanceId(resultSet.getString("ENTRY_ID"));
                ((FiredTriggerRecord)object).setFireInstanceState(resultSet.getString("STATE"));
                ((FiredTriggerRecord)object).setFireTimestamp(resultSet.getLong("FIRED_TIME"));
                ((FiredTriggerRecord)object).setScheduleTimestamp(resultSet.getLong("SCHED_TIME"));
                ((FiredTriggerRecord)object).setPriority(resultSet.getInt("PRIORITY"));
                ((FiredTriggerRecord)object).setSchedulerInstanceId(resultSet.getString("INSTANCE_NAME"));
                ((FiredTriggerRecord)object).setTriggerKey(TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
                if (!((FiredTriggerRecord)object).getFireInstanceState().equals("ACQUIRED")) {
                    ((FiredTriggerRecord)object).setJobDisallowsConcurrentExecution(this.getBoolean(resultSet, "IS_NONCONCURRENT"));
                    ((FiredTriggerRecord)object).setJobRequestsRecovery(resultSet.getBoolean("REQUESTS_RECOVERY"));
                    ((FiredTriggerRecord)object).setJobKey(JobKey.jobKey(resultSet.getString("JOB_NAME"), resultSet.getString("JOB_GROUP")));
                }
                linkedList.add(object);
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public List<FiredTriggerRecord> selectFiredTriggerRecordsByJob(Connection object, String string, String string2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            if (string != null) {
                preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
            } else {
                preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND JOB_GROUP = ?"));
                preparedStatement.setString(1, string2);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new FiredTriggerRecord();
                ((FiredTriggerRecord)object).setFireInstanceId(resultSet.getString("ENTRY_ID"));
                ((FiredTriggerRecord)object).setFireInstanceState(resultSet.getString("STATE"));
                ((FiredTriggerRecord)object).setFireTimestamp(resultSet.getLong("FIRED_TIME"));
                ((FiredTriggerRecord)object).setScheduleTimestamp(resultSet.getLong("SCHED_TIME"));
                ((FiredTriggerRecord)object).setPriority(resultSet.getInt("PRIORITY"));
                ((FiredTriggerRecord)object).setSchedulerInstanceId(resultSet.getString("INSTANCE_NAME"));
                ((FiredTriggerRecord)object).setTriggerKey(TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
                if (!((FiredTriggerRecord)object).getFireInstanceState().equals("ACQUIRED")) {
                    ((FiredTriggerRecord)object).setJobDisallowsConcurrentExecution(this.getBoolean(resultSet, "IS_NONCONCURRENT"));
                    ((FiredTriggerRecord)object).setJobRequestsRecovery(resultSet.getBoolean("REQUESTS_RECOVERY"));
                    ((FiredTriggerRecord)object).setJobKey(JobKey.jobKey(resultSet.getString("JOB_NAME"), resultSet.getString("JOB_GROUP")));
                }
                linkedList.add(object);
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public List<FiredTriggerRecord> selectInstancesFiredTriggerRecords(Connection object, String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new FiredTriggerRecord();
                ((FiredTriggerRecord)object).setFireInstanceId(resultSet.getString("ENTRY_ID"));
                ((FiredTriggerRecord)object).setFireInstanceState(resultSet.getString("STATE"));
                ((FiredTriggerRecord)object).setFireTimestamp(resultSet.getLong("FIRED_TIME"));
                ((FiredTriggerRecord)object).setScheduleTimestamp(resultSet.getLong("SCHED_TIME"));
                ((FiredTriggerRecord)object).setSchedulerInstanceId(resultSet.getString("INSTANCE_NAME"));
                ((FiredTriggerRecord)object).setTriggerKey(TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
                if (!((FiredTriggerRecord)object).getFireInstanceState().equals("ACQUIRED")) {
                    ((FiredTriggerRecord)object).setJobDisallowsConcurrentExecution(this.getBoolean(resultSet, "IS_NONCONCURRENT"));
                    ((FiredTriggerRecord)object).setJobRequestsRecovery(resultSet.getBoolean("REQUESTS_RECOVERY"));
                    ((FiredTriggerRecord)object).setJobKey(JobKey.jobKey(resultSet.getString("JOB_NAME"), resultSet.getString("JOB_GROUP")));
                }
                ((FiredTriggerRecord)object).setPriority(resultSet.getInt("PRIORITY"));
                linkedList.add(object);
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public Set<String> selectFiredTriggerInstanceNames(Connection object) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            HashSet<String> hashSet = new HashSet<String>();
            preparedStatement = object.prepareStatement(this.rtp("SELECT DISTINCT INSTANCE_NAME FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("INSTANCE_NAME"));
            }
            object = hashSet;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    @Override
    public int deleteFiredTrigger(Connection connection, String string) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND ENTRY_ID = ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int selectJobExecutionCount(Connection connection, JobKey jobKey) {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobKey.getName());
            preparedStatement.setString(2, jobKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            n = resultSet.next() ? resultSet.getInt(1) : 0;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int insertSchedulerState(Connection connection, String string, long l, long l2) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}SCHEDULER_STATE (SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL) VALUES({1}, ?, ?, ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            preparedStatement.setLong(3, l2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int deleteSchedulerState(Connection connection, String string) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}SCHEDULER_STATE WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int updateSchedulerState(Connection connection, String string, long l) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}SCHEDULER_STATE SET LAST_CHECKIN_TIME = ? WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public List<SchedulerStateRecord> selectSchedulerStateRecords(Connection object, String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            if (string != null) {
                preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}SCHEDULER_STATE WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
                preparedStatement.setString(1, string);
            } else {
                preparedStatement = object.prepareStatement(this.rtp("SELECT * FROM {0}SCHEDULER_STATE WHERE SCHED_NAME = {1}"));
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new SchedulerStateRecord();
                ((SchedulerStateRecord)object).setSchedulerInstanceId(resultSet.getString("INSTANCE_NAME"));
                ((SchedulerStateRecord)object).setCheckinTimestamp(resultSet.getLong("LAST_CHECKIN_TIME"));
                ((SchedulerStateRecord)object).setCheckinInterval(resultSet.getLong("CHECKIN_INTERVAL"));
                linkedList.add(object);
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    protected final String rtp(String string) {
        return Util.rtp(string, this.tablePrefix, this.getSchedulerNameLiteral());
    }

    protected String getSchedulerNameLiteral() {
        if (this.schedNameLiteral == null) {
            this.schedNameLiteral = "'" + this.schedName + "'";
        }
        return this.schedNameLiteral;
    }

    protected ByteArrayOutputStream serializeObject(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (object != null) {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        return byteArrayOutputStream;
    }

    protected ByteArrayOutputStream serializeJobData(JobDataMap jobDataMap) {
        if (this.canUseProperties()) {
            return this.serializeProperties(jobDataMap);
        }
        try {
            return this.serializeObject(jobDataMap);
        }
        catch (NotSerializableException notSerializableException) {
            throw new NotSerializableException("Unable to serialize JobDataMap for insertion into database because the value of property '" + this.getKeyOfNonSerializableValue(jobDataMap) + "' is not serializable: " + notSerializableException.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    protected Object getKeyOfNonSerializableValue(Map<?, ?> object) {
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            ByteArrayOutputStream byteArrayOutputStream = null;
            byteArrayOutputStream = this.serializeObject(entry.getValue());
            if (byteArrayOutputStream == null) continue;
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            continue;
            catch (IOException iOException) {
                block12: {
                    try {
                        object = entry.getKey();
                        if (byteArrayOutputStream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException3) {}
                }
                return object;
            }
        }
        return null;
    }

    private ByteArrayOutputStream serializeProperties(JobDataMap map) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (map != null) {
            map = this.convertToProperty(map.getWrappedMap());
            ((Properties)map).store(byteArrayOutputStream, "");
        }
        return byteArrayOutputStream;
    }

    protected Map<?, ?> convertFromProperty(Properties properties) {
        return new HashMap<Object, Object>(properties);
    }

    protected Properties convertToProperty(Map<?, ?> object) {
        Properties properties = new Properties();
        for (Map.Entry entry : object.entrySet()) {
            String object2;
            Object k = entry.getKey();
            String string = object2 = entry.getValue() == null ? "" : entry.getValue();
            if (!(k instanceof String)) {
                throw new IOException("JobDataMap keys/values must be Strings when the 'useProperties' property is set.  offending Key: " + k);
            }
            if (!(object2 instanceof String)) {
                throw new IOException("JobDataMap values must be Strings when the 'useProperties' property is set.  Key of offending value: " + k);
            }
            properties.put(k, object2);
        }
        return properties;
    }

    protected Object getObjectFromBlob(ResultSet object, String string) {
        Object object2 = null;
        if (!((object = object.getBlob(string)) == null || object.length() == 0L || (object = object.getBinaryStream()) == null || object instanceof ByteArrayInputStream && ((ByteArrayInputStream)object).available() == 0)) {
            object = new ObjectInputStream((InputStream)object);
            try {
                object2 = ((ObjectInputStream)object).readObject();
            }
            finally {
                ((ObjectInputStream)object).close();
            }
        }
        return object2;
    }

    protected Object getJobDataFromBlob(ResultSet object, String string) {
        if (this.canUseProperties()) {
            if ((object = object.getBlob(string)) != null) {
                object = object.getBinaryStream();
                return object;
            }
            return null;
        }
        return this.getObjectFromBlob((ResultSet)object, string);
    }

    @Override
    public Set<String> selectPausedTriggerGroups(Connection object) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            preparedStatement = object.prepareStatement(this.rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("TRIGGER_GROUP");
                hashSet.add(object);
            }
            object = hashSet;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    protected static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                return;
            }
            catch (SQLException sQLException) {}
        }
    }

    protected static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                return;
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void setBoolean(PreparedStatement preparedStatement, int n, boolean bl) {
        preparedStatement.setBoolean(n, bl);
    }

    protected boolean getBoolean(ResultSet resultSet, String string) {
        return resultSet.getBoolean(string);
    }

    protected boolean getBoolean(ResultSet resultSet, int n) {
        return resultSet.getBoolean(n);
    }

    protected void setBytes(PreparedStatement preparedStatement, int n, ByteArrayOutputStream byteArrayOutputStream) {
        preparedStatement.setBytes(n, byteArrayOutputStream == null ? new byte[]{} : byteArrayOutputStream.toByteArray());
    }
}

