/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.quartz.utils.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNDIConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties props;
    private Object datasource;
    private boolean alwaysLookup = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JNDIConnectionProvider(String string, boolean bl) {
        this.url = string;
        this.alwaysLookup = bl;
        this.init();
    }

    public JNDIConnectionProvider(String string, Properties properties, boolean bl) {
        this.url = string;
        this.props = properties;
        this.alwaysLookup = bl;
        this.init();
    }

    protected Logger getLog() {
        return this.log;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.isAlwaysLookup()) return;
        InitialContext initialContext = null;
        initialContext = this.props != null ? new InitialContext(this.props) : new InitialContext();
        this.datasource = (DataSource)initialContext.lookup(this.url);
        try {
            initialContext.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Exception exception) {
            try {
                this.getLog().error("Error looking up datasource: " + exception.getMessage(), (Throwable)exception);
                if (initialContext == null) return;
            }
            catch (Throwable throwable) {
                if (initialContext == null) throw throwable;
                try {
                    initialContext.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                initialContext.close();
                return;
            }
            catch (Exception exception3) {
                return;
            }
        }
    }

    @Override
    public Connection getConnection() {
        Context context;
        block18: {
            Object object;
            block19: {
                block16: {
                    block17: {
                        context = null;
                        object = this.datasource;
                        if (object == null || this.isAlwaysLookup()) {
                            context = this.props != null ? new InitialContext(this.props) : new InitialContext();
                            object = context.lookup(this.url);
                            if (!this.isAlwaysLookup()) {
                                this.datasource = object;
                            }
                        }
                        if (object == null) {
                            throw new SQLException("There is no object at the JNDI URL '" + this.url + "'");
                        }
                        if (!(object instanceof XADataSource)) break block16;
                        object = ((XADataSource)object).getXAConnection().getConnection();
                        if (context == null) break block17;
                        try {
                            context.close();
                        }
                        catch (Exception exception) {}
                    }
                    return object;
                }
                if (!(object instanceof DataSource)) break block18;
                object = ((DataSource)object).getConnection();
                if (context == null) break block19;
                try {
                    context.close();
                }
                catch (Exception exception) {}
            }
            return object;
        }
        try {
            try {
                throw new SQLException("Object at JNDI URL '" + this.url + "' is not a DataSource.");
            }
            catch (Exception exception) {
                this.datasource = null;
                throw new SQLException("Could not retrieve datasource via JNDI url '" + this.url + "' " + exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
    }

    public boolean isAlwaysLookup() {
        return this.alwaysLookup;
    }

    public void setAlwaysLookup(boolean bl) {
        this.alwaysLookup = bl;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void initialize() {
    }
}

