/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils.counter;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import org.quartz.utils.counter.Counter;
import org.quartz.utils.counter.CounterConfig;
import org.quartz.utils.counter.CounterManager;
import org.quartz.utils.counter.sampled.SampledCounter;
import org.quartz.utils.counter.sampled.SampledCounterImpl;

public class CounterManagerImpl
implements CounterManager {
    private Timer timer;
    private boolean shutdown;
    private List<Counter> counters = new ArrayList<Counter>();

    public CounterManagerImpl(Timer timer) {
        if (timer == null) {
            throw new IllegalArgumentException("Timer cannot be null");
        }
        this.timer = timer;
    }

    @Override
    public synchronized void shutdown(boolean bl) {
        if (this.shutdown) {
            return;
        }
        try {
            for (Counter counter : this.counters) {
                if (!(counter instanceof SampledCounter)) continue;
                ((SampledCounter)counter).shutdown();
            }
            if (bl) {
                this.timer.cancel();
            }
            return;
        }
        finally {
            this.shutdown = true;
        }
    }

    @Override
    public synchronized Counter createCounter(CounterConfig object) {
        if (this.shutdown) {
            throw new IllegalStateException("counter manager is shutdown");
        }
        if (object == null) {
            throw new NullPointerException("config cannot be null");
        }
        if ((object = ((CounterConfig)object).createCounter()) instanceof SampledCounterImpl) {
            SampledCounterImpl sampledCounterImpl = (SampledCounterImpl)object;
            this.timer.schedule(sampledCounterImpl.getTimerTask(), sampledCounterImpl.getIntervalMillis(), sampledCounterImpl.getIntervalMillis());
        }
        this.counters.add((Counter)object);
        return object;
    }

    @Override
    public void shutdownCounter(Counter counter) {
        if (counter instanceof SampledCounter) {
            counter = (SampledCounter)counter;
            counter.shutdown();
        }
    }
}

