/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

public class IOReturnException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int ioReturn;

    public IOReturnException(int n) {
        int n2 = n;
        this(n2, IOReturnException.formatMessage(n2));
    }

    protected IOReturnException(int n, String string) {
        super(string);
        this.ioReturn = n;
    }

    public int getIOReturnCode() {
        return this.ioReturn;
    }

    public static int getSystem(int n) {
        return n >> 26 & 0x3F;
    }

    public static int getSubSystem(int n) {
        return n >> 14 & 0xFFF;
    }

    public static int getCode(int n) {
        return n & 0x3FFF;
    }

    private static String formatMessage(int n) {
        return "IOReturn error code: " + n + " (system=" + IOReturnException.getSystem(n) + ", subSystem=" + IOReturnException.getSubSystem(n) + ", code=" + IOReturnException.getCode(n) + ")";
    }
}

