/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.platform.win32.COM.util.ComThread$1;
import com.sun.jna.platform.win32.COM.util.ComThread$2;
import com.sun.jna.platform.win32.COM.util.ComThread$3;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ComThread {
    private static ThreadLocal<Boolean> isCOMThread = new ThreadLocal();
    ExecutorService executor;
    Runnable firstTask;
    boolean requiresInitialisation = true;
    long timeoutMilliseconds;
    Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public ComThread(String string, long l, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this(string, l, uncaughtExceptionHandler, 0);
    }

    public ComThread(String string, long l, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int n) {
        this.timeoutMilliseconds = l;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.firstTask = new ComThread$1(this, n);
        this.executor = Executors.newSingleThreadExecutor(new ComThread$2(this, string));
    }

    public void terminate(long l) {
        try {
            this.executor.submit(new ComThread$3(this)).get(l, TimeUnit.MILLISECONDS);
            this.executor.shutdown();
            return;
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            executionException.printStackTrace();
            return;
        }
        catch (TimeoutException timeoutException) {
            this.executor.shutdownNow();
            return;
        }
    }

    protected void finalize() {
        if (!this.executor.isShutdown()) {
            this.terminate(100L);
        }
    }

    static void setComThread(boolean bl) {
        isCOMThread.set(bl);
    }

    public <T> T execute(Callable<T> callable) {
        Boolean bl = isCOMThread.get();
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        if (bl.booleanValue()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                throw new ExecutionException(exception);
            }
        }
        if (this.requiresInitialisation) {
            this.executor.execute(this.firstTask);
        }
        return this.executor.submit(callable).get(this.timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }

    static /* synthetic */ ThreadLocal access$000() {
        return isCOMThread;
    }
}

