/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory {
    protected volatile ConnectionFactory a = null;
    private volatile String e = null;
    private volatile int f = -1;
    private Collection g = null;
    protected volatile ObjectPool b = null;
    protected volatile KeyedObjectPoolFactory c = null;
    private Boolean h = null;
    private boolean i = true;
    private int j = -1;
    private String k;
    protected AbandonedConfig d = null;

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, boolean bl, boolean bl2) {
        this.a = connectionFactory;
        this.b = objectPool;
        this.b.a((PoolableObjectFactory)this);
        this.c = keyedObjectPoolFactory;
        this.e = string;
        this.h = bl ? Boolean.TRUE : Boolean.FALSE;
        this.i = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, int n, Collection collection, Boolean bl, boolean bl2, int n2, String string2, AbandonedConfig abandonedConfig) {
        this.a = connectionFactory;
        this.b = objectPool;
        this.d = abandonedConfig;
        this.b.a((PoolableObjectFactory)this);
        this.c = keyedObjectPoolFactory;
        this.e = string;
        this.f = n;
        this.g = collection;
        this.h = bl;
        this.i = bl2;
        this.j = n2;
        this.k = string2;
    }

    public final synchronized ObjectPool a() {
        return this.b;
    }

    public Object b() {
        Connection connection = this.a.a();
        if (connection == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.a(connection);
        if (this.c != null) {
            KeyedObjectPool keyedObjectPool = this.c.a();
            connection = new PoolingConnection(connection, keyedObjectPool);
            keyedObjectPool.a((KeyedPoolableObjectFactory)((PoolingConnection)connection));
        }
        return new PoolableConnection(connection, this.b, this.d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void a(Connection iterator) {
        Object object = this.g;
        if (iterator.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (object == null) return;
        Statement statement = null;
        try {
            statement = iterator.createStatement();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) {
                    throw new NullPointerException("null connectionInitSqls element");
                }
                object = object.toString();
                statement.execute((String)object);
            }
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void a(Object object) {
        if (object instanceof PoolableConnection) {
            ((PoolableConnection)object).n();
        }
    }

    public final boolean b(Object object) {
        if (object instanceof Connection) {
            try {
                this.b((Connection)object);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public final void b(Connection connection) {
        String string = this.e;
        if (connection.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        if (string != null) {
            Statement statement;
            block17: {
                statement = null;
                ResultSet resultSet = null;
                try {
                    statement = connection.createStatement();
                    if (this.f > 0) {
                        statement.setQueryTimeout(this.f);
                    }
                    if (!(resultSet = statement.executeQuery(string)).next()) {
                        throw new SQLException("validationQuery didn't return a row");
                    }
                    if (resultSet == null) break block17;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    public final void c(Object object) {
        if (object instanceof Connection) {
            Connection connection = (Connection)object;
            if (!connection.getAutoCommit() && !connection.isReadOnly()) {
                connection.rollback();
            }
            connection.clearWarnings();
            if (!connection.getAutoCommit()) {
                connection.setAutoCommit(true);
            }
        }
        if (object instanceof DelegatingConnection) {
            ((DelegatingConnection)object).m();
        }
    }

    public final void d(Object object) {
        if (object instanceof DelegatingConnection) {
            ((DelegatingConnection)object).l();
        }
        if (object instanceof Connection) {
            if ((object = (Connection)object).getAutoCommit() != this.i) {
                object.setAutoCommit(this.i);
            }
            if (this.j != -1 && object.getTransactionIsolation() != this.j) {
                object.setTransactionIsolation(this.j);
            }
            if (this.h != null && object.isReadOnly() != this.h.booleanValue()) {
                object.setReadOnly(this.h);
            }
            if (this.k != null && !this.k.equals(object.getCatalog())) {
                object.setCatalog(this.k);
            }
        }
    }
}

