/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;

public final class ClassifierNamePolicy$SOURCE_CODE_QUALIFIED
implements ClassifierNamePolicy {
    public static final ClassifierNamePolicy$SOURCE_CODE_QUALIFIED INSTANCE = new ClassifierNamePolicy$SOURCE_CODE_QUALIFIED();

    private ClassifierNamePolicy$SOURCE_CODE_QUALIFIED() {
    }

    @Override
    public final String renderClassifier(ClassifierDescriptor classifierDescriptor, DescriptorRenderer descriptorRenderer2) {
        Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)descriptorRenderer2, (String)"");
        return this.qualifiedNameForSourceCode(classifierDescriptor);
    }

    private final String qualifiedNameForSourceCode(ClassifierDescriptor object) {
        Name name = object.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        String string = RenderingUtilsKt.render(name);
        if (object instanceof TypeParameterDescriptor) {
            return string;
        }
        DeclarationDescriptor declarationDescriptor = object.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
        object = this.qualifierName(declarationDescriptor);
        if (object != null && !Intrinsics.areEqual((Object)object, (Object)"")) {
            return (String)object + '.' + string;
        }
        return string;
    }

    private final String qualifierName(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        if (declarationDescriptor2 instanceof ClassDescriptor) {
            return this.qualifiedNameForSourceCode((ClassifierDescriptor)declarationDescriptor);
        }
        if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
            FqNameUnsafe fqNameUnsafe = ((PackageFragmentDescriptor)declarationDescriptor).getFqName().toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
            return RenderingUtilsKt.render(fqNameUnsafe);
        }
        return null;
    }
}

