/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeOfDay
implements Serializable {
    private static final long serialVersionUID = 2964774315889061771L;
    private final int hour;
    private final int minute;
    private final int second;

    public TimeOfDay(int n, int n2, int n3) {
        this.hour = n;
        this.minute = n2;
        this.second = n3;
        this.validate();
    }

    public TimeOfDay(int n, int n2) {
        this.hour = n;
        this.minute = n2;
        this.second = 0;
        this.validate();
    }

    private void validate() {
        if (this.hour < 0 || this.hour > 23) {
            throw new IllegalArgumentException("Hour must be from 0 to 23");
        }
        if (this.minute < 0 || this.minute > 59) {
            throw new IllegalArgumentException("Minute must be from 0 to 59");
        }
        if (this.second < 0 || this.second > 59) {
            throw new IllegalArgumentException("Second must be from 0 to 59");
        }
    }

    public static TimeOfDay hourMinuteAndSecondOfDay(int n, int n2, int n3) {
        return new TimeOfDay(n, n2, n3);
    }

    public static TimeOfDay hourAndMinuteOfDay(int n, int n2) {
        return new TimeOfDay(n, n2);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public boolean before(TimeOfDay timeOfDay) {
        if (timeOfDay.hour > this.hour) {
            return true;
        }
        if (timeOfDay.hour < this.hour) {
            return false;
        }
        if (timeOfDay.minute > this.minute) {
            return true;
        }
        if (timeOfDay.minute < this.minute) {
            return false;
        }
        if (timeOfDay.second > this.second) {
            return true;
        }
        if (timeOfDay.second < this.second) {
            return false;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeOfDay)) {
            return false;
        }
        object = (TimeOfDay)object;
        return ((TimeOfDay)object).hour == this.hour && ((TimeOfDay)object).minute == this.minute && ((TimeOfDay)object).second == this.second;
    }

    public int hashCode() {
        return this.hour + 1 ^ this.minute + 1 ^ this.second + 1;
    }

    public Date getTimeOfDayForDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static TimeOfDay hourAndMinuteAndSecondFromDate(Date date) {
        return TimeOfDay.hourAndMinuteAndSecondFromDate(date, null);
    }

    public static TimeOfDay hourAndMinuteAndSecondFromDate(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        }
        return new TimeOfDay(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static TimeOfDay hourAndMinuteFromDate(Date date) {
        return TimeOfDay.hourAndMinuteFromDate(date, null);
    }

    public static TimeOfDay hourAndMinuteFromDate(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        }
        return new TimeOfDay(calendar.get(11), calendar.get(12));
    }

    public String toString() {
        return "TimeOfDay[" + this.hour + ":" + this.minute + ":" + this.second + "]";
    }
}

