/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.listeners;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class BroadcastSchedulerListener
implements SchedulerListener {
    private List<SchedulerListener> listeners = new LinkedList<SchedulerListener>();

    public BroadcastSchedulerListener() {
    }

    public BroadcastSchedulerListener(List<SchedulerListener> list) {
        this();
        this.listeners.addAll(list);
    }

    public void addListener(SchedulerListener schedulerListener) {
        this.listeners.add(schedulerListener);
    }

    public boolean removeListener(SchedulerListener schedulerListener) {
        return this.listeners.remove(schedulerListener);
    }

    public List<SchedulerListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void jobAdded(JobDetail jobDetail) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.jobAdded(jobDetail);
        }
    }

    @Override
    public void jobDeleted(JobKey jobKey) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.jobDeleted(jobKey);
        }
    }

    @Override
    public void jobScheduled(Trigger trigger) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.jobScheduled(trigger);
        }
    }

    @Override
    public void jobUnscheduled(TriggerKey triggerKey) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.jobUnscheduled(triggerKey);
        }
    }

    @Override
    public void triggerFinalized(Trigger trigger) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.triggerFinalized(trigger);
        }
    }

    @Override
    public void triggerPaused(TriggerKey triggerKey) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.triggerPaused(triggerKey);
        }
    }

    @Override
    public void triggersPaused(String string) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.triggersPaused(string);
        }
    }

    @Override
    public void triggerResumed(TriggerKey triggerKey) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.triggerResumed(triggerKey);
        }
    }

    @Override
    public void triggersResumed(String string) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.triggersResumed(string);
        }
    }

    @Override
    public void schedulingDataCleared() {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.schedulingDataCleared();
        }
    }

    @Override
    public void jobPaused(JobKey jobKey) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.jobPaused(jobKey);
        }
    }

    @Override
    public void jobsPaused(String string) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.jobsPaused(string);
        }
    }

    @Override
    public void jobResumed(JobKey jobKey) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.jobResumed(jobKey);
        }
    }

    @Override
    public void jobsResumed(String string) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.jobsResumed(string);
        }
    }

    @Override
    public void schedulerError(String string, SchedulerException schedulerException) {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.schedulerError(string, schedulerException);
        }
    }

    @Override
    public void schedulerStarted() {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.schedulerStarted();
        }
    }

    @Override
    public void schedulerStarting() {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.schedulerStarting();
        }
    }

    @Override
    public void schedulerInStandbyMode() {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.schedulerInStandbyMode();
        }
    }

    @Override
    public void schedulerShutdown() {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.schedulerShutdown();
        }
    }

    @Override
    public void schedulerShuttingdown() {
        for (SchedulerListener schedulerListener : this.listeners) {
            schedulerListener.schedulerShuttingdown();
        }
    }
}

