/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJobFactory
implements JobFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public Job newJob(TriggerFiredBundle serializable, Scheduler object) {
        serializable = ((TriggerFiredBundle)serializable).getJobDetail();
        object = serializable.getJobClass();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Producing instance of Job '" + serializable.getKey() + "', class=" + ((Class)object).getName());
            }
            return (Job)((Class)object).newInstance();
        }
        catch (Exception exception) {
            serializable = new SchedulerException("Problem instantiating class '" + serializable.getJobClass().getName() + "'", exception);
            throw serializable;
        }
    }
}

