/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.net.AbstractSocketAppender$1;
import ch.qos.logback.core.net.AutoFlushingObjectWriter;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.ObjectWriter;
import ch.qos.logback.core.net.ObjectWriterFactory;
import ch.qos.logback.core.net.QueueFactory;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.net.SocketConnector$ExceptionHandler;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

public abstract class AbstractSocketAppender<E>
extends AppenderBase<E>
implements SocketConnector$ExceptionHandler {
    public static final int DEFAULT_PORT = 4560;
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 128;
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private static final int DEFAULT_EVENT_DELAY_TIMEOUT = 100;
    private final ObjectWriterFactory objectWriterFactory;
    private final QueueFactory queueFactory;
    private String remoteHost;
    private int port = 4560;
    private InetAddress address;
    private Duration reconnectionDelay = new Duration(30000L);
    private int queueSize = 128;
    private int acceptConnectionTimeout = 5000;
    private Duration eventDelayLimit = new Duration(100L);
    private BlockingDeque<E> deque;
    private String peerId;
    private SocketConnector connector;
    private Future<?> task;
    private volatile Socket socket;

    protected AbstractSocketAppender() {
        this(new QueueFactory(), new ObjectWriterFactory());
    }

    AbstractSocketAppender(QueueFactory queueFactory, ObjectWriterFactory objectWriterFactory) {
        this.objectWriterFactory = objectWriterFactory;
        this.queueFactory = queueFactory;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        int n = 0;
        if (this.port <= 0) {
            ++n;
            AbstractSocketAppender abstractSocketAppender = this;
            abstractSocketAppender.addError("No port was configured for appender" + abstractSocketAppender.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.remoteHost == null) {
            ++n;
            AbstractSocketAppender abstractSocketAppender = this;
            abstractSocketAppender.addError("No remote host was configured for appender" + abstractSocketAppender.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        if (this.queueSize == 0) {
            this.addWarn("Queue size of zero is deprecated, use a size of one to indicate synchronous processing");
        }
        if (this.queueSize < 0) {
            ++n;
            this.addError("Queue size must be greater than zero");
        }
        if (n == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                AbstractSocketAppender abstractSocketAppender = this;
                abstractSocketAppender.addError("unknown host: " + abstractSocketAppender.remoteHost);
                ++n;
            }
        }
        if (n == 0) {
            this.deque = this.queueFactory.newLinkedBlockingDeque(this.queueSize);
            this.peerId = "remote peer " + this.remoteHost + ":" + this.port + ": ";
            this.connector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay.getMilliseconds());
            this.task = this.getContext().getExecutorService().submit(new AbstractSocketAppender$1(this));
            super.start();
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly(this.socket);
        this.task.cancel(true);
        super.stop();
    }

    @Override
    protected void append(E e) {
        if (e == null || !this.isStarted()) {
            return;
        }
        try {
            boolean bl = this.deque.offer(e, this.eventDelayLimit.getMilliseconds(), TimeUnit.MILLISECONDS);
            if (!bl) {
                AbstractSocketAppender abstractSocketAppender = this;
                abstractSocketAppender.addInfo("Dropping event due to timeout limit of [" + String.valueOf(abstractSocketAppender.eventDelayLimit) + "] being exceeded");
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.addError("Interrupted while appending event to SocketAppender", interruptedException);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void connectSocketAndDispatchEvents() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean socketConnectionCouldBeEstablished() {
        this.socket = this.connector.call();
        return this.socket != null;
    }

    private ObjectWriter createObjectWriterForSocket() {
        this.socket.setSoTimeout(this.acceptConnectionTimeout);
        AutoFlushingObjectWriter autoFlushingObjectWriter = this.objectWriterFactory.newAutoFlushingObjectWriter(this.socket.getOutputStream());
        this.socket.setSoTimeout(0);
        return autoFlushingObjectWriter;
    }

    private SocketConnector createConnector(InetAddress object, int n, int n2, long l) {
        object = this.newConnector((InetAddress)object, n, n2, l);
        object.setExceptionHandler(this);
        object.setSocketFactory(this.getSocketFactory());
        return object;
    }

    private void dispatchEvents(ObjectWriter objectWriter) {
        while (true) {
            E e = this.deque.takeFirst();
            this.postProcessEvent(e);
            Serializable serializable = this.getPST().transform(e);
            try {
                objectWriter.write(serializable);
            }
            catch (IOException iOException) {
                this.tryReAddingEventToFrontOfQueue(e);
                throw iOException;
            }
        }
    }

    private void tryReAddingEventToFrontOfQueue(E e) {
        boolean bl = this.deque.offerFirst(e);
        if (!bl) {
            this.addInfo("Dropping event due to socket connection error and maxed out deque capacity");
        }
    }

    @Override
    public void connectionFailed(SocketConnector socketConnector, Exception exception) {
        if (exception instanceof InterruptedException) {
            this.addInfo("connector interrupted");
            return;
        }
        if (exception instanceof ConnectException) {
            AbstractSocketAppender abstractSocketAppender = this;
            abstractSocketAppender.addInfo(abstractSocketAppender.peerId + "connection refused");
            return;
        }
        AbstractSocketAppender abstractSocketAppender = this;
        abstractSocketAppender.addInfo(abstractSocketAppender.peerId + String.valueOf(exception));
    }

    protected SocketConnector newConnector(InetAddress inetAddress, int n, long l, long l2) {
        return new DefaultSocketConnector(inetAddress, n, l, l2);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    protected abstract void postProcessEvent(E var1);

    protected abstract PreSerializationTransformer<E> getPST();

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(Duration duration) {
        this.reconnectionDelay = duration;
    }

    public Duration getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setQueueSize(int n) {
        this.queueSize = n;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setEventDelayLimit(Duration duration) {
        this.eventDelayLimit = duration;
    }

    public Duration getEventDelayLimit() {
        return this.eventDelayLimit;
    }

    void setAcceptConnectionTimeout(int n) {
        this.acceptConnectionTimeout = n;
    }
}

